/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.annotation.NonNull;
import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.jank.Cuj;
import java.util.ArrayList;

class InteractionMonitorDebugOverlay {
    private static final String TAG = "InteractionMonitorDebug";
    private static final int REASON_STILL_RUNNING = -1000;
    private static final long HIDE_OVERLAY_DELAY = 2000L;
    private final Application mCurrentApplication;
    private final Handler mUiThread;
    private final DebugOverlayView mDebugOverlayView;
    private final WindowManager mWindowManager;
    private final ArrayList<TrackerState> mRunningCujs = new ArrayList();
    private final Runnable mHideOverlayRunnable = new Runnable(){

        @Override
        public void run() {
            InteractionMonitorDebugOverlay.this.mRunningCujs.clear();
            InteractionMonitorDebugOverlay.this.mDebugOverlayView.setVisibility(4);
        }
    };

    InteractionMonitorDebugOverlay(@NonNull Application currentApplication, @NonNull Handler uiThread, int bgColor, double yOffset) {
        this.mCurrentApplication = currentApplication;
        this.mUiThread = uiThread;
        Display display = this.mCurrentApplication.getSystemService(DisplayManager.class).getDisplay(0);
        Context windowContext = this.mCurrentApplication.createDisplayContext(display).createWindowContext(2006, null);
        this.mWindowManager = windowContext.getSystemService(WindowManager.class);
        Rect size = this.mWindowManager.getCurrentWindowMetrics().getBounds();
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(2006, 8388920, -3);
        lp.privateFlags |= 0x50;
        lp.layoutInDisplayCutoutMode = 3;
        lp.setFitInsetsTypes(0);
        lp.privateFlags |= 0x1000000;
        lp.width = size.width();
        lp.height = size.height();
        lp.gravity = 17;
        lp.setTitle("InteractionMonitorDebugOverlay");
        if (!this.mUiThread.getLooper().isCurrentThread()) {
            Log.e(TAG, "InteractionMonitorDebugOverlay must be constructed on InteractionJankMonitor's worker thread");
        }
        this.mDebugOverlayView = new DebugOverlayView(this.mCurrentApplication, bgColor, yOffset);
        this.mWindowManager.addView(this.mDebugOverlayView, lp);
    }

    void onTrackerAdded(int addedCuj, int cookie) {
        this.mUiThread.removeCallbacks(this.mHideOverlayRunnable);
        this.mUiThread.post(() -> {
            String cujName = Cuj.getNameOfCuj(addedCuj);
            Log.i(TAG, cujName + " started (cookie=" + cookie + ")");
            this.mRunningCujs.add(new TrackerState(addedCuj, cookie));
            this.mDebugOverlayView.setVisibility(0);
            this.mDebugOverlayView.invalidate();
        });
    }

    void onTrackerRemoved(int removedCuj, int reason, int cookie) {
        this.mUiThread.post(() -> {
            TrackerState foundTracker = null;
            boolean allTrackersEnded = true;
            for (int i = 0; i < this.mRunningCujs.size(); ++i) {
                TrackerState tracker = this.mRunningCujs.get(i);
                if (tracker.mCuj == removedCuj && tracker.mCookie == cookie) {
                    foundTracker = tracker;
                    continue;
                }
                allTrackersEnded = allTrackersEnded && tracker.mState != -1000;
            }
            if (foundTracker != null) {
                foundTracker.mState = reason;
            }
            String cujName = Cuj.getNameOfCuj(removedCuj);
            Log.i(TAG, cujName + (reason == 0 ? " ended" : " cancelled") + " (cookie=" + cookie + ")");
            if (allTrackersEnded) {
                Log.i(TAG, "All CUJs ended");
                this.mUiThread.postDelayed(this.mHideOverlayRunnable, 2000L);
            }
            this.mDebugOverlayView.invalidate();
        });
    }

    void dispose() {
        this.mUiThread.post(() -> this.mWindowManager.removeView(this.mDebugOverlayView));
    }

    private class DebugOverlayView
    extends View {
        private static final String TRACK_NAME = "InteractionJankMonitor";
        private final int mBgColor;
        private final double mYOffset;
        private final float mDensity;
        private final Paint mDebugPaint;
        private final Paint.FontMetrics mDebugFontMetrics;
        private final String mPackageNameText;
        final int mPadding;
        final int mPackageNameFontSize;
        final int mCujFontSize;
        final float mCujNameTextHeight;
        final float mCujStatusWidth;
        final float mPackageNameTextHeight;
        final float mPackageNameWidth;

        private DebugOverlayView(Context context, int bgColor, double yOffset) {
            super(context);
            this.setVisibility(4);
            this.mBgColor = bgColor;
            this.mYOffset = yOffset;
            DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
            this.mDensity = displayMetrics.density;
            this.mDebugPaint = new Paint();
            this.mDebugPaint.setAntiAlias(false);
            this.mDebugFontMetrics = new Paint.FontMetrics();
            this.mPackageNameText = "package:" + InteractionMonitorDebugOverlay.this.mCurrentApplication.getPackageName();
            this.mPadding = this.dipToPx(5);
            this.mPackageNameFontSize = this.dipToPx(12);
            this.mCujFontSize = this.dipToPx(18);
            this.mCujNameTextHeight = this.getTextHeight(this.mCujFontSize);
            this.mCujStatusWidth = this.mCujNameTextHeight * 1.2f;
            this.mPackageNameTextHeight = this.getTextHeight(this.mPackageNameFontSize);
            this.mPackageNameWidth = this.getWidthOfText(this.mPackageNameText, this.mPackageNameFontSize);
        }

        private int dipToPx(int dip) {
            return (int)(this.mDensity * (float)dip + 0.5f);
        }

        private float getTextHeight(int textSize) {
            this.mDebugPaint.setTextSize(textSize);
            this.mDebugPaint.getFontMetrics(this.mDebugFontMetrics);
            return this.mDebugFontMetrics.descent - this.mDebugFontMetrics.ascent;
        }

        private float getWidthOfText(String text, int fontSize) {
            this.mDebugPaint.setTextSize(fontSize);
            return this.mDebugPaint.measureText(text);
        }

        private float getWidthOfLongestCujName(int cujFontSize) {
            this.mDebugPaint.setTextSize(cujFontSize);
            float maxLength = 0.0f;
            for (int i = 0; i < InteractionMonitorDebugOverlay.this.mRunningCujs.size(); ++i) {
                String cujName = Cuj.getNameOfCuj(InteractionMonitorDebugOverlay.this.mRunningCujs.get((int)i).mCuj);
                float textLength = this.mDebugPaint.measureText(cujName);
                if (!(textLength > maxLength)) continue;
                maxLength = textLength;
            }
            return maxLength;
        }

        @Override
        protected void onDraw(@NonNull Canvas canvas) {
            super.onDraw(canvas);
            Trace.asyncTraceForTrackBegin(4096L, TRACK_NAME, "DEBUG_OVERLAY_DRAW", 0);
            int h = this.getHeight();
            int w = this.getWidth();
            int dy = (int)((double)h * this.mYOffset);
            float maxLength = Math.max(this.mPackageNameWidth, this.getWidthOfLongestCujName(this.mCujFontSize)) + this.mCujStatusWidth;
            int dx = (int)(((float)w - maxLength) / 2.0f);
            canvas.translate(dx, dy);
            this.mDebugPaint.setColor(this.mBgColor);
            canvas.drawRect(-this.mPadding * 2, -this.mPadding, (float)(this.mPadding * 2) + maxLength, (float)(this.mPadding * 2) + this.mPackageNameTextHeight + this.mCujNameTextHeight * (float)InteractionMonitorDebugOverlay.this.mRunningCujs.size(), this.mDebugPaint);
            this.mDebugPaint.setTextSize(this.mPackageNameFontSize);
            this.mDebugPaint.setColor(-16777216);
            this.mDebugPaint.setStrikeThruText(false);
            canvas.translate(0.0f, this.mPackageNameTextHeight);
            canvas.drawText(this.mPackageNameText, 0.0f, 0.0f, this.mDebugPaint);
            this.mDebugPaint.setTextSize(this.mCujFontSize);
            for (int i = 0; i < InteractionMonitorDebugOverlay.this.mRunningCujs.size(); ++i) {
                String string2;
                TrackerState tracker = InteractionMonitorDebugOverlay.this.mRunningCujs.get(i);
                int status = tracker.mState;
                switch (status) {
                    case -1000: {
                        this.mDebugPaint.setColor(-16777216);
                        this.mDebugPaint.setStrikeThruText(false);
                        string2 = "\u2610";
                        break;
                    }
                    case 0: {
                        this.mDebugPaint.setColor(-7829368);
                        this.mDebugPaint.setStrikeThruText(false);
                        string2 = "\u2705";
                        break;
                    }
                    default: {
                        this.mDebugPaint.setColor(-65536);
                        this.mDebugPaint.setStrikeThruText(true);
                        string2 = "\u274c";
                    }
                }
                String statusText = string2;
                String cujName = Cuj.getNameOfCuj(tracker.mCuj);
                canvas.translate(0.0f, this.mCujNameTextHeight);
                canvas.drawText(statusText, 0.0f, 0.0f, this.mDebugPaint);
                canvas.drawText(cujName, this.mCujStatusWidth, 0.0f, this.mDebugPaint);
            }
            Trace.asyncTraceForTrackEnd(4096L, TRACK_NAME, 0);
        }
    }

    private static class TrackerState {
        final int mCookie;
        final int mCuj;
        int mState;

        private TrackerState(int cuj, int cookie) {
            this.mCuj = cuj;
            this.mCookie = cookie;
            this.mState = -1000;
        }
    }
}

