/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Color;
import android.util.TimingLogger;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.Quantizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class ColorCutQuantizer
implements Quantizer {
    private static final String LOG_TAG = "ColorCutQuantizer";
    private static final boolean LOG_TIMINGS = false;
    static final int COMPONENT_RED = -3;
    static final int COMPONENT_GREEN = -2;
    static final int COMPONENT_BLUE = -1;
    private static final int QUANTIZE_WORD_WIDTH = 5;
    private static final int QUANTIZE_WORD_MASK = 31;
    int[] mColors;
    int[] mHistogram;
    List<Palette.Swatch> mQuantizedColors;
    TimingLogger mTimingLogger;
    private final float[] mTempHsl = new float[3];
    private static final Comparator<Vbox> VBOX_COMPARATOR_VOLUME = new Comparator<Vbox>(){

        @Override
        public int compare(Vbox lhs, Vbox rhs) {
            return rhs.getVolume() - lhs.getVolume();
        }
    };

    ColorCutQuantizer() {
    }

    @Override
    public void quantize(int[] pixels, int maxColors) {
        this.mTimingLogger = null;
        this.mHistogram = new int[32768];
        int[] hist = this.mHistogram;
        for (int i = 0; i < pixels.length; ++i) {
            int quantizedColor;
            pixels[i] = quantizedColor = ColorCutQuantizer.quantizeFromRgb888(pixels[i]);
            int n = quantizedColor;
            hist[n] = hist[n] + 1;
        }
        int distinctColorCount = 0;
        for (int color2 = 0; color2 < hist.length; ++color2) {
            if (hist[color2] <= 0) continue;
            ++distinctColorCount;
        }
        this.mColors = new int[distinctColorCount];
        int[] colors = this.mColors;
        int distinctColorIndex = 0;
        for (int color3 = 0; color3 < hist.length; ++color3) {
            if (hist[color3] <= 0) continue;
            colors[distinctColorIndex++] = color3;
        }
        if (distinctColorCount <= maxColors) {
            this.mQuantizedColors = new ArrayList<Palette.Swatch>();
            for (int color4 : colors) {
                this.mQuantizedColors.add(new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(color4), hist[color4]));
            }
        } else {
            this.mQuantizedColors = this.quantizePixels(maxColors);
        }
    }

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return this.mQuantizedColors;
    }

    private List<Palette.Swatch> quantizePixels(int maxColors) {
        PriorityQueue<Vbox> pq = new PriorityQueue<Vbox>(maxColors, VBOX_COMPARATOR_VOLUME);
        pq.offer(new Vbox(0, this.mColors.length - 1));
        this.splitBoxes(pq, maxColors);
        return this.generateAverageColors(pq);
    }

    private void splitBoxes(PriorityQueue<Vbox> queue, int maxSize) {
        while (queue.size() < maxSize) {
            Vbox vbox = queue.poll();
            if (vbox != null && vbox.canSplit()) {
                queue.offer(vbox.splitBox());
                queue.offer(vbox);
                continue;
            }
            return;
        }
    }

    private List<Palette.Swatch> generateAverageColors(Collection<Vbox> vboxes) {
        ArrayList<Palette.Swatch> colors = new ArrayList<Palette.Swatch>(vboxes.size());
        for (Vbox vbox : vboxes) {
            Palette.Swatch swatch = vbox.getAverageColor();
            colors.add(swatch);
        }
        return colors;
    }

    static void modifySignificantOctet(int[] a, int dimension, int lower, int upper) {
        switch (dimension) {
            case -3: {
                break;
            }
            case -2: {
                for (int i = lower; i <= upper; ++i) {
                    int color2 = a[i];
                    a[i] = ColorCutQuantizer.quantizedGreen(color2) << 10 | ColorCutQuantizer.quantizedRed(color2) << 5 | ColorCutQuantizer.quantizedBlue(color2);
                }
                break;
            }
            case -1: {
                for (int i = lower; i <= upper; ++i) {
                    int color3 = a[i];
                    a[i] = ColorCutQuantizer.quantizedBlue(color3) << 10 | ColorCutQuantizer.quantizedGreen(color3) << 5 | ColorCutQuantizer.quantizedRed(color3);
                }
                break;
            }
        }
    }

    private static int quantizeFromRgb888(int color2) {
        int r = ColorCutQuantizer.modifyWordWidth(Color.red(color2), 8, 5);
        int g = ColorCutQuantizer.modifyWordWidth(Color.green(color2), 8, 5);
        int b = ColorCutQuantizer.modifyWordWidth(Color.blue(color2), 8, 5);
        return r << 10 | g << 5 | b;
    }

    static int approximateToRgb888(int r, int g, int b) {
        return Color.rgb(ColorCutQuantizer.modifyWordWidth(r, 5, 8), ColorCutQuantizer.modifyWordWidth(g, 5, 8), ColorCutQuantizer.modifyWordWidth(b, 5, 8));
    }

    private static int approximateToRgb888(int color2) {
        return ColorCutQuantizer.approximateToRgb888(ColorCutQuantizer.quantizedRed(color2), ColorCutQuantizer.quantizedGreen(color2), ColorCutQuantizer.quantizedBlue(color2));
    }

    static int quantizedRed(int color2) {
        return color2 >> 10 & 0x1F;
    }

    static int quantizedGreen(int color2) {
        return color2 >> 5 & 0x1F;
    }

    static int quantizedBlue(int color2) {
        return color2 & 0x1F;
    }

    private static int modifyWordWidth(int value, int currentWidth, int targetWidth) {
        int newValue = targetWidth > currentWidth ? value << targetWidth - currentWidth : value >> currentWidth - targetWidth;
        return newValue & (1 << targetWidth) - 1;
    }

    private class Vbox {
        private final int mLowerIndex;
        private int mUpperIndex;
        private int mPopulation;
        private int mMinRed;
        private int mMaxRed;
        private int mMinGreen;
        private int mMaxGreen;
        private int mMinBlue;
        private int mMaxBlue;

        Vbox(int lowerIndex, int upperIndex) {
            this.mLowerIndex = lowerIndex;
            this.mUpperIndex = upperIndex;
            this.fitBox();
        }

        int getVolume() {
            return (this.mMaxRed - this.mMinRed + 1) * (this.mMaxGreen - this.mMinGreen + 1) * (this.mMaxBlue - this.mMinBlue + 1);
        }

        boolean canSplit() {
            return this.getColorCount() > 1;
        }

        int getColorCount() {
            return 1 + this.mUpperIndex - this.mLowerIndex;
        }

        void fitBox() {
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            int minBlue = Integer.MAX_VALUE;
            int minGreen = Integer.MAX_VALUE;
            int minRed = Integer.MAX_VALUE;
            int maxBlue = Integer.MIN_VALUE;
            int maxGreen = Integer.MIN_VALUE;
            int maxRed = Integer.MIN_VALUE;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color2 = colors[i];
                count += hist[color2];
                int r = ColorCutQuantizer.quantizedRed(color2);
                int g = ColorCutQuantizer.quantizedGreen(color2);
                int b = ColorCutQuantizer.quantizedBlue(color2);
                if (r > maxRed) {
                    maxRed = r;
                }
                if (r < minRed) {
                    minRed = r;
                }
                if (g > maxGreen) {
                    maxGreen = g;
                }
                if (g < minGreen) {
                    minGreen = g;
                }
                if (b > maxBlue) {
                    maxBlue = b;
                }
                if (b >= minBlue) continue;
                minBlue = b;
            }
            this.mMinRed = minRed;
            this.mMaxRed = maxRed;
            this.mMinGreen = minGreen;
            this.mMaxGreen = maxGreen;
            this.mMinBlue = minBlue;
            this.mMaxBlue = maxBlue;
            this.mPopulation = count;
        }

        Vbox splitBox() {
            if (!this.canSplit()) {
                throw new IllegalStateException("Can not split a box with only 1 color");
            }
            int splitPoint = this.findSplitPoint();
            Vbox newBox = new Vbox(splitPoint + 1, this.mUpperIndex);
            this.mUpperIndex = splitPoint;
            this.fitBox();
            return newBox;
        }

        int getLongestColorDimension() {
            int redLength = this.mMaxRed - this.mMinRed;
            int greenLength = this.mMaxGreen - this.mMinGreen;
            int blueLength = this.mMaxBlue - this.mMinBlue;
            if (redLength >= greenLength && redLength >= blueLength) {
                return -3;
            }
            if (greenLength >= redLength && greenLength >= blueLength) {
                return -2;
            }
            return -1;
        }

        int findSplitPoint() {
            int longestDimension = this.getLongestColorDimension();
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            Arrays.sort(colors, this.mLowerIndex, this.mUpperIndex + 1);
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            int midPoint = this.mPopulation / 2;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                if ((count += hist[colors[i]]) < midPoint) continue;
                return Math.min(this.mUpperIndex - 1, i);
            }
            return this.mLowerIndex;
        }

        Palette.Swatch getAverageColor() {
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            int totalPopulation = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color2 = colors[i];
                int colorPopulation = hist[color2];
                totalPopulation += colorPopulation;
                redSum += colorPopulation * ColorCutQuantizer.quantizedRed(color2);
                greenSum += colorPopulation * ColorCutQuantizer.quantizedGreen(color2);
                blueSum += colorPopulation * ColorCutQuantizer.quantizedBlue(color2);
            }
            int redMean = Math.round((float)redSum / (float)totalPopulation);
            int greenMean = Math.round((float)greenSum / (float)totalPopulation);
            int blueMean = Math.round((float)blueSum / (float)totalPopulation);
            return new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(redMean, greenMean, blueMean), totalPopulation);
        }
    }
}

