/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.parsing.ApkLite;
import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.parsing.result.ParseTypeImpl;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.om.OverlayConfigParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class OverlayScanner {
    private final ArrayMap<String, ParsedOverlayInfo> mParsedOverlayInfos = new ArrayMap();
    private final List<Pair<String, File>> mExcludedOverlayPackages = new ArrayList<Pair<String, File>>();

    @Nullable
    public ParsedOverlayInfo getParsedInfo(String packageName) {
        return this.mParsedOverlayInfos.get(packageName);
    }

    @NonNull
    Collection<ParsedOverlayInfo> getAllParsedInfos() {
        return this.mParsedOverlayInfos.values();
    }

    boolean isExcludedOverlayPackage(@NonNull String packageName, @NonNull OverlayConfigParser.OverlayPartition overlayPartition) {
        for (int i = 0; i < this.mExcludedOverlayPackages.size(); ++i) {
            Pair<String, File> pair = this.mExcludedOverlayPackages.get(i);
            if (!((String)pair.first).equals(packageName) || !overlayPartition.containsOverlay((File)pair.second)) continue;
            return true;
        }
        return false;
    }

    public void scanDir(File partitionOverlayDir) {
        if (!partitionOverlayDir.exists() || !partitionOverlayDir.isDirectory()) {
            return;
        }
        if (!partitionOverlayDir.canRead()) {
            Log.w("OverlayConfig", "Directory " + partitionOverlayDir + " cannot be read");
            return;
        }
        File[] files = partitionOverlayDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            ParsedOverlayInfo info;
            File f = files[i];
            if (f.isDirectory()) {
                this.scanDir(f);
            }
            if (!f.isFile() || !f.getPath().endsWith(".apk") || (info = this.parseOverlayManifest(f, this.mExcludedOverlayPackages)) == null) continue;
            this.mParsedOverlayInfos.put(info.packageName, info);
        }
    }

    @VisibleForTesting
    public ParsedOverlayInfo parseOverlayManifest(File overlayApk, List<Pair<String, File>> outExcludedOverlayPackages) {
        ParseTypeImpl input = ParseTypeImpl.forParsingWithoutPlatformCompat();
        ParseResult<ApkLite> ret = ApkLiteParseUtils.parseApkLite(input.reset(), overlayApk, 128);
        if (ret.isError()) {
            Log.w("OverlayConfig", "Got exception loading overlay.", ret.getException());
            return null;
        }
        ApkLite apkLite = ret.getResult();
        if (apkLite.getTargetPackageName() == null) {
            return null;
        }
        String propName = apkLite.getRequiredSystemPropertyName();
        String propValue = apkLite.getRequiredSystemPropertyValue();
        if (!(TextUtils.isEmpty(propName) && TextUtils.isEmpty(propValue) || FrameworkParsingPackageUtils.checkRequiredSystemProperties(propName, propValue))) {
            outExcludedOverlayPackages.add(Pair.create(apkLite.getPackageName(), overlayApk));
            return null;
        }
        return new ParsedOverlayInfo(apkLite.getPackageName(), apkLite.getTargetPackageName(), apkLite.getTargetSdkVersion(), apkLite.isOverlayIsStatic(), apkLite.getOverlayPriority(), new File(apkLite.getPath()), null);
    }

    public static class ParsedOverlayInfo {
        public final String packageName;
        public final String targetPackageName;
        public final int targetSdkVersion;
        public final boolean isStatic;
        public final int priority;
        public final File path;
        @Nullable
        public final File preInstalledApexPath;

        public ParsedOverlayInfo(String packageName, String targetPackageName, int targetSdkVersion, boolean isStatic, int priority, File path, @Nullable File preInstalledApexPath) {
            this.packageName = packageName;
            this.targetPackageName = targetPackageName;
            this.targetSdkVersion = targetSdkVersion;
            this.isStatic = isStatic;
            this.priority = priority;
            this.path = path;
            this.preInstalledApexPath = preInstalledApexPath;
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format("{packageName=%s, targetPackageName=%s, targetSdkVersion=%s, isStatic=%s, priority=%s, path=%s, preInstalledApexPath=%s}", this.packageName, this.targetPackageName, this.targetSdkVersion, this.isStatic, this.priority, this.path, this.preInstalledApexPath);
        }

        @NonNull
        public File getOriginalPartitionPath() {
            return this.preInstalledApexPath != null ? this.preInstalledApexPath : this.path;
        }
    }
}

