/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content.om;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.PackagePartitions;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.om.OverlayScanner;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@VisibleForTesting
public class OverlayConfigParser {
    static final boolean DEFAULT_ENABLED_STATE = false;
    static final boolean DEFAULT_MUTABILITY = true;
    private static final int MAXIMUM_MERGE_DEPTH = 5;
    private static final String CONFIG_DIRECTORY = "config";
    private static final String CONFIG_DEFAULT_FILENAME = "config/config.xml";

    @Nullable
    static ArrayList<ParsedConfiguration> getConfigurations(@NonNull OverlayPartition partition, @Nullable OverlayScanner scanner, @Nullable Map<String, OverlayScanner.ParsedOverlayInfo> packageManagerOverlayInfos, @NonNull List<String> activeApexes) {
        if (scanner != null) {
            if (partition.getOverlayFolder() != null) {
                scanner.scanDir(partition.getOverlayFolder());
            }
            for (String apex : activeApexes) {
                scanner.scanDir(new File("/apex/" + apex + "/overlay/"));
            }
        }
        if (partition.getOverlayFolder() == null) {
            return null;
        }
        File configFile = new File(partition.getOverlayFolder(), CONFIG_DEFAULT_FILENAME);
        if (!configFile.exists()) {
            return null;
        }
        ParsingContext parsingContext = new ParsingContext(partition);
        OverlayConfigParser.readConfigFile(configFile, scanner, packageManagerOverlayInfos, parsingContext);
        return parsingContext.mOrderedConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfigFile(@NonNull File configFile, @Nullable OverlayScanner scanner, @Nullable Map<String, OverlayScanner.ParsedOverlayInfo> packageManagerOverlayInfos, @NonNull ParsingContext parsingContext) {
        FileReader configReader;
        try {
            configReader = new FileReader(configFile);
        }
        catch (FileNotFoundException e) {
            Log.w("OverlayConfig", "Couldn't find or open overlay configuration file " + configFile);
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((Reader)configReader);
            XmlUtils.beginDocument(parser, CONFIG_DIRECTORY);
            int depth = parser.getDepth();
            block15: while (XmlUtils.nextElementWithin(parser, depth)) {
                String name;
                switch (name = parser.getName()) {
                    case "merge": {
                        OverlayConfigParser.parseMerge(configFile, parser, scanner, packageManagerOverlayInfos, parsingContext);
                        continue block15;
                    }
                    case "overlay": {
                        OverlayConfigParser.parseOverlay(configFile, parser, scanner, packageManagerOverlayInfos, parsingContext);
                        continue block15;
                    }
                }
                Log.w("OverlayConfig", String.format("Tag %s is unknown in %s at %s", name, configFile, parser.getPositionDescription()));
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.w("OverlayConfig", "Got exception parsing overlay configuration.", e);
        }
        finally {
            IoUtils.closeQuietly(configReader);
        }
    }

    @VisibleForTesting
    public static String expandProperty(String configPath, SysPropWrapper sysPropWrapper) {
        if (configPath == null) {
            return null;
        }
        int propStartPos = configPath.indexOf("${");
        if (propStartPos == -1) {
            return configPath;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(configPath.substring(0, propStartPos));
        int propEndPos = configPath.indexOf("}", propStartPos);
        if (propEndPos == -1) {
            throw new IllegalStateException("Malformed property, unmatched braces, in: " + configPath);
        }
        if (configPath.indexOf("${", propStartPos + 2) != -1) {
            throw new IllegalStateException("Only a single property supported in path: " + configPath);
        }
        String propertyName = configPath.substring(propStartPos + 2, propEndPos);
        if (!propertyName.startsWith("ro.")) {
            throw new IllegalStateException("Only read only properties can be used when merging RRO config files: " + propertyName);
        }
        String propertyValue = sysPropWrapper.get(propertyName);
        if (TextUtils.isEmpty(propertyValue)) {
            throw new IllegalStateException("Property is empty or doesn't exist: " + propertyName);
        }
        Log.d("OverlayConfig", String.format("Using property in overlay config path: \"%s\"", propertyName));
        sb.append(propertyValue);
        if (++propEndPos < configPath.length()) {
            sb.append(configPath.substring(propEndPos));
        }
        return sb.toString();
    }

    private static void parseMerge(@NonNull File configFile, @NonNull XmlPullParser parser, @Nullable OverlayScanner scanner, @Nullable Map<String, OverlayScanner.ParsedOverlayInfo> packageManagerOverlayInfos, @NonNull ParsingContext parsingContext) {
        File includedConfigFile;
        File configDirectory;
        String path;
        try {
            SysPropWrapper sysPropWrapper = p -> SystemProperties.get(p, "");
            path = OverlayConfigParser.expandProperty(parser.getAttributeValue(null, "path"), sysPropWrapper);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format("<merge> path expand error in %s at %s", configFile, parser.getPositionDescription()), e);
        }
        if (path == null) {
            throw new IllegalStateException(String.format("<merge> without path in %s at %s", configFile, parser.getPositionDescription()));
        }
        if (path.startsWith("/")) {
            throw new IllegalStateException(String.format("Path %s must be relative to the directory containing overlay configurations  files in %s at %s ", path, configFile, parser.getPositionDescription()));
        }
        if (parsingContext.mMergeDepth++ == 5) {
            throw new IllegalStateException(String.format("Maximum <merge> depth exceeded in %s at %s", configFile, parser.getPositionDescription()));
        }
        try {
            configDirectory = new File(parsingContext.mPartition.getOverlayFolder(), CONFIG_DIRECTORY).getCanonicalFile();
            includedConfigFile = new File(configDirectory, path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Couldn't find or open merged configuration file %s in %s at %s", path, configFile, parser.getPositionDescription()), e);
        }
        if (!includedConfigFile.exists()) {
            throw new IllegalStateException(String.format("Merged configuration file %s does not exist in %s at %s", path, configFile, parser.getPositionDescription()));
        }
        if (!FileUtils.contains(configDirectory, includedConfigFile)) {
            throw new IllegalStateException(String.format("Merged file %s outside of configuration directory in %s at %s", includedConfigFile.getAbsolutePath(), includedConfigFile, parser.getPositionDescription()));
        }
        OverlayConfigParser.readConfigFile(includedConfigFile, scanner, packageManagerOverlayInfos, parsingContext);
        --parsingContext.mMergeDepth;
    }

    private static void parseOverlay(@NonNull File configFile, @NonNull XmlPullParser parser, @Nullable OverlayScanner scanner, @Nullable Map<String, OverlayScanner.ParsedOverlayInfo> packageManagerOverlayInfos, @NonNull ParsingContext parsingContext) {
        Preconditions.checkArgument(scanner == null != (packageManagerOverlayInfos == null), "scanner and packageManagerOverlayInfos cannot be both null or both non-null");
        String packageName = parser.getAttributeValue(null, "package");
        if (packageName == null) {
            throw new IllegalStateException(String.format("\"<overlay> without package in %s at %s", configFile, parser.getPositionDescription()));
        }
        OverlayScanner.ParsedOverlayInfo info = null;
        if (scanner != null) {
            info = scanner.getParsedInfo(packageName);
            if (info == null && scanner.isExcludedOverlayPackage(packageName, parsingContext.mPartition)) {
                Log.d("OverlayConfig", "overlay " + packageName + " in partition " + parsingContext.mPartition.getOverlayFolder() + " is ignored.");
                return;
            }
            if (info == null || !parsingContext.mPartition.containsOverlay(info.path)) {
                throw new IllegalStateException(String.format("overlay %s not present in partition %s in %s at %s", packageName, parsingContext.mPartition.getOverlayFolder(), configFile, parser.getPositionDescription()));
            }
        } else if (packageManagerOverlayInfos.get(packageName) == null) {
            Log.d("OverlayConfig", "overlay " + packageName + " in partition " + parsingContext.mPartition.getOverlayFolder() + " is ignored.");
            return;
        }
        if (parsingContext.mConfiguredOverlays.contains(packageName)) {
            throw new IllegalStateException(String.format("overlay %s configured multiple times in a single partition in %s at %s", packageName, configFile, parser.getPositionDescription()));
        }
        boolean isEnabled = false;
        String enabled = parser.getAttributeValue(null, "enabled");
        if (enabled != null) {
            isEnabled = !"false".equals(enabled);
        }
        boolean isMutable = true;
        String mutable = parser.getAttributeValue(null, "mutable");
        if (mutable != null) {
            boolean bl = isMutable = !"false".equals(mutable);
            if (!isMutable && parsingContext.mFoundMutableOverlay) {
                throw new IllegalStateException(String.format("immutable overlays must precede mutable overlays: found in %s at %s", configFile, parser.getPositionDescription()));
            }
        }
        if (isMutable) {
            parsingContext.mFoundMutableOverlay = true;
        } else if (!isEnabled) {
            Log.w("OverlayConfig", "found default-disabled immutable overlay " + packageName);
        }
        ParsedConfigFile parsedConfigFile = new ParsedConfigFile(configFile.getPath().intern(), parser.getLineNumber(), _Original_Build.IS_ENG || _Original_Build.IS_USERDEBUG ? OverlayConfigParser.currentParserContextToString(parser) : null);
        ParsedConfiguration config = new ParsedConfiguration(packageName, isEnabled, isMutable, parsingContext.mPartition.policy, info, parsedConfigFile);
        parsingContext.mConfiguredOverlays.add(packageName);
        parsingContext.mOrderedConfigurations.add(config);
    }

    private static String currentParserContextToString(@NonNull XmlPullParser parser) {
        StringBuilder sb = new StringBuilder("<");
        sb.append(parser.getName());
        sb.append(" ");
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            sb.append(parser.getAttributeName(i));
            sb.append("=\"");
            sb.append(parser.getAttributeValue(i));
            sb.append("\" ");
        }
        sb.append("/>");
        return sb.toString();
    }

    @VisibleForTesting
    public static class OverlayPartition
    extends PackagePartitions.SystemPartition {
        static final String POLICY_ODM = "odm";
        static final String POLICY_OEM = "oem";
        static final String POLICY_PRODUCT = "product";
        static final String POLICY_PUBLIC = "public";
        static final String POLICY_SYSTEM = "system";
        static final String POLICY_VENDOR = "vendor";
        @NonNull
        public final String policy;

        @VisibleForTesting
        public OverlayPartition(@NonNull PackagePartitions.SystemPartition partition) {
            super(partition);
            this.policy = OverlayPartition.policyForPartition(partition);
        }

        OverlayPartition(@NonNull File folder, @NonNull PackagePartitions.SystemPartition original) {
            super(folder, original);
            this.policy = OverlayPartition.policyForPartition(original);
        }

        private static String policyForPartition(PackagePartitions.SystemPartition partition) {
            switch (partition.type) {
                case 0: 
                case 5: {
                    return POLICY_SYSTEM;
                }
                case 1: {
                    return POLICY_VENDOR;
                }
                case 2: {
                    return POLICY_ODM;
                }
                case 3: {
                    return POLICY_OEM;
                }
                case 4: {
                    return POLICY_PRODUCT;
                }
            }
            throw new IllegalStateException("Unable to determine policy for " + partition.getFolder());
        }
    }

    private static class ParsingContext {
        private final OverlayPartition mPartition;
        private final ArrayList<ParsedConfiguration> mOrderedConfigurations = new ArrayList();
        private final ArraySet<String> mConfiguredOverlays = new ArraySet();
        private boolean mFoundMutableOverlay;
        private int mMergeDepth;

        private ParsingContext(OverlayPartition partition) {
            this.mPartition = partition;
        }
    }

    @FunctionalInterface
    public static interface SysPropWrapper {
        public String get(String var1);
    }

    public static class ParsedConfigFile {
        @NonNull
        public final String path;
        @NonNull
        public final int line;
        @Nullable
        public final String xml;

        ParsedConfigFile(@NonNull String path, int line, @Nullable String xml2) {
            this.path = path;
            this.line = line;
            this.xml = xml2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("{path=");
            sb.append(this.path);
            sb.append(", line=");
            sb.append(this.line);
            if (this.xml != null) {
                sb.append(", xml=");
                sb.append(this.xml);
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static class ParsedConfiguration {
        @NonNull
        public final String packageName;
        public final boolean enabled;
        public final boolean mutable;
        @NonNull
        public final String policy;
        @Nullable
        public final OverlayScanner.ParsedOverlayInfo parsedInfo;
        @Nullable
        public final ParsedConfigFile parsedConfigFile;

        ParsedConfiguration(@NonNull String packageName, boolean enabled, boolean mutable, @NonNull String policy, @Nullable OverlayScanner.ParsedOverlayInfo parsedInfo, @Nullable ParsedConfigFile parsedConfigFile) {
            this.packageName = packageName;
            this.enabled = enabled;
            this.mutable = mutable;
            this.policy = policy;
            this.parsedInfo = parsedInfo;
            this.parsedConfigFile = parsedConfigFile;
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format("{packageName=%s, enabled=%s, mutable=%s, policy=%s, parsedInfo=%s, parsedConfigFile=%s}", this.packageName, this.enabled, this.mutable, this.policy, this.parsedInfo, this.parsedConfigFile);
        }
    }
}

