/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.Nullable;
import android.content.Context;
import android.os.UserHandle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;

@VisibleForTesting
public class ResolverMultiProfilePagerAdapter
extends AbstractMultiProfilePagerAdapter {
    private final ResolverProfileDescriptor[] mItems;
    private boolean mUseLayoutWithDefault;

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter adapter, AbstractMultiProfilePagerAdapter.EmptyStateProvider emptyStateProvider, AbstractMultiProfilePagerAdapter.QuietModeManager quietModeManager, UserHandle workProfileUserHandle, UserHandle cloneUserHandle) {
        super(context, 0, emptyStateProvider, quietModeManager, workProfileUserHandle, cloneUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(adapter)};
    }

    ResolverMultiProfilePagerAdapter(Context context, ResolverListAdapter personalAdapter, ResolverListAdapter workAdapter, AbstractMultiProfilePagerAdapter.EmptyStateProvider emptyStateProvider, AbstractMultiProfilePagerAdapter.QuietModeManager quietModeManager, @AbstractMultiProfilePagerAdapter.Profile int defaultProfile, UserHandle workProfileUserHandle, UserHandle cloneUserHandle) {
        super(context, defaultProfile, emptyStateProvider, quietModeManager, workProfileUserHandle, cloneUserHandle);
        this.mItems = new ResolverProfileDescriptor[]{this.createProfileDescriptor(personalAdapter), this.createProfileDescriptor(workAdapter)};
    }

    private ResolverProfileDescriptor createProfileDescriptor(ResolverListAdapter adapter) {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        ViewGroup rootView = (ViewGroup)inflater.inflate(17367341, null, false);
        return new ResolverProfileDescriptor(this, rootView, adapter);
    }

    ListView getListViewForIndex(int index) {
        return this.getItem((int)index).listView;
    }

    @Override
    public ResolverProfileDescriptor getItem(int pageIndex) {
        return this.mItems[pageIndex];
    }

    @Override
    int getItemCount() {
        return this.mItems.length;
    }

    @Override
    void setupListAdapter(int pageIndex) {
        ListView listView = this.getItem((int)pageIndex).listView;
        listView.setAdapter(this.getItem((int)pageIndex).resolverListAdapter);
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getAdapterForIndex(int pageIndex) {
        return this.mItems[pageIndex].resolverListAdapter;
    }

    @Override
    public ViewGroup instantiateItem(ViewGroup container, int position) {
        this.setupListAdapter(position);
        return super.instantiateItem(container, position);
    }

    @Override
    @Nullable
    ResolverListAdapter getListAdapterForUserHandle(UserHandle userHandle) {
        if (this.getPersonalListAdapter().getUserHandle().equals(userHandle) || userHandle.equals(this.getCloneUserHandle())) {
            return this.getPersonalListAdapter();
        }
        if (this.getWorkListAdapter() != null && this.getWorkListAdapter().getUserHandle().equals(userHandle)) {
            return this.getWorkListAdapter();
        }
        return null;
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getActiveListAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage());
    }

    @Override
    @VisibleForTesting
    public ResolverListAdapter getInactiveListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1 - this.getCurrentPage());
    }

    @Override
    public ResolverListAdapter getPersonalListAdapter() {
        return this.getAdapterForIndex(0);
    }

    @Override
    @Nullable
    public ResolverListAdapter getWorkListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1);
    }

    @Override
    ResolverListAdapter getCurrentRootAdapter() {
        return this.getActiveListAdapter();
    }

    @Override
    ListView getActiveAdapterView() {
        return this.getListViewForIndex(this.getCurrentPage());
    }

    @Override
    @Nullable
    ViewGroup getInactiveAdapterView() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getListViewForIndex(1 - this.getCurrentPage());
    }

    void setUseLayoutWithDefault(boolean useLayoutWithDefault) {
        this.mUseLayoutWithDefault = useLayoutWithDefault;
    }

    @Override
    protected void setupContainerPadding(View container) {
        int bottom = this.mUseLayoutWithDefault ? container.getPaddingBottom() : 0;
        container.setPadding(container.getPaddingLeft(), container.getPaddingTop(), container.getPaddingRight(), bottom);
    }

    class ResolverProfileDescriptor
    extends AbstractMultiProfilePagerAdapter.ProfileDescriptor {
        private ResolverListAdapter resolverListAdapter;
        final ListView listView;

        ResolverProfileDescriptor(ResolverMultiProfilePagerAdapter this$0, ViewGroup rootView, ResolverListAdapter adapter) {
            super(rootView);
            this.resolverListAdapter = adapter;
            this.listView = (ListView)rootView.findViewById(16909508);
        }
    }
}

