/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.LocaleConfig;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.InstallSourceInfo;
import android.content.pm.PackageManager;
import android.os.LocaleList;
import android.util.Log;
import java.util.HashSet;
import java.util.Locale;
import java.util.stream.Collectors;

public class AppLocaleStore {
    private static final String TAG = AppLocaleStore.class.getSimpleName();

    public static AppLocaleResult getAppSupportedLocales(Context context, String packageName) {
        LocaleConfig localeConfig = null;
        AppLocaleResult.LocaleStatus localeStatus = AppLocaleResult.LocaleStatus.UNKNOWN_FAILURE;
        HashSet<Object> appSupportedLocales = new HashSet();
        HashSet<Locale> assetLocale = AppLocaleStore.getAssetLocales(context, packageName);
        try {
            localeConfig = new LocaleConfig(context.createPackageContext(packageName, 0));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Can not found the package name : " + packageName + " / " + e);
        }
        if (localeConfig != null) {
            if (localeConfig.getStatus() == 0) {
                LocaleList packageLocaleList = localeConfig.getSupportedLocales();
                boolean shouldFilterNotMatchingLocale = !AppLocaleStore.hasInstallerInfo(context, packageName) && AppLocaleStore.isSystemApp(context, packageName);
                Log.d(TAG, "filterNonMatchingLocale. , shouldFilterNotMatchingLocale: " + shouldFilterNotMatchingLocale + ", assetLocale size: " + assetLocale.size() + ", packageLocaleList size: " + packageLocaleList.size());
                for (int i = 0; i < packageLocaleList.size(); ++i) {
                    appSupportedLocales.add(packageLocaleList.get(i));
                }
                if (shouldFilterNotMatchingLocale) {
                    appSupportedLocales = AppLocaleStore.filterNotMatchingLocale(appSupportedLocales, assetLocale);
                }
                localeStatus = appSupportedLocales.size() > 0 ? AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_LOCAL_CONFIG : AppLocaleResult.LocaleStatus.NO_SUPPORTED_LANGUAGE_IN_APP;
            } else if (localeConfig.getStatus() == 1) {
                if (assetLocale.size() > 0) {
                    localeStatus = AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_ASSET;
                    appSupportedLocales = assetLocale;
                } else {
                    localeStatus = AppLocaleResult.LocaleStatus.ASSET_LOCALE_IS_EMPTY;
                }
            }
        }
        Log.d(TAG, "getAppSupportedLocales(). package: " + packageName + ", status: " + (Object)((Object)localeStatus) + ", appSupportedLocales:" + appSupportedLocales.size());
        return new AppLocaleResult(localeStatus, appSupportedLocales);
    }

    private static HashSet<Locale> getAssetLocales(Context context, String packageName) {
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            PackageManager packageManager = context.getPackageManager();
            String[] locales = packageManager.getResourcesForApplication(packageManager.getPackageInfo((String)packageName, (int)131072).applicationInfo).getAssets().getNonSystemLocales();
            if (locales == null) {
                Log.i(TAG, "[" + packageName + "] locales are null.");
            } else if (locales.length <= 0) {
                Log.i(TAG, "[" + packageName + "] locales length is 0.");
            } else {
                for (String language : locales) {
                    result.add(Locale.forLanguageTag(language));
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Can not found the package name : " + packageName + " / " + e);
        }
        return result;
    }

    private static HashSet<Locale> filterNotMatchingLocale(HashSet<Locale> appSupportedLocales, HashSet<Locale> assetLocale) {
        return appSupportedLocales.stream().filter(locale -> AppLocaleStore.matchLanguageInSet(locale, assetLocale)).collect(Collectors.toCollection(HashSet::new));
    }

    private static boolean matchLanguageInSet(Locale locale, HashSet<Locale> localesSet) {
        if (localesSet.contains(locale)) {
            return true;
        }
        for (Locale l : localesSet) {
            if (!LocaleList.matchesLanguageAndScript(l, locale)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInstallerInfo(Context context, String packageName) {
        try {
            InstallSourceInfo installSourceInfo = context.getPackageManager().getInstallSourceInfo(packageName);
            return installSourceInfo != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Installer info not found for: " + packageName);
            return false;
        }
    }

    private static boolean isSystemApp(Context context, String packageName) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfoAsUser(packageName, 0, context.getUserId());
            return applicationInfo.isSystemApp();
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Application info not found for: " + packageName);
            return false;
        }
    }

    public static class AppLocaleResult {
        LocaleStatus mLocaleStatus;
        public HashSet<Locale> mAppSupportedLocales;

        public AppLocaleResult(LocaleStatus localeStatus, HashSet<Locale> appSupportedLocales) {
            this.mLocaleStatus = localeStatus;
            this.mAppSupportedLocales = appSupportedLocales;
        }

        public static enum LocaleStatus {
            UNKNOWN_FAILURE,
            NO_SUPPORTED_LANGUAGE_IN_APP,
            ASSET_LOCALE_IS_EMPTY,
            GET_SUPPORTED_LANGUAGE_FROM_LOCAL_CONFIG,
            GET_SUPPORTED_LANGUAGE_FROM_ASSET;

        }
    }
}

