/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import com.android.i18n.timezone.internal.BufferIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Arrays;

public class ZoneInfoData {
    public static final ObjectStreamField[] ZONEINFO_SERIALIZED_FIELDS = new ObjectStreamField[]{new ObjectStreamField("mRawOffset", Integer.TYPE), new ObjectStreamField("mEarliestRawOffset", Integer.TYPE), new ObjectStreamField("mTransitions", long[].class), new ObjectStreamField("mTypes", byte[].class), new ObjectStreamField("mOffsets", int[].class), new ObjectStreamField("mIsDsts", byte[].class)};
    private final String mId;
    private final int mRawOffset;
    private final int mEarliestRawOffset;
    final long[] mTransitions;
    final byte[] mTypes;
    final int[] mOffsets;
    final byte[] mIsDsts;

    private ZoneInfoData(String id2, int rawOffset, int earliestRawOffset, long[] transitions, byte[] types, int[] offsets, byte[] isDsts) {
        this.mId = id2;
        this.mRawOffset = rawOffset;
        this.mEarliestRawOffset = earliestRawOffset;
        this.mTransitions = transitions;
        this.mTypes = types;
        this.mOffsets = offsets;
        this.mIsDsts = isDsts;
    }

    private ZoneInfoData(ZoneInfoData that) {
        this(that, that.mRawOffset);
    }

    private ZoneInfoData(ZoneInfoData that, int newRawOffset) {
        this.mRawOffset = newRawOffset;
        this.mId = that.mId;
        this.mEarliestRawOffset = that.mEarliestRawOffset;
        this.mTransitions = that.mTransitions == null ? null : (long[])that.mTransitions.clone();
        this.mTypes = that.mTypes == null ? null : (byte[])that.mTypes.clone();
        this.mOffsets = that.mOffsets == null ? null : (int[])that.mOffsets.clone();
        this.mIsDsts = that.mIsDsts == null ? null : (byte[])that.mIsDsts.clone();
    }

    public static ZoneInfoData readTimeZone(String id2, BufferIterator it) throws IOException {
        ZoneInfoData.skipOver32BitData(id2, it);
        return ZoneInfoData.read64BitData(id2, it);
    }

    private static void skipOver32BitData(String id2, BufferIterator it) throws IOException {
        int tzh_magic = it.readInt();
        if (tzh_magic != 1415211366) {
            throw new IOException("Timezone id=" + id2 + " has an invalid header=" + tzh_magic);
        }
        byte tzh_version = it.readByte();
        ZoneInfoData.checkTzifVersionAcceptable(id2, tzh_version);
        it.skip(15);
        int tzh_ttisgmtcnt = it.readInt();
        int tzh_ttisstdcnt = it.readInt();
        int tzh_leapcnt = it.readInt();
        int tzh_timecnt = it.readInt();
        int tzh_typecnt = it.readInt();
        int tzh_charcnt = it.readInt();
        int transitionInfoSize = 5;
        it.skip(tzh_timecnt * 5);
        int ttinfoSize = 6;
        it.skip(tzh_typecnt * 6);
        it.skip(tzh_charcnt);
        int leapInfoSize = 8;
        it.skip(tzh_leapcnt * leapInfoSize);
        it.skip(tzh_ttisstdcnt + tzh_ttisgmtcnt);
    }

    private static ZoneInfoData read64BitData(String id2, BufferIterator it) throws IOException {
        int tzh_magic = it.readInt();
        if (tzh_magic != 1415211366) {
            throw new IOException("Timezone id=" + id2 + " has an invalid header=" + tzh_magic);
        }
        byte tzh_version = it.readByte();
        ZoneInfoData.checkTzifVersionAcceptable(id2, tzh_version);
        it.skip(27);
        int tzh_timecnt = it.readInt();
        int MAX_TRANSITIONS = 2000;
        if (tzh_timecnt < 0 || tzh_timecnt > 2000) {
            throw new IOException("Timezone id=" + id2 + " has an invalid number of transitions=" + tzh_timecnt);
        }
        int tzh_typecnt = it.readInt();
        int MAX_TYPES = 256;
        if (tzh_typecnt < 1) {
            throw new IOException("ZoneInfo requires at least one type to be provided for each timezone but could not find one for '" + id2 + "'");
        }
        if (tzh_typecnt > 256) {
            throw new IOException("Timezone with id " + id2 + " has too many types=" + tzh_typecnt);
        }
        it.skip(4);
        long[] transitions64 = new long[tzh_timecnt];
        it.readLongArray(transitions64, 0, transitions64.length);
        for (int i = 0; i < tzh_timecnt; ++i) {
            if (i <= 0 || transitions64[i] > transitions64[i - 1]) continue;
            throw new IOException(id2 + " transition at " + i + " is not sorted correctly, is " + transitions64[i] + ", previous is " + transitions64[i - 1]);
        }
        byte[] types = new byte[tzh_timecnt];
        it.readByteArray(types, 0, types.length);
        for (int i = 0; i < types.length; ++i) {
            int typeIndex = types[i] & 0xFF;
            if (typeIndex < tzh_typecnt) continue;
            throw new IOException(id2 + " type at " + i + " is not < " + tzh_typecnt + ", is " + typeIndex);
        }
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = it.readInt();
            byte isDst = it.readByte();
            if (isDst != 0 && isDst != 1) {
                throw new IOException(id2 + " dst at " + i + " is not 0 or 1, is " + isDst);
            }
            isDsts[i] = isDst;
            it.skip(1);
        }
        return new ZoneInfoData(id2, transitions64, types, gmtOffsets, isDsts);
    }

    private static void checkTzifVersionAcceptable(String id2, byte tzh_version) throws IOException {
        char tzh_version_char = (char)tzh_version;
        if (tzh_version_char != '2' && tzh_version_char != '3') {
            throw new IOException("Timezone id=" + id2 + " has an invalid format version='" + tzh_version_char + "' (" + tzh_version + ")");
        }
    }

    private ZoneInfoData(String name, long[] transitions, byte[] types, int[] gmtOffsets, byte[] isDsts) {
        int rawOffsetInSeconds;
        if (gmtOffsets.length == 0) {
            throw new IllegalArgumentException("ZoneInfo requires at least one offset to be provided for each timezone but could not find one for '" + name + "'");
        }
        this.mTransitions = transitions;
        this.mTypes = types;
        this.mIsDsts = isDsts;
        this.mId = name;
        int lastStdTransitionIndex = -1;
        for (int i = this.mTransitions.length - 1; lastStdTransitionIndex == -1 && i >= 0; --i) {
            int typeIndex = this.mTypes[i] & 0xFF;
            if (lastStdTransitionIndex != -1 || this.mIsDsts[typeIndex] != 0) continue;
            lastStdTransitionIndex = i;
        }
        if (this.mTransitions.length == 0) {
            rawOffsetInSeconds = gmtOffsets[0];
        } else {
            if (lastStdTransitionIndex == -1) {
                throw new IllegalStateException("ZoneInfo requires at least one non-DST transition to be provided for each timezone that has at least one transition but could not find one for '" + name + "'");
            }
            rawOffsetInSeconds = gmtOffsets[this.mTypes[lastStdTransitionIndex] & 0xFF];
        }
        int firstStdTypeIndex = -1;
        for (int i = 0; i < this.mIsDsts.length; ++i) {
            if (this.mIsDsts[i] != 0) continue;
            firstStdTypeIndex = i;
            break;
        }
        int earliestRawOffset = firstStdTypeIndex != -1 ? gmtOffsets[firstStdTypeIndex] : rawOffsetInSeconds;
        this.mOffsets = gmtOffsets;
        int i = 0;
        while (i < this.mOffsets.length) {
            int n = i++;
            this.mOffsets[n] = this.mOffsets[n] - rawOffsetInSeconds;
        }
        this.mRawOffset = rawOffsetInSeconds * 1000;
        this.mEarliestRawOffset = earliestRawOffset * 1000;
    }

    public static ZoneInfoData createFromSerializationFields(String id2, ObjectInputStream.GetField getField) throws IOException {
        int rawOffset = getField.get("mRawOffset", 0);
        int earliestRawOffset = getField.get("mEarliestRawOffset", 0);
        long[] transitions = (long[])getField.get("mTransitions", null);
        byte[] types = (byte[])getField.get("mTypes", null);
        int[] offsets = (int[])getField.get("mOffsets", null);
        byte[] isDsts = (byte[])getField.get("mIsDsts", null);
        return new ZoneInfoData(id2, rawOffset, earliestRawOffset, transitions, types, offsets, isDsts);
    }

    public void writeToSerializationFields(ObjectOutputStream.PutField putField) {
        putField.put("mRawOffset", this.mRawOffset);
        putField.put("mEarliestRawOffset", this.mEarliestRawOffset);
        putField.put("mTransitions", this.mTransitions);
        putField.put("mTypes", this.mTypes);
        putField.put("mOffsets", this.mOffsets);
        putField.put("mIsDsts", this.mIsDsts);
    }

    public int findTransitionIndex(long seconds) {
        int transition2 = Arrays.binarySearch(this.mTransitions, seconds);
        if (transition2 < 0 && (transition2 = ~transition2 - 1) < 0) {
            return -1;
        }
        return transition2;
    }

    int findOffsetIndexForTimeInSeconds(long seconds) {
        int transition2 = this.findTransitionIndex(seconds);
        if (transition2 < 0) {
            return -1;
        }
        return this.mTypes[transition2] & 0xFF;
    }

    int findOffsetIndexForTimeInMilliseconds(long millis) {
        return this.findOffsetIndexForTimeInSeconds(ZoneInfoData.roundDownMillisToSeconds(millis));
    }

    static long roundDownMillisToSeconds(long millis) {
        if (millis < 0L) {
            return (millis - 999L) / 1000L;
        }
        return millis / 1000L;
    }

    static long roundUpMillisToSeconds(long millis) {
        if (millis > 0L) {
            return (millis + 999L) / 1000L;
        }
        return millis / 1000L;
    }

    public int getOffsetsByUtcTime(long unixEpochTimeInMillis, int[] offsets) {
        int totalOffset;
        int dstOffset;
        int rawOffset;
        int transitionIndex = this.findTransitionIndex(ZoneInfoData.roundDownMillisToSeconds(unixEpochTimeInMillis));
        if (transitionIndex == -1) {
            rawOffset = this.mEarliestRawOffset;
            dstOffset = 0;
            totalOffset = rawOffset;
        } else {
            int type = this.mTypes[transitionIndex] & 0xFF;
            totalOffset = this.mRawOffset + this.mOffsets[type] * 1000;
            if (this.mIsDsts[type] == 0) {
                rawOffset = totalOffset;
                dstOffset = 0;
            } else {
                rawOffset = -1;
                --transitionIndex;
                while (transitionIndex >= 0) {
                    type = this.mTypes[transitionIndex] & 0xFF;
                    if (this.mIsDsts[type] == 0) {
                        rawOffset = this.mRawOffset + this.mOffsets[type] * 1000;
                        break;
                    }
                    --transitionIndex;
                }
                if (rawOffset == -1) {
                    rawOffset = this.mEarliestRawOffset;
                }
                dstOffset = totalOffset - rawOffset;
            }
        }
        offsets[0] = rawOffset;
        offsets[1] = dstOffset;
        return totalOffset;
    }

    public int getOffset(long whenMillis) {
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(whenMillis);
        if (offsetIndex == -1) {
            return this.mEarliestRawOffset;
        }
        return this.mRawOffset + this.mOffsets[offsetIndex] * 1000;
    }

    public boolean isInDaylightTime(long whenMillis) {
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(whenMillis);
        if (offsetIndex == -1) {
            return false;
        }
        return this.mIsDsts[offsetIndex] == 1;
    }

    public int getRawOffset() {
        return this.mRawOffset;
    }

    public Integer getLatestDstSavingsMillis(long whenMillis) {
        Integer dstSavings;
        long currentUnixTimeSeconds;
        long lastDSTTransitionTime;
        int lastStdTransitionIndex = -1;
        int lastDstTransitionIndex = -1;
        for (int i = this.mTransitions.length - 1; (lastStdTransitionIndex == -1 || lastDstTransitionIndex == -1) && i >= 0; --i) {
            int typeIndex = this.mTypes[i] & 0xFF;
            if (lastStdTransitionIndex == -1 && this.mIsDsts[typeIndex] == 0) {
                lastStdTransitionIndex = i;
            }
            if (lastDstTransitionIndex != -1 || this.mIsDsts[typeIndex] == 0) continue;
            lastDstTransitionIndex = i;
        }
        if (lastDstTransitionIndex != -1 && (lastDSTTransitionTime = this.mTransitions[lastDstTransitionIndex]) < (currentUnixTimeSeconds = ZoneInfoData.roundUpMillisToSeconds(whenMillis))) {
            lastDstTransitionIndex = -1;
        }
        if (lastDstTransitionIndex == -1) {
            dstSavings = null;
        } else {
            int lastGmtOffset = this.mOffsets[this.mTypes[lastStdTransitionIndex] & 0xFF];
            int lastDstOffset = this.mOffsets[this.mTypes[lastDstTransitionIndex] & 0xFF];
            dstSavings = (lastDstOffset - lastGmtOffset) * 1000;
        }
        return dstSavings;
    }

    int getEarliestRawOffset() {
        return this.mEarliestRawOffset;
    }

    public boolean hasSameRules(ZoneInfoData other) {
        return this.mRawOffset == other.mRawOffset && Arrays.equals(this.mOffsets, other.mOffsets) && Arrays.equals(this.mIsDsts, other.mIsDsts) && Arrays.equals(this.mTypes, other.mTypes) && Arrays.equals(this.mTransitions, other.mTransitions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZoneInfoData)) {
            return false;
        }
        ZoneInfoData other = (ZoneInfoData)obj;
        return this.getID().equals(other.getID()) && this.hasSameRules(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + Arrays.hashCode(this.mOffsets);
        result = 31 * result + Arrays.hashCode(this.mIsDsts);
        result = 31 * result + this.mRawOffset;
        result = 31 * result + Arrays.hashCode(this.mTransitions);
        result = 31 * result + Arrays.hashCode(this.mTypes);
        return result;
    }

    public String toString() {
        return "[id=\"" + this.getID() + "\",mRawOffset=" + this.mRawOffset + ",mEarliestRawOffset=" + this.mEarliestRawOffset + ",transitions=" + this.mTransitions.length + "]";
    }

    public String getID() {
        return this.mId;
    }

    public ZoneInfoData createCopyWithRawOffset(int newRawOffset) {
        return new ZoneInfoData(this, newRawOffset);
    }

    public long[] getTransitions() {
        return this.mTransitions == null ? null : (long[])this.mTransitions.clone();
    }

    public static ZoneInfoData createInstance(String id2, long[] transitions, byte[] types, int[] offsets, boolean[] isDsts) {
        return new ZoneInfoData(id2, transitions, types, offsets, ZoneInfoData.toByteArray(isDsts));
    }

    private static byte[] toByteArray(boolean[] isDsts) {
        byte[] result = new byte[isDsts.length];
        for (int i = 0; i < isDsts.length; ++i) {
            result[i] = (byte)(isDsts[i] ? 1 : 0);
        }
        return result;
    }
}

