/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.system;

import android.compat.Compatibility;
import android.icu.impl.CacheValue;
import android.icu.impl.ZoneMeta;
import android.icu.platform.AndroidDataFiles;
import android.icu.text.DateFormatSymbols;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.android.i18n.util.ATrace;
import com.android.icu.util.UResourceBundleNative;

public class ZygoteHooks {
    private static final long HIDE_PROP_ICUBINARY_DATA_PATH = 171979766L;
    public static final String PROP_ICUBINARY_DATA_PATH = "android.icu.impl.ICUBinary.dataPath";

    private ZygoteHooks() {
    }

    public static void onBeginPreload() {
        ULocale[] localesToPin;
        ATrace.traceBegin("IcuZygoteHooksOnBeginPreload");
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
            new DateFormatSymbols(uLocale);
        }
        TimeZone.getDefault();
        ZoneMeta.getAvailableIDs(TimeZone.SystemTimeZoneType.ANY, null, null);
        ATrace.traceEnd();
    }

    public static void onEndPreload() {
        ATrace.traceBegin("IcuZygoteHooksOnEndPreload");
        CacheValue.setStrength(CacheValue.Strength.SOFT);
        System.setProperty(PROP_ICUBINARY_DATA_PATH, AndroidDataFiles.generateIcuDataPath());
        UResourceBundleNative.cacheTimeZoneBundles();
        ATrace.traceEnd();
    }

    static void handleCompatChangesBeforeBindingApplication() {
        if (Compatibility.isChangeEnabled(171979766L)) {
            System.clearProperty(PROP_ICUBINARY_DATA_PATH);
        }
    }
}

