/*
 * Decompiled with CFR 0.152.
 */
package com.android.federatedcompute.internal.util;

import android.util.Log;
import java.util.Locale;

public class LogUtil {
    public static final String TAG = "federatedcompute";

    private LogUtil() {
    }

    public static int v(String msg) {
        if (Log.isLoggable(TAG, 2)) {
            return Log.v(TAG, msg);
        }
        return 0;
    }

    public static int v(String tag, String msg) {
        if (Log.isLoggable(TAG, 2)) {
            return Log.v(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int d(String tag, String msg) {
        if (Log.isLoggable(TAG, 3)) {
            return Log.d(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int d(String tag, Throwable throwable, String msg) {
        if (Log.isLoggable(TAG, 3)) {
            return Log.d(TAG, tag + " - " + msg, throwable);
        }
        return 0;
    }

    public static int d(String tag, String format, Object ... params) {
        if (Log.isLoggable(TAG, 3)) {
            String msg = LogUtil.format(format, params);
            return Log.d(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int i(String tag, String format, Object ... params) {
        if (Log.isLoggable(TAG, 4)) {
            String msg = LogUtil.format(format, params);
            return Log.i(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int w(String tag, String msg) {
        if (Log.isLoggable(TAG, 5)) {
            return Log.w(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int w(String tag, Throwable throwable, String msg) {
        if (Log.isLoggable(TAG, 5)) {
            return Log.w(TAG, tag + " - " + msg, throwable);
        }
        return 0;
    }

    public static int w(String tag, String format, Object ... params) {
        if (Log.isLoggable(TAG, 5)) {
            String msg = LogUtil.format(format, params);
            return Log.w(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int e(String tag, String msg) {
        if (Log.isLoggable(TAG, 6)) {
            return Log.e(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int e(String tag, Throwable throwable, String msg) {
        if (Log.isLoggable(TAG, 6)) {
            return Log.e(TAG, tag + " - " + msg, throwable);
        }
        return 0;
    }

    public static int e(String tag, String format, Object ... params) {
        if (Log.isLoggable(TAG, 6)) {
            String msg = LogUtil.format(format, params);
            return Log.e(TAG, tag + " - " + msg);
        }
        return 0;
    }

    public static int e(String tag, Throwable throwable, String format, Object ... params) {
        if (Log.isLoggable(TAG, 6)) {
            String msg = LogUtil.format(format, params);
            return Log.e(TAG, tag + " - " + msg, throwable);
        }
        return 0;
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }
}

