/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ResourcesManager;
import android.app.servertransaction.ClientTransactionListenerController;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.inputmethodservice.AbstractInputMethodService;
import android.os.Binder;
import android.os.Debug;
import android.os.Handler;
import android.os._Original_Build;
import android.util.Log;
import android.window.ConfigurationDispatcher;
import android.window.ConfigurationHelper;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.ref.WeakReference;

public class WindowTokenClient
extends Binder {
    private static final String TAG = WindowTokenClient.class.getSimpleName();
    private WeakReference<Context> mContextRef = null;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();
    @GuardedBy(value={"itself"})
    private final Configuration mConfiguration = new Configuration();
    private boolean mShouldDumpConfigForIme;
    private final Handler mHandler = ActivityThread.currentActivityThread().getHandler();

    public void attachContext(@NonNull Context context) {
        if (this.mContextRef != null) {
            throw new IllegalStateException("Context is already attached.");
        }
        this.mContextRef = new WeakReference<Context>(context);
        this.mShouldDumpConfigForIme = _Original_Build.IS_DEBUGGABLE && context instanceof AbstractInputMethodService;
    }

    @Nullable
    public Context getContext() {
        return this.mContextRef != null ? (Context)this.mContextRef.get() : null;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void onConfigurationChanged(Configuration newConfig, int newDisplayId) {
        this.onConfigurationChanged(newConfig, newDisplayId, true);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void postOnConfigurationChanged(@NonNull Configuration newConfig, int newDisplayId) {
        this.mHandler.post(PooledLambda.obtainRunnable(this::onConfigurationChanged, newConfig, newDisplayId, true).recycleOnUse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChanged(@NonNull Configuration newConfig, int newDisplayId, boolean shouldReportConfigChange) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        if (shouldReportConfigChange) {
            ClientTransactionListenerController controller = this.getClientTransactionListenerController();
            controller.onContextConfigurationPreChanged(context);
            try {
                this.onConfigurationChangedInner(context, newConfig, newDisplayId, shouldReportConfigChange);
            }
            finally {
                controller.onContextConfigurationPostChanged(context);
            }
        } else {
            this.onConfigurationChangedInner(context, newConfig, newDisplayId, shouldReportConfigChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void onConfigurationChangedInner(@NonNull Context context, @NonNull Configuration newConfig, int newDisplayId, boolean shouldReportConfigChange) {
        Configuration currentConfig;
        int publicDiff;
        boolean shouldUpdateResources;
        boolean displayChanged;
        CompatibilityInfo.applyOverrideIfNeeded(newConfig);
        Configuration configuration = this.mConfiguration;
        synchronized (configuration) {
            displayChanged = ConfigurationHelper.isDifferentDisplay(context.getDisplayId(), newDisplayId);
            shouldUpdateResources = ConfigurationHelper.shouldUpdateResources(this, this.mConfiguration, newConfig, newConfig, displayChanged, null);
            publicDiff = this.mConfiguration.diffPublicOnly(newConfig);
            Configuration configuration2 = currentConfig = this.mShouldDumpConfigForIme ? new Configuration(this.mConfiguration) : null;
            if (shouldUpdateResources) {
                this.mConfiguration.setTo(newConfig);
            }
        }
        if (!shouldUpdateResources && this.mShouldDumpConfigForIme) {
            Log.d(TAG, "Configuration not dispatch to IME because configuration is up to date. Current config=" + context.getResources().getConfiguration() + ", reported config=" + currentConfig + ", updated config=" + newConfig + ", updated display ID=" + newDisplayId);
        }
        if (displayChanged) {
            context.updateDisplay(newDisplayId);
        }
        if (shouldUpdateResources) {
            ConfigurationDispatcher dispatcher;
            this.mResourcesManager.updateResourcesForActivity(this, newConfig, newDisplayId);
            if (shouldReportConfigChange && context instanceof ConfigurationDispatcher && ((dispatcher = (ConfigurationDispatcher)((Object)context)).shouldReportPrivateChanges() || publicDiff != 0)) {
                dispatcher.dispatchConfigurationChanged(newConfig);
            }
            ConfigurationHelper.freeTextLayoutCachesIfNeeded(publicDiff);
            if (this.mShouldDumpConfigForIme) {
                if (!shouldReportConfigChange) {
                    Log.d(TAG, "Only apply configuration update to Resources because shouldReportConfigChange is false. context=" + context + ", config=" + context.getResources().getConfiguration() + ", display ID=" + context.getDisplayId() + "\n" + Debug.getCallers(5));
                } else if (publicDiff == 0) {
                    Log.d(TAG, "Configuration not dispatch to IME because configuration has no  public difference with updated config.  Current config=" + context.getResources().getConfiguration() + ", reported config=" + currentConfig + ", updated config=" + newConfig + ", display ID=" + context.getDisplayId());
                }
            }
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void onWindowTokenRemoved() {
        Context context = (Context)this.mContextRef.get();
        if (context != null) {
            context.destroy();
            this.mContextRef.clear();
        }
    }

    @VisibleForTesting
    @NonNull
    public ClientTransactionListenerController getClientTransactionListenerController() {
        return ClientTransactionListenerController.getInstance();
    }
}

