/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControl;
import java.util.Objects;

@SuppressLint(value={"UnflaggedApi"})
public class TaskFragmentParentInfo
implements Parcelable {
    @NonNull
    private final Configuration mConfiguration = new Configuration();
    private final int mDisplayId;
    private final int mTaskId;
    private final boolean mVisible;
    private final boolean mHasDirectActivity;
    @Nullable
    private final SurfaceControl mDecorSurface;
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public static final Parcelable.Creator<TaskFragmentParentInfo> CREATOR = new Parcelable.Creator<TaskFragmentParentInfo>(){

        @Override
        public TaskFragmentParentInfo createFromParcel(Parcel in) {
            return new TaskFragmentParentInfo(in);
        }

        public TaskFragmentParentInfo[] newArray(int size) {
            return new TaskFragmentParentInfo[size];
        }
    };

    public TaskFragmentParentInfo(@NonNull Configuration configuration, int displayId, int taskId, boolean visible, boolean hasDirectActivity, @Nullable SurfaceControl decorSurface) {
        this.mConfiguration.setTo(configuration);
        this.mDisplayId = displayId;
        this.mTaskId = taskId;
        this.mVisible = visible;
        this.mHasDirectActivity = hasDirectActivity;
        this.mDecorSurface = decorSurface;
    }

    public TaskFragmentParentInfo(@NonNull TaskFragmentParentInfo info) {
        this.mConfiguration.setTo(info.getConfiguration());
        this.mDisplayId = info.mDisplayId;
        this.mTaskId = info.mTaskId;
        this.mVisible = info.mVisible;
        this.mHasDirectActivity = info.mHasDirectActivity;
        this.mDecorSurface = info.mDecorSurface;
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public boolean hasDirectActivity() {
        return this.mHasDirectActivity;
    }

    public boolean equalsForTaskFragmentOrganizer(@Nullable TaskFragmentParentInfo that) {
        if (that == null) {
            return false;
        }
        return this.getWindowingMode() == that.getWindowingMode() && this.mDisplayId == that.mDisplayId && this.mTaskId == that.mTaskId && this.mVisible == that.mVisible && this.mHasDirectActivity == that.mHasDirectActivity && this.mDecorSurface == that.mDecorSurface;
    }

    @Nullable
    public SurfaceControl getDecorSurface() {
        return this.mDecorSurface;
    }

    private int getWindowingMode() {
        return this.mConfiguration.windowConfiguration.getWindowingMode();
    }

    public String toString() {
        return TaskFragmentParentInfo.class.getSimpleName() + ":{config=" + this.mConfiguration + ", displayId=" + this.mDisplayId + ", taskId=" + this.mTaskId + ", visible=" + this.mVisible + ", hasDirectActivity=" + this.mHasDirectActivity + ", decorSurface=" + this.mDecorSurface + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskFragmentParentInfo)) {
            return false;
        }
        TaskFragmentParentInfo that = (TaskFragmentParentInfo)obj;
        return this.mConfiguration.equals(that.mConfiguration) && this.mDisplayId == that.mDisplayId && this.mTaskId == that.mTaskId && this.mVisible == that.mVisible && this.mHasDirectActivity == that.mHasDirectActivity && this.mDecorSurface == that.mDecorSurface;
    }

    public int hashCode() {
        int result = this.mConfiguration.hashCode();
        result = 31 * result + this.mDisplayId;
        result = 31 * result + this.mTaskId;
        result = 31 * result + (this.mVisible ? 1 : 0);
        result = 31 * result + (this.mHasDirectActivity ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.mDecorSurface);
        return result;
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mConfiguration.writeToParcel(dest, flags);
        dest.writeInt(this.mDisplayId);
        dest.writeInt(this.mTaskId);
        dest.writeBoolean(this.mVisible);
        dest.writeBoolean(this.mHasDirectActivity);
        dest.writeTypedObject(this.mDecorSurface, flags);
    }

    private TaskFragmentParentInfo(Parcel in) {
        this.mConfiguration.readFromParcel(in);
        this.mDisplayId = in.readInt();
        this.mTaskId = in.readInt();
        this.mVisible = in.readBoolean();
        this.mHasDirectActivity = in.readBoolean();
        this.mDecorSurface = in.readTypedObject(SurfaceControl.CREATOR);
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public int describeContents() {
        return 0;
    }
}

