/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.util.Pair;
import android.util.Printer;
import android.view.ViewRootImpl;
import android.window.BackEvent;
import android.window.BackMotionEvent;
import android.window.IBackAnimationHandoffHandler;
import android.window.IOnBackInvokedCallback;
import android.window.OnBackAnimationCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import android.window.WindowOnBackInvokedDispatcher;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.Consumer;

public class ImeOnBackInvokedDispatcher
implements OnBackInvokedDispatcher,
Parcelable {
    private static final String TAG = "ImeBackDispatcher";
    static final String RESULT_KEY_ID = "id";
    static final String RESULT_KEY_CALLBACK = "callback";
    static final String RESULT_KEY_PRIORITY = "priority";
    static final int RESULT_CODE_REGISTER = 0;
    static final int RESULT_CODE_UNREGISTER = 1;
    @NonNull
    private final ResultReceiver mResultReceiver;
    private Handler mHandler;
    private final ArrayDeque<Pair<Integer, Bundle>> mQueuedReceive = new ArrayDeque();
    @NonNull
    public static final Parcelable.Creator<ImeOnBackInvokedDispatcher> CREATOR = new Parcelable.Creator<ImeOnBackInvokedDispatcher>(){

        @Override
        public ImeOnBackInvokedDispatcher createFromParcel(Parcel in) {
            return new ImeOnBackInvokedDispatcher(in);
        }

        public ImeOnBackInvokedDispatcher[] newArray(int size) {
            return new ImeOnBackInvokedDispatcher[size];
        }
    };
    private final ArrayList<ImeOnBackInvokedCallback> mImeCallbacks = new ArrayList();

    public ImeOnBackInvokedDispatcher(Handler handler) {
        this.mResultReceiver = new ResultReceiver(handler){

            @Override
            public void onReceiveResult(int resultCode, Bundle resultData) {
                WindowOnBackInvokedDispatcher dispatcher = ImeOnBackInvokedDispatcher.this.getReceivingDispatcher();
                if (dispatcher != null) {
                    ImeOnBackInvokedDispatcher.this.receive(resultCode, resultData, dispatcher);
                } else {
                    ImeOnBackInvokedDispatcher.this.mQueuedReceive.add(new Pair<Integer, Bundle>(resultCode, resultData));
                }
            }
        };
    }

    public void updateReceivingDispatcher(@NonNull WindowOnBackInvokedDispatcher dispatcher) {
        if (!this.mQueuedReceive.isEmpty()) {
            Log.d(TAG, "updateReceivingDispatcher (mQueuedReceive.size=" + this.mQueuedReceive.size() + ")");
        }
        while (!this.mQueuedReceive.isEmpty()) {
            Pair<Integer, Bundle> queuedMessage = this.mQueuedReceive.poll();
            this.receive((Integer)queuedMessage.first, (Bundle)queuedMessage.second, dispatcher);
        }
    }

    void setHandler(@NonNull Handler handler) {
        this.mHandler = handler;
    }

    @Nullable
    protected WindowOnBackInvokedDispatcher getReceivingDispatcher() {
        return null;
    }

    ImeOnBackInvokedDispatcher(Parcel in) {
        this.mResultReceiver = in.readTypedObject(ResultReceiver.CREATOR);
    }

    @Override
    public void registerOnBackInvokedCallback(int priority, @NonNull OnBackInvokedCallback callback) {
        Bundle bundle = new Bundle();
        ImeOnBackInvokedCallbackWrapper iCallback = new ImeOnBackInvokedCallbackWrapper(callback);
        bundle.putBinder(RESULT_KEY_CALLBACK, iCallback.asBinder());
        bundle.putInt(RESULT_KEY_PRIORITY, priority);
        bundle.putInt(RESULT_KEY_ID, callback.hashCode());
        this.mResultReceiver.send(0, bundle);
        Log.d(TAG, "Send callback registration id=" + callback.hashCode() + " priority=" + priority);
    }

    @Override
    public void unregisterOnBackInvokedCallback(@NonNull OnBackInvokedCallback callback) {
        Bundle bundle = new Bundle();
        bundle.putInt(RESULT_KEY_ID, callback.hashCode());
        this.mResultReceiver.send(1, bundle);
        Log.d(TAG, "Send callback unregistration id=" + callback.hashCode());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mResultReceiver, flags);
    }

    private void receive(int resultCode, Bundle resultData, @NonNull WindowOnBackInvokedDispatcher receivingDispatcher) {
        if (resultCode == 0) {
            int callbackId = resultData.getInt(RESULT_KEY_ID);
            int priority = resultData.getInt(RESULT_KEY_PRIORITY);
            IOnBackInvokedCallback callback = IOnBackInvokedCallback.Stub.asInterface(resultData.getBinder(RESULT_KEY_CALLBACK));
            this.registerReceivedCallback(callback, priority, callbackId, receivingDispatcher);
        } else if (resultCode == 1) {
            int callbackId = resultData.getInt(RESULT_KEY_ID);
            this.unregisterReceivedCallback(callbackId, receivingDispatcher);
        }
    }

    private void registerReceivedCallback(@NonNull IOnBackInvokedCallback iCallback, int priority, int callbackId, @NonNull WindowOnBackInvokedDispatcher receivingDispatcher) {
        ImeOnBackInvokedCallback imeCallback;
        if (priority == -1) {
            priority = 0;
            imeCallback = new DefaultImeOnBackAnimationCallback(iCallback, callbackId, priority);
        } else {
            imeCallback = new ImeOnBackInvokedCallback(iCallback, callbackId, priority);
        }
        if (this.unregisterCallback(callbackId, receivingDispatcher)) {
            Log.w(TAG, "Received IME callback that's already registered. Unregistering and reregistering. (callbackId: " + callbackId + " current callbacks: " + this.mImeCallbacks.size() + ")");
        }
        Log.d(TAG, "Register received callback id=" + callbackId + " priority=" + priority);
        this.mImeCallbacks.add(imeCallback);
        receivingDispatcher.registerOnBackInvokedCallbackUnchecked(imeCallback, priority);
    }

    private void unregisterReceivedCallback(int callbackId, @NonNull OnBackInvokedDispatcher receivingDispatcher) {
        Log.d(TAG, "Unregister received callback id=" + callbackId);
        if (!this.unregisterCallback(callbackId, receivingDispatcher)) {
            Log.w(TAG, "Ime callback not found. Ignoring unregisterReceivedCallback. callbackId: " + callbackId + " remaining callbacks: " + this.mImeCallbacks.size());
        }
    }

    private boolean unregisterCallback(int callbackId, @NonNull OnBackInvokedDispatcher receivingDispatcher) {
        ImeOnBackInvokedCallback callback = null;
        for (ImeOnBackInvokedCallback imeCallback : this.mImeCallbacks) {
            if (imeCallback.getId() != callbackId) continue;
            callback = imeCallback;
            break;
        }
        if (callback == null) {
            return false;
        }
        receivingDispatcher.unregisterOnBackInvokedCallback(callback);
        this.mImeCallbacks.remove(callback);
        return true;
    }

    public void preliminaryClear() {
        Log.d(TAG, "Preliminary clear (mImeCallbacks.size=" + this.mImeCallbacks.size() + ")");
        if (this.getReceivingDispatcher() != null) {
            for (ImeOnBackInvokedCallback callback : this.mImeCallbacks) {
                this.getReceivingDispatcher().unregisterOnBackInvokedCallback(callback);
            }
        }
    }

    public void undoPreliminaryClear() {
        Log.d(TAG, "Undo preliminary clear (mImeCallbacks.size=" + this.mImeCallbacks.size() + ")");
        if (this.getReceivingDispatcher() != null) {
            for (ImeOnBackInvokedCallback callback : this.mImeCallbacks) {
                this.getReceivingDispatcher().registerOnBackInvokedCallbackUnchecked(callback, callback.mPriority);
            }
        }
    }

    public void clear() {
        Log.d(TAG, "Clear (mImeCallbacks.size=" + this.mImeCallbacks.size() + ")");
        if (this.getReceivingDispatcher() != null) {
            for (ImeOnBackInvokedCallback callback : this.mImeCallbacks) {
                this.getReceivingDispatcher().unregisterOnBackInvokedCallback(callback);
            }
        }
        this.mImeCallbacks.clear();
        this.mQueuedReceive.clear();
    }

    public void dump(@NonNull Printer p, @NonNull String prefix) {
        if (this.mImeCallbacks.isEmpty()) {
            p.println(prefix + TAG + " mImeCallbacks: []");
        } else {
            p.println(prefix + TAG + " mImeCallbacks:");
            for (ImeOnBackInvokedCallback callback : this.mImeCallbacks) {
                p.println(prefix + "  " + callback);
            }
        }
    }

    public void switchRootView(ViewRootImpl previous, ViewRootImpl current) {
        Log.d(TAG, "switch root view (mImeCallbacks.size=" + this.mImeCallbacks.size() + ")");
        for (ImeOnBackInvokedCallback imeCallback : this.mImeCallbacks) {
            if (previous != null) {
                previous.getOnBackInvokedDispatcher().unregisterOnBackInvokedCallback(imeCallback);
            }
            if (current == null) continue;
            current.getOnBackInvokedDispatcher().registerOnBackInvokedCallbackUnchecked(imeCallback, imeCallback.mPriority);
        }
    }

    private class ImeOnBackInvokedCallbackWrapper
    extends IOnBackInvokedCallback.Stub {
        private final OnBackInvokedCallback mCallback;

        ImeOnBackInvokedCallbackWrapper(OnBackInvokedCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onBackStarted(BackMotionEvent backMotionEvent) {
            this.maybeRunOnAnimationCallback(animationCallback -> animationCallback.onBackStarted(BackEvent.fromBackMotionEvent(backMotionEvent)));
        }

        @Override
        public void onBackProgressed(BackMotionEvent backMotionEvent) {
            this.maybeRunOnAnimationCallback(animationCallback -> animationCallback.onBackProgressed(BackEvent.fromBackMotionEvent(backMotionEvent)));
        }

        @Override
        public void onBackCancelled() {
            this.maybeRunOnAnimationCallback(OnBackAnimationCallback::onBackCancelled);
        }

        @Override
        public void onBackInvoked() {
            ImeOnBackInvokedDispatcher.this.mHandler.post(this.mCallback::onBackInvoked);
        }

        @Override
        public void setTriggerBack(boolean triggerBack) {
        }

        @Override
        public void setHandoffHandler(IBackAnimationHandoffHandler handoffHandler) {
        }

        private void maybeRunOnAnimationCallback(Consumer<OnBackAnimationCallback> block) {
            if (this.mCallback instanceof OnBackAnimationCallback) {
                ImeOnBackInvokedDispatcher.this.mHandler.post(() -> block.accept((OnBackAnimationCallback)this.mCallback));
            }
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static class DefaultImeOnBackAnimationCallback
    extends ImeOnBackInvokedCallback {
        DefaultImeOnBackAnimationCallback(@NonNull IOnBackInvokedCallback iCallback, int id2, int priority) {
            super(iCallback, id2, priority);
        }

        @Override
        public String toString() {
            return "DefaultImeOnBackAnimationCallback@" + this.mId + " Callback=" + this.mIOnBackInvokedCallback;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static class ImeOnBackInvokedCallback
    implements OnBackAnimationCallback {
        @NonNull
        protected final IOnBackInvokedCallback mIOnBackInvokedCallback;
        protected final int mId;
        private final int mPriority;

        ImeOnBackInvokedCallback(@NonNull IOnBackInvokedCallback iCallback, int id2, int priority) {
            this.mIOnBackInvokedCallback = iCallback;
            this.mId = id2;
            this.mPriority = priority;
        }

        @Override
        public void onBackStarted(@NonNull BackEvent backEvent) {
            try {
                long frameTime = 0L;
                if (Flags.predictiveBackTimestampApi()) {
                    frameTime = backEvent.getFrameTimeMillis();
                }
                this.mIOnBackInvokedCallback.onBackStarted(new BackMotionEvent(backEvent.getTouchX(), backEvent.getTouchY(), frameTime, backEvent.getProgress(), false, backEvent.getSwipeEdge(), null));
            }
            catch (RemoteException e) {
                Log.e(ImeOnBackInvokedDispatcher.TAG, "Exception when invoking forwarded callback. e: ", e);
            }
        }

        @Override
        public void onBackProgressed(@NonNull BackEvent backEvent) {
            try {
                long frameTime = 0L;
                if (Flags.predictiveBackTimestampApi()) {
                    frameTime = backEvent.getFrameTimeMillis();
                }
                this.mIOnBackInvokedCallback.onBackProgressed(new BackMotionEvent(backEvent.getTouchX(), backEvent.getTouchY(), frameTime, backEvent.getProgress(), false, backEvent.getSwipeEdge(), null));
            }
            catch (RemoteException e) {
                Log.e(ImeOnBackInvokedDispatcher.TAG, "Exception when invoking forwarded callback. e: ", e);
            }
        }

        @Override
        public void onBackInvoked() {
            try {
                this.mIOnBackInvokedCallback.onBackInvoked();
            }
            catch (RemoteException e) {
                Log.e(ImeOnBackInvokedDispatcher.TAG, "Exception when invoking forwarded callback. e: ", e);
            }
        }

        @Override
        public void onBackCancelled() {
            try {
                this.mIOnBackInvokedCallback.onBackCancelled();
            }
            catch (RemoteException e) {
                Log.e(ImeOnBackInvokedDispatcher.TAG, "Exception when invoking forwarded callback. e: ", e);
            }
        }

        private int getId() {
            return this.mId;
        }

        public String toString() {
            return "ImeOnBackInvokedCallback@" + this.mId + " Callback=" + this.mIOnBackInvokedCallback;
        }
    }
}

