/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.TaskSnapshot;

public interface ITaskSnapshotManager
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskSnapshotManager";

    public TaskSnapshot getTaskSnapshot(int var1, int var2) throws RemoteException;

    public TaskSnapshot takeTaskSnapshot(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskSnapshotManager {
        static final int TRANSACTION_getTaskSnapshot = 1;
        static final int TRANSACTION_takeTaskSnapshot = 2;

        public Stub() {
            this.attachInterface(this, ITaskSnapshotManager.DESCRIPTOR);
        }

        public static ITaskSnapshotManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskSnapshotManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskSnapshotManager) {
                return (ITaskSnapshotManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTaskSnapshot";
                }
                case 2: {
                    return "takeTaskSnapshot";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskSnapshotManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    TaskSnapshot _result = this.getTaskSnapshot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    TaskSnapshot _result = this.takeTaskSnapshot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ITaskSnapshotManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskSnapshotManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TaskSnapshot getTaskSnapshot(int taskId, int retrieveResolution) throws RemoteException {
                TaskSnapshot _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskSnapshotManager.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeInt(retrieveResolution);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TaskSnapshot.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TaskSnapshot takeTaskSnapshot(int taskId, boolean updateCache) throws RemoteException {
                TaskSnapshot _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskSnapshotManager.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeBoolean(updateCache);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TaskSnapshot.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITaskSnapshotManager {
        @Override
        public TaskSnapshot getTaskSnapshot(int taskId, int retrieveResolution) throws RemoteException {
            return null;
        }

        @Override
        public TaskSnapshot takeTaskSnapshot(int taskId, boolean updateCache) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

