/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.DragEvent;
import android.window.IUnhandledDragCallback;

public interface IGlobalDragListener
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IGlobalDragListener";

    public void onCrossWindowDrop(ActivityManager.RunningTaskInfo var1) throws RemoteException;

    public void onUnhandledDrop(DragEvent var1, IUnhandledDragCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGlobalDragListener {
        static final int TRANSACTION_onCrossWindowDrop = 1;
        static final int TRANSACTION_onUnhandledDrop = 2;

        public Stub() {
            this.attachInterface(this, IGlobalDragListener.DESCRIPTOR);
        }

        public static IGlobalDragListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGlobalDragListener.DESCRIPTOR);
            if (iin != null && iin instanceof IGlobalDragListener) {
                return (IGlobalDragListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCrossWindowDrop";
                }
                case 2: {
                    return "onUnhandledDrop";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGlobalDragListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ActivityManager.RunningTaskInfo _arg0 = data.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCrossWindowDrop(_arg0);
                    break;
                }
                case 2: {
                    DragEvent _arg0 = data.readTypedObject(DragEvent.CREATOR);
                    IUnhandledDragCallback _arg1 = IUnhandledDragCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onUnhandledDrop(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IGlobalDragListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGlobalDragListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCrossWindowDrop(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGlobalDragListener.DESCRIPTOR);
                    _data.writeTypedObject(taskInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnhandledDrop(DragEvent event, IUnhandledDragCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGlobalDragListener.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGlobalDragListener {
        @Override
        public void onCrossWindowDrop(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
        }

        @Override
        public void onUnhandledDrop(DragEvent event, IUnhandledDragCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

