/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.RemoteAnimationTarget;
import android.window.WindowAnimationState;

public interface IBackAnimationHandoffHandler
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IBackAnimationHandoffHandler";

    public void handOffAnimation(RemoteAnimationTarget[] var1, WindowAnimationState[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackAnimationHandoffHandler {
        static final int TRANSACTION_handOffAnimation = 1;

        public Stub() {
            this.attachInterface(this, IBackAnimationHandoffHandler.DESCRIPTOR);
        }

        public static IBackAnimationHandoffHandler asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBackAnimationHandoffHandler.DESCRIPTOR);
            if (iin != null && iin instanceof IBackAnimationHandoffHandler) {
                return (IBackAnimationHandoffHandler)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "handOffAnimation";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBackAnimationHandoffHandler.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    RemoteAnimationTarget[] _arg0 = data.createTypedArray(RemoteAnimationTarget.CREATOR);
                    WindowAnimationState[] _arg1 = data.createTypedArray(WindowAnimationState.CREATOR);
                    data.enforceNoDataAvail();
                    this.handOffAnimation(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IBackAnimationHandoffHandler {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBackAnimationHandoffHandler.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handOffAnimation(RemoteAnimationTarget[] targets, WindowAnimationState[] states) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBackAnimationHandoffHandler.DESCRIPTOR);
                    _data.writeTypedArray(targets, 0);
                    _data.writeTypedArray(states, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBackAnimationHandoffHandler {
        @Override
        public void handOffAnimation(RemoteAnimationTarget[] targets, WindowAnimationState[] states) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

