/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.window.IOnBackInvokedCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BackNavigationInfo
implements Parcelable {
    public static final int TYPE_UNDEFINED = -1;
    public static final int TYPE_DIALOG_CLOSE = 0;
    public static final int TYPE_RETURN_TO_HOME = 1;
    public static final int TYPE_CROSS_ACTIVITY = 2;
    public static final int TYPE_CROSS_TASK = 3;
    public static final int TYPE_CALLBACK = 4;
    public static final String KEY_NAVIGATION_FINISHED = "NavigationFinished";
    public static final String KEY_GESTURE_FINISHED = "GestureFinished";
    public static final String KEY_TOUCH_GESTURE_TRANSFERRED = "TouchGestureTransferred";
    public static final String KEY_DISPLAY_ID = "DisplayId";
    private final int mType;
    @Nullable
    private final RemoteCallback mOnBackNavigationDone;
    @Nullable
    private final IOnBackInvokedCallback mOnBackInvokedCallback;
    private final boolean mPrepareRemoteAnimation;
    private final boolean mAnimationCallback;
    @Nullable
    private final CustomAnimationInfo mCustomAnimationInfo;
    private final int mLetterboxColor;
    @NonNull
    private final Rect mTouchableRegion;
    private boolean mAppProgressGenerationAllowed;
    private final int mFocusedTaskId;
    @NonNull
    public static final Parcelable.Creator<BackNavigationInfo> CREATOR = new Parcelable.Creator<BackNavigationInfo>(){

        @Override
        public BackNavigationInfo createFromParcel(Parcel in) {
            return new BackNavigationInfo(in);
        }

        public BackNavigationInfo[] newArray(int size) {
            return new BackNavigationInfo[size];
        }
    };

    private BackNavigationInfo(int type, @Nullable RemoteCallback onBackNavigationDone, @Nullable IOnBackInvokedCallback onBackInvokedCallback, boolean isPrepareRemoteAnimation, boolean isAnimationCallback, @Nullable CustomAnimationInfo customAnimationInfo, int letterboxColor, @Nullable Rect touchableRegion, boolean appProgressGenerationAllowed, int focusedTaskId) {
        this.mType = type;
        this.mOnBackNavigationDone = onBackNavigationDone;
        this.mOnBackInvokedCallback = onBackInvokedCallback;
        this.mPrepareRemoteAnimation = isPrepareRemoteAnimation;
        this.mAnimationCallback = isAnimationCallback;
        this.mCustomAnimationInfo = customAnimationInfo;
        this.mLetterboxColor = letterboxColor;
        this.mTouchableRegion = new Rect(touchableRegion);
        this.mAppProgressGenerationAllowed = appProgressGenerationAllowed;
        this.mFocusedTaskId = focusedTaskId;
    }

    private BackNavigationInfo(@NonNull Parcel in) {
        this.mType = in.readInt();
        this.mOnBackNavigationDone = in.readTypedObject(RemoteCallback.CREATOR);
        this.mOnBackInvokedCallback = IOnBackInvokedCallback.Stub.asInterface(in.readStrongBinder());
        this.mPrepareRemoteAnimation = in.readBoolean();
        this.mAnimationCallback = in.readBoolean();
        this.mCustomAnimationInfo = in.readTypedObject(CustomAnimationInfo.CREATOR);
        this.mLetterboxColor = in.readInt();
        this.mTouchableRegion = in.readTypedObject(Rect.CREATOR);
        this.mAppProgressGenerationAllowed = in.readBoolean();
        this.mFocusedTaskId = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeTypedObject(this.mOnBackNavigationDone, flags);
        dest.writeStrongInterface(this.mOnBackInvokedCallback);
        dest.writeBoolean(this.mPrepareRemoteAnimation);
        dest.writeBoolean(this.mAnimationCallback);
        dest.writeTypedObject(this.mCustomAnimationInfo, flags);
        dest.writeInt(this.mLetterboxColor);
        dest.writeTypedObject(this.mTouchableRegion, flags);
        dest.writeBoolean(this.mAppProgressGenerationAllowed);
        dest.writeInt(this.mFocusedTaskId);
    }

    public int getType() {
        return this.mType;
    }

    @Nullable
    public IOnBackInvokedCallback getOnBackInvokedCallback() {
        return this.mOnBackInvokedCallback;
    }

    public boolean isPrepareRemoteAnimation() {
        return this.mPrepareRemoteAnimation;
    }

    public boolean isAnimationCallback() {
        return this.mAnimationCallback;
    }

    public int getLetterboxColor() {
        return this.mLetterboxColor;
    }

    @NonNull
    public Rect getTouchableRegion() {
        return this.mTouchableRegion;
    }

    public boolean isAppProgressGenerationAllowed() {
        return this.mAppProgressGenerationAllowed;
    }

    public int getFocusedTaskId() {
        return this.mFocusedTaskId;
    }

    public void disableAppProgressGenerationAllowed() {
        this.mAppProgressGenerationAllowed = false;
    }

    public void onBackNavigationFinished(boolean triggerBack) {
        if (this.mOnBackNavigationDone != null) {
            Bundle result = new Bundle();
            result.putBoolean(KEY_NAVIGATION_FINISHED, triggerBack);
            this.mOnBackNavigationDone.sendResult(result);
        }
    }

    @Nullable
    public CustomAnimationInfo getCustomAnimationInfo() {
        return this.mCustomAnimationInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "BackNavigationInfo{mType=" + BackNavigationInfo.typeToString(this.mType) + " (" + this.mType + "), mOnBackNavigationDone=" + this.mOnBackNavigationDone + ", mOnBackInvokedCallback=" + this.mOnBackInvokedCallback + ", mPrepareRemoteAnimation=" + this.mPrepareRemoteAnimation + ", mAnimationCallback=" + this.mAnimationCallback + ", mCustomizeAnimationInfo=" + this.mCustomAnimationInfo + '}';
    }

    @NonNull
    public static String typeToString(int type) {
        switch (type) {
            case -1: {
                return "TYPE_UNDEFINED";
            }
            case 0: {
                return "TYPE_DIALOG_CLOSE";
            }
            case 1: {
                return "TYPE_RETURN_TO_HOME";
            }
            case 2: {
                return "TYPE_CROSS_ACTIVITY";
            }
            case 3: {
                return "TYPE_CROSS_TASK";
            }
            case 4: {
                return "TYPE_CALLBACK";
            }
        }
        return String.valueOf(type);
    }

    public static class CustomAnimationInfo
    implements Parcelable {
        private final String mPackageName;
        private int mWindowAnimations;
        private int mCustomExitAnim;
        private int mCustomEnterAnim;
        private int mCustomBackground;
        @NonNull
        public static final Parcelable.Creator<CustomAnimationInfo> CREATOR = new Parcelable.Creator<CustomAnimationInfo>(){

            @Override
            public CustomAnimationInfo createFromParcel(Parcel in) {
                return new CustomAnimationInfo(in);
            }

            public CustomAnimationInfo[] newArray(int size) {
                return new CustomAnimationInfo[size];
            }
        };

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        public int getWindowAnimations() {
            return this.mWindowAnimations;
        }

        public int getCustomExitAnim() {
            return this.mCustomExitAnim;
        }

        public int getCustomEnterAnim() {
            return this.mCustomEnterAnim;
        }

        public int getCustomBackground() {
            return this.mCustomBackground;
        }

        public CustomAnimationInfo(@NonNull String packageName) {
            this.mPackageName = packageName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mPackageName);
            dest.writeInt(this.mWindowAnimations);
            dest.writeInt(this.mCustomEnterAnim);
            dest.writeInt(this.mCustomExitAnim);
            dest.writeInt(this.mCustomBackground);
        }

        private CustomAnimationInfo(@NonNull Parcel in) {
            this.mPackageName = in.readString8();
            this.mWindowAnimations = in.readInt();
            this.mCustomEnterAnim = in.readInt();
            this.mCustomExitAnim = in.readInt();
            this.mCustomBackground = in.readInt();
        }

        public String toString() {
            return "CustomAnimationInfo, package name= " + this.mPackageName;
        }
    }

    public static class Builder {
        private int mType = -1;
        @Nullable
        private RemoteCallback mOnBackNavigationDone = null;
        @Nullable
        private IOnBackInvokedCallback mOnBackInvokedCallback = null;
        private boolean mPrepareRemoteAnimation;
        private CustomAnimationInfo mCustomAnimationInfo;
        private boolean mAnimationCallback = false;
        private int mLetterboxColor = 0;
        private Rect mTouchableRegion;
        private boolean mAppProgressGenerationAllowed;
        private int mFocusedTaskId = -1;

        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setOnBackNavigationDone(@Nullable RemoteCallback onBackNavigationDone) {
            this.mOnBackNavigationDone = onBackNavigationDone;
            return this;
        }

        public Builder setOnBackInvokedCallback(@Nullable IOnBackInvokedCallback onBackInvokedCallback) {
            this.mOnBackInvokedCallback = onBackInvokedCallback;
            return this;
        }

        public Builder setPrepareRemoteAnimation(boolean prepareRemoteAnimation) {
            this.mPrepareRemoteAnimation = prepareRemoteAnimation;
            return this;
        }

        public Builder setWindowAnimations(String packageName, int windowAnimations) {
            if (this.mCustomAnimationInfo == null) {
                this.mCustomAnimationInfo = new CustomAnimationInfo(packageName);
            }
            this.mCustomAnimationInfo.mWindowAnimations = windowAnimations;
            return this;
        }

        public Builder setCustomAnimation(String packageName, int enterResId, int exitResId, int backgroundColor) {
            if (this.mCustomAnimationInfo == null) {
                this.mCustomAnimationInfo = new CustomAnimationInfo(packageName);
            }
            this.mCustomAnimationInfo.mCustomExitAnim = exitResId;
            this.mCustomAnimationInfo.mCustomEnterAnim = enterResId;
            this.mCustomAnimationInfo.mCustomBackground = backgroundColor;
            return this;
        }

        public Builder setAnimationCallback(boolean isAnimationCallback) {
            this.mAnimationCallback = isAnimationCallback;
            return this;
        }

        public Builder setLetterboxColor(int color2) {
            this.mLetterboxColor = color2;
            return this;
        }

        public Builder setTouchableRegion(Rect rect) {
            this.mTouchableRegion = new Rect(rect);
            return this;
        }

        public Builder setAppProgressAllowed(boolean allowed) {
            this.mAppProgressGenerationAllowed = allowed;
            return this;
        }

        public Builder setFocusedTaskId(int focusedTaskId) {
            this.mFocusedTaskId = focusedTaskId;
            return this;
        }

        public BackNavigationInfo build() {
            return new BackNavigationInfo(this.mType, this.mOnBackNavigationDone, this.mOnBackInvokedCallback, this.mPrepareRemoteAnimation, this.mAnimationCallback, this.mCustomAnimationInfo, this.mLetterboxColor, this.mTouchableRegion, this.mAppProgressGenerationAllowed, this.mFocusedTaskId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackTargetType {
    }
}

