/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.RemoteAnimationTarget;

public class BackMotionEvent
implements Parcelable {
    private final float mTouchX;
    private final float mTouchY;
    private final long mFrameTimeMillis;
    private final float mProgress;
    private final boolean mTriggerBack;
    private final int mSwipeEdge;
    @Nullable
    private final RemoteAnimationTarget mDepartingAnimationTarget;
    @NonNull
    public static final Parcelable.Creator<BackMotionEvent> CREATOR = new Parcelable.Creator<BackMotionEvent>(){

        @Override
        public BackMotionEvent createFromParcel(Parcel in) {
            return new BackMotionEvent(in);
        }

        public BackMotionEvent[] newArray(int size) {
            return new BackMotionEvent[size];
        }
    };

    public BackMotionEvent(float touchX, float touchY, long frameTimeMillis, float progress, boolean triggerBack, int swipeEdge, @Nullable RemoteAnimationTarget departingAnimationTarget) {
        this.mTouchX = touchX;
        this.mTouchY = touchY;
        this.mFrameTimeMillis = frameTimeMillis;
        this.mProgress = progress;
        this.mTriggerBack = triggerBack;
        this.mSwipeEdge = swipeEdge;
        this.mDepartingAnimationTarget = departingAnimationTarget;
    }

    private BackMotionEvent(@NonNull Parcel in) {
        this.mTouchX = in.readFloat();
        this.mTouchY = in.readFloat();
        this.mProgress = in.readFloat();
        this.mTriggerBack = in.readBoolean();
        this.mSwipeEdge = in.readInt();
        this.mDepartingAnimationTarget = in.readTypedObject(RemoteAnimationTarget.CREATOR);
        this.mFrameTimeMillis = in.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.mTouchX);
        dest.writeFloat(this.mTouchY);
        dest.writeFloat(this.mProgress);
        dest.writeBoolean(this.mTriggerBack);
        dest.writeInt(this.mSwipeEdge);
        dest.writeTypedObject(this.mDepartingAnimationTarget, flags);
        dest.writeLong(this.mFrameTimeMillis);
    }

    public float getTouchX() {
        return this.mTouchX;
    }

    public float getTouchY() {
        return this.mTouchY;
    }

    public float getProgress() {
        return this.mProgress;
    }

    public boolean getTriggerBack() {
        return this.mTriggerBack;
    }

    public int getSwipeEdge() {
        return this.mSwipeEdge;
    }

    public long getFrameTimeMillis() {
        return this.mFrameTimeMillis;
    }

    @Nullable
    public RemoteAnimationTarget getDepartingAnimationTarget() {
        return this.mDepartingAnimationTarget;
    }

    public String toString() {
        return "BackMotionEvent{mTouchX=" + this.mTouchX + ", mTouchY=" + this.mTouchY + ", mFrameTimeMillis=" + this.mFrameTimeMillis + ", mProgress=" + this.mProgress + ", mTriggerBack=" + this.mTriggerBack + ", mSwipeEdge=" + this.mSwipeEdge + ", mDepartingAnimationTarget=" + this.mDepartingAnimationTarget + "}";
    }
}

