/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.HapticScrollFeedbackProvider;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.DifferentialMotionFlingHelper;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.view.flags.Flags;
import java.util.ArrayList;

public class ScrollView
extends FrameLayout {
    static final int ANIMATED_SCROLL_GAP = 250;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final String TAG = "ScrollView";
    private static final float FLING_DESTRETCH_FACTOR = 4.0f;
    @UnsupportedAppUsage
    private long mLastScroll;
    private final Rect mTempRect = new Rect();
    @UnsupportedAppUsage
    private OverScroller mScroller;
    @NonNull
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123768600L)
    @VisibleForTesting
    public EdgeEffect mEdgeGlowTop;
    @NonNull
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769386L)
    @VisibleForTesting
    public EdgeEffect mEdgeGlowBottom;
    @UnsupportedAppUsage
    private int mLastMotionY;
    private boolean mIsLayoutDirty = true;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769715L)
    private View mChildToScrollTo = null;
    @UnsupportedAppUsage
    private boolean mIsBeingDragged = false;
    @UnsupportedAppUsage
    private VelocityTracker mVelocityTracker;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled = true;
    private int mTouchSlop;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124051125L)
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050903L)
    private int mOverscrollDistance;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050903L)
    private int mOverflingDistance;
    private float mVerticalScrollFactor;
    private int mActivePointerId = -1;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedYOffset;
    private StrictMode.Span mScrollStrictSpan = null;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private StrictMode.Span mFlingStrictSpan = null;
    private DifferentialMotionFlingHelper mDifferentialMotionFlingHelper;
    private HapticScrollFeedbackProvider mHapticScrollFeedbackProvider;
    private static final int INVALID_POINTER = -1;
    private SavedState mSavedState;

    public ScrollView(Context context) {
        this(context, null);
    }

    public ScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010080);
    }

    public ScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mEdgeGlowTop = new EdgeEffect(context, attrs);
        this.mEdgeGlowBottom = new EdgeEffect(context, attrs);
        this.initScrollView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollView, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.ScrollView, attrs, a, defStyleAttr, defStyleRes);
        this.setFillViewport(a.getBoolean(0, false));
        a.recycle();
        if (context.getResources().getConfiguration().uiMode == 6) {
            this.setRevealOnFocusHint(false);
        }
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        if (this.mScrollY < length) {
            return (float)this.mScrollY / (float)length;
        }
        return 1.0f;
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        int bottomEdge = this.getHeight() - this.mPaddingBottom;
        int span = this.getChildAt(0).getBottom() - this.mScrollY - bottomEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    public void setEdgeEffectColor(int color2) {
        this.setTopEdgeEffectColor(color2);
        this.setBottomEdgeEffectColor(color2);
    }

    public void setBottomEdgeEffectColor(int color2) {
        this.mEdgeGlowBottom.setColor(color2);
    }

    public void setTopEdgeEffectColor(int color2) {
        this.mEdgeGlowTop.setColor(color2);
    }

    public int getTopEdgeEffectColor() {
        return this.mEdgeGlowTop.getColor();
    }

    public int getBottomEdgeEffectColor() {
        return this.mEdgeGlowBottom.getColor();
    }

    public int getMaxScrollAmount() {
        return (int)(0.5f * (float)(this.mBottom - this.mTop));
    }

    private void initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mVerticalScrollFactor = configuration.getScaledVerticalScrollFactor();
    }

    @Override
    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child);
    }

    @Override
    public void addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    @UnsupportedAppUsage
    private boolean canScroll() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            return this.getHeight() < childHeight + this.mPaddingTop + this.mPaddingBottom;
        }
        return false;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public void setFillViewport(boolean fillViewport) {
        if (fillViewport != this.mFillViewport) {
            this.mFillViewport = fillViewport;
            this.requestLayout();
        }
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    public void setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mFillViewport) {
            return;
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int heightPadding;
            int widthPadding;
            View child = this.getChildAt(0);
            int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            if (targetSdkVersion >= 23) {
                widthPadding = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin;
                heightPadding = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin;
            } else {
                widthPadding = this.mPaddingLeft + this.mPaddingRight;
                heightPadding = this.mPaddingTop + this.mPaddingBottom;
            }
            int desiredHeight = this.getMeasuredHeight() - heightPadding;
            if (child.getMeasuredHeight() < desiredHeight) {
                int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(widthMeasureSpec, widthPadding, lp.width);
                int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(desiredHeight, 0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused() && event.getKeyCode() != 4 && event.getKeyCode() != 111) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, 130)) != null && nextFocused != this && nextFocused.requestFocus(130);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 19: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(33);
                        break;
                    }
                    handled = this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(130);
                        break;
                    }
                    handled = this.fullScroll(130);
                    break;
                }
                case 122: {
                    handled = this.fullScroll(33);
                    break;
                }
                case 123: {
                    handled = this.fullScroll(130);
                    break;
                }
                case 92: {
                    handled = this.pageScroll(33);
                    break;
                }
                case 93: {
                    handled = this.pageScroll(130);
                    break;
                }
                case 62: {
                    handled = this.pageScroll(event.isShiftPressed() ? 33 : 130);
                }
            }
        }
        return handled;
    }

    private boolean inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollY = this.mScrollY;
            View child = this.getChildAt(0);
            return y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() && x < child.getRight();
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void initDifferentialFlingHelperIfNotExists() {
        if (this.mDifferentialMotionFlingHelper == null) {
            this.mDifferentialMotionFlingHelper = new DifferentialMotionFlingHelper(this.mContext, new DifferentialFlingTarget());
        }
    }

    private void initHapticScrollFeedbackProviderIfNotExists() {
        if (this.mHapticScrollFeedbackProvider == null) {
            this.mHapticScrollFeedbackProvider = new HapticScrollFeedbackProvider(this);
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (super.onInterceptTouchEvent(ev)) {
            return true;
        }
        if (this.getScrollY() == 0 && !this.canScrollVertically(1)) {
            return false;
        }
        switch (action & 0xFF) {
            case 2: {
                ViewParent parent;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    Log.e(TAG, "Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent");
                    break;
                }
                int y = (int)ev.getY(pointerIndex);
                int yDiff = Math.abs(y - this.mLastMotionY);
                if (yDiff <= this.mTouchSlop || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                if (this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                if ((parent = this.getParent()) == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int y = (int)ev.getY();
                if (!this.inChild((int)ev.getX(), y)) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionY = y;
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mScroller.computeScrollOffset();
                if (Flags.viewVelocityApi()) {
                    this.setFrameContentVelocity(Math.abs(this.mScroller.getCurrVelocity()));
                }
                boolean bl = this.mIsBeingDragged = !this.mScroller.isFinished() || !this.mEdgeGlowBottom.isFinished() || !this.mEdgeGlowTop.isFinished();
                if (!this.mEdgeGlowTop.isFinished()) {
                    this.mEdgeGlowTop.onPullDistance(0.0f, ev.getX() / (float)this.getWidth());
                }
                if (!this.mEdgeGlowBottom.isFinished()) {
                    this.mEdgeGlowBottom.onPullDistance(0.0f, 1.0f - ev.getX() / (float)this.getWidth());
                }
                if (this.mIsBeingDragged && this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                this.startNestedScroll(2);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    private boolean shouldDisplayEdgeEffects() {
        return this.getOverScrollMode() != 2;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain(ev);
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                if (!this.mScroller.isFinished() && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    if (this.mFlingStrictSpan != null) {
                        this.mFlingStrictSpan.finish();
                        this.mFlingStrictSpan = null;
                    }
                }
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.startNestedScroll(2);
                break;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e(TAG, "Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent");
                    break;
                }
                int y = (int)ev.getY(activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                boolean hitTopLimit = false;
                boolean hitBottomLimit = false;
                if (this.mIsBeingDragged) {
                    this.mLastMotionY = y - this.mScrollOffset[1];
                    int oldY = this.mScrollY;
                    int range = this.getScrollRange();
                    int overscrollMode = this.getOverScrollMode();
                    boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                    float displacement = ev.getX(activePointerIndex) / (float)this.getWidth();
                    if (canOverscroll) {
                        int consumed = 0;
                        if (deltaY < 0 && this.mEdgeGlowBottom.getDistance() != 0.0f) {
                            consumed = Math.round((float)this.getHeight() * this.mEdgeGlowBottom.onPullDistance((float)deltaY / (float)this.getHeight(), 1.0f - displacement));
                        } else if (deltaY > 0 && this.mEdgeGlowTop.getDistance() != 0.0f) {
                            consumed = Math.round((float)(-this.getHeight()) * this.mEdgeGlowTop.onPullDistance((float)(-deltaY) / (float)this.getHeight(), displacement));
                        }
                        deltaY -= consumed;
                    }
                    this.overScrollBy(0, deltaY, 0, this.mScrollY, 0, range, 0, this.mOverscrollDistance, true);
                    int scrolledDeltaY = this.mScrollY - oldY;
                    int unconsumedY = deltaY - scrolledDeltaY;
                    if (this.dispatchNestedScroll(0, scrolledDeltaY, 0, unconsumedY, this.mScrollOffset)) {
                        this.mLastMotionY -= this.mScrollOffset[1];
                        vtev.offsetLocation(0.0f, this.mScrollOffset[1]);
                        this.mNestedYOffset += this.mScrollOffset[1];
                    } else if (canOverscroll && (float)deltaY != 0.0f) {
                        int pulledToY = oldY + deltaY;
                        if (pulledToY < 0) {
                            this.mEdgeGlowTop.onPullDistance((float)(-deltaY) / (float)this.getHeight(), displacement);
                            if (!this.mEdgeGlowBottom.isFinished()) {
                                this.mEdgeGlowBottom.onRelease();
                            }
                            hitTopLimit = true;
                        } else if (pulledToY > range) {
                            this.mEdgeGlowBottom.onPullDistance((float)deltaY / (float)this.getHeight(), 1.0f - displacement);
                            if (!this.mEdgeGlowTop.isFinished()) {
                                this.mEdgeGlowTop.onRelease();
                            }
                            hitBottomLimit = true;
                        }
                        if (!(!this.shouldDisplayEdgeEffects() || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished())) {
                            this.postInvalidateOnAnimation();
                        }
                    }
                }
                if (!Flags.enableScrollFeedbackForTouch()) break;
                if (hitTopLimit || hitBottomLimit) {
                    this.initHapticScrollFeedbackProviderIfNotExists();
                    this.mHapticScrollFeedbackProvider.onScrollLimit(vtev.getDeviceId(), vtev.getSource(), 1, hitTopLimit);
                    break;
                }
                if (Math.abs(deltaY) == 0) break;
                this.initHapticScrollFeedbackProviderIfNotExists();
                this.mHapticScrollFeedbackProvider.onScrollProgress(vtev.getDeviceId(), vtev.getSource(), 1, deltaY);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.flingWithNestedDispatch(-initialVelocity);
                } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                velocityTracker.clear();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mLastMotionY = (int)ev.getY(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = (int)ev.getY(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 8: {
                int axis = event.isFromSource(2) ? 9 : (event.isFromSource(0x400000) ? 26 : -1);
                float axisValue = axis == -1 ? 0.0f : event.getAxisValue(axis);
                int delta = Math.round(axisValue * this.mVerticalScrollFactor);
                if (delta == 0) break;
                boolean hitLimit = false;
                int range = this.getScrollRange();
                int oldScrollY = this.mScrollY;
                int newScrollY = oldScrollY - delta;
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = !event.isFromSource(8194) && (overscrollMode == 0 || overscrollMode == 1 && range > 0);
                boolean absorbed = false;
                if (newScrollY < 0) {
                    if (canOverscroll) {
                        this.mEdgeGlowTop.onPullDistance(-((float)newScrollY) / (float)this.getHeight(), 0.5f);
                        this.mEdgeGlowTop.onRelease();
                        this.invalidate();
                        absorbed = true;
                    }
                    newScrollY = 0;
                    hitLimit = true;
                } else if (newScrollY > range) {
                    if (canOverscroll) {
                        this.mEdgeGlowBottom.onPullDistance((float)(newScrollY - range) / (float)this.getHeight(), 0.5f);
                        this.mEdgeGlowBottom.onRelease();
                        this.invalidate();
                        absorbed = true;
                    }
                    newScrollY = range;
                    hitLimit = true;
                }
                if (newScrollY != oldScrollY) {
                    super.scrollTo(this.mScrollX, newScrollY);
                    if (hitLimit) {
                        if (Flags.scrollFeedbackApi()) {
                            this.initHapticScrollFeedbackProviderIfNotExists();
                            this.mHapticScrollFeedbackProvider.onScrollLimit(event.getDeviceId(), event.getSource(), axis, newScrollY == 0);
                        }
                    } else {
                        if (Flags.scrollFeedbackApi()) {
                            this.initHapticScrollFeedbackProviderIfNotExists();
                            this.mHapticScrollFeedbackProvider.onScrollProgress(event.getDeviceId(), event.getSource(), axis, delta);
                        }
                        this.initDifferentialFlingHelperIfNotExists();
                        this.mDifferentialMotionFlingHelper.onMotionEvent(event, axis);
                    }
                    return true;
                }
                if (!absorbed) break;
                return true;
            }
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (!this.mScroller.isFinished()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
            this.invalidateParentIfNeeded();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (clampedY) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange());
            }
        } else {
            super.scrollTo(scrollX, scrollY);
        }
        this.awakenScrollBars();
    }

    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action) {
            case 4096: 
            case 16908346: {
                int viewportHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
                int targetScrollY = Math.min(this.mScrollY + viewportHeight, this.getScrollRange());
                if (targetScrollY != this.mScrollY) {
                    this.smoothScrollTo(0, targetScrollY);
                    return true;
                }
                return false;
            }
            case 8192: 
            case 16908344: {
                int viewportHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
                int targetScrollY = Math.max(this.mScrollY - viewportHeight, 0);
                if (targetScrollY != this.mScrollY) {
                    this.smoothScrollTo(0, targetScrollY);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ScrollView.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        int scrollRange;
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled() && (scrollRange = this.getScrollRange()) > 0) {
            info.setScrollable(true);
            if (this.mScrollY > 0) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP);
            }
            if (this.mScrollY < scrollRange) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN);
            }
        }
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        boolean scrollable = this.getScrollRange() > 0;
        event.setScrollable(scrollable);
        event.setMaxScrollX(this.mScrollX);
        event.setMaxScrollY(this.getScrollRange());
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getHeight() - (this.getHeight() - this.mPaddingBottom - this.mPaddingTop));
        }
        return scrollRange;
    }

    private View findFocusableViewInBounds(boolean topFocus, int top, int bottom) {
        ArrayList<View> focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        int count = focusables.size();
        for (int i = 0; i < count; ++i) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            View view = (View)focusables.get(i);
            int viewTop = view.getTop();
            int viewBottom = view.getBottom();
            if (top >= viewBottom || viewTop >= bottom) continue;
            boolean bl = viewIsFullyContained = top < viewTop && viewBottom < bottom;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = topFocus && viewTop < focusCandidate.getTop() || !topFocus && viewBottom > focusCandidate.getBottom();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    public boolean pageScroll(int direction) {
        boolean down = direction == 130;
        int height = this.getHeight();
        if (down) {
            View view;
            this.mTempRect.top = this.getScrollY() + height;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.top + height > (view = this.getChildAt(count - 1)).getBottom()) {
                this.mTempRect.top = view.getBottom() - height;
            }
        } else {
            this.mTempRect.top = this.getScrollY() - height;
            if (this.mTempRect.top < 0) {
                this.mTempRect.top = 0;
            }
        }
        this.mTempRect.bottom = this.mTempRect.top + height;
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    public boolean fullScroll(int direction) {
        int count;
        boolean down = direction == 130;
        int height = this.getHeight();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = height;
        if (down && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(count - 1);
            this.mTempRect.bottom = view.getBottom() + this.mPaddingBottom;
            this.mTempRect.top = this.mTempRect.bottom - height;
        }
        return this.scrollAndFocus(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    private boolean scrollAndFocus(int direction, int top, int bottom) {
        boolean handled = true;
        int height = this.getHeight();
        int containerTop = this.getScrollY();
        int containerBottom = containerTop + height;
        boolean up = direction == 33;
        View newFocused = this.findFocusableViewInBounds(up, top, bottom);
        if (newFocused == null) {
            newFocused = this;
        }
        if (top >= containerTop && bottom <= containerBottom) {
            handled = false;
        } else {
            int delta = up ? top - containerTop : bottom - containerBottom;
            this.doScrollY(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        int scrollDelta;
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmount();
        if (nextFocused != null && this.isWithinDeltaOfScreen(nextFocused, maxJump, this.getHeight())) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
            nextFocused.requestFocus(direction);
        } else {
            int screenBottom;
            int daBottom;
            scrollDelta = maxJump;
            if (direction == 33 && this.getScrollY() < scrollDelta) {
                scrollDelta = this.getScrollY();
            } else if (direction == 130 && this.getChildCount() > 0 && (daBottom = this.getChildAt(0).getBottom()) - (screenBottom = this.getScrollY() + this.getHeight() - this.mPaddingBottom) < maxJump) {
                scrollDelta = daBottom - screenBottom;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollY(direction == 130 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreen(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private boolean isOffScreen(View descendant) {
        return !this.isWithinDeltaOfScreen(descendant, 0, this.getHeight());
    }

    private boolean isWithinDeltaOfScreen(View descendant, int delta, int height) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.bottom + delta >= this.getScrollY() && this.mTempRect.top - delta <= this.getScrollY() + height;
    }

    private void doScrollY(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(0, delta);
            } else {
                this.scrollBy(0, delta);
            }
        }
    }

    public void smoothScrollBy(int dx, int dy) {
        if (this.getChildCount() == 0) {
            return;
        }
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int bottom = this.getChildAt(0).getHeight();
            int maxY = Math.max(0, bottom - height);
            int scrollY = this.mScrollY;
            dy = Math.max(0, Math.min(scrollY + dy, maxY)) - scrollY;
            this.mScroller.startScroll(this.mScrollX, scrollY, 0, dy);
            this.postInvalidateOnAnimation();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
                if (this.mFlingStrictSpan != null) {
                    this.mFlingStrictSpan.finish();
                    this.mFlingStrictSpan = null;
                }
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public void smoothScrollTo(int x, int y) {
        this.smoothScrollBy(x - this.mScrollX, y - this.mScrollY);
    }

    @Override
    protected int computeVerticalScrollRange() {
        int count = this.getChildCount();
        int contentHeight = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        if (count == 0) {
            return contentHeight;
        }
        int scrollRange = this.getChildAt(0).getBottom();
        int scrollY = this.mScrollY;
        int overscrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overscrollBottom) {
            scrollRange += scrollY - overscrollBottom;
        }
        return scrollRange;
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @Override
    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int verticalPadding = this.mPaddingTop + this.mPaddingBottom;
        int childHeightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentHeightMeasureSpec) - verticalPadding), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ScrollView.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int usedTotal = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed;
        int childHeightMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentHeightMeasureSpec) - usedTotal), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            int deltaY = this.consumeFlingInStretch(y - oldY);
            if (oldX != x || deltaY != 0) {
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                this.overScrollBy(x - oldX, deltaY, oldX, oldY, 0, range, 0, this.mOverflingDistance, false);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                if (canOverscroll && deltaY != 0) {
                    if (y < 0 && oldY >= 0) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (y > range && oldY <= range) {
                        this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
            if (Flags.viewVelocityApi()) {
                this.setFrameContentVelocity(Math.abs(this.mScroller.getCurrVelocity()));
            }
        } else if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
    }

    private int consumeFlingInStretch(int unconsumed) {
        int scrollY = this.getScrollY();
        if (scrollY < 0 || scrollY > this.getScrollRange()) {
            return unconsumed;
        }
        if (unconsumed > 0 && this.mEdgeGlowTop != null && this.mEdgeGlowTop.getDistance() != 0.0f) {
            int size = this.getHeight();
            float deltaDistance = (float)(-unconsumed) * 4.0f / (float)size;
            int consumed = Math.round((float)(-size) / 4.0f * this.mEdgeGlowTop.onPullDistance(deltaDistance, 0.5f));
            this.mEdgeGlowTop.onRelease();
            if (consumed != unconsumed) {
                this.mEdgeGlowTop.finish();
            }
            return unconsumed - consumed;
        }
        if (unconsumed < 0 && this.mEdgeGlowBottom != null && this.mEdgeGlowBottom.getDistance() != 0.0f) {
            int size = this.getHeight();
            float deltaDistance = (float)unconsumed * 4.0f / (float)size;
            int consumed = Math.round((float)size / 4.0f * this.mEdgeGlowBottom.onPullDistance(deltaDistance, 0.5f));
            this.mEdgeGlowBottom.onRelease();
            if (consumed != unconsumed) {
                this.mEdgeGlowBottom.finish();
            }
            return unconsumed - consumed;
        }
        return unconsumed;
    }

    public void scrollToDescendant(@NonNull View child) {
        if (!this.mIsLayoutDirty) {
            child.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(child, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            if (scrollDelta != 0) {
                this.scrollBy(0, scrollDelta);
            }
        } else {
            this.mChildToScrollTo = child;
        }
    }

    private boolean scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(0, delta);
            } else {
                this.smoothScrollBy(0, delta);
            }
        }
        return scroll;
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int height = this.getHeight();
        int screenTop = this.getScrollY();
        int screenBottom = screenTop + height;
        int fadingEdge = this.getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            screenTop += fadingEdge;
        }
        if (rect.bottom < this.getChildAt(0).getHeight()) {
            screenBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom && rect.top > screenTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - screenTop) : (scrollYDelta += rect.bottom - screenBottom);
            int bottom = this.getChildAt(0).getBottom();
            int distanceToBottom = bottom - screenBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < screenTop && rect.bottom < screenBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= screenBottom - rect.bottom) : (scrollYDelta -= screenTop - rect.top);
            scrollYDelta = Math.max(scrollYDelta, -this.getScrollY());
        }
        return scrollYDelta;
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (focused != null && focused.getRevealOnFocusHint()) {
            if (!this.mIsLayoutDirty) {
                this.scrollToDescendant(focused);
            } else {
                this.mChildToScrollTo = focused;
            }
        }
        super.requestChildFocus(child, focused);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 130;
        } else if (direction == 1) {
            direction = 33;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus(this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect(this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.isOffScreen(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && ScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToDescendant(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int childHeight;
            int scrollRange;
            if (this.mSavedState != null) {
                this.mScrollY = this.mSavedState.scrollPosition;
                this.mSavedState = null;
            }
            if (this.mScrollY > (scrollRange = Math.max(0, (childHeight = this.getChildCount() > 0 ? this.getChildAt(0).getMeasuredHeight() : 0) - (b - t - this.mPaddingBottom - this.mPaddingTop)))) {
                this.mScrollY = scrollRange;
            } else if (this.mScrollY < 0) {
                this.mScrollY = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        if (this.isWithinDeltaOfScreen(currentFocused, 0, oldh)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta);
        }
    }

    private static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ScrollView.isViewDescendantOf((View)((Object)theParent), parent);
    }

    public void fling(int velocityY) {
        if (this.getChildCount() > 0) {
            int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int bottom = this.getChildAt(0).getHeight();
            this.mScroller.fling(this.mScrollX, this.mScrollY, 0, velocityY, 0, 0, 0, Math.max(0, bottom - height), 0, height / 2);
            if (Flags.viewVelocityApi()) {
                this.setFrameContentVelocity(Math.abs(this.mScroller.getCurrVelocity()));
            }
            if (this.mFlingStrictSpan == null) {
                this.mFlingStrictSpan = StrictMode.enterCriticalSpan("ScrollView-fling");
            }
            this.postInvalidateOnAnimation();
        }
    }

    private void flingWithNestedDispatch(int velocityY) {
        boolean canFling;
        boolean bl = canFling = !(this.mScrollY <= 0 && velocityY <= 0 || this.mScrollY >= this.getScrollRange() && velocityY >= 0);
        if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
            boolean consumed = this.dispatchNestedFling(0.0f, velocityY, canFling);
            if (canFling) {
                this.fling(velocityY);
            } else if (!consumed) {
                if (!this.mEdgeGlowTop.isFinished()) {
                    if (this.shouldAbsorb(this.mEdgeGlowTop, -velocityY)) {
                        this.mEdgeGlowTop.onAbsorb(-velocityY);
                    } else {
                        this.fling(velocityY);
                    }
                } else if (!this.mEdgeGlowBottom.isFinished()) {
                    if (this.shouldAbsorb(this.mEdgeGlowBottom, velocityY)) {
                        this.mEdgeGlowBottom.onAbsorb(velocityY);
                    } else {
                        this.fling(velocityY);
                    }
                }
            }
        }
    }

    private boolean shouldAbsorb(EdgeEffect edgeEffect, int velocity) {
        if (velocity > 0) {
            return true;
        }
        float distance = edgeEffect.getDistance() * (float)this.getHeight();
        float flingDistance = (float)this.mScroller.getSplineFlingDistance(-velocity);
        return flingDistance < distance;
    }

    @UnsupportedAppUsage
    private void endDrag() {
        this.mIsBeingDragged = false;
        this.recycleVelocityTracker();
        if (this.shouldDisplayEdgeEffects()) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = ScrollView.clamp(x, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, child.getWidth());
            y = ScrollView.clamp(y, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, child.getHeight());
            if (x != this.mScrollX || y != this.mScrollY) {
                super.scrollTo(x, y);
            }
        }
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(2);
    }

    @Override
    public void onStopNestedScroll(View target) {
        super.onStopNestedScroll(target);
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int oldScrollY = this.mScrollY;
        this.scrollBy(0, dyUnconsumed);
        int myConsumed = this.mScrollY - oldScrollY;
        int myUnconsumed = dyUnconsumed - myConsumed;
        this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null);
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.flingWithNestedDispatch((int)velocityY);
            return true;
        }
        return false;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.shouldDisplayEdgeEffects()) {
            float translateY;
            float translateX;
            int height;
            int width;
            int restoreCount;
            int scrollY = this.mScrollY;
            boolean clipToPadding = this.getClipToPadding();
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                if (clipToPadding) {
                    width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                    height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                    translateX = this.mPaddingLeft;
                    translateY = this.mPaddingTop;
                } else {
                    width = this.getWidth();
                    height = this.getHeight();
                    translateX = 0.0f;
                    translateY = 0.0f;
                }
                canvas.translate(translateX, (float)Math.min(0, scrollY) + translateY);
                this.mEdgeGlowTop.setSize(width, height);
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                if (clipToPadding) {
                    width = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                    height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                    translateX = this.mPaddingLeft;
                    translateY = this.mPaddingTop;
                } else {
                    width = this.getWidth();
                    height = this.getHeight();
                    translateX = 0.0f;
                    translateY = 0.0f;
                }
                canvas.translate((float)(-width) + translateX, (float)(Math.max(this.getScrollRange(), scrollY) + height) + translateY);
                canvas.rotate(180.0f, width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private static int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSavedState = ss;
        this.requestLayout();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            return super.onSaveInstanceState();
        }
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.scrollPosition = this.mScrollY;
        return ss;
    }

    @Override
    protected void encodeProperties(@NonNull ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("fillViewport", this.mFillViewport);
    }

    private class DifferentialFlingTarget
    implements DifferentialMotionFlingHelper.DifferentialMotionFlingTarget {
        private DifferentialFlingTarget() {
        }

        @Override
        public boolean startDifferentialMotionFling(float velocity) {
            this.stopDifferentialMotionFling();
            ScrollView.this.fling((int)velocity);
            return true;
        }

        @Override
        public void stopDifferentialMotionFling() {
            ScrollView.this.mScroller.abortAnimation();
        }

        @Override
        public float getScaledScrollFactor() {
            return -ScrollView.this.mVerticalScrollFactor;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public int scrollPosition;
        @NonNull
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel source) {
            super(source);
            this.scrollPosition = source.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.scrollPosition);
        }

        public String toString() {
            return "ScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.scrollPosition + "}";
        }
    }
}

