/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SimpleMonthView;
import com.android.internal.widget.PagerAdapter;

class DayPickerPagerAdapter
extends PagerAdapter {
    private static final int MONTHS_IN_YEAR = 12;
    private final Calendar mMinDate = Calendar.getInstance();
    private final Calendar mMaxDate = Calendar.getInstance();
    private final SparseArray<ViewHolder> mItems = new SparseArray();
    private final LayoutInflater mInflater;
    private final int mLayoutResId;
    private final int mCalendarViewId;
    private Calendar mSelectedDay = null;
    private int mMonthTextAppearance;
    private int mDayOfWeekTextAppearance;
    private int mDayTextAppearance;
    private ColorStateList mCalendarTextColor;
    private ColorStateList mDaySelectorColor;
    private ColorStateList mDayHighlightColor;
    private OnDaySelectedListener mOnDaySelectedListener;
    private int mCount;
    private int mFirstDayOfWeek;
    private final SimpleMonthView.OnDayClickListener mOnDayClickListener = new SimpleMonthView.OnDayClickListener(){

        @Override
        public void onDayClick(SimpleMonthView view, Calendar day) {
            if (day != null) {
                DayPickerPagerAdapter.this.setSelectedDay(day);
                if (DayPickerPagerAdapter.this.mOnDaySelectedListener != null) {
                    DayPickerPagerAdapter.this.mOnDaySelectedListener.onDaySelected(DayPickerPagerAdapter.this, day);
                }
            }
        }
    };

    public DayPickerPagerAdapter(@NonNull Context context, int layoutResId, int calendarViewId) {
        this.mInflater = LayoutInflater.from(context);
        this.mLayoutResId = layoutResId;
        this.mCalendarViewId = calendarViewId;
        TypedArray ta = context.obtainStyledAttributes(new int[]{16843820});
        this.mDayHighlightColor = ta.getColorStateList(0);
        ta.recycle();
    }

    public void setRange(@NonNull Calendar min, @NonNull Calendar max) {
        this.mMinDate.setTimeInMillis(min.getTimeInMillis());
        this.mMaxDate.setTimeInMillis(max.getTimeInMillis());
        int diffYear = this.mMaxDate.get(1) - this.mMinDate.get(1);
        int diffMonth = this.mMaxDate.get(2) - this.mMinDate.get(2);
        this.mCount = diffMonth + 12 * diffYear + 1;
        this.notifyDataSetChanged();
    }

    public void setFirstDayOfWeek(int weekStart) {
        this.mFirstDayOfWeek = weekStart;
        int count = this.mItems.size();
        for (int i = 0; i < count; ++i) {
            SimpleMonthView monthView = this.mItems.valueAt((int)i).calendar;
            monthView.setFirstDayOfWeek(weekStart);
        }
    }

    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    public boolean getBoundsForDate(Calendar day, Rect outBounds) {
        int position = this.getPositionForDay(day);
        ViewHolder monthView = this.mItems.get(position, null);
        if (monthView == null) {
            return false;
        }
        int dayOfMonth = day.get(5);
        return monthView.calendar.getBoundsForDay(dayOfMonth, outBounds);
    }

    public void setSelectedDay(@Nullable Calendar day) {
        ViewHolder newMonthView;
        ViewHolder oldMonthView;
        int newPosition;
        int oldPosition = this.getPositionForDay(this.mSelectedDay);
        if (oldPosition != (newPosition = this.getPositionForDay(day)) && oldPosition >= 0 && (oldMonthView = (ViewHolder)this.mItems.get(oldPosition, null)) != null) {
            oldMonthView.calendar.setSelectedDay(-1);
        }
        if (newPosition >= 0 && (newMonthView = (ViewHolder)this.mItems.get(newPosition, null)) != null) {
            int dayOfMonth = day.get(5);
            newMonthView.calendar.setSelectedDay(dayOfMonth);
        }
        this.mSelectedDay = day;
    }

    public void setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    void setCalendarTextColor(ColorStateList calendarTextColor) {
        this.mCalendarTextColor = calendarTextColor;
        this.notifyDataSetChanged();
    }

    void setDaySelectorColor(ColorStateList selectorColor) {
        this.mDaySelectorColor = selectorColor;
        this.notifyDataSetChanged();
    }

    void setMonthTextAppearance(int resId) {
        this.mMonthTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    void setDayOfWeekTextAppearance(int resId) {
        this.mDayOfWeekTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    int getDayOfWeekTextAppearance() {
        return this.mDayOfWeekTextAppearance;
    }

    void setDayTextAppearance(int resId) {
        this.mDayTextAppearance = resId;
        this.notifyDataSetChanged();
    }

    int getDayTextAppearance() {
        return this.mDayTextAppearance;
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        ViewHolder holder = (ViewHolder)object;
        return view == holder.container;
    }

    private int getMonthForPosition(int position) {
        return (position + this.mMinDate.get(2)) % 12;
    }

    private int getYearForPosition(int position) {
        int yearOffset = (position + this.mMinDate.get(2)) / 12;
        return yearOffset + this.mMinDate.get(1);
    }

    private int getPositionForDay(@Nullable Calendar day) {
        if (day == null) {
            return -1;
        }
        int yearOffset = day.get(1) - this.mMinDate.get(1);
        int monthOffset = day.get(2) - this.mMinDate.get(2);
        int position = yearOffset * 12 + monthOffset;
        return position;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View itemView = this.mInflater.inflate(this.mLayoutResId, container, false);
        SimpleMonthView v = (SimpleMonthView)itemView.findViewById(this.mCalendarViewId);
        v.setOnDayClickListener(this.mOnDayClickListener);
        v.setMonthTextAppearance(this.mMonthTextAppearance);
        v.setDayOfWeekTextAppearance(this.mDayOfWeekTextAppearance);
        v.setDayTextAppearance(this.mDayTextAppearance);
        if (this.mDaySelectorColor != null) {
            v.setDaySelectorColor(this.mDaySelectorColor);
        }
        if (this.mDayHighlightColor != null) {
            v.setDayHighlightColor(this.mDayHighlightColor);
        }
        if (this.mCalendarTextColor != null) {
            v.setMonthTextColor(this.mCalendarTextColor);
            v.setDayOfWeekTextColor(this.mCalendarTextColor);
            v.setDayTextColor(this.mCalendarTextColor);
        }
        int month = this.getMonthForPosition(position);
        int year = this.getYearForPosition(position);
        int selectedDay = this.mSelectedDay != null && this.mSelectedDay.get(2) == month && this.mSelectedDay.get(1) == year ? this.mSelectedDay.get(5) : -1;
        int enabledDayRangeStart = this.mMinDate.get(2) == month && this.mMinDate.get(1) == year ? this.mMinDate.get(5) : 1;
        int enabledDayRangeEnd = this.mMaxDate.get(2) == month && this.mMaxDate.get(1) == year ? this.mMaxDate.get(5) : 31;
        v.setMonthParams(selectedDay, month, year, this.mFirstDayOfWeek, enabledDayRangeStart, enabledDayRangeEnd);
        ViewHolder holder = new ViewHolder(position, itemView, v);
        this.mItems.put(position, holder);
        container.addView(itemView);
        return holder;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        ViewHolder holder = (ViewHolder)object;
        container.removeView(holder.container);
        this.mItems.remove(position);
    }

    @Override
    public int getItemPosition(Object object) {
        ViewHolder holder = (ViewHolder)object;
        return holder.position;
    }

    @Override
    public CharSequence getPageTitle(int position) {
        SimpleMonthView v = this.mItems.get((int)position).calendar;
        if (v != null) {
            return v.getMonthYearLabel();
        }
        return null;
    }

    SimpleMonthView getView(Object object) {
        if (object == null) {
            return null;
        }
        ViewHolder holder = (ViewHolder)object;
        return holder.calendar;
    }

    private static class ViewHolder {
        public final int position;
        public final View container;
        public final SimpleMonthView calendar;

        public ViewHolder(int position, View container, SimpleMonthView calendar) {
            this.position = position;
            this.container = container;
            this.calendar = calendar;
        }
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(DayPickerPagerAdapter var1, Calendar var2);
    }
}

