/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.Signature;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class WebViewProviderInfo
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<WebViewProviderInfo> CREATOR = new Parcelable.Creator<WebViewProviderInfo>(){

        @Override
        public WebViewProviderInfo createFromParcel(Parcel in) {
            return new WebViewProviderInfo(in);
        }

        public WebViewProviderInfo[] newArray(int size) {
            return new WebViewProviderInfo[size];
        }
    };
    public final String packageName;
    public final String description;
    public final boolean availableByDefault;
    public final boolean isFallback;
    public final Signature[] signatures;

    public WebViewProviderInfo(String packageName, String description, boolean availableByDefault, boolean isFallback, String[] signatures) {
        this.packageName = packageName;
        this.description = description;
        this.availableByDefault = availableByDefault;
        this.isFallback = isFallback;
        if (signatures == null) {
            this.signatures = new Signature[0];
        } else {
            this.signatures = new Signature[signatures.length];
            for (int n = 0; n < signatures.length; ++n) {
                this.signatures[n] = new Signature(Base64.decode(signatures[n], 0));
            }
        }
    }

    @UnsupportedAppUsage
    private WebViewProviderInfo(Parcel in) {
        this.packageName = in.readString();
        this.description = in.readString();
        this.availableByDefault = in.readInt() > 0;
        this.isFallback = in.readInt() > 0;
        this.signatures = in.createTypedArray(Signature.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.packageName);
        out.writeString(this.description);
        out.writeInt(this.availableByDefault ? 1 : 0);
        out.writeInt(this.isFallback ? 1 : 0);
        out.writeTypedArray(this.signatures, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WebViewProviderInfo) {
            WebViewProviderInfo that = (WebViewProviderInfo)o;
            return this.packageName.equals(that.packageName) && this.description.equals(that.description) && this.availableByDefault == that.availableByDefault && this.isFallback == that.isFallback && Arrays.equals(this.signatures, that.signatures);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.description, this.availableByDefault, this.isFallback, Arrays.hashCode(this.signatures));
    }

    public String toString() {
        return "WebViewProviderInfo; packageName=" + this.packageName + " description=\"" + this.description + "\" availableByDefault=" + this.availableByDefault + " isFallback=" + this.isFallback + " signatures=" + Arrays.toString(this.signatures);
    }
}

