/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.autofill.AutofillId;
import android.view.translation.TranslationRequestValue;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ViewTranslationRequest
implements Parcelable {
    public static final String ID_TEXT = "android:text";
    public static final String ID_CONTENT_DESCRIPTION = "android:content_description";
    @NonNull
    private final AutofillId mAutofillId;
    @NonNull
    private final Map<String, TranslationRequestValue> mTranslationRequestValues;
    @NonNull
    public static final Parcelable.Creator<ViewTranslationRequest> CREATOR = new Parcelable.Creator<ViewTranslationRequest>(){

        public ViewTranslationRequest[] newArray(int size) {
            return new ViewTranslationRequest[size];
        }

        @Override
        public ViewTranslationRequest createFromParcel(@NonNull Parcel in) {
            return new ViewTranslationRequest(in);
        }
    };

    @NonNull
    public TranslationRequestValue getValue(@NonNull String key) {
        Objects.requireNonNull(key, "key should not be null");
        if (!this.mTranslationRequestValues.containsKey(key)) {
            throw new IllegalArgumentException("Request does not contain value for key=" + key);
        }
        return this.mTranslationRequestValues.get(key);
    }

    @NonNull
    public Set<String> getKeys() {
        return this.mTranslationRequestValues.keySet();
    }

    @NonNull
    public AutofillId getAutofillId() {
        return this.mAutofillId;
    }

    private static Map<String, TranslationRequestValue> defaultTranslationRequestValues() {
        return Collections.emptyMap();
    }

    public ViewTranslationRequest(@NonNull AutofillId autofillId, @NonNull Map<String, TranslationRequestValue> translationRequestValues) {
        this.mAutofillId = autofillId;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        this.mTranslationRequestValues = translationRequestValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationRequestValues);
    }

    public String toString() {
        return "ViewTranslationRequest { autofillId = " + this.mAutofillId + ", translationRequestValues = " + this.mTranslationRequestValues + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewTranslationRequest that = (ViewTranslationRequest)o;
        return Objects.equals(this.mAutofillId, that.mAutofillId) && Objects.equals(this.mTranslationRequestValues, that.mTranslationRequestValues);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mAutofillId);
        _hash = 31 * _hash + Objects.hashCode(this.mTranslationRequestValues);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mAutofillId, flags);
        dest.writeMap(this.mTranslationRequestValues);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ViewTranslationRequest(@NonNull Parcel in) {
        AutofillId autofillId = in.readTypedObject(AutofillId.CREATOR);
        LinkedHashMap<String, TranslationRequestValue> translationRequestValues = new LinkedHashMap<String, TranslationRequestValue>();
        in.readMap(translationRequestValues, TranslationRequestValue.class.getClassLoader());
        this.mAutofillId = autofillId;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        this.mTranslationRequestValues = translationRequestValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationRequestValues);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Id {
    }

    public static class Builder {
        @NonNull
        private AutofillId mAutofillId;
        @NonNull
        private Map<String, TranslationRequestValue> mTranslationRequestValues;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull AutofillId autofillId) {
            this.mAutofillId = autofillId;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        }

        public Builder(@NonNull AutofillId autofillId, long virtualChildId) {
            this.mAutofillId = new AutofillId(autofillId, virtualChildId, 0);
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setValue(@NonNull String key, @NonNull TranslationRequestValue value) {
            if (this.mTranslationRequestValues == null) {
                this.setTranslationRequestValues(new ArrayMap<String, TranslationRequestValue>());
            }
            this.mTranslationRequestValues.put(key, value);
            return this;
        }

        @NonNull
        public ViewTranslationRequest build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mTranslationRequestValues = ViewTranslationRequest.defaultTranslationRequestValues();
            }
            ViewTranslationRequest o = new ViewTranslationRequest(this.mAutofillId, this.mTranslationRequestValues);
            return o;
        }

        Builder setTranslationRequestValues(@NonNull Map<String, TranslationRequestValue> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mTranslationRequestValues = value;
            return this;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

