/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.util.ArrayMap;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TextSelection
implements Parcelable {
    private final int mStartIndex;
    private final int mEndIndex;
    private final EntityConfidence mEntityConfidence;
    @Nullable
    private final String mId;
    @Nullable
    private final TextClassification mTextClassification;
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<TextSelection> CREATOR = new Parcelable.Creator<TextSelection>(){

        @Override
        public TextSelection createFromParcel(Parcel in) {
            return new TextSelection(in);
        }

        public TextSelection[] newArray(int size) {
            return new TextSelection[size];
        }
    };

    private TextSelection(int startIndex, int endIndex, Map<String, Float> entityConfidence, String id2, @Nullable TextClassification textClassification, Bundle extras) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence(entityConfidence);
        this.mId = id2;
        this.mTextClassification = textClassification;
        this.mExtras = extras;
    }

    public int getSelectionStartIndex() {
        return this.mStartIndex;
    }

    public int getSelectionEndIndex() {
        return this.mEndIndex;
    }

    public int getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    @NonNull
    public String getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    @Nullable
    public TextClassification getTextClassification() {
        return this.mTextClassification;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public Builder toBuilder() {
        return new Builder(this.mStartIndex, this.mEndIndex).setId(this.mId).setEntityConfidence(this.mEntityConfidence).setTextClassification(this.mTextClassification).setExtras(this.mExtras);
    }

    public String toString() {
        return String.format(Locale.US, "TextSelection {id=%s, startIndex=%d, endIndex=%d, entities=%s}", this.mId, this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStartIndex);
        dest.writeInt(this.mEndIndex);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mId);
        dest.writeBundle(this.mExtras);
        dest.writeParcelable(this.mTextClassification, flags);
    }

    private TextSelection(Parcel in) {
        this.mStartIndex = in.readInt();
        this.mEndIndex = in.readInt();
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mId = in.readString();
        this.mExtras = in.readBundle();
        this.mTextClassification = in.readParcelable(TextClassification.class.getClassLoader(), TextClassification.class);
    }

    public static class Builder {
        private final int mStartIndex;
        private final int mEndIndex;
        private final Map<String, Float> mEntityConfidence = new ArrayMap<String, Float>();
        @Nullable
        private String mId;
        @Nullable
        private TextClassification mTextClassification;
        @Nullable
        private Bundle mExtras;

        public Builder(int startIndex, int endIndex) {
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        @NonNull
        public Builder setEntityType(@NonNull String type, float confidenceScore) {
            Objects.requireNonNull(type);
            this.mEntityConfidence.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        Builder setEntityConfidence(EntityConfidence scores) {
            this.mEntityConfidence.clear();
            this.mEntityConfidence.putAll(scores.toMap());
            return this;
        }

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setTextClassification(@Nullable TextClassification textClassification) {
            this.mTextClassification = textClassification;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public TextSelection build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mId, this.mTextClassification, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
        }
    }

    public static class Request
    implements Parcelable {
        private final CharSequence mText;
        private final int mStartIndex;
        private final int mEndIndex;
        @Nullable
        private final LocaleList mDefaultLocales;
        private final boolean mDarkLaunchAllowed;
        private final boolean mIncludeTextClassification;
        private final Bundle mExtras;
        @Nullable
        private SystemTextClassifierMetadata mSystemTcMetadata;
        @NonNull
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales, boolean darkLaunchAllowed, boolean includeTextClassification, Bundle extras) {
            this.mText = text;
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mDefaultLocales = defaultLocales;
            this.mDarkLaunchAllowed = darkLaunchAllowed;
            this.mIncludeTextClassification = includeTextClassification;
            this.mExtras = extras;
        }

        @NonNull
        public CharSequence getText() {
            return this.mText;
        }

        public int getStartIndex() {
            return this.mStartIndex;
        }

        public int getEndIndex() {
            return this.mEndIndex;
        }

        public boolean isDarkLaunchAllowed() {
            return this.mDarkLaunchAllowed;
        }

        @Nullable
        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        @Nullable
        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public void setSystemTextClassifierMetadata(@Nullable SystemTextClassifierMetadata systemTcMetadata) {
            this.mSystemTcMetadata = systemTcMetadata;
        }

        @Nullable
        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        public boolean shouldIncludeTextClassification() {
            return this.mIncludeTextClassification;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeCharSequence(this.mText);
            dest.writeInt(this.mStartIndex);
            dest.writeInt(this.mEndIndex);
            dest.writeParcelable(this.mDefaultLocales, flags);
            dest.writeBundle(this.mExtras);
            dest.writeParcelable(this.mSystemTcMetadata, flags);
            dest.writeBoolean(this.mIncludeTextClassification);
        }

        private static Request readFromParcel(Parcel in) {
            CharSequence text = in.readCharSequence();
            int startIndex = in.readInt();
            int endIndex = in.readInt();
            LocaleList defaultLocales = in.readParcelable(null, LocaleList.class);
            Bundle extras = in.readBundle();
            SystemTextClassifierMetadata systemTcMetadata = in.readParcelable(null, SystemTextClassifierMetadata.class);
            boolean includeTextClassification = in.readBoolean();
            Request request = new Request(text, startIndex, endIndex, defaultLocales, false, includeTextClassification, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        public static class Builder {
            private final CharSequence mText;
            private final int mStartIndex;
            private final int mEndIndex;
            @Nullable
            private LocaleList mDefaultLocales;
            private boolean mDarkLaunchAllowed;
            private boolean mIncludeTextClassification;
            private Bundle mExtras;

            public Builder(@NonNull CharSequence text, int startIndex, int endIndex) {
                TextClassifier.Utils.checkArgument(text, startIndex, endIndex);
                this.mText = text;
                this.mStartIndex = startIndex;
                this.mEndIndex = endIndex;
            }

            @NonNull
            public Builder setDefaultLocales(@Nullable LocaleList defaultLocales) {
                this.mDefaultLocales = defaultLocales;
                return this;
            }

            @NonNull
            public Builder setDarkLaunchAllowed(boolean allowed) {
                this.mDarkLaunchAllowed = allowed;
                return this;
            }

            @NonNull
            public Builder setIncludeTextClassification(boolean includeTextClassification) {
                this.mIncludeTextClassification = includeTextClassification;
                return this;
            }

            @NonNull
            public Builder setExtras(@Nullable Bundle extras) {
                this.mExtras = extras;
                return this;
            }

            @NonNull
            public Request build() {
                return new Request(new SpannedString(this.mText), this.mStartIndex, this.mEndIndex, this.mDefaultLocales, this.mDarkLaunchAllowed, this.mIncludeTextClassification, this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }
}

