/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.Nullable;
import android.provider.DeviceConfig;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;

public class TextClassificationConstants {
    private static final String SMART_LINKIFY_ENABLED = "smart_linkify_enabled";
    static final String SYSTEM_TEXT_CLASSIFIER_ENABLED = "system_textclassifier_enabled";
    @VisibleForTesting
    static final String LOCAL_TEXT_CLASSIFIER_ENABLED = "local_textclassifier_enabled";
    private static final String MODEL_DARK_LAUNCH_ENABLED = "model_dark_launch_enabled";
    private static final String SMART_SELECTION_ENABLED = "smart_selection_enabled";
    private static final String SMART_TEXT_SHARE_ENABLED = "smart_text_share_enabled";
    private static final String SMART_SELECT_ANIMATION_ENABLED = "smart_select_animation_enabled";
    @VisibleForTesting
    static final String GENERATE_LINKS_MAX_TEXT_LENGTH = "generate_links_max_text_length";
    @VisibleForTesting
    static final String TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE = "textclassifier_service_package_override";
    @VisibleForTesting
    static final String SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND = "system_textclassifier_api_timeout_in_second";
    private static final String SMART_SELECTION_TRIM_DELTA = "smart_selection_trim_delta";
    private static final String DEFAULT_TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE = null;
    private static final boolean LOCAL_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static final boolean SYSTEM_TEXT_CLASSIFIER_ENABLED_DEFAULT = true;
    private static final boolean MODEL_DARK_LAUNCH_ENABLED_DEFAULT = false;
    private static final boolean SMART_SELECTION_ENABLED_DEFAULT = true;
    private static final boolean SMART_TEXT_SHARE_ENABLED_DEFAULT = true;
    private static final boolean SMART_LINKIFY_ENABLED_DEFAULT = true;
    private static final boolean SMART_SELECT_ANIMATION_ENABLED_DEFAULT = true;
    private static final int GENERATE_LINKS_MAX_TEXT_LENGTH_DEFAULT = 100000;
    private static final long SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND_DEFAULT = 60L;
    private static final int SMART_SELECTION_TRIM_DELTA_DEFAULT = 120;
    private static final Object sLock = new Object();
    private static volatile boolean sMemoizedValuesInitialized;
    private static boolean sLocalTextClassifierEnabled;
    private static boolean sSystemTextClassifierEnabled;
    private static boolean sModelDarkLaunchEnabled;
    private static boolean sSmartSelectionEnabled;
    private static boolean sSmartTextShareEnabled;
    private static boolean sSmartLinkifyEnabled;
    private static boolean sSmartSelectAnimationEnabled;
    private static int sGenerateLinksMaxTextLength;
    private static long sSystemTextClassifierApiTimeoutInSecond;
    private static int sSmartSelectionTrimDelta;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureMemoizedValues() {
        if (sMemoizedValuesInitialized) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (sMemoizedValuesInitialized) {
                return;
            }
            DeviceConfig.Properties properties = DeviceConfig.getProperties("textclassifier", new String[0]);
            sLocalTextClassifierEnabled = properties.getBoolean(LOCAL_TEXT_CLASSIFIER_ENABLED, true);
            sModelDarkLaunchEnabled = properties.getBoolean(MODEL_DARK_LAUNCH_ENABLED, false);
            sSmartSelectionEnabled = properties.getBoolean(SMART_SELECTION_ENABLED, true);
            sSmartTextShareEnabled = properties.getBoolean(SMART_TEXT_SHARE_ENABLED, true);
            sSmartLinkifyEnabled = properties.getBoolean(SMART_LINKIFY_ENABLED, true);
            sSmartSelectAnimationEnabled = properties.getBoolean(SMART_SELECT_ANIMATION_ENABLED, true);
            sGenerateLinksMaxTextLength = properties.getInt(GENERATE_LINKS_MAX_TEXT_LENGTH, 100000);
            sSystemTextClassifierApiTimeoutInSecond = properties.getLong(SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND, 60L);
            sSmartSelectionTrimDelta = properties.getInt(SMART_SELECTION_TRIM_DELTA, 120);
            sMemoizedValuesInitialized = true;
        }
    }

    @VisibleForTesting
    public static void resetMemoizedValues() {
        sMemoizedValuesInitialized = false;
    }

    @Nullable
    public String getTextClassifierServicePackageOverride() {
        return DeviceConfig.getString("textclassifier", TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE, DEFAULT_TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE);
    }

    public boolean isLocalTextClassifierEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sLocalTextClassifierEnabled;
    }

    public boolean isSystemTextClassifierEnabled() {
        return DeviceConfig.getBoolean("textclassifier", SYSTEM_TEXT_CLASSIFIER_ENABLED, true);
    }

    public boolean isModelDarkLaunchEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sModelDarkLaunchEnabled;
    }

    public boolean isSmartSelectionEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSmartSelectionEnabled;
    }

    public boolean isSmartTextShareEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSmartTextShareEnabled;
    }

    public boolean isSmartLinkifyEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSmartLinkifyEnabled;
    }

    public boolean isSmartSelectionAnimationEnabled() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSmartSelectAnimationEnabled;
    }

    public int getGenerateLinksMaxTextLength() {
        TextClassificationConstants.ensureMemoizedValues();
        return sGenerateLinksMaxTextLength;
    }

    public long getSystemTextClassifierApiTimeoutInSecond() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSystemTextClassifierApiTimeoutInSecond;
    }

    public int getSmartSelectionTrimDelta() {
        TextClassificationConstants.ensureMemoizedValues();
        return sSmartSelectionTrimDelta;
    }

    void dump(IndentingPrintWriter pw) {
        pw.println("TextClassificationConstants:");
        pw.increaseIndent();
        pw.print(GENERATE_LINKS_MAX_TEXT_LENGTH, this.getGenerateLinksMaxTextLength()).println();
        pw.print(LOCAL_TEXT_CLASSIFIER_ENABLED, this.isLocalTextClassifierEnabled()).println();
        pw.print(MODEL_DARK_LAUNCH_ENABLED, this.isModelDarkLaunchEnabled()).println();
        pw.print(SMART_LINKIFY_ENABLED, this.isSmartLinkifyEnabled()).println();
        pw.print(SMART_SELECT_ANIMATION_ENABLED, this.isSmartSelectionAnimationEnabled()).println();
        pw.print(SMART_SELECTION_ENABLED, this.isSmartSelectionEnabled()).println();
        pw.print(SMART_TEXT_SHARE_ENABLED, this.isSmartTextShareEnabled()).println();
        pw.print(SYSTEM_TEXT_CLASSIFIER_ENABLED, this.isSystemTextClassifierEnabled()).println();
        pw.print(TEXT_CLASSIFIER_SERVICE_PACKAGE_OVERRIDE, this.getTextClassifierServicePackageOverride()).println();
        pw.print(SYSTEM_TEXT_CLASSIFIER_API_TIMEOUT_IN_SECOND, this.getSystemTextClassifierApiTimeoutInSecond()).println();
        pw.print(SMART_SELECTION_TRIM_DELTA, this.getSmartSelectionTrimDelta()).println();
        pw.decreaseIndent();
    }
}

