/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.util.Log;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IInputMethodSession;
import com.android.internal.inputmethod.IRemoteInputConnection;

class IInputMethodSessionInvoker {
    private static final String TAG = "InputMethodSessionWrapper";
    @NonNull
    private final IInputMethodSession mSession;
    @Nullable
    private final Handler mCustomHandler;
    private static final Object sAsyncBinderEmulationHandlerLock = new Object();
    @GuardedBy(value={"sAsyncBinderEmulationHandlerLock"})
    @Nullable
    private static Handler sAsyncBinderEmulationHandler;

    private IInputMethodSessionInvoker(@NonNull IInputMethodSession inputMethodSession, @Nullable Handler customHandler) {
        this.mSession = inputMethodSession;
        this.mCustomHandler = customHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IInputMethodSessionInvoker createOrNull(@NonNull IInputMethodSession inputMethodSession) {
        Handler customHandler;
        if (inputMethodSession != null && !Binder.isProxy(inputMethodSession)) {
            Object object = sAsyncBinderEmulationHandlerLock;
            synchronized (object) {
                if (sAsyncBinderEmulationHandler == null) {
                    HandlerThread thread = new HandlerThread("IMM.binder-emu");
                    thread.start();
                    sAsyncBinderEmulationHandler = Handler.createAsync(thread.getLooper());
                }
                customHandler = sAsyncBinderEmulationHandler;
            }
        } else {
            customHandler = null;
        }
        return inputMethodSession != null ? new IInputMethodSessionInvoker(inputMethodSession, customHandler) : null;
    }

    void finishInput() {
        if (this.mCustomHandler == null) {
            this.finishInputInternal();
        } else {
            this.mCustomHandler.post(this::finishInputInternal);
        }
    }

    private void finishInputInternal() {
        try {
            this.mSession.finishInput();
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        if (this.mCustomHandler == null) {
            this.updateCursorAnchorInfoInternal(cursorAnchorInfo);
        } else {
            this.mCustomHandler.post(() -> this.updateCursorAnchorInfoInternal(cursorAnchorInfo));
        }
    }

    private void updateCursorAnchorInfoInternal(CursorAnchorInfo cursorAnchorInfo) {
        try {
            this.mSession.updateCursorAnchorInfo(cursorAnchorInfo);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void displayCompletions(CompletionInfo[] completions) {
        if (this.mCustomHandler == null) {
            this.displayCompletionsInternal(completions);
        } else {
            this.mCustomHandler.post(() -> this.displayCompletionsInternal(completions));
        }
    }

    void displayCompletionsInternal(CompletionInfo[] completions) {
        try {
            this.mSession.displayCompletions(completions);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void updateExtractedText(int token, ExtractedText text) {
        if (this.mCustomHandler == null) {
            this.updateExtractedTextInternal(token, text);
        } else {
            this.mCustomHandler.post(() -> this.updateExtractedTextInternal(token, text));
        }
    }

    private void updateExtractedTextInternal(int token, ExtractedText text) {
        try {
            this.mSession.updateExtractedText(token, text);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void appPrivateCommand(String action, Bundle data) {
        if (this.mCustomHandler == null) {
            this.appPrivateCommandInternal(action, data);
        } else {
            this.mCustomHandler.post(() -> this.appPrivateCommandInternal(action, data));
        }
    }

    private void appPrivateCommandInternal(String action, Bundle data) {
        try {
            this.mSession.appPrivateCommand(action, data);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void viewClicked(boolean focusChanged) {
        if (this.mCustomHandler == null) {
            this.viewClickedInternal(focusChanged);
        } else {
            this.mCustomHandler.post(() -> this.viewClickedInternal(focusChanged));
        }
    }

    private void viewClickedInternal(boolean focusChanged) {
        try {
            this.mSession.viewClicked(focusChanged);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void updateCursor(Rect newCursor) {
        if (this.mCustomHandler == null) {
            this.updateCursorInternal(newCursor);
        } else {
            this.mCustomHandler.post(() -> this.updateCursorInternal(newCursor));
        }
    }

    private void updateCursorInternal(Rect newCursor) {
        try {
            this.mSession.updateCursor(newCursor);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void updateSelection(int oldSelStart, int oldSelEnd, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        if (this.mCustomHandler == null) {
            this.updateSelectionInternal(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
        } else {
            this.mCustomHandler.post(() -> this.updateSelectionInternal(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd));
        }
    }

    private void updateSelectionInternal(int oldSelStart, int oldSelEnd, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        try {
            this.mSession.updateSelection(oldSelStart, oldSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    void invalidateInput(EditorInfo editorInfo, IRemoteInputConnection inputConnection, int sessionId) {
        if (this.mCustomHandler == null) {
            this.invalidateInputInternal(editorInfo, inputConnection, sessionId);
        } else {
            this.mCustomHandler.post(() -> this.invalidateInputInternal(editorInfo, inputConnection, sessionId));
        }
    }

    private void invalidateInputInternal(EditorInfo editorInfo, IRemoteInputConnection inputConnection, int sessionId) {
        try {
            this.mSession.invalidateInput(editorInfo, inputConnection, sessionId);
        }
        catch (RemoteException e) {
            Log.w(TAG, "IME died", e);
        }
    }

    @NonNull
    public String toString() {
        return this.mSession.toString();
    }
}

