/*
 * Decompiled with CFR 0.152.
 */
package android.view.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.compat.CompatChanges;
import android.content.Context;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.InputEvent;
import android.view.InputEventCompatProcessor;
import android.view.input.LetterboxScrollProcessor;
import android.view.input.MouseToTouchProcessor;
import android.view.input.StylusButtonCompatibility;
import java.util.ArrayList;
import java.util.List;

public class InputEventCompatHandler {
    private static final String TAG = InputEventCompatHandler.class.getSimpleName();
    private final InputEventCompatProcessor mProcessor;
    private final InputEventCompatHandler mNext;

    public InputEventCompatHandler(InputEventCompatProcessor processor, @Nullable InputEventCompatHandler next) {
        this.mProcessor = processor;
        this.mNext = next;
    }

    public List<InputEvent> processInputEvent(InputEvent inputEvent) {
        List<InputEvent> events = this.mProcessor.processInputEventForCompatibility(inputEvent);
        if (this.mNext == null) {
            return events;
        }
        if (events == null) {
            return this.mNext.processInputEvent(inputEvent);
        }
        if (events.isEmpty()) {
            return events;
        }
        if (events.size() == 1) {
            List<InputEvent> res = this.mNext.processInputEvent(events.get(0));
            return res == null ? events : res;
        }
        ArrayList<InputEvent> tmpEvents = new ArrayList<InputEvent>(events.size());
        for (InputEvent ev : events) {
            List<InputEvent> res = this.mNext.processInputEvent(ev);
            if (res != null) {
                tmpEvents.addAll(res);
                continue;
            }
            tmpEvents.add(ev);
        }
        return tmpEvents;
    }

    @Nullable
    public InputEvent processInputEventBeforeFinish(@NonNull InputEvent inputEvent) {
        if (this.mNext != null && (inputEvent = this.mNext.processInputEventBeforeFinish(inputEvent)) == null) {
            return null;
        }
        return this.mProcessor.processInputEventBeforeFinish(inputEvent);
    }

    public static InputEventCompatHandler buildChain(Context context, Handler handler) {
        InputEventCompatHandler chainHead = null;
        String processorOverrideName = context.getResources().getString(17040020);
        if (!processorOverrideName.isEmpty()) {
            try {
                Class<?> klass = Class.forName(processorOverrideName);
                InputEventCompatProcessor processor = (InputEventCompatProcessor)klass.getConstructor(Context.class, Handler.class).newInstance(context, handler);
                chainHead = new InputEventCompatHandler(processor, chainHead);
            }
            catch (Exception e) {
                Log.e(TAG, "Unable to create the InputEventCompatProcessor. ", e);
                chainHead = null;
            }
        }
        if (MouseToTouchProcessor.isCompatibilityNeeded(context)) {
            chainHead = new InputEventCompatHandler(new MouseToTouchProcessor(context, handler), chainHead);
        }
        if (LetterboxScrollProcessor.isCompatibilityNeeded()) {
            chainHead = new InputEventCompatHandler(new LetterboxScrollProcessor(context, handler), chainHead);
        }
        if (StylusButtonCompatibility.isCompatibilityNeeded(context)) {
            chainHead = new InputEventCompatHandler(new StylusButtonCompatibility(context, handler), chainHead);
        }
        return chainHead;
    }

    static boolean isPcInputCompatibilityNeeded(Context context, long changeId) {
        if (ActivityThread.isSystem() || !CompatChanges.isChangeEnabled(changeId)) {
            return false;
        }
        try {
            PackageInfo pkgInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 16384);
            if (pkgInfo.reqFeatures != null) {
                for (FeatureInfo feature : pkgInfo.reqFeatures) {
                    if (!TextUtils.equals(feature.name, "android.hardware.type.pc")) continue;
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Cannot obtain package info.", e);
        }
        Log.i(TAG, "Input compatibility " + changeId + " is enabled for " + context.getPackageName());
        return true;
    }
}

