/*
 * Decompiled with CFR 0.152.
 */
package android.view.displayhash;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Log;
import android.view.WindowManagerGlobal;
import android.view.displayhash.DisplayHash;
import android.view.displayhash.VerifiedDisplayHash;
import com.android.internal.annotations.GuardedBy;
import java.util.Collections;
import java.util.Set;

public class DisplayHashManager {
    private static final String TAG = "DisplayHashManager";
    private final Object mSupportedHashingAlgorithmLock = new Object();
    @GuardedBy(value={"mSupportedAlgorithmLock"})
    private static Set<String> sSupportedHashAlgorithms;

    @NonNull
    public Set<String> getSupportedHashAlgorithms() {
        Object object = this.mSupportedHashingAlgorithmLock;
        synchronized (object) {
            if (sSupportedHashAlgorithms != null) {
                return sSupportedHashAlgorithms;
            }
            try {
                String[] supportedAlgorithms = WindowManagerGlobal.getWindowManagerService().getSupportedDisplayHashAlgorithms();
                if (supportedAlgorithms == null) {
                    return Collections.emptySet();
                }
                sSupportedHashAlgorithms = new ArraySet<String>(supportedAlgorithms);
                return sSupportedHashAlgorithms;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to send request getSupportedHashingAlgorithms", e);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Nullable
    public VerifiedDisplayHash verifyDisplayHash(@NonNull DisplayHash displayHash) {
        try {
            return WindowManagerGlobal.getWindowManagerService().verifyDisplayHash(displayHash);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send request verifyImpressionToken", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_FRAME_BUFFER")
    public void setDisplayHashThrottlingEnabled(boolean enable) {
        try {
            WindowManagerGlobal.getWindowManagerService().setDisplayHashThrottlingEnabled(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

