/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Dumpable;
import android.util.Log;
import android.util.Slog;
import android.view.WindowManager;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.DataShareRequest;
import android.view.contentcapture.DataShareWriteAdapter;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.IDataShareWriteAdapter;
import android.view.contentcapture.MainContentCaptureSession;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.RingBuffer;
import com.android.internal.util.SyncResultReceiver;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ContentCaptureManager {
    private static final String TAG = ContentCaptureManager.class.getSimpleName();
    public static final boolean DEBUG = false;
    public static final String DUMPABLE_NAME = "ContentCaptureManager";
    public static final int DATA_SHARE_ERROR_UNKNOWN = 1;
    public static final int DATA_SHARE_ERROR_CONCURRENT_REQUEST = 2;
    public static final int DATA_SHARE_ERROR_TIMEOUT_INTERRUPTED = 3;
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_TRUE = 1;
    public static final int RESULT_CODE_FALSE = 2;
    public static final int RESULT_CODE_SECURITY_EXCEPTION = -1;
    @SystemApi
    public static final int NO_SESSION_ID = 0;
    private static final int SYNC_CALLS_TIMEOUT_MS = 5000;
    public static final String DEVICE_CONFIG_PROPERTY_SERVICE_EXPLICITLY_ENABLED = "service_explicitly_enabled";
    public static final String DEVICE_CONFIG_PROPERTY_REPORT_LIST_VIEW_CHILDREN = "report_list_view_children";
    public static final String DEVICE_CONFIG_PROPERTY_MAX_BUFFER_SIZE = "max_buffer_size";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_FLUSH_FREQUENCY = "idle_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_TEXT_CHANGE_FLUSH_FREQUENCY = "text_change_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_LOG_HISTORY_SIZE = "log_history_size";
    public static final String DEVICE_CONFIG_PROPERTY_LOGGING_LEVEL = "logging_level";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_UNBIND_TIMEOUT = "idle_unbind_timeout";
    public static final String DEVICE_CONFIG_PROPERTY_DISABLE_FLUSH_FOR_VIEW_TREE_APPEARING = "disable_flush_for_view_tree_appearing";
    public static final String DEVICE_CONFIG_PROPERTY_ENABLE_CONTENT_PROTECTION_RECEIVER = "enable_content_protection_receiver";
    public static final String DEVICE_CONFIG_ENABLE_ACTIVITY_START_ASSIST_CONTENT = "enable_activity_start_assist_content";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_BUFFER_SIZE = "content_protection_buffer_size";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_REQUIRED_GROUPS_CONFIG = "content_protection_required_groups_config";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_OPTIONAL_GROUPS_CONFIG = "content_protection_optional_groups_config";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_OPTIONAL_GROUPS_THRESHOLD = "content_protection_optional_groups_threshold";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_ALLOWLIST_DELAY_MS = "content_protection_allowlist_delay_ms";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_ALLOWLIST_TIMEOUT_MS = "content_protection_allowlist_timeout_ms";
    public static final String DEVICE_CONFIG_PROPERTY_CONTENT_PROTECTION_AUTO_DISCONNECT_TIMEOUT = "content_protection_auto_disconnect_timeout_ms";
    public static final int LOGGING_LEVEL_OFF = 0;
    public static final int LOGGING_LEVEL_DEBUG = 1;
    public static final int LOGGING_LEVEL_VERBOSE = 2;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 500;
    public static final int DEFAULT_IDLE_FLUSHING_FREQUENCY_MS = 5000;
    public static final int DEFAULT_TEXT_CHANGE_FLUSHING_FREQUENCY_MS = 1000;
    public static final int DEFAULT_LOG_HISTORY_SIZE = 10;
    public static final boolean DEFAULT_DISABLE_FLUSH_FOR_VIEW_TREE_APPEARING = false;
    public static final boolean DEFAULT_ENABLE_CONTENT_CAPTURE_RECEIVER = true;
    public static final boolean DEFAULT_ENABLE_CONTENT_PROTECTION_RECEIVER = false;
    public static final int DEFAULT_CONTENT_PROTECTION_BUFFER_SIZE = 150;
    public static final List<List<String>> DEFAULT_CONTENT_PROTECTION_REQUIRED_GROUPS = Collections.emptyList();
    public static final String DEFAULT_CONTENT_PROTECTION_REQUIRED_GROUPS_CONFIG = "";
    public static final List<List<String>> DEFAULT_CONTENT_PROTECTION_OPTIONAL_GROUPS = Collections.emptyList();
    public static final String DEFAULT_CONTENT_PROTECTION_OPTIONAL_GROUPS_CONFIG = "";
    public static final int DEFAULT_CONTENT_PROTECTION_OPTIONAL_GROUPS_THRESHOLD = 0;
    public static final long DEFAULT_CONTENT_PROTECTION_ALLOWLIST_DELAY_MS = 30000L;
    public static final long DEFAULT_CONTENT_PROTECTION_ALLOWLIST_TIMEOUT_MS = 250L;
    public static final long DEFAULT_CONTENT_PROTECTION_AUTO_DISCONNECT_TIMEOUT_MS = 3000L;
    private final Object mLock = new Object();
    @NonNull
    private final StrippedContext mContext;
    @NonNull
    private final IContentCaptureManager mService;
    @GuardedBy(value={"mLock"})
    private final LocalDataShareAdapterResourceManager mDataShareAdapterResourceManager;
    @NonNull
    final ContentCaptureOptions mOptions;
    @GuardedBy(value={"mLock"})
    private int mFlags;
    @Nullable
    @GuardedBy(value={"mLock"})
    private Handler mUiHandler;
    @Nullable
    @GuardedBy(value={"mLock"})
    private Handler mContentCaptureHandler;
    @GuardedBy(value={"mLock"})
    private ContentCaptureSession mMainSession;
    @Nullable
    private Dumper mDumpable;
    @Nullable
    private final RingBuffer<ContentCaptureEvent> mContentProtectionEventBuffer;

    public ContentCaptureManager(@NonNull Context context, @NonNull IContentCaptureManager service, @NonNull ContentCaptureOptions options) {
        Objects.requireNonNull(context, "context cannot be null");
        this.mContext = new StrippedContext(context);
        this.mService = Objects.requireNonNull(service, "service cannot be null");
        this.mOptions = Objects.requireNonNull(options, "options cannot be null");
        ContentCaptureHelper.setLoggingLevel(this.mOptions.loggingLevel);
        this.setFlushViewTreeAppearingEventDisabled(this.mOptions.disableFlushForViewTreeAppearing);
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "Constructor for " + context.getPackageName());
        }
        this.mDataShareAdapterResourceManager = new LocalDataShareAdapterResourceManager();
        this.mContentProtectionEventBuffer = this.mOptions.contentProtectionOptions.enableReceiver && this.mOptions.contentProtectionOptions.bufferSize > 0 ? new RingBuffer<ContentCaptureEvent>(ContentCaptureEvent.class, this.mOptions.contentProtectionOptions.bufferSize) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentCaptureSession getMainContentCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMainSession == null) {
                this.mMainSession = new MainContentCaptureSession(this.mContext, this, this.prepareUiHandler(), this.prepareContentCaptureHandler(), this.mService);
                if (ContentCaptureHelper.sVerbose) {
                    Log.v(TAG, "getMainContentCaptureSession(): created " + this.mMainSession);
                }
            }
            return this.mMainSession;
        }
    }

    @NonNull
    @GuardedBy(value={"mLock"})
    private Handler prepareContentCaptureHandler() {
        if (this.mContentCaptureHandler == null) {
            this.mContentCaptureHandler = BackgroundThread.getHandler();
        }
        return this.mContentCaptureHandler;
    }

    @NonNull
    @GuardedBy(value={"mLock"})
    private Handler prepareUiHandler() {
        if (this.mUiHandler == null) {
            this.mUiHandler = Handler.createAsync(Looper.getMainLooper());
        }
        return this.mUiHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityCreated(@NonNull IBinder applicationToken, @NonNull IBinder shareableActivityToken, @NonNull ComponentName activityComponent) {
        if (this.mOptions.lite) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.getMainContentCaptureSession().start(applicationToken, shareableActivityToken, activityComponent, this.mFlags);
        }
    }

    public void onActivityResumed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionResumed();
    }

    public void onActivityPaused() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionPaused();
    }

    public void onActivityDestroyed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().destroy();
    }

    public void flush(int reason) {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().flush(reason);
    }

    @Nullable
    public ComponentName getServiceComponentName() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            this.mService.getServiceComponentName(resultReceiver);
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get service componentName.");
        }
    }

    @Nullable
    public static ComponentName getServiceSettingsComponentName() {
        IBinder binder = ServiceManager.checkService("content_capture");
        if (binder == null) {
            return null;
        }
        IContentCaptureManager service = IContentCaptureManager.Stub.asInterface(binder);
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            service.getServiceSettingsActivity(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get service settings componentName: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentCaptureEnabled() {
        ContentCaptureSession mainSession;
        if (this.mOptions.lite) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            mainSession = this.mMainSession;
        }
        return mainSession == null || !mainSession.isDisabled();
    }

    @Nullable
    public Set<ContentCaptureCondition> getContentCaptureConditions() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.getContentCaptureConditions(this.mContext.getPackageName(), r));
        try {
            ArrayList result = resultReceiver.getParcelableListResult();
            return ContentCaptureHelper.toSet(result);
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get content capture conditions.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentCaptureEnabled(boolean enabled) {
        ContentCaptureSession mainSession;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "setContentCaptureEnabled(): setting to " + enabled + " for " + this.mContext);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = enabled ? (this.mFlags &= 0xFFFFFFFE) : (this.mFlags |= 1);
            mainSession = this.mMainSession;
        }
        if (mainSession != null) {
            mainSession.setDisabled(!enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindowAttributes(@NonNull WindowManager.LayoutParams params) {
        ContentCaptureSession mainSession;
        boolean alreadyDisabledByApp;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "updateWindowAttributes(): window flags=" + params.flags);
        }
        boolean flagSecureEnabled = (params.flags & 0x2000) != 0;
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = alreadyDisabledByApp = (this.mFlags & 1) != 0;
            this.mFlags = flagSecureEnabled ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            mainSession = this.mMainSession;
        }
        if (mainSession != null && !alreadyDisabledByApp) {
            mainSession.setDisabled(flagSecureEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setFlushViewTreeAppearingEventDisabled(boolean disabled) {
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "setFlushViewTreeAppearingEventDisabled(): setting to " + disabled);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = disabled ? (this.mFlags |= 8) : (this.mFlags &= 0xFFFFFFF7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlushViewTreeAppearingEventDisabled() {
        Object object = this.mLock;
        synchronized (object) {
            return (this.mFlags & 8) != 0;
        }
    }

    @SystemApi
    public boolean isContentCaptureFeatureEnabled() {
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.isContentCaptureFeatureEnabled(r));
        try {
            int resultCode = resultReceiver.getIntResult();
            switch (resultCode) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            Log.wtf(TAG, "received invalid result: " + resultCode);
            return false;
        }
        catch (SyncResultReceiver.TimeoutException e) {
            Log.e(TAG, "Fail to get content capture feature enable status: " + e);
            return false;
        }
    }

    public void removeData(@NonNull DataRemovalRequest request) {
        Objects.requireNonNull(request);
        try {
            this.mService.removeData(request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void shareData(@NonNull DataShareRequest request, @NonNull Executor executor, @NonNull DataShareWriteAdapter dataShareWriteAdapter) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(dataShareWriteAdapter);
        Objects.requireNonNull(executor);
        try {
            this.mService.shareData(request, new DataShareAdapterDelegate(executor, dataShareWriteAdapter, this.mDataShareAdapterResourceManager));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    private SyncResultReceiver syncRun(@NonNull MyRunnable r) {
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            r.run(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SyncResultReceiver.TimeoutException e) {
            throw new RuntimeException("Fail to get syn run result from SyncResultReceiver.");
        }
        return resultReceiver;
    }

    public void addDumpable(Activity activity) {
        if (this.mDumpable == null) {
            this.mDumpable = new Dumper();
        }
        activity.addDumpable(this.mDumpable);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @Nullable
    public RingBuffer<ContentCaptureEvent> getContentProtectionEventBuffer() {
        return this.mContentProtectionEventBuffer;
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void resetTemporaryService(int userId) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.resetTemporaryService(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void setTemporaryService(int userId, @NonNull String serviceName, int duration) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.setTemporaryService(userId, serviceName, duration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CONTENT_CAPTURE")
    public static void setDefaultServiceEnabled(int userId, boolean enabled) {
        IContentCaptureManager service = ContentCaptureManager.getService();
        if (service == null) {
            Log.e(TAG, "IContentCaptureManager is null");
        }
        try {
            service.setDefaultServiceEnabled(userId, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static IContentCaptureManager getService() {
        return IContentCaptureManager.Stub.asInterface(ServiceManager.getService("content_capture"));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static class StrippedContext {
        @NonNull
        final String mPackageName;
        @NonNull
        final String mContext;
        final int mUserId;

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
        public StrippedContext(@NonNull Context context) {
            this.mPackageName = context.getPackageName();
            this.mContext = context.toString();
            this.mUserId = context.getUserId();
        }

        public String toString() {
            return this.mContext;
        }

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        public int getUserId() {
            return this.mUserId;
        }
    }

    private static class LocalDataShareAdapterResourceManager {
        private Map<DataShareAdapterDelegate, DataShareWriteAdapter> mWriteAdapterHardReferences = new HashMap<DataShareAdapterDelegate, DataShareWriteAdapter>();
        private Map<DataShareAdapterDelegate, Executor> mExecutorHardReferences = new HashMap<DataShareAdapterDelegate, Executor>();

        private LocalDataShareAdapterResourceManager() {
        }

        void initializeForDelegate(DataShareAdapterDelegate delegate, DataShareWriteAdapter adapter, Executor executor) {
            this.mWriteAdapterHardReferences.put(delegate, adapter);
            this.mExecutorHardReferences.put(delegate, executor);
        }

        Executor getExecutor(DataShareAdapterDelegate delegate) {
            return this.mExecutorHardReferences.get(delegate);
        }

        DataShareWriteAdapter getAdapter(DataShareAdapterDelegate delegate) {
            return this.mWriteAdapterHardReferences.get(delegate);
        }

        void clearHardReferences(DataShareAdapterDelegate delegate) {
            this.mWriteAdapterHardReferences.remove(delegate);
            this.mExecutorHardReferences.remove(delegate);
        }
    }

    private static interface MyRunnable {
        public void run(@NonNull SyncResultReceiver var1) throws RemoteException;
    }

    private static class DataShareAdapterDelegate
    extends IDataShareWriteAdapter.Stub {
        private final WeakReference<LocalDataShareAdapterResourceManager> mResourceManagerReference;

        private DataShareAdapterDelegate(Executor executor, DataShareWriteAdapter adapter, LocalDataShareAdapterResourceManager resourceManager) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(adapter);
            Objects.requireNonNull(resourceManager);
            resourceManager.initializeForDelegate(this, adapter, executor);
            this.mResourceManagerReference = new WeakReference<LocalDataShareAdapterResourceManager>(resourceManager);
        }

        @Override
        public void write(ParcelFileDescriptor destination) throws RemoteException {
            this.executeAdapterMethodLocked(adapter -> adapter.onWrite(destination), "onWrite");
        }

        @Override
        public void error(int errorCode) throws RemoteException {
            this.executeAdapterMethodLocked(adapter -> adapter.onError(errorCode), "onError");
            this.clearHardReferences();
        }

        @Override
        public void rejected() throws RemoteException {
            this.executeAdapterMethodLocked(DataShareWriteAdapter::onRejected, "onRejected");
            this.clearHardReferences();
        }

        @Override
        public void finish() throws RemoteException {
            this.clearHardReferences();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAdapterMethodLocked(Consumer<DataShareWriteAdapter> adapterFn, String methodName) {
            LocalDataShareAdapterResourceManager resourceManager = (LocalDataShareAdapterResourceManager)this.mResourceManagerReference.get();
            if (resourceManager == null) {
                Slog.w(TAG, "Can't execute " + methodName + "(), resource manager has been GC'ed");
                return;
            }
            DataShareWriteAdapter adapter = resourceManager.getAdapter(this);
            Executor executor = resourceManager.getExecutor(this);
            if (adapter == null || executor == null) {
                Slog.w(TAG, "Can't execute " + methodName + "(), references are null");
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> adapterFn.accept(adapter));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void clearHardReferences() {
            LocalDataShareAdapterResourceManager resourceManager = (LocalDataShareAdapterResourceManager)this.mResourceManagerReference.get();
            if (resourceManager == null) {
                Slog.w(TAG, "Can't clear references, resource manager has been GC'ed");
                return;
            }
            resourceManager.clearHardReferences(this);
        }
    }

    private class Dumper
    implements Dumpable {
        private Dumper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(@NonNull PrintWriter pw, @Nullable String[] args) {
            String prefix = "";
            pw.print(prefix);
            pw.println(ContentCaptureManager.DUMPABLE_NAME);
            String prefix2 = prefix + "  ";
            Object object = ContentCaptureManager.this.mLock;
            synchronized (object) {
                pw.print(prefix2);
                pw.print("isContentCaptureEnabled(): ");
                pw.println(ContentCaptureManager.this.isContentCaptureEnabled());
                pw.print(prefix2);
                pw.print("Debug: ");
                pw.print(ContentCaptureHelper.sDebug);
                pw.print(" Verbose: ");
                pw.println(ContentCaptureHelper.sVerbose);
                pw.print(prefix2);
                pw.print("Context: ");
                pw.println(ContentCaptureManager.this.mContext);
                pw.print(prefix2);
                pw.print("User: ");
                pw.println(ContentCaptureManager.this.mContext.getUserId());
                pw.print(prefix2);
                pw.print("Service: ");
                pw.println(ContentCaptureManager.this.mService);
                pw.print(prefix2);
                pw.print("Flags: ");
                pw.println(ContentCaptureManager.this.mFlags);
                pw.print(prefix2);
                pw.print("Options: ");
                ContentCaptureManager.this.mOptions.dumpShort(pw);
                pw.println();
                if (ContentCaptureManager.this.mMainSession != null) {
                    String prefix3 = prefix2 + "  ";
                    pw.print(prefix2);
                    pw.println("Main session:");
                    ContentCaptureManager.this.mMainSession.dump(prefix3, pw);
                } else {
                    pw.print(prefix2);
                    pw.println("No sessions");
                }
            }
        }

        @Override
        public String getDumpableName() {
            return ContentCaptureManager.DUMPABLE_NAME;
        }
    }

    public static interface ContentCaptureClient {
        @NonNull
        public ComponentName contentCaptureClientGetComponentName();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoggingLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataShareError {
    }
}

