/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.LocusId;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DebugUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ContentCaptureCondition
implements Parcelable {
    public static final int FLAG_IS_REGEX = 2;
    @NonNull
    private final LocusId mLocusId;
    private final int mFlags;
    @NonNull
    public static final Parcelable.Creator<ContentCaptureCondition> CREATOR = new Parcelable.Creator<ContentCaptureCondition>(){

        @Override
        public ContentCaptureCondition createFromParcel(@NonNull Parcel parcel) {
            return new ContentCaptureCondition(parcel.readParcelable(null, LocusId.class), parcel.readInt());
        }

        public ContentCaptureCondition[] newArray(int size) {
            return new ContentCaptureCondition[size];
        }
    };

    public ContentCaptureCondition(@NonNull LocusId locusId, int flags) {
        this.mLocusId = Objects.requireNonNull(locusId);
        this.mFlags = flags;
    }

    @NonNull
    public LocusId getLocusId() {
        return this.mLocusId;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mFlags;
        result = 31 * result + (this.mLocusId == null ? 0 : this.mLocusId.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentCaptureCondition other = (ContentCaptureCondition)obj;
        if (this.mFlags != other.mFlags) {
            return false;
        }
        return !(this.mLocusId == null ? other.mLocusId != null : !this.mLocusId.equals(other.mLocusId));
    }

    public String toString() {
        StringBuilder string2 = new StringBuilder(this.mLocusId.toString());
        if (this.mFlags != 0) {
            string2.append(" (").append(DebugUtils.flagsToString(ContentCaptureCondition.class, "FLAG_", this.mFlags)).append(')');
        }
        return string2.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeParcelable(this.mLocusId, flags);
        parcel.writeInt(this.mFlags);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Flags {
    }
}

