/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ScaleAnimation
extends Animation {
    private final Resources mResources;
    private float mFromX;
    private float mToX;
    private float mFromY;
    private float mToY;
    private int mFromXType = 0;
    private int mToXType = 0;
    private int mFromYType = 0;
    private int mToYType = 0;
    private int mFromXData = 0;
    private int mToXData = 0;
    private int mFromYData = 0;
    private int mToYData = 0;
    private int mPivotXType = 0;
    private int mPivotYType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotYValue = 0.0f;
    private float mPivotX;
    private float mPivotY;

    public ScaleAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mResources = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScaleAnimation);
        TypedValue tv = a.peekValue(2);
        this.mFromX = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mFromX = tv.getFloat();
            } else {
                this.mFromXType = tv.type;
                this.mFromXData = tv.data;
            }
        }
        tv = a.peekValue(3);
        this.mToX = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mToX = tv.getFloat();
            } else {
                this.mToXType = tv.type;
                this.mToXData = tv.data;
            }
        }
        tv = a.peekValue(4);
        this.mFromY = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mFromY = tv.getFloat();
            } else {
                this.mFromYType = tv.type;
                this.mFromYData = tv.data;
            }
        }
        tv = a.peekValue(5);
        this.mToY = 0.0f;
        if (tv != null) {
            if (tv.type == 4) {
                this.mToY = tv.getFloat();
            } else {
                this.mToYType = tv.type;
                this.mToYData = tv.data;
            }
        }
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0), context);
        this.mPivotXType = d.type;
        this.mPivotXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1), context);
        this.mPivotYType = d.type;
        this.mPivotYValue = d.value;
        a.recycle();
        this.initializePivotPoint();
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY) {
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY, float pivotX, float pivotY) {
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = pivotX;
        this.mPivotYValue = pivotY;
        this.initializePivotPoint();
    }

    public ScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        this.mResources = null;
        this.mFromX = fromX;
        this.mToX = toX;
        this.mFromY = fromY;
        this.mToY = toY;
        this.mPivotXValue = pivotXValue;
        this.mPivotXType = pivotXType;
        this.mPivotYValue = pivotYValue;
        this.mPivotYType = pivotYType;
        this.initializePivotPoint();
    }

    private void initializePivotPoint() {
        if (this.mPivotXType == 0) {
            this.mPivotX = this.mPivotXValue;
        }
        if (this.mPivotYType == 0) {
            this.mPivotY = this.mPivotYValue;
        }
    }

    @Override
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float sx = 1.0f;
        float sy = 1.0f;
        float scale = this.getScaleFactor();
        if (this.mFromX != 1.0f || this.mToX != 1.0f) {
            sx = this.mFromX + (this.mToX - this.mFromX) * interpolatedTime;
        }
        if (this.mFromY != 1.0f || this.mToY != 1.0f) {
            sy = this.mFromY + (this.mToY - this.mFromY) * interpolatedTime;
        }
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            t.getMatrix().setScale(sx, sy);
        } else {
            t.getMatrix().setScale(sx, sy, scale * this.mPivotX, scale * this.mPivotY);
        }
    }

    float resolveScale(float scale, int type, int data, int size, int psize) {
        float targetSize;
        if (type == 6) {
            targetSize = TypedValue.complexToFraction(data, size, psize);
        } else if (type == 5) {
            targetSize = TypedValue.complexToDimension(data, this.mResources.getDisplayMetrics());
        } else {
            return scale;
        }
        if (size == 0) {
            return 1.0f;
        }
        return targetSize / (float)size;
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromX = this.resolveScale(this.mFromX, this.mFromXType, this.mFromXData, width, parentWidth);
        this.mToX = this.resolveScale(this.mToX, this.mToXType, this.mToXData, width, parentWidth);
        this.mFromY = this.resolveScale(this.mFromY, this.mFromYType, this.mFromYData, height, parentHeight);
        this.mToY = this.resolveScale(this.mToY, this.mToYType, this.mToYData, height, parentHeight);
        this.mPivotX = this.resolveSize(this.mPivotXType, this.mPivotXValue, width, parentWidth);
        this.mPivotY = this.resolveSize(this.mPivotYType, this.mPivotYValue, height, parentHeight);
    }
}

