/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.graphics.BLASTBufferQueue;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.view.ISurfaceControlViewHostParent;
import android.view.KeyEvent;
import android.view.RemoteAccessibilityController;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import android.window.InputTransferToken;
import android.window.SurfaceSyncGroup;
import com.android.internal.hidden_from_bootclasspath.com.android.graphics.hwui.flags.Flags;
import com.android.internal.view.SurfaceCallbackHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class _Original_SurfaceView
extends View
implements ViewRootImpl.SurfaceChangedCallback {
    public static final int SURFACE_LIFECYCLE_DEFAULT = 0;
    public static final int SURFACE_LIFECYCLE_FOLLOWS_VISIBILITY = 1;
    public static final int SURFACE_LIFECYCLE_FOLLOWS_ATTACHMENT = 2;
    private static final String TAG = "SurfaceView";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_POSITION = false;
    private static final long FORWARD_BACK_KEY_TOLERANCE_MS = 100L;
    private static final int LOGTAG_SURFACEVIEW_LAYOUT = 60005;
    private static final int LOGTAG_SURFACEVIEW_CALLBACK = 60006;
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Track {@link SurfaceHolder#addCallback} instead")
    final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    final int[] mLocation = new int[2];
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@link SurfaceHolder#lockCanvas} instead")
    final ReentrantLock mSurfaceLock = new ReentrantLock();
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@link SurfaceHolder#getSurface} instead")
    final Surface mSurface = new Surface();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Use {@link View#getVisibility} instead")
    boolean mDrawingStopped = true;
    boolean mDrawFinished = false;
    final Rect mScreenRect = new Rect();
    SurfaceControl mSurfaceControl;
    SurfaceControl mBackgroundControl;
    private boolean mDisableBackgroundLayer = false;
    private int mRequestedSurfaceLifecycleStrategy = 0;
    private int mSurfaceLifecycleStrategy = 0;
    private float mRequestedHdrHeadroom = 0.0f;
    private float mHdrHeadroom = 0.0f;
    final Object mSurfaceControlLock = new Object();
    final Rect mTmpRect = new Rect();
    Paint mRoundedViewportPaint;
    int mSubLayer = -2;
    int mRequestedSubLayer = -2;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Use {@link SurfaceHolder#isCreating} instead")
    boolean mIsCreating = false;
    private final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = (ViewTreeObserver.OnScrollChangedListener)LambdaMetafactory.metafactory(null, null, null, ()V, updateSurface(), ()V)((SurfaceView)((Object)this));
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Rely on {@link ViewTreeObserver#dispatchOnPreDraw} instead")
    private final ViewTreeObserver.OnPreDrawListener mDrawListener = (ViewTreeObserver.OnPreDrawListener)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$new$0(), ()Z)((SurfaceView)((Object)this));
    boolean mRequestedVisible = false;
    boolean mWindowVisibility = false;
    boolean mLastWindowVisibility = false;
    boolean mViewVisibility = false;
    boolean mWindowStopped = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Use {@link View#getWidth} instead")
    int mRequestedWidth = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Use {@link View#getHeight} instead")
    int mRequestedHeight = -1;
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code SurfaceHolder.Callback#surfaceChanged} instead")
    int mRequestedFormat = 4;
    float mAlpha = 1.0f;
    boolean mClipSurfaceToBounds;
    int mBackgroundColor = -16777216;
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@link View#getWidth} and {@link View#getHeight} to determine if the SurfaceView is onscreen and has a frame")
    boolean mHaveFrame = false;
    boolean mSurfaceCreated = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Time {@link SurfaceHolder#lockCanvas} instead")
    long mLastLockTime = 0L;
    boolean mVisible = false;
    int mWindowSpaceLeft = -1;
    int mWindowSpaceTop = -1;
    int mSurfaceWidth = -1;
    int mSurfaceHeight = -1;
    float mCornerRadius;
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@code SurfaceHolder.Callback#surfaceChanged} instead")
    int mFormat = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L, publicAlternatives="Use {@link SurfaceHolder#getSurfaceFrame} instead")
    final Rect mSurfaceFrame = new Rect();
    int mLastSurfaceWidth = -1;
    int mLastSurfaceHeight = -1;
    int mTransformHint = 0;
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    private int mSurfaceFlags = 4;
    private final ArraySet<SurfaceSyncGroup> mSyncGroups = new ArraySet();
    private final SurfaceControl.Transaction mRtTransaction = new SurfaceControl.Transaction();
    private final SurfaceControl.Transaction mFrameCallbackTransaction = new SurfaceControl.Transaction();
    private int mParentSurfaceSequenceId;
    private RemoteAccessibilityController mRemoteAccessibilityController = new RemoteAccessibilityController(this);
    private final Matrix mTmpMatrix = new Matrix();
    SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    private SurfaceControl mBlastSurfaceControl;
    private BLASTBufferQueue mBlastBufferQueue;
    private final ConcurrentLinkedQueue<WindowManager.LayoutParams> mEmbeddedWindowParams = new ConcurrentLinkedQueue();
    private String mTag = "SurfaceView";
    private final SurfaceControlViewHostParent mSurfaceControlViewHostParent = new SurfaceControlViewHostParent();
    private final boolean mRtDrivenClipping = Flags.clipSurfaceviews();
    private final Rect mRTLastReportedPosition = new Rect();
    private final RectF mRTLastSetCrop = new RectF();
    private SurfaceViewPositionUpdateListener mPositionListener = null;
    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Use {@link SurfaceView#getHolder} instead")
    private final SurfaceHolder mSurfaceHolder = new SurfaceHolder(){
        private static final String LOG_TAG = "SurfaceHolder";

        @Override
        public boolean isCreating() {
            return _Original_SurfaceView.this.mIsCreating;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                if (!_Original_SurfaceView.this.mCallbacks.contains(callback)) {
                    _Original_SurfaceView.this.mCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                _Original_SurfaceView.this.mCallbacks.remove(callback);
            }
        }

        @Override
        public void setFixedSize(int width, int height) {
            if (_Original_SurfaceView.this.mRequestedWidth != width || _Original_SurfaceView.this.mRequestedHeight != height) {
                _Original_SurfaceView.this.mRequestedWidth = width;
                _Original_SurfaceView.this.mRequestedHeight = height;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setSizeFromLayout() {
            if (_Original_SurfaceView.this.mRequestedWidth != -1 || _Original_SurfaceView.this.mRequestedHeight != -1) {
                _Original_SurfaceView.this.mRequestedHeight = -1;
                _Original_SurfaceView.this.mRequestedWidth = -1;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setFormat(int format) {
            if (format == -1) {
                format = 4;
            }
            _Original_SurfaceView.this.mRequestedFormat = format;
            if (_Original_SurfaceView.this.mSurfaceControl != null) {
                _Original_SurfaceView.this.updateSurface();
            }
        }

        @Override
        @Deprecated
        public void setType(int type) {
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            _Original_SurfaceView.this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$setKeepScreenOn$0(boolean ), ()V)((Object)this, (boolean)screenOn));
        }

        @Override
        public Canvas lockCanvas() {
            return this.internalLockCanvas(null, false);
        }

        @Override
        public Canvas lockCanvas(Rect inOutDirty) {
            return this.internalLockCanvas(inOutDirty, false);
        }

        @Override
        public Canvas lockHardwareCanvas() {
            return this.internalLockCanvas(null, true);
        }

        private Canvas internalLockCanvas(Rect dirty, boolean hardware) {
            _Original_SurfaceView.this.mSurfaceLock.lock();
            Canvas c = null;
            if (!_Original_SurfaceView.this.mDrawingStopped && _Original_SurfaceView.this.mSurfaceControl != null) {
                try {
                    c = hardware ? _Original_SurfaceView.this.mSurface.lockHardwareCanvas() : _Original_SurfaceView.this.mSurface.lockCanvas(dirty);
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Exception locking surface", e);
                }
            }
            if (c != null) {
                _Original_SurfaceView.this.mLastLockTime = SystemClock.uptimeMillis();
                return c;
            }
            long nextTime = _Original_SurfaceView.this.mLastLockTime + 100L;
            long now = SystemClock.uptimeMillis();
            if (nextTime > now) {
                try {
                    Thread.sleep(nextTime - now);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = SystemClock.uptimeMillis();
            }
            _Original_SurfaceView.this.mLastLockTime = now;
            _Original_SurfaceView.this.mSurfaceLock.unlock();
            return null;
        }

        @Override
        public void unlockCanvasAndPost(Canvas canvas) {
            try {
                _Original_SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
            }
            finally {
                _Original_SurfaceView.this.mSurfaceLock.unlock();
            }
        }

        @Override
        public Surface getSurface() {
            return _Original_SurfaceView.this.mSurface;
        }

        @Override
        public Rect getSurfaceFrame() {
            return _Original_SurfaceView.this.mSurfaceFrame;
        }

        private /* synthetic */ void lambda$setKeepScreenOn$0(boolean screenOn) {
            _Original_SurfaceView.this.setKeepScreenOn(screenOn);
        }
    };

    public _Original_SurfaceView(Context context) {
        this(context, null);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this(context, attrs, defStyleAttr, defStyleRes, false);
    }

    public _Original_SurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes, boolean disableBackgroundLayer) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setWillNotDraw(true);
        this.mDisableBackgroundLayer = disableBackgroundLayer;
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    private void updateRequestedVisibility() {
        this.mRequestedVisible = this.mViewVisibility && this.mWindowVisibility && !this.mWindowStopped;
    }

    private void setWindowStopped(boolean stopped) {
        this.mWindowStopped = stopped;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    private void setTag() {
        String[] split;
        String windowName = "";
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null && (split = viewRoot.mWindowAttributes.getTitle().toString().split("\\.")).length > 0) {
            windowName = " " + split[split.length - 1];
        }
        this.mTag = "SV[" + System.identityHashCode(this) + windowName + "]";
    }

    private void dispatchScvhAttachedToHost() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        IBinder inputToken = viewRoot.getInputToken();
        if (inputToken == null) {
            return;
        }
        try {
            this.mSurfacePackage.getRemoteInterface().onDispatchAttachedToWindow(new InputTransferToken(inputToken));
        }
        catch (RemoteException e) {
            Log.d(TAG, "Failed to onDispatchAttachedToWindow to SCVH. Likely SCVH is already dead.");
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setTag();
        if (this.mSurfacePackage != null) {
            this.dispatchScvhAttachedToHost();
        }
        this.getViewRootImpl().addSurfaceChangedCallback(this);
        this.mWindowStopped = false;
        this.mViewVisibility = this.getVisibility() == 0;
        this.updateRequestedVisibility();
        this.mAttachedToWindow = true;
        this.mParent.requestTransparentRegion(this);
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    public void setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility && !this.mWindowStopped;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    public void setUseAlpha() {
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
    }

    @Override
    protected boolean onSetAlpha(int alpha) {
        if (Math.round(this.mAlpha * 255.0f) != alpha) {
            this.updateSurface();
        }
        return true;
    }

    private void performDrawFinished() {
        this.mDrawFinished = true;
        if (this.mAttachedToWindow) {
            this.mParent.requestTransparentRegion(this);
            this.invalidate();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeSurfaceChangedCallback(this);
        }
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        this.releaseSurfaces(true);
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    @Override
    @UnsupportedAppUsage
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateSurface();
        return result;
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.isAboveParent() || !this.mDrawFinished) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 0) {
            this.clearSurfaceViewPort(canvas);
        }
        super.draw(canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 128) {
            this.clearSurfaceViewPort(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public void setEnableSurfaceClipping(boolean enabled) {
        this.mClipSurfaceToBounds = enabled;
        this.invalidate();
    }

    @Override
    public void setClipBounds(Rect clipBounds) {
        super.setClipBounds(clipBounds);
        if (this.mRtDrivenClipping && this.isHardwareAccelerated()) {
            return;
        }
        if (!this.mClipSurfaceToBounds || this.mSurfaceControl == null) {
            return;
        }
        if (this.mCornerRadius > 0.0f && !this.isAboveParent()) {
            this.invalidate();
        }
        if (this.mClipBounds != null) {
            this.mTmpRect.set(this.mClipBounds);
        } else {
            this.mTmpRect.set(0, 0, this.mSurfaceWidth, this.mSurfaceHeight);
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        transaction.setWindowCrop(this.mSurfaceControl, this.mTmpRect);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    private void clearSurfaceViewPort(Canvas canvas) {
        float alpha = this.getAlpha();
        if (this.mCornerRadius > 0.0f) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                this.mTmpRect.intersect(this.mClipBounds);
            }
            canvas.punchHole(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.right, this.mTmpRect.bottom, this.mCornerRadius, this.mCornerRadius, alpha);
        } else {
            canvas.punchHole(0.0f, 0.0f, this.getWidth(), this.getHeight(), 0.0f, 0.0f, alpha);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (this.mCornerRadius > 0.0f && this.mRoundedViewportPaint == null) {
            this.mRoundedViewportPaint = new Paint(1);
            this.mRoundedViewportPaint.setBlendMode(BlendMode.CLEAR);
            this.mRoundedViewportPaint.setColor(0);
        }
        this.invalidate();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    @FlaggedApi(value="android.view.flags.surface_view_set_composition_order")
    public void setCompositionOrder(int compositionOrder) {
        this.mRequestedSubLayer = compositionOrder;
        if (this.mSubLayer != this.mRequestedSubLayer) {
            this.updateSurface();
        }
    }

    @FlaggedApi(value="android.view.flags.surface_view_set_composition_order")
    public int getCompositionOrder() {
        return this.mRequestedSubLayer;
    }

    @Deprecated
    @FlaggedApi(value="android.view.flags.deprecate_surface_view_z_order_apis")
    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mRequestedSubLayer = isMediaOverlay ? -1 : -2;
    }

    @Deprecated
    @FlaggedApi(value="android.view.flags.deprecate_surface_view_z_order_apis")
    public void setZOrderOnTop(boolean onTop) {
        boolean allowDynamicChange = this.getContext().getApplicationInfo().targetSdkVersion > 29;
        this.setZOrderedOnTop(onTop, allowDynamicChange);
    }

    public boolean isZOrderedOnTop() {
        return this.mRequestedSubLayer > 0;
    }

    @Deprecated
    public boolean setZOrderedOnTop(boolean onTop, boolean allowDynamicChange) {
        int subLayer = onTop ? 1 : -2;
        if (this.mRequestedSubLayer == subLayer) {
            return false;
        }
        this.mRequestedSubLayer = subLayer;
        if (!allowDynamicChange) {
            return false;
        }
        if (this.mSurfaceControl == null) {
            return true;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return true;
        }
        this.updateSurface();
        this.invalidate();
        return true;
    }

    public void setSecure(boolean isSecure) {
        this.mSurfaceFlags = isSecure ? (this.mSurfaceFlags |= 0x80) : (this.mSurfaceFlags &= 0xFFFFFF7F);
    }

    public void setSurfaceLifecycle(int lifecycleStrategy) {
        this.mRequestedSurfaceLifecycleStrategy = lifecycleStrategy;
        this.updateSurface();
    }

    public void setDesiredHdrHeadroom(float desiredHeadroom) {
        if (!Float.isFinite(desiredHeadroom)) {
            throw new IllegalArgumentException("desiredHeadroom must be finite: " + desiredHeadroom);
        }
        if (desiredHeadroom != 0.0f && (desiredHeadroom < 1.0f || desiredHeadroom > 10000.0f)) {
            throw new IllegalArgumentException("desiredHeadroom must be 0.0 or in the range [1.0, 10000.0f], received: " + desiredHeadroom);
        }
        this.mRequestedHdrHeadroom = desiredHeadroom;
        this.updateSurface();
        this.invalidate();
    }

    private void updateOpaqueFlag() {
        this.mSurfaceFlags = !PixelFormat.formatHasAlpha(this.mRequestedFormat) ? (this.mSurfaceFlags |= 0x400) : (this.mSurfaceFlags &= 0xFFFFFBFF);
    }

    private void updateBackgroundVisibility(SurfaceControl.Transaction t) {
        if (this.mBackgroundControl == null) {
            return;
        }
        if (this.mSubLayer < 0 && (this.mSurfaceFlags & 0x400) != 0 && !this.mDisableBackgroundLayer) {
            t.show(this.mBackgroundControl);
        } else {
            t.hide(this.mBackgroundControl);
        }
    }

    private SurfaceControl.Transaction updateBackgroundColor(SurfaceControl.Transaction t) {
        float[] colorComponents = new float[]{(float)Color.red(this.mBackgroundColor) / 255.0f, (float)Color.green(this.mBackgroundColor) / 255.0f, (float)Color.blue(this.mBackgroundColor) / 255.0f};
        t.setColor(this.mBackgroundControl, colorComponents);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSurfaces(boolean releaseSurfacePackage) {
        this.mAlpha = 1.0f;
        this.mSurface.destroy();
        Object object = this.mSurfaceControlLock;
        synchronized (object) {
            if (this.mBlastBufferQueue != null) {
                this.mBlastBufferQueue.destroy();
                this.mBlastBufferQueue = null;
            }
            SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
            if (this.mSurfaceControl != null) {
                transaction.remove(this.mSurfaceControl);
                this.mSurfaceControl = null;
            }
            if (this.mBackgroundControl != null) {
                transaction.remove(this.mBackgroundControl);
                this.mBackgroundControl = null;
            }
            if (this.mBlastSurfaceControl != null) {
                transaction.remove(this.mBlastSurfaceControl);
                this.mBlastSurfaceControl = null;
            }
            if (this.mSurfacePackage != null) {
                this.mEmbeddedWindowParams.clear();
                if (releaseSurfacePackage) {
                    this.mSurfaceControlViewHostParent.detach();
                    this.mSurfacePackage.release();
                    this.mSurfacePackage = null;
                }
            }
            this.applyTransactionOnVriDraw(transaction);
        }
    }

    private void replacePositionUpdateListener(int surfaceWidth, int surfaceHeight) {
        if (this.mPositionListener != null) {
            this.mRenderNode.removePositionUpdateListener(this.mPositionListener);
        }
        this.mPositionListener = new SurfaceViewPositionUpdateListener(surfaceWidth, surfaceHeight);
        this.mRenderNode.addPositionUpdateListener(this.mPositionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSurfaceTransaction(ViewRootImpl viewRoot, CompatibilityInfo.Translator translator, boolean creating, boolean sizeChanged, boolean hintChanged, boolean relativeZChanged, boolean hdrHeadroomChanged, SurfaceControl.Transaction surfaceUpdateTransaction) {
        boolean realSizeChanged = false;
        this.mSurfaceLock.lock();
        try {
            boolean bl = this.mDrawingStopped = !this.surfaceShouldExist();
            if (creating) {
                this.updateRelativeZ(surfaceUpdateTransaction);
                if (this.mSurfacePackage != null) {
                    this.reparentSurfacePackage(surfaceUpdateTransaction, this.mSurfacePackage);
                }
            }
            this.mParentSurfaceSequenceId = viewRoot.getSurfaceSequenceId();
            if (!this.isHardwareAccelerated()) {
                if (this.mViewVisibility) {
                    surfaceUpdateTransaction.show(this.mSurfaceControl);
                } else {
                    surfaceUpdateTransaction.hide(this.mSurfaceControl);
                }
            }
            this.updateBackgroundVisibility(surfaceUpdateTransaction);
            this.updateBackgroundColor(surfaceUpdateTransaction);
            if (hdrHeadroomChanged || creating) {
                surfaceUpdateTransaction.setDesiredHdrHeadroom(this.mBlastSurfaceControl, this.mHdrHeadroom);
            }
            if (this.isAboveParent()) {
                float alpha = this.getAlpha();
                surfaceUpdateTransaction.setAlpha(this.mSurfaceControl, alpha);
            }
            if (relativeZChanged) {
                if (!this.isAboveParent()) {
                    surfaceUpdateTransaction.setAlpha(this.mSurfaceControl, 1.0f);
                }
                this.updateRelativeZ(surfaceUpdateTransaction);
            }
            surfaceUpdateTransaction.setCornerRadius(this.mSurfaceControl, this.mCornerRadius);
            if ((sizeChanged || hintChanged) && !creating) {
                this.setBufferSize(surfaceUpdateTransaction);
            }
            if (sizeChanged || creating || !this.isHardwareAccelerated()) {
                if (!this.mRtDrivenClipping || !this.isHardwareAccelerated()) {
                    if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                        surfaceUpdateTransaction.setWindowCrop(this.mSurfaceControl, this.mClipBounds);
                    } else {
                        surfaceUpdateTransaction.setWindowCrop(this.mSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
                    }
                }
                surfaceUpdateTransaction.setDestinationFrame(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
                if (this.isHardwareAccelerated()) {
                    this.replacePositionUpdateListener(this.mSurfaceWidth, this.mSurfaceHeight);
                } else {
                    this.onSetSurfacePositionAndScale(surfaceUpdateTransaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
                }
            }
            this.applyTransactionOnVriDraw(surfaceUpdateTransaction);
            this.updateEmbeddedAccessibilityMatrix(false);
            this.mSurfaceFrame.left = 0;
            this.mSurfaceFrame.top = 0;
            if (translator == null) {
                this.mSurfaceFrame.right = this.mSurfaceWidth;
                this.mSurfaceFrame.bottom = this.mSurfaceHeight;
            } else {
                float appInvertedScale = translator.applicationInvertedScale;
                this.mSurfaceFrame.right = (int)((float)this.mSurfaceWidth * appInvertedScale + 0.5f);
                this.mSurfaceFrame.bottom = (int)((float)this.mSurfaceHeight * appInvertedScale + 0.5f);
            }
            int surfaceWidth = this.mSurfaceFrame.right;
            int surfaceHeight = this.mSurfaceFrame.bottom;
            realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
            this.mLastSurfaceWidth = surfaceWidth;
            this.mLastSurfaceHeight = surfaceHeight;
        }
        finally {
            this.mSurfaceLock.unlock();
        }
        return realSizeChanged;
    }

    private boolean requiresSurfaceControlCreation(boolean formatChanged, boolean visibleChanged) {
        if (this.mSurfaceLifecycleStrategy == 2) {
            return (this.mSurfaceControl == null || formatChanged) && this.mAttachedToWindow;
        }
        return (this.mSurfaceControl == null || formatChanged || visibleChanged) && this.mRequestedVisible;
    }

    private boolean surfaceShouldExist() {
        boolean respectVisibility = this.mSurfaceLifecycleStrategy != 2;
        return this.mVisible || !respectVisibility && this.mAttachedToWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSurface() {
        boolean hdrHeadroomChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        if (viewRoot.mSurface == null || !viewRoot.mSurface.isValid()) {
            this.notifySurfaceDestroyed();
            this.releaseSurfaces(false);
            return;
        }
        CompatibilityInfo.Translator translator = viewRoot.mTranslator;
        if (translator != null) {
            this.mSurface.setCompatibilityTranslator(translator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        float alpha = this.getAlpha();
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean alphaChanged = this.mAlpha != alpha;
        boolean creating = this.requiresSurfaceControlCreation(formatChanged, visibleChanged);
        boolean sizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        boolean windowVisibleChanged = this.mWindowVisibility != this.mLastWindowVisibility;
        this.getLocationInWindow(this.mLocation);
        boolean positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
        boolean layoutSizeChanged = this.getWidth() != this.mScreenRect.width() || this.getHeight() != this.mScreenRect.height();
        boolean hintChanged = viewRoot.getBufferTransformHint() != this.mTransformHint && this.mRequestedVisible;
        boolean relativeZChanged = this.mSubLayer != this.mRequestedSubLayer;
        boolean surfaceLifecycleStrategyChanged = this.mSurfaceLifecycleStrategy != this.mRequestedSurfaceLifecycleStrategy;
        boolean bl = hdrHeadroomChanged = this.mHdrHeadroom != this.mRequestedHdrHeadroom;
        if (creating || formatChanged || sizeChanged || visibleChanged || alphaChanged || windowVisibleChanged || positionChanged || layoutSizeChanged || hintChanged || relativeZChanged || !this.mAttachedToWindow || surfaceLifecycleStrategyChanged || hdrHeadroomChanged) {
            if (creating || formatChanged || sizeChanged || visibleChanged || layoutSizeChanged || relativeZChanged || !this.mAttachedToWindow || surfaceLifecycleStrategyChanged) {
                EventLog.writeEvent(60005, this.mTag, this.mRequestedFormat, myWidth, myHeight, this.mRequestedSubLayer, this.mRequestedWidth > 0 ? "setFixedSize" : "layout", this.mAttachedToWindow ? 1 : 0, this.mRequestedSurfaceLifecycleStrategy, this.mRequestedVisible ? 1 : 0);
            }
            try {
                this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mSurfaceWidth = myWidth;
                this.mSurfaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mAlpha = alpha;
                this.mLastWindowVisibility = this.mWindowVisibility;
                this.mTransformHint = viewRoot.getBufferTransformHint();
                this.mSubLayer = this.mRequestedSubLayer;
                int previousSurfaceLifecycleStrategy = this.mSurfaceLifecycleStrategy;
                this.mSurfaceLifecycleStrategy = this.mRequestedSurfaceLifecycleStrategy;
                this.mHdrHeadroom = this.mRequestedHdrHeadroom;
                this.mScreenRect.left = this.mWindowSpaceLeft;
                this.mScreenRect.top = this.mWindowSpaceTop;
                this.mScreenRect.right = this.mWindowSpaceLeft + this.getWidth();
                this.mScreenRect.bottom = this.mWindowSpaceTop + this.getHeight();
                if (translator != null) {
                    translator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                Rect surfaceInsets = viewRoot.mWindowAttributes.surfaceInsets;
                this.mScreenRect.offset(surfaceInsets.left, surfaceInsets.top);
                SurfaceControl.Transaction surfaceUpdateTransaction = new SurfaceControl.Transaction();
                if (creating) {
                    this.updateOpaqueFlag();
                    String name = Integer.toHexString(System.identityHashCode(this)) + " SurfaceView[" + viewRoot.getTitle().toString() + "]";
                    this.createBlastSurfaceControls(viewRoot, name, surfaceUpdateTransaction);
                } else if (this.mSurfaceControl == null) {
                    return;
                }
                boolean redrawNeeded = sizeChanged || creating || hintChanged || this.mVisible && !this.mDrawFinished || alphaChanged || relativeZChanged;
                boolean shouldSyncBuffer = redrawNeeded && viewRoot.wasRelayoutRequested() && viewRoot.isInWMSRequestedSync();
                SyncBufferTransactionCallback syncBufferTransactionCallback = null;
                if (shouldSyncBuffer) {
                    syncBufferTransactionCallback = new SyncBufferTransactionCallback();
                    this.mBlastBufferQueue.syncNextTransaction(false, arg_0 -> ((SurfaceView.SyncBufferTransactionCallback)syncBufferTransactionCallback).onTransactionReady(arg_0));
                }
                boolean realSizeChanged = this.performSurfaceTransaction(viewRoot, translator, creating, sizeChanged, hintChanged, relativeZChanged, hdrHeadroomChanged, surfaceUpdateTransaction);
                try {
                    boolean lifecycleNewlyRespectsVisibility;
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean surfaceChanged = creating;
                    boolean respectVisibility = this.mSurfaceLifecycleStrategy != 2;
                    boolean previouslyDidNotRespectVisibility = previousSurfaceLifecycleStrategy == 2;
                    boolean bl2 = lifecycleNewlyRespectsVisibility = respectVisibility && previouslyDidNotRespectVisibility;
                    if (this.mSurfaceCreated && (surfaceChanged || !respectVisibility && !this.mAttachedToWindow || respectVisibility && !this.mVisible && (visibleChanged || lifecycleNewlyRespectsVisibility))) {
                        this.mSurfaceCreated = false;
                        this.notifySurfaceDestroyed();
                    }
                    this.copySurface(creating, sizeChanged);
                    if (this.surfaceShouldExist() && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || respectVisibility && visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            EventLog.writeEvent(60006, this.mTag, "surfaceCreated");
                            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || hintChanged || respectVisibility && visibleChanged || realSizeChanged) {
                            EventLog.writeEvent(60006, this.mTag, "surfaceChanged -- format=" + this.mFormat + " w=" + myWidth + " h=" + myHeight);
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            EventLog.writeEvent(60006, this.mTag, "surfaceRedrawNeeded");
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            if (shouldSyncBuffer) {
                                this.handleSyncBufferCallback(callbacks, syncBufferTransactionCallback);
                            } else {
                                this.handleSyncNoBuffer(callbacks);
                            }
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (this.mSurfaceControl != null && !this.mSurfaceCreated) {
                        this.releaseSurfaces(false);
                    }
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception configuring surface", ex);
            }
        }
    }

    public String getName() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        String viewRootName = viewRoot == null ? "detached" : viewRoot.getTitle().toString();
        return "SurfaceView[" + viewRootName + "]";
    }

    private void handleSyncBufferCallback(SurfaceHolder.Callback[] callbacks, SyncBufferTransactionCallback syncBufferTransactionCallback) {
        SurfaceSyncGroup surfaceSyncGroup = new SurfaceSyncGroup(this.getName());
        this.getViewRootImpl().addToSync(surfaceSyncGroup);
        this.redrawNeededAsync(callbacks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleSyncBufferCallback$1(android.view.SurfaceView$SyncBufferTransactionCallback android.window.SurfaceSyncGroup ), ()V)((SurfaceView)((Object)this), (SurfaceView.SyncBufferTransactionCallback)syncBufferTransactionCallback, (SurfaceSyncGroup)surfaceSyncGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncNoBuffer(SurfaceHolder.Callback[] callbacks) {
        SurfaceSyncGroup surfaceSyncGroup = new SurfaceSyncGroup(this.getName());
        ArraySet<SurfaceSyncGroup> arraySet = this.mSyncGroups;
        synchronized (arraySet) {
            this.mSyncGroups.add(surfaceSyncGroup);
        }
        this.redrawNeededAsync(callbacks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$handleSyncNoBuffer$2(android.window.SurfaceSyncGroup ), ()V)((SurfaceView)((Object)this), (SurfaceSyncGroup)surfaceSyncGroup));
    }

    private void redrawNeededAsync(SurfaceHolder.Callback[] callbacks, Runnable callbacksCollected) {
        SurfaceCallbackHelper sch = new SurfaceCallbackHelper(callbacksCollected, this.mTag);
        sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vriDrawStarted(boolean isWmSync) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        ArraySet<SurfaceSyncGroup> arraySet = this.mSyncGroups;
        synchronized (arraySet) {
            if (isWmSync && viewRoot != null) {
                for (SurfaceSyncGroup syncGroup : this.mSyncGroups) {
                    viewRoot.addToSync(syncGroup);
                }
            }
            this.mSyncGroups.clear();
        }
    }

    private void copySurface(boolean surfaceControlCreated, boolean bufferSizeChanged) {
        if (surfaceControlCreated) {
            this.mSurface.copyFrom(this.mBlastBufferQueue);
        }
        if (bufferSizeChanged && this.getContext().getApplicationInfo().targetSdkVersion < 26 && this.mBlastBufferQueue != null) {
            this.mSurface.transferFrom(this.mBlastBufferQueue.createSurfaceWithHandle());
        }
    }

    private void setBufferSize(SurfaceControl.Transaction transaction) {
        this.mBlastSurfaceControl.setTransformHint(this.mTransformHint);
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.update(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight, this.mFormat);
        }
    }

    private void createBlastSurfaceControls(ViewRootImpl viewRoot, String name, SurfaceControl.Transaction surfaceUpdateTransaction) {
        if (this.mSurfaceControl == null) {
            this.mSurfaceControl = new SurfaceControl.Builder().setName(name).setLocalOwnerView(this).setParent(viewRoot.updateAndGetBoundsLayer(surfaceUpdateTransaction)).setCallsite("SurfaceView.updateSurface").setContainerLayer().build();
        }
        if (this.mBlastSurfaceControl == null) {
            this.mBlastSurfaceControl = new SurfaceControl.Builder().setName(name + "(BLAST)").setLocalOwnerView(this).setParent(this.mSurfaceControl).setFlags(this.mSurfaceFlags).setHidden(false).setBLASTLayer().setCallsite("SurfaceView.updateSurface").build();
        } else {
            surfaceUpdateTransaction.setOpaque(this.mBlastSurfaceControl, (this.mSurfaceFlags & 0x400) != 0).setSecure(this.mBlastSurfaceControl, (this.mSurfaceFlags & 0x80) != 0).show(this.mBlastSurfaceControl);
        }
        if (this.mBackgroundControl == null) {
            this.mBackgroundControl = new SurfaceControl.Builder().setName("Background for " + name).setLocalOwnerView(this).setOpaque(true).setColorLayer().setParent(this.mSurfaceControl).setCallsite("SurfaceView.updateSurface").build();
        }
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.destroy();
        }
        this.mTransformHint = viewRoot.getBufferTransformHint();
        this.mBlastSurfaceControl.setTransformHint(this.mTransformHint);
        this.mBlastBufferQueue = new BLASTBufferQueue(name, false);
        this.mBlastBufferQueue.update(this.mBlastSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight, this.mFormat);
        this.mBlastBufferQueue.setTransactionHangCallback(ViewRootImpl.sTransactionHangCallback);
    }

    private void onDrawFinished() {
        this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, performDrawFinished(), ()V)((SurfaceView)((Object)this)));
    }

    protected void onSetSurfacePositionAndScale(@NonNull SurfaceControl.Transaction transaction, @NonNull SurfaceControl surface, int positionLeft, int positionTop, float postScaleX, float postScaleY) {
        transaction.setPosition(surface, positionLeft, positionTop);
        transaction.setMatrix(surface, postScaleX, 0.0f, 0.0f, postScaleY);
    }

    public void requestUpdateSurfacePositionAndScale() {
        if (this.mSurfaceControl == null) {
            return;
        }
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        this.onSetSurfacePositionAndScale(transaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    @NonNull
    public Rect getSurfaceRenderPosition() {
        return this.mRTLastReportedPosition;
    }

    private void applyOrMergeTransaction(SurfaceControl.Transaction t, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.mergeWithNextTransaction(t, frameNumber);
        } else {
            t.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    private void runOnUiThread(Runnable runnable) {
        Handler handler = this.getHandler();
        if (handler != null && handler.getLooper() != Looper.myLooper()) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=33, publicAlternatives="Track {@link SurfaceHolder#setFixedSize} instead")
    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private boolean isAboveParent() {
        return this.mSubLayer >= 0;
    }

    public void setResizeBackgroundColor(int bgColor) {
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        this.setResizeBackgroundColor(transaction, bgColor);
        this.applyTransactionOnVriDraw(transaction);
        this.invalidate();
    }

    public void setResizeBackgroundColor(@NonNull SurfaceControl.Transaction t, int bgColor) {
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundColor = bgColor;
        this.updateBackgroundColor(t);
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    @Deprecated
    @Nullable
    public IBinder getHostToken() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        return viewRoot.getInputToken();
    }

    @Override
    public void surfaceCreated(SurfaceControl.Transaction t) {
        this.setWindowStopped(false);
    }

    @Override
    public void surfaceDestroyed() {
        this.setWindowStopped(true);
        this.mRemoteAccessibilityController.disassosciateHierarchy();
    }

    @Override
    public void surfaceReplaced(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl != null && this.mBackgroundControl != null) {
            this.updateRelativeZ(t);
        }
    }

    private void updateRelativeZ(SurfaceControl.Transaction t) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        SurfaceControl viewRootControl = viewRoot.getSurfaceControl();
        t.setRelativeLayer(this.mBackgroundControl, viewRootControl, Integer.MIN_VALUE);
        t.setRelativeLayer(this.mSurfaceControl, viewRootControl, this.mSubLayer);
    }

    public void setChildSurfacePackage(@NonNull SurfaceControlViewHost.SurfacePackage p) {
        SurfaceControl lastSc = this.mSurfacePackage != null ? this.mSurfacePackage.getSurfaceControl() : null;
        SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
        if (this.mSurfaceControl != null) {
            if (lastSc != null) {
                transaction.reparent(lastSc, null);
                this.mSurfacePackage.release();
            }
            this.reparentSurfacePackage(transaction, p);
            this.applyTransactionOnVriDraw(transaction);
        }
        this.mSurfacePackage = p;
        this.dispatchScvhAttachedToHost();
        this.mSurfaceControlViewHostParent.attach(this);
        if (this.isFocused()) {
            this.requestEmbeddedFocus(true);
        }
        this.invalidate();
    }

    @SuppressLint(value={"GetterSetterNullability"})
    @FlaggedApi(value="android.view.flags.surface_view_get_surface_package")
    @Nullable
    public SurfaceControlViewHost.SurfacePackage getChildSurfacePackage() {
        return this.mSurfacePackage;
    }

    @FlaggedApi(value="android.view.flags.surface_view_get_surface_package")
    public void clearChildSurfacePackage() {
        if (this.mSurfacePackage != null) {
            this.mSurfaceControlViewHostParent.detach();
            this.mEmbeddedWindowParams.clear();
            SurfaceControl sc = this.mSurfacePackage.getSurfaceControl();
            SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
            transaction.reparent(sc, null);
            this.mSurfacePackage.release();
            this.applyTransactionOnVriDraw(transaction);
            this.mSurfacePackage = null;
            this.invalidate();
        }
    }

    private void reparentSurfacePackage(SurfaceControl.Transaction t, SurfaceControlViewHost.SurfacePackage p) {
        SurfaceControl sc = p.getSurfaceControl();
        if (sc == null || !sc.isValid()) {
            return;
        }
        this.initEmbeddedHierarchyForAccessibility(p);
        t.reparent(sc, this.mBlastSurfaceControl).show(sc);
    }

    @Override
    protected void onProvideStructure(@NonNull ViewStructure structure, int viewFor, int flags) {
        super.onProvideStructure(structure, viewFor, flags);
        if ((this.mSurfaceFlags & 0x80) != 0) {
            structure.getExtras().putBoolean("android.view.ViewStructure.extra.CONTAINS_SECURE_LAYERS", true);
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (!this.mRemoteAccessibilityController.connected()) {
            return;
        }
        info.addChild(this.mRemoteAccessibilityController.getLeashToken());
    }

    @Override
    public int getImportantForAccessibility() {
        int mode = super.getImportantForAccessibility();
        if (this.mRemoteAccessibilityController != null && !this.mRemoteAccessibilityController.connected() || mode != 0) {
            return mode;
        }
        return 1;
    }

    private void initEmbeddedHierarchyForAccessibility(SurfaceControlViewHost.SurfacePackage p) {
        IAccessibilityEmbeddedConnection connection = p.getAccessibilityEmbeddedConnection();
        if (this.mRemoteAccessibilityController.alreadyAssociated(connection)) {
            return;
        }
        this.mRemoteAccessibilityController.assosciateHierarchy(connection, this.getViewRootImpl().mLeashToken, this.getAccessibilityViewId());
        this.updateEmbeddedAccessibilityMatrix(true);
    }

    private void notifySurfaceDestroyed() {
        if (this.mSurface.isValid()) {
            SurfaceHolder.Callback[] callbacks;
            EventLog.writeEvent(60006, this.mTag, "surfaceDestroyed");
            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
            if (this.mSurface.isValid()) {
                this.mSurface.forceScopedDisconnect();
            }
        }
    }

    void updateEmbeddedAccessibilityMatrix(boolean force) {
        if (!this.mRemoteAccessibilityController.connected()) {
            return;
        }
        this.getBoundsOnScreen(this.mTmpRect);
        this.mTmpRect.offset(-this.mAttachInfo.mWindowLeft, -this.mAttachInfo.mWindowTop);
        this.mTmpMatrix.reset();
        this.mTmpMatrix.setTranslate(this.mTmpRect.left, this.mTmpRect.top);
        this.mTmpMatrix.postScale((float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        this.mRemoteAccessibilityController.setWindowMatrix(this.mTmpMatrix, force);
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        this.requestEmbeddedFocus(gainFocus);
    }

    private void requestEmbeddedFocus(boolean gainFocus) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (this.mSurfacePackage == null || viewRoot == null) {
            return;
        }
        try {
            viewRoot.mWindowSession.grantEmbeddedWindowFocus(viewRoot.mWindow, this.mSurfacePackage.getInputTransferToken(), gainFocus);
        }
        catch (Exception e) {
            Log.e(TAG, System.identityHashCode(this) + "Exception requesting focus on embedded window", e);
        }
    }

    private void applyTransactionOnVriDraw(SurfaceControl.Transaction t) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.applyTransactionOnDraw(t);
        } else {
            t.apply();
        }
    }

    public void syncNextFrame(Consumer<SurfaceControl.Transaction> t) {
        this.mBlastBufferQueue.syncNextTransaction(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTransactionToFrame(@NonNull SurfaceControl.Transaction transaction) {
        Object object = this.mSurfaceControlLock;
        synchronized (object) {
            if (this.mBlastBufferQueue == null) {
                throw new IllegalStateException("Surface does not exist!");
            }
            long frameNumber = this.mBlastBufferQueue.getLastAcquiredFrameNum() + 1L;
            this.mBlastBufferQueue.mergeWithNextTransaction(transaction, frameNumber);
        }
    }

    @Override
    void performCollectViewAttributes(View.AttachInfo attachInfo, int visibility) {
        super.performCollectViewAttributes(attachInfo, visibility);
        if (this.mEmbeddedWindowParams.isEmpty()) {
            return;
        }
        for (WindowManager.LayoutParams embeddedWindowAttr : this.mEmbeddedWindowParams) {
            if ((embeddedWindowAttr.flags & 0x80) != 128) continue;
            attachInfo.mKeepScreenOn = true;
            break;
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return _Original_SurfaceView.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$handleSyncNoBuffer$2(SurfaceSyncGroup surfaceSyncGroup) {
        ArraySet<SurfaceSyncGroup> arraySet = this.mSyncGroups;
        synchronized (arraySet) {
            this.mSyncGroups.remove(surfaceSyncGroup);
        }
        surfaceSyncGroup.markSyncReady();
        this.onDrawFinished();
    }

    private /* synthetic */ void lambda$handleSyncBufferCallback$1(SyncBufferTransactionCallback syncBufferTransactionCallback, SurfaceSyncGroup surfaceSyncGroup) {
        SurfaceControl.Transaction t = null;
        if (this.mBlastBufferQueue != null) {
            this.mBlastBufferQueue.stopContinuousSyncTransaction();
            t = syncBufferTransactionCallback.waitForTransaction();
        }
        surfaceSyncGroup.addTransaction(t);
        surfaceSyncGroup.markSyncReady();
        this.onDrawFinished();
    }

    private /* synthetic */ boolean lambda$new$0() {
        this.mHaveFrame = this.getWidth() > 0 && this.getHeight() > 0;
        this.updateSurface();
        return true;
    }

    private static class SurfaceControlViewHostParent
    extends ISurfaceControlViewHostParent.Stub {
        @Nullable
        private _Original_SurfaceView mSurfaceView;

        private SurfaceControlViewHostParent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attach(_Original_SurfaceView sv) {
            SurfaceControlViewHostParent surfaceControlViewHostParent = this;
            synchronized (surfaceControlViewHostParent) {
                try {
                    sv.mSurfacePackage.getRemoteInterface().attachParentInterface(this);
                    this.mSurfaceView = sv;
                }
                catch (RemoteException e) {
                    Log.d(_Original_SurfaceView.TAG, "Failed to attach parent interface to SCVH. Likely SCVH is already dead.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void detach() {
            SurfaceControlViewHostParent surfaceControlViewHostParent = this;
            synchronized (surfaceControlViewHostParent) {
                if (this.mSurfaceView == null) {
                    return;
                }
                try {
                    this.mSurfaceView.mSurfacePackage.getRemoteInterface().attachParentInterface(null);
                }
                catch (RemoteException e) {
                    Log.d(_Original_SurfaceView.TAG, "Failed to remove parent interface from SCVH. Likely SCVH is already dead");
                }
                this.mSurfaceView = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateParams(WindowManager.LayoutParams[] childAttrs) {
            _Original_SurfaceView sv;
            SurfaceControlViewHostParent surfaceControlViewHostParent = this;
            synchronized (surfaceControlViewHostParent) {
                sv = this.mSurfaceView;
            }
            if (sv == null) {
                return;
            }
            sv.mEmbeddedWindowParams.clear();
            sv.mEmbeddedWindowParams.addAll(Arrays.asList(childAttrs));
            if (sv.isAttachedToWindow()) {
                sv.runOnUiThread(() -> SurfaceView.SurfaceControlViewHostParent.lambda$updateParams$0((SurfaceView)((Object)sv)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forwardBackKeyToParent(@NonNull KeyEvent keyEvent) {
            _Original_SurfaceView sv;
            SurfaceControlViewHostParent surfaceControlViewHostParent = this;
            synchronized (surfaceControlViewHostParent) {
                sv = this.mSurfaceView;
            }
            if (sv == null) {
                return;
            }
            sv.runOnUiThread(() -> SurfaceView.SurfaceControlViewHostParent.lambda$forwardBackKeyToParent$1((SurfaceView)((Object)sv), (KeyEvent)keyEvent));
        }

        private static /* synthetic */ void lambda$forwardBackKeyToParent$1(_Original_SurfaceView sv, KeyEvent keyEvent) {
            if (!sv.isAttachedToWindow() || keyEvent.getKeyCode() != 4) {
                return;
            }
            ViewRootImpl vri = sv.getViewRootImpl();
            if (vri == null) {
                return;
            }
            InputManager inputManager = sv.mContext.getSystemService(InputManager.class);
            if (inputManager == null) {
                return;
            }
            long timeDiff = SystemClock.uptimeMillis() - keyEvent.getEventTime();
            if (timeDiff > 100L) {
                Log.e(_Original_SurfaceView.TAG, "Ignore the input event that exceed the tolerance time, exceed " + timeDiff + "ms");
                return;
            }
            if (inputManager.verifyInputEvent(keyEvent) == null) {
                Log.e(_Original_SurfaceView.TAG, "Received invalid input event");
                return;
            }
            vri.enqueueInputEvent(keyEvent, null, 0, true);
        }

        private static /* synthetic */ void lambda$updateParams$0(_Original_SurfaceView sv) {
            if (sv.mParent != null) {
                sv.mParent.recomputeViewAttributes(sv);
            }
        }
    }

    private class SurfaceViewPositionUpdateListener
    implements RenderNode.PositionUpdateListener {
        private final int mRtSurfaceWidth;
        private final int mRtSurfaceHeight;
        private final SurfaceControl.Transaction mPositionChangedTransaction = new SurfaceControl.Transaction();

        SurfaceViewPositionUpdateListener(int surfaceWidth, int surfaceHeight) {
            this.mRtSurfaceWidth = surfaceWidth;
            this.mRtSurfaceHeight = surfaceHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            try {
                Object object = _Original_SurfaceView.this.mSurfaceControlLock;
                synchronized (object) {
                    if (_Original_SurfaceView.this.mSurfaceControl == null) {
                        return;
                    }
                    _Original_SurfaceView.this.mRTLastReportedPosition.set(left, top, right, bottom);
                    _Original_SurfaceView.this.onSetSurfacePositionAndScale(this.mPositionChangedTransaction, _Original_SurfaceView.this.mSurfaceControl, _Original_SurfaceView.this.mRTLastReportedPosition.left, _Original_SurfaceView.this.mRTLastReportedPosition.top, (float)_Original_SurfaceView.this.mRTLastReportedPosition.width() / (float)this.mRtSurfaceWidth, (float)_Original_SurfaceView.this.mRTLastReportedPosition.height() / (float)this.mRtSurfaceHeight);
                    this.mPositionChangedTransaction.show(_Original_SurfaceView.this.mSurfaceControl);
                }
                _Original_SurfaceView.this.applyOrMergeTransaction(this.mPositionChangedTransaction, frameNumber);
            }
            catch (Exception ex) {
                Log.e(_Original_SurfaceView.TAG, "Exception from repositionChild", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom, int clipLeft, int clipTop, int clipRight, int clipBottom, int nodeWidth, int nodeHeight) {
            try {
                Object object = _Original_SurfaceView.this.mSurfaceControlLock;
                synchronized (object) {
                    if (_Original_SurfaceView.this.mSurfaceControl == null) {
                        return;
                    }
                    _Original_SurfaceView.this.mRTLastReportedPosition.set(left, top, right, bottom);
                    float postScaleX = (float)_Original_SurfaceView.this.mRTLastReportedPosition.width() / (float)this.mRtSurfaceWidth;
                    float postScaleY = (float)_Original_SurfaceView.this.mRTLastReportedPosition.height() / (float)this.mRtSurfaceHeight;
                    _Original_SurfaceView.this.onSetSurfacePositionAndScale(this.mPositionChangedTransaction, _Original_SurfaceView.this.mSurfaceControl, _Original_SurfaceView.this.mRTLastReportedPosition.left, _Original_SurfaceView.this.mRTLastReportedPosition.top, postScaleX, postScaleY);
                    float surfaceToNodeScaleX = (float)this.mRtSurfaceWidth / (float)nodeWidth;
                    float surfaceToNodeScaleY = (float)this.mRtSurfaceHeight / (float)nodeHeight;
                    _Original_SurfaceView.this.mRTLastSetCrop.set((float)clipLeft * surfaceToNodeScaleX, (float)clipTop * surfaceToNodeScaleY, (float)clipRight * surfaceToNodeScaleX, (float)clipBottom * surfaceToNodeScaleY);
                    this.mPositionChangedTransaction.setCrop(_Original_SurfaceView.this.mSurfaceControl, _Original_SurfaceView.this.mRTLastSetCrop.left, _Original_SurfaceView.this.mRTLastSetCrop.top, _Original_SurfaceView.this.mRTLastSetCrop.right, _Original_SurfaceView.this.mRTLastSetCrop.bottom);
                    if (_Original_SurfaceView.this.mRTLastSetCrop.isEmpty()) {
                        this.mPositionChangedTransaction.hide(_Original_SurfaceView.this.mSurfaceControl);
                    } else {
                        this.mPositionChangedTransaction.show(_Original_SurfaceView.this.mSurfaceControl);
                    }
                }
                _Original_SurfaceView.this.applyOrMergeTransaction(this.mPositionChangedTransaction, frameNumber);
            }
            catch (Exception ex) {
                Log.e(_Original_SurfaceView.TAG, "Exception from repositionChild", ex);
            }
        }

        @Override
        public void applyStretch(long frameNumber, float width, float height, float vecX, float vecY, float maxStretchX, float maxStretchY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
            _Original_SurfaceView.this.mRtTransaction.setStretchEffect(_Original_SurfaceView.this.mSurfaceControl, width, height, vecX, vecY, maxStretchX, maxStretchY, childRelativeLeft, childRelativeTop, childRelativeRight, childRelativeBottom);
            _Original_SurfaceView.this.applyOrMergeTransaction(_Original_SurfaceView.this.mRtTransaction, frameNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionLost(long frameNumber) {
            _Original_SurfaceView.this.mRTLastReportedPosition.setEmpty();
            Object object = _Original_SurfaceView.this.mSurfaceControlLock;
            synchronized (object) {
                if (_Original_SurfaceView.this.mSurfaceControl == null) {
                    return;
                }
                _Original_SurfaceView.this.mRtTransaction.hide(_Original_SurfaceView.this.mSurfaceControl);
                _Original_SurfaceView.this.applyOrMergeTransaction(_Original_SurfaceView.this.mRtTransaction, frameNumber);
            }
        }
    }

    private static class SyncBufferTransactionCallback {
        private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
        private SurfaceControl.Transaction mTransaction;

        private SyncBufferTransactionCallback() {
        }

        SurfaceControl.Transaction waitForTransaction() {
            try {
                this.mCountDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTransaction;
        }

        void onTransactionReady(SurfaceControl.Transaction t) {
            this.mTransaction = t;
            this.mCountDownLatch.countDown();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SurfaceLifecycleStrategy {
    }
}

