/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.Insets;
import android.view.WindowInsets;
import android.view.animation.Interpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class WindowInsetsAnimation {
    private final int mTypeMask;
    private float mFraction;
    @Nullable
    private final Interpolator mInterpolator;
    private final long mDurationMillis;
    private float mAlpha;

    public WindowInsetsAnimation(int typeMask, @Nullable Interpolator interpolator2, long durationMillis) {
        this.mTypeMask = typeMask;
        this.mInterpolator = interpolator2;
        this.mDurationMillis = durationMillis;
    }

    public int getTypeMask() {
        return this.mTypeMask;
    }

    public float getFraction() {
        return this.mFraction;
    }

    public float getInterpolatedFraction() {
        if (this.mInterpolator != null) {
            return this.mInterpolator.getInterpolation(this.mFraction);
        }
        return this.mFraction;
    }

    @Nullable
    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public long getDurationMillis() {
        return this.mDurationMillis;
    }

    public void setFraction(float fraction2) {
        this.mFraction = fraction2;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    @SuppressLint(value={"CallbackMethodName"})
    public static abstract class Callback {
        public static final int DISPATCH_MODE_STOP = 0;
        public static final int DISPATCH_MODE_CONTINUE_ON_SUBTREE = 1;
        private final int mDispatchMode;

        public Callback(int dispatchMode) {
            this.mDispatchMode = dispatchMode;
        }

        @SuppressLint(value={"CallbackMethodName"})
        public int getDispatchMode() {
            return this.mDispatchMode;
        }

        public void onPrepare(@NonNull WindowInsetsAnimation animation) {
        }

        @NonNull
        public Bounds onStart(@NonNull WindowInsetsAnimation animation, @NonNull Bounds bounds) {
            return bounds;
        }

        @NonNull
        public abstract WindowInsets onProgress(@NonNull WindowInsets var1, @NonNull List<WindowInsetsAnimation> var2);

        public void onEnd(@NonNull WindowInsetsAnimation animation) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DispatchMode {
        }
    }

    public static class Bounds {
        private final Insets mLowerBound;
        private final Insets mUpperBound;

        public Bounds(@NonNull Insets lowerBound, @NonNull Insets upperBound) {
            this.mLowerBound = lowerBound;
            this.mUpperBound = upperBound;
        }

        @NonNull
        public Insets getLowerBound() {
            return this.mLowerBound;
        }

        @NonNull
        public Insets getUpperBound() {
            return this.mUpperBound;
        }

        @NonNull
        public Bounds inset(@NonNull Insets insets) {
            return new Bounds(WindowInsets.insetInsets(this.mLowerBound, insets.left, insets.top, insets.right, insets.bottom), WindowInsets.insetInsets(this.mUpperBound, insets.left, insets.top, insets.right, insets.bottom));
        }

        public String toString() {
            return "Bounds{lower=" + this.mLowerBound + " upper=" + this.mUpperBound + "}";
        }
    }
}

