/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.RenderNode;
import android.view.NativeVectorDrawableAnimator;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.layoutlib.androidx.annotation.NonNull;

public class ViewAnimationHostBridge
extends AnimatorListenerAdapter
implements RenderNode.AnimationHost {
    private final View mView;

    public ViewAnimationHostBridge(View view) {
        this.mView = view;
    }

    @Override
    public void registerAnimatingRenderNode(RenderNode renderNode, Animator animator2) {
        this.mView.mAttachInfo.mViewRootImpl.registerAnimatingRenderNode(renderNode);
        animator2.addListener(this);
    }

    @Override
    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animator2) {
        this.mView.mAttachInfo.mViewRootImpl.registerVectorDrawableAnimator(animator2);
        animator2.setThreadedRendererAnimatorListener(this);
    }

    @Override
    public boolean isAttached() {
        return this.mView.mAttachInfo != null;
    }

    @Override
    public void onAnimationStart(@NonNull Animator animation) {
        ViewRootImpl viewRoot = this.mView.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.addThreadedRendererView(this.mView);
        }
    }

    @Override
    public void onAnimationEnd(@NonNull Animator animation) {
        ViewRootImpl viewRoot = this.mView.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeThreadedRendererView(this.mView);
        }
    }
}

