/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsets;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.ImeTracing;
import java.util.Objects;

public class InsetsSourceConsumer {
    protected static final int ANIMATION_STATE_NONE = 0;
    protected static final int ANIMATION_STATE_SHOW = 1;
    protected static final int ANIMATION_STATE_HIDE = 2;
    protected int mAnimationState = 0;
    protected final InsetsController mController;
    protected final InsetsState mState;
    private final int mId;
    private final int mType;
    private static final String TAG = "InsetsSourceConsumer";
    @Nullable
    private InsetsSourceControl mSourceControl;
    private boolean mHasWindowFocus;
    private InsetsAnimationControlRunner.SurfaceParamsApplier mSurfaceParamsApplier = InsetsAnimationControlRunner.SurfaceParamsApplier.DEFAULT;
    private final Matrix mTmpMatrix = new Matrix();
    private boolean mHasViewFocusWhenWindowFocusGain;
    private Rect mPendingFrame;
    private Rect mPendingVisibleFrame;

    public InsetsSourceConsumer(int id2, int type, InsetsState state, InsetsController controller) {
        this.mId = id2;
        this.mType = type;
        this.mState = state;
        this.mController = controller;
    }

    public boolean setControl(@Nullable InsetsSourceControl control, int[] showTypes, int[] hideTypes, int[] cancelTypes, int[] transientTypes) {
        if (Objects.equals(this.mSourceControl, control)) {
            if (this.mSourceControl != null && this.mSourceControl != control) {
                this.mSourceControl.release(SurfaceControl::release);
                this.mSourceControl = control;
            }
            return false;
        }
        InsetsSourceControl lastControl = this.mSourceControl;
        this.mSourceControl = control;
        if (control != null) {
            // empty if block
        }
        if (this.mSourceControl == null) {
            boolean serverVisible;
            this.mController.notifyControlRevoked(this);
            InsetsSource localSource = this.mState.peekSource(this.mId);
            InsetsSource serverSource = this.mController.getLastDispatchedState().peekSource(this.mId);
            boolean localVisible = localSource != null && localSource.isVisible();
            boolean bl = serverVisible = serverSource != null && serverSource.isVisible();
            if (localSource != null) {
                localSource.setVisible(serverVisible);
            }
            if (localVisible != serverVisible) {
                this.mController.notifyVisibilityChanged();
            }
            this.setSurfaceParamsApplier(InsetsAnimationControlRunner.SurfaceParamsApplier.DEFAULT);
        } else {
            if (lastControl != null && !Insets.NONE.equals(lastControl.getInsetsHint()) && InsetsSource.getInsetSide(lastControl.getInsetsHint()) != InsetsSource.getInsetSide(control.getInsetsHint())) {
                cancelTypes[0] = cancelTypes[0] | this.mType;
            }
            boolean requestedVisible = this.isRequestedVisibleAwaitingControl();
            SurfaceControl oldLeash = lastControl != null ? lastControl.getLeash() : null;
            SurfaceControl newLeash = control.getLeash();
            if (!(newLeash == null || oldLeash != null && newLeash.isSameSurface(oldLeash) || requestedVisible == control.isInitiallyVisible())) {
                if (requestedVisible) {
                    showTypes[0] = showTypes[0] | this.mType;
                } else {
                    hideTypes[0] = hideTypes[0] | this.mType;
                }
                if (lastControl != null && lastControl.isFake()) {
                    transientTypes[0] = transientTypes[0] | this.mType;
                }
            } else {
                if (this.applyLocalVisibilityOverride()) {
                    this.mController.notifyVisibilityChanged();
                }
                if (!this.mController.hasSurfaceAnimation(this.mType)) {
                    this.applyRequestedVisibilityAndPositionToControl();
                }
                if (!requestedVisible && lastControl == null) {
                    this.removeSurface();
                }
            }
        }
        if (lastControl != null) {
            lastControl.release(SurfaceControl::release);
        }
        return true;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public InsetsSourceControl getControl() {
        return this.mSourceControl;
    }

    protected boolean isRequestedVisibleAwaitingControl() {
        return (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
    }

    int getId() {
        return this.mId;
    }

    int getType() {
        return this.mType;
    }

    void setSurfaceParamsApplier(InsetsAnimationControlRunner.SurfaceParamsApplier applier) {
        this.mSurfaceParamsApplier = applier;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean onAnimationStateChanged(boolean running) {
        boolean cancelledForNewAnimation;
        boolean insetsChanged = false;
        if (!running && this.mPendingFrame != null) {
            InsetsSource source = this.mState.peekSource(this.mId);
            if (source != null) {
                source.setFrame(this.mPendingFrame);
                source.setVisibleFrame(this.mPendingVisibleFrame);
                insetsChanged = true;
            }
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
        }
        boolean showRequested = this.isShowRequested();
        boolean bl = cancelledForNewAnimation = (this.mController.getCancelledForNewAnimationTypes() & this.mType) != 0;
        int n = running ? (showRequested ? 1 : 2) : (this.mAnimationState = 0);
        if (!cancelledForNewAnimation) {
            insetsChanged |= this.applyLocalVisibilityOverride();
        }
        return insetsChanged;
    }

    protected boolean isShowRequested() {
        return (this.mController.getRequestedVisibleTypes() & this.getType()) != 0;
    }

    public void onWindowFocusGained(boolean hasViewFocus) {
        this.mHasWindowFocus = true;
        this.mHasViewFocusWhenWindowFocusGain = hasViewFocus;
    }

    public void onWindowFocusLost() {
        this.mHasWindowFocus = false;
    }

    boolean hasViewFocusWhenWindowFocusGain() {
        return this.mHasViewFocusWhenWindowFocusGain;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean applyLocalVisibilityOverride() {
        boolean requestedVisible;
        InsetsSource source;
        if (this.mType == WindowInsets.Type.ime()) {
            ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#applyLocalVisibilityOverride", this.mController.getHost().getInputMethodManager(), null);
        }
        if ((source = this.mState.peekSource(this.mId)) == null || source.hasFlags(32)) {
            return false;
        }
        boolean bl = requestedVisible = (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
        if (this.mSourceControl == null) {
            return false;
        }
        if (this.mId == InsetsSource.ID_IME && this.mSourceControl.getLeash() == null) {
            boolean wasVisible = source.isVisible();
            source.setVisible(false);
            return wasVisible;
        }
        if (source.isVisible() == requestedVisible) {
            return false;
        }
        source.setVisible(requestedVisible);
        return true;
    }

    public void onPerceptible(boolean perceptible) {
        IBinder window;
        if (this.mType == WindowInsets.Type.ime() && (window = this.mController.getHost().getWindowToken()) != null) {
            this.mController.getHost().getInputMethodManager().reportPerceptible(window, perceptible);
        }
    }

    public void removeSurface() {
        IBinder window;
        if (this.mType == WindowInsets.Type.ime() && (window = this.mController.getHost().getWindowToken()) != null) {
            this.mController.getHost().getInputMethodManager().removeImeSurface(window);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateSource(InsetsSource newSource, int animationType) {
        InsetsSource source = this.mState.peekSource(this.mId);
        if (source == null || animationType == -1 || source.getFrame().equals(newSource.getFrame())) {
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            this.mState.addSource(newSource);
            return;
        }
        this.mPendingFrame = new Rect(newSource.getFrame());
        this.mPendingVisibleFrame = newSource.getVisibleFrame() != null ? new Rect(newSource.getVisibleFrame()) : null;
        newSource.setFrame(source.getFrame());
        newSource.setVisibleFrame(source.getVisibleFrame());
        this.mState.addSource(newSource);
    }

    private void applyRequestedVisibilityAndPositionToControl() {
        if (this.mSourceControl == null) {
            return;
        }
        SurfaceControl leash = this.mSourceControl.getLeash();
        if (leash == null) {
            return;
        }
        boolean visible = (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
        Point surfacePosition = this.mSourceControl.getSurfacePosition();
        this.mTmpMatrix.setTranslate(surfacePosition.x, surfacePosition.y);
        this.mSurfaceParamsApplier.applySurfaceParams(new SyncRtSurfaceTransactionApplier.SurfaceParams.Builder(leash).withVisibility(visible).withAlpha(visible ? 1.0f : 0.0f).withMatrix(this.mTmpMatrix).build());
        this.onPerceptible(visible);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(1133871366146L, this.mHasWindowFocus);
        proto.write(1133871366147L, this.isShowRequested());
        if (this.mSourceControl != null) {
            this.mSourceControl.dumpDebug(proto, 1146756268036L);
        }
        if (this.mPendingFrame != null) {
            this.mPendingFrame.dumpDebug(proto, 1146756268037L);
        }
        if (this.mPendingVisibleFrame != null) {
            this.mPendingVisibleFrame.dumpDebug(proto, 1146756268038L);
        }
        proto.write(1120986464263L, this.mAnimationState);
        proto.write(1120986464264L, this.mType);
        proto.end(token);
    }
}

