/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.content.res.CompatibilityInfo;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Trace;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.Choreographer;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationSpec;
import android.view.InsetsAnimationThread;
import android.view.InsetsController;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InternalInsetsAnimationController;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.inputmethod.ImeTracker;

public class InsetsAnimationThreadControlRunner
implements InsetsAnimationControlRunner {
    private static final String TAG = "InsetsAnimThreadRunner";
    private final InsetsAnimationControlImpl mControl;
    private final InsetsAnimationControlCallbacks mOuterCallbacks;
    private final Handler mMainThreadHandler;
    private final InsetsAnimationControlCallbacks mCallbacks = new InsetsAnimationControlCallbacks(){

        @Override
        public <T extends InsetsAnimationControlRunner & InternalInsetsAnimationController> void startAnimation(T runner, WindowInsetsAnimationControlListener listener, int types, WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleApplyChangeInsets(InsetsAnimationControlRunner runner) {
            InsetsAnimationControlImpl insetsAnimationControlImpl = InsetsAnimationThreadControlRunner.this.mControl;
            synchronized (insetsAnimationControlImpl) {
                InsetsAnimationThreadControlRunner.this.mControl.applyChangeInsets(null);
            }
        }

        @Override
        public void notifyFinished(InsetsAnimationControlRunner runner, boolean shown) {
            Trace.asyncTraceEnd(8L, "InsetsAsyncAnimation: " + WindowInsets.Type.toString(runner.getTypes()), runner.getTypes());
            InsetsController.releaseControls(InsetsAnimationThreadControlRunner.this.mControl.getControls());
            InsetsAnimationThreadControlRunner.this.mMainThreadHandler.post(() -> InsetsAnimationThreadControlRunner.this.mOuterCallbacks.notifyFinished(InsetsAnimationThreadControlRunner.this, shown));
        }

        @Override
        public void releaseSurfaceControlFromRt(SurfaceControl sc) {
            sc.release();
        }

        @Override
        public void reportPerceptible(int types, boolean perceptible) {
            InsetsAnimationThreadControlRunner.this.mMainThreadHandler.post(() -> InsetsAnimationThreadControlRunner.this.mOuterCallbacks.reportPerceptible(types, perceptible));
        }
    };
    private final InsetsAnimationControlRunner.SurfaceParamsApplier mSurfaceParamsApplier = new InsetsAnimationControlRunner.SurfaceParamsApplier(this){
        private final float[] mTmpFloat9 = new float[9];

        @Override
        public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            for (int i = params.length - 1; i >= 0; --i) {
                SyncRtSurfaceTransactionApplier.applyParams(t, params[i], this.mTmpFloat9);
            }
            t.setFrameTimelineVsync(Choreographer.getInstance().getVsyncId());
            t.apply();
            t.close();
        }
    };

    public InsetsAnimationThreadControlRunner(SparseArray<InsetsSourceControl> controls, @Nullable Rect frame, @Nullable Rect bounds, InsetsState state, WindowInsetsAnimationControlListener listener, int types, InsetsAnimationControlCallbacks controller, InsetsAnimationSpec insetsAnimationSpec, int animationType, int layoutInsetsDuringAnimation, CompatibilityInfo.Translator translator, Handler mainThreadHandler, @Nullable ImeTracker.Token statsToken) {
        this.mMainThreadHandler = mainThreadHandler;
        this.mOuterCallbacks = controller;
        this.mControl = new InsetsAnimationControlImpl(controls, frame, bounds, state, listener, types, this.mCallbacks, this.mSurfaceParamsApplier, insetsAnimationSpec, animationType, layoutInsetsDuringAnimation, translator, statsToken);
        InsetsAnimationThread.getHandler().post(() -> {
            if (this.mControl.isCancelled()) {
                return;
            }
            Trace.asyncTraceBegin(8L, "InsetsAsyncAnimation: " + WindowInsets.Type.toString(types), types);
            listener.onReady(this.mControl, types);
        });
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        this.mControl.dumpDebug(proto, fieldId);
    }

    @Override
    @Nullable
    public ImeTracker.Token getStatsToken() {
        return this.mControl.getStatsToken();
    }

    @Override
    public int getTypes() {
        return this.mControl.getTypes();
    }

    @Override
    public int getControllingTypes() {
        return this.mControl.getControllingTypes();
    }

    @Override
    public void notifyControlRevoked(int types) {
        this.mControl.notifyControlRevoked(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSurfacePosition(SparseArray<InsetsSourceControl> controls) {
        InsetsAnimationControlImpl insetsAnimationControlImpl = this.mControl;
        synchronized (insetsAnimationControlImpl) {
            this.mControl.updateSurfacePosition(controls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean willUpdateSurface() {
        InsetsAnimationControlImpl insetsAnimationControlImpl = this.mControl;
        synchronized (insetsAnimationControlImpl) {
            return this.mControl.willUpdateSurface();
        }
    }

    @Override
    public void cancel() {
        InsetsAnimationThread.getHandler().post(this.mControl::cancel);
    }

    @Override
    public WindowInsetsAnimation getAnimation() {
        return this.mControl.getAnimation();
    }

    @Override
    public int getAnimationType() {
        return this.mControl.getAnimationType();
    }

    @Override
    public InsetsAnimationControlRunner.SurfaceParamsApplier getSurfaceParamsApplier() {
        return this.mSurfaceParamsApplier;
    }

    @Override
    public void updateLayoutInsetsDuringAnimation(int layoutInsetsDuringAnimation) {
        InsetsAnimationThread.getHandler().post(() -> this.mControl.updateLayoutInsetsDuringAnimation(layoutInsetsDuringAnimation));
    }
}

