/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.util.Size;
import android.view.InputApplicationHandle;
import android.view.SurfaceControl;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public class InputWindowHandle {
    private long ptr;
    public InputApplicationHandle inputApplicationHandle;
    public IBinder token;
    @Nullable
    private IBinder windowToken;
    public String name;
    public int layoutParamsFlags;
    public int layoutParamsType;
    public long dispatchingTimeoutMillis;
    public final Rect frame = new Rect();
    public Size contentSize = new Size(0, 0);
    public int surfaceInset;
    public float scaleFactor;
    public final Region touchableRegion = new Region();
    public int inputConfig;
    public int touchOcclusionMode = 0;
    public int ownerPid;
    public int ownerUid;
    public String packageName;
    public int displayId;
    public WeakReference<SurfaceControl> touchableRegionSurfaceControl = new WeakReference<Object>(null);
    public boolean replaceTouchableRegionWithCrop;
    public Matrix transform;
    public float alpha;
    public boolean canOccludePresentation;
    @Nullable
    public IBinder focusTransferTarget;

    private void nativeDispose() {
        OverrideMethod.invokeV("android.view.InputWindowHandle#nativeDispose()V", true, this);
    }

    public InputWindowHandle(InputApplicationHandle inputApplicationHandle, int displayId) {
        this.inputApplicationHandle = inputApplicationHandle;
        this.displayId = displayId;
    }

    public InputWindowHandle(InputWindowHandle other) {
        this.ptr = 0L;
        this.inputApplicationHandle = new InputApplicationHandle(other.inputApplicationHandle);
        this.token = other.token;
        this.windowToken = other.windowToken;
        this.name = other.name;
        this.layoutParamsFlags = other.layoutParamsFlags;
        this.layoutParamsType = other.layoutParamsType;
        this.dispatchingTimeoutMillis = other.dispatchingTimeoutMillis;
        this.frame.set(other.frame);
        this.surfaceInset = other.surfaceInset;
        this.scaleFactor = other.scaleFactor;
        this.touchableRegion.set(other.touchableRegion);
        this.inputConfig = other.inputConfig;
        this.touchOcclusionMode = other.touchOcclusionMode;
        this.ownerPid = other.ownerPid;
        this.ownerUid = other.ownerUid;
        this.packageName = other.packageName;
        this.displayId = other.displayId;
        this.touchableRegionSurfaceControl = other.touchableRegionSurfaceControl;
        this.replaceTouchableRegionWithCrop = other.replaceTouchableRegionWithCrop;
        if (other.transform != null) {
            this.transform = new Matrix();
            this.transform.set(other.transform);
        }
        this.focusTransferTarget = other.focusTransferTarget;
        this.contentSize = new Size(other.contentSize.getWidth(), other.contentSize.getHeight());
        this.alpha = other.alpha;
        this.canOccludePresentation = other.canOccludePresentation;
    }

    public String toString() {
        return (this.name != null ? this.name : "") + ", frame=[" + this.frame + "]" + ", touchableRegion=" + this.touchableRegion + ", scaleFactor=" + this.scaleFactor + ", transform=" + this.transform + ", windowToken=" + this.windowToken + ", displayId=" + this.displayId + ", isClone=" + ((this.inputConfig & 0x10000) != 0) + ", contentSize=" + this.contentSize + ", alpha=" + this.alpha + ", canOccludePresentation=" + this.canOccludePresentation;
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDispose();
        }
        finally {
            super.finalize();
        }
    }

    public void replaceTouchableRegionWithCrop(@Nullable SurfaceControl bounds) {
        this.setTouchableRegionCrop(bounds);
        this.replaceTouchableRegionWithCrop = true;
    }

    public void setTouchableRegionCrop(@Nullable SurfaceControl bounds) {
        this.touchableRegionSurfaceControl = new WeakReference<SurfaceControl>(bounds);
    }

    public void setTouchableRegion(Rect rect) {
        this.touchableRegion.set(rect);
    }

    public void setWindowToken(IBinder iwindow) {
        this.windowToken = iwindow;
    }

    @Nullable
    public IBinder getWindowToken() {
        return this.windowToken;
    }

    public void setInputConfig(int inputConfig, boolean value) {
        if (value) {
            this.inputConfig |= inputConfig;
            return;
        }
        this.inputConfig &= ~inputConfig;
    }

    public void setTrustedOverlay(SurfaceControl.Transaction t, SurfaceControl sc, boolean isTrusted) {
        if (Flags.surfaceTrustedOverlay()) {
            t.setTrustedOverlay(sc, isTrusted);
        } else if (isTrusted) {
            this.inputConfig |= 0x100;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InputConfigFlags {
    }
}

