/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.graphics.Rect;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Gravity {
    public static final int NO_GRAVITY = 0;
    public static final int AXIS_SPECIFIED = 1;
    public static final int AXIS_PULL_BEFORE = 2;
    public static final int AXIS_PULL_AFTER = 4;
    public static final int AXIS_CLIP = 8;
    public static final int AXIS_X_SHIFT = 0;
    public static final int AXIS_Y_SHIFT = 4;
    public static final int TOP = 48;
    public static final int BOTTOM = 80;
    public static final int LEFT = 3;
    public static final int RIGHT = 5;
    public static final int CENTER_VERTICAL = 16;
    public static final int FILL_VERTICAL = 112;
    public static final int CENTER_HORIZONTAL = 1;
    public static final int FILL_HORIZONTAL = 7;
    public static final int CENTER = 17;
    public static final int FILL = 119;
    public static final int CLIP_VERTICAL = 128;
    public static final int CLIP_HORIZONTAL = 8;
    public static final int RELATIVE_LAYOUT_DIRECTION = 0x800000;
    public static final int HORIZONTAL_GRAVITY_MASK = 7;
    public static final int VERTICAL_GRAVITY_MASK = 112;
    public static final int DISPLAY_CLIP_VERTICAL = 0x10000000;
    public static final int DISPLAY_CLIP_HORIZONTAL = 0x1000000;
    public static final int START = 0x800003;
    public static final int END = 0x800005;
    public static final int RELATIVE_HORIZONTAL_GRAVITY_MASK = 0x800007;

    public static void apply(int gravity, int w, int h, Rect container, Rect outRect) {
        Gravity.apply(gravity, w, h, container, 0, 0, outRect);
    }

    public static void apply(int gravity, int w, int h, @NonNull Rect container, @NonNull Rect outRect, int layoutDirection) {
        int absGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
        Gravity.apply(absGravity, w, h, container, 0, 0, outRect);
    }

    public static void apply(int gravity, int w, int h, @NonNull Rect container, int xAdj, int yAdj, @NonNull Rect outRect) {
        switch (gravity & 6) {
            case 0: {
                outRect.left = container.left + (container.right - container.left - w) / 2 + xAdj;
                outRect.right = outRect.left + w;
                if ((gravity & 8) != 8) break;
                if (outRect.left < container.left) {
                    outRect.left = container.left;
                }
                if (outRect.right <= container.right) break;
                outRect.right = container.right;
                break;
            }
            case 2: {
                outRect.left = container.left + xAdj;
                outRect.right = outRect.left + w;
                if ((gravity & 8) != 8 || outRect.right <= container.right) break;
                outRect.right = container.right;
                break;
            }
            case 4: {
                outRect.right = container.right - xAdj;
                outRect.left = outRect.right - w;
                if ((gravity & 8) != 8 || outRect.left >= container.left) break;
                outRect.left = container.left;
                break;
            }
            default: {
                outRect.left = container.left + xAdj;
                outRect.right = container.right + xAdj;
            }
        }
        switch (gravity & 0x60) {
            case 0: {
                outRect.top = container.top + (container.bottom - container.top - h) / 2 + yAdj;
                outRect.bottom = outRect.top + h;
                if ((gravity & 0x80) != 128) break;
                if (outRect.top < container.top) {
                    outRect.top = container.top;
                }
                if (outRect.bottom <= container.bottom) break;
                outRect.bottom = container.bottom;
                break;
            }
            case 32: {
                outRect.top = container.top + yAdj;
                outRect.bottom = outRect.top + h;
                if ((gravity & 0x80) != 128 || outRect.bottom <= container.bottom) break;
                outRect.bottom = container.bottom;
                break;
            }
            case 64: {
                outRect.bottom = container.bottom - yAdj;
                outRect.top = outRect.bottom - h;
                if ((gravity & 0x80) != 128 || outRect.top >= container.top) break;
                outRect.top = container.top;
                break;
            }
            default: {
                outRect.top = container.top + yAdj;
                outRect.bottom = container.bottom + yAdj;
            }
        }
    }

    public static void apply(int gravity, int w, int h, @NonNull Rect container, int xAdj, int yAdj, @NonNull Rect outRect, int layoutDirection) {
        int absGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
        Gravity.apply(absGravity, w, h, container, xAdj, yAdj, outRect);
    }

    public static void applyDisplay(int gravity, @NonNull Rect display, @NonNull Rect inoutObj) {
        int off;
        if ((gravity & 0x10000000) != 0) {
            if (inoutObj.top < display.top) {
                inoutObj.top = display.top;
            }
            if (inoutObj.bottom > display.bottom) {
                inoutObj.bottom = display.bottom;
            }
        } else {
            off = 0;
            if (inoutObj.top < display.top) {
                off = display.top - inoutObj.top;
            } else if (inoutObj.bottom > display.bottom) {
                off = display.bottom - inoutObj.bottom;
            }
            if (off != 0) {
                if (inoutObj.height() > display.bottom - display.top) {
                    inoutObj.top = display.top;
                    inoutObj.bottom = display.bottom;
                } else {
                    inoutObj.top += off;
                    inoutObj.bottom += off;
                }
            }
        }
        if ((gravity & 0x1000000) != 0) {
            if (inoutObj.left < display.left) {
                inoutObj.left = display.left;
            }
            if (inoutObj.right > display.right) {
                inoutObj.right = display.right;
            }
        } else {
            off = 0;
            if (inoutObj.left < display.left) {
                off = display.left - inoutObj.left;
            } else if (inoutObj.right > display.right) {
                off = display.right - inoutObj.right;
            }
            if (off != 0) {
                if (inoutObj.width() > display.right - display.left) {
                    inoutObj.left = display.left;
                    inoutObj.right = display.right;
                } else {
                    inoutObj.left += off;
                    inoutObj.right += off;
                }
            }
        }
    }

    public static void applyDisplay(int gravity, @NonNull Rect display, @NonNull Rect inoutObj, int layoutDirection) {
        int absGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
        Gravity.applyDisplay(absGravity, display, inoutObj);
    }

    public static boolean isVertical(int gravity) {
        return gravity > 0 && (gravity & 0x70) != 0;
    }

    public static boolean isHorizontal(int gravity) {
        return gravity > 0 && (gravity & 0x800007) != 0;
    }

    public static int getAbsoluteGravity(int gravity, int layoutDirection) {
        int result = gravity;
        if ((result & 0x800000) > 0) {
            if ((result & 0x800003) == 0x800003) {
                result &= 0xFF7FFFFC;
                result = layoutDirection == 1 ? (result |= 5) : (result |= 3);
            } else if ((result & 0x800005) == 0x800005) {
                result &= 0xFF7FFFFA;
                result = layoutDirection == 1 ? (result |= 3) : (result |= 5);
            }
            result &= 0xFF7FFFFF;
        }
        return result;
    }

    public static String toString(int gravity) {
        StringBuilder result = new StringBuilder();
        if ((gravity & 0x77) == 119) {
            result.append("FILL").append(' ');
        } else {
            if ((gravity & 0x70) == 112) {
                result.append("FILL_VERTICAL").append(' ');
            } else {
                if ((gravity & 0x30) == 48) {
                    result.append("TOP").append(' ');
                }
                if ((gravity & 0x50) == 80) {
                    result.append("BOTTOM").append(' ');
                }
            }
            if ((gravity & 7) == 7) {
                result.append("FILL_HORIZONTAL").append(' ');
            } else {
                if ((gravity & 0x800003) == 0x800003) {
                    result.append("START").append(' ');
                } else if ((gravity & 3) == 3) {
                    result.append("LEFT").append(' ');
                }
                if ((gravity & 0x800005) == 0x800005) {
                    result.append("END").append(' ');
                } else if ((gravity & 5) == 5) {
                    result.append("RIGHT").append(' ');
                }
            }
        }
        if ((gravity & 0x11) == 17) {
            result.append("CENTER").append(' ');
        } else {
            if ((gravity & 0x10) == 16) {
                result.append("CENTER_VERTICAL").append(' ');
            }
            if ((gravity & 1) == 1) {
                result.append("CENTER_HORIZONTAL").append(' ');
            }
        }
        if (result.length() == 0) {
            result.append("NO GRAVITY").append(' ');
        }
        if ((gravity & 0x10000000) == 0x10000000) {
            result.append("DISPLAY_CLIP_VERTICAL").append(' ');
        }
        if ((gravity & 0x1000000) == 0x1000000) {
            result.append("DISPLAY_CLIP_HORIZONTAL").append(' ');
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityFlags {
    }
}

