/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.Choreographer;
import android.view.DisplayEventReceiver;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Optional;

public class Choreographer_Delegate {
    private static DisplayEventReceiver.VsyncEventData sVsyncEventData;
    public static long sChoreographerTime;

    @LayoutlibDelegate
    public static float getRefreshRate() {
        return 60.0f;
    }

    @LayoutlibDelegate
    public static void postCallbackDelayedInternal(Choreographer thiz, int callbackType, Object action, Object token, long delayMillis) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            if (!Thread.currentThread().getName().equals("kotlinx.coroutines.DefaultExecutor")) {
                return;
            }
            ClassLoader moduleClassLoader = Choreographer_Delegate.findCallingClassLoader();
            if (moduleClassLoader == null) {
                return;
            }
            context = RenderAction.findContextFor(moduleClassLoader);
            if (context == null) {
                return;
            }
        }
        if (callbackType != 1) {
            return;
        }
        if (action == null) {
            Bridge.getLog().error("broken", "Callback with null action", null, null);
        }
        context.getSessionInteractiveData().getChoreographerCallbacks().add(action, token, delayMillis);
    }

    @LayoutlibDelegate
    public static void removeCallbacksInternal(Choreographer thiz, int callbackType, Object action, Object token) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            return;
        }
        if (callbackType != 1) {
            return;
        }
        context.getSessionInteractiveData().getChoreographerCallbacks().remove(action, token);
    }

    @LayoutlibDelegate
    public static void doCallbacks(Choreographer thiz, int callbackType, long frameIntervalNanos) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context == null) {
            return;
        }
        if (callbackType != 1) {
            return;
        }
        thiz.mCallbacksRunning = true;
        context.getSessionInteractiveData().getChoreographerCallbacks().execute(System_Delegate.nanoTime(), Bridge.getLog());
        thiz.mCallbacksRunning = false;
    }

    private static ClassLoader findCallingClassLoader() {
        ClassLoader current = Choreographer_Delegate.class.getClassLoader();
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        try {
            return walker.walk(stackFrameStream -> {
                Optional<StackWalker.StackFrame> stackFrame = stackFrameStream.filter(sf -> sf.getDeclaringClass().getClassLoader() != current).findFirst();
                return stackFrame.map(f -> f.getDeclaringClass().getClassLoader()).orElse(null);
            });
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static void doFrame(long frameTimeNanos) {
        if (sVsyncEventData == null) {
            sVsyncEventData = new DisplayEventReceiver.VsyncEventData();
            Choreographer_Delegate.sVsyncEventData.frameTimelinesLength = 1;
        }
        Choreographer choreographer = Choreographer.getInstance();
        choreographer.mFrameScheduled = true;
        choreographer.doFrame(frameTimeNanos, 0, sVsyncEventData);
        sChoreographerTime = frameTimeNanos;
    }

    static {
        sChoreographerTime = 0L;
    }
}

