/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Insets;
import android.util.Pair;
import android.view.Display;
import android.view.IWindowSession;
import android.view.InsetsController;
import android.view.LayoutlibRenderer;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowLayout;
import android.view.WindowManagerImpl;
import com.android.layoutlib.bridge.impl.Layout;
import com.android.layoutlib.bridge.util.InsetUtil;

public class AttachInfo_Accessor {
    private static final Window.OnContentApplyWindowInsetsListener sDefaultContentInsetsApplier = (view, insets) -> {
        if ((view.getWindowSystemUiVisibility() & 0x600) != 0) {
            return new Pair<Insets, WindowInsets>(Insets.NONE, insets);
        }
        Insets insetsToApply = insets.getSystemWindowInsets();
        return new Pair<Insets, WindowInsets>(insetsToApply, insets.inset(insetsToApply).consumeSystemWindowInsets());
    };

    public static LayoutlibRenderer setAttachInfo(ViewGroup view) {
        Context context = view.getContext();
        WindowManagerImpl wm = (WindowManagerImpl)context.getSystemService("window");
        wm.setBaseRootView(view);
        Display display = wm.getDefaultDisplay();
        ViewRootImpl root = new ViewRootImpl(context, display, new IWindowSession.Default(), new WindowLayout());
        root.setOnContentApplyWindowInsetsListener(sDefaultContentInsetsApplier);
        LayoutlibRenderer renderer = new LayoutlibRenderer(context, false, "layoutlib-renderer");
        View.AttachInfo info = root.mAttachInfo;
        info.mThreadedRenderer = renderer.getThreadedRenderer();
        info.mHasWindowFocus = true;
        info.mWindowVisibility = 0;
        info.mInTouchMode = false;
        info.mHardwareAccelerated = true;
        info.mApplicationScale = 1.0f;
        ViewRootImpl_Accessor.setChild(root, view);
        view.assignParent(root);
        if (view instanceof Layout) {
            InsetsController insetsController = root.getInsetsController();
            wm.createOrUpdateDisplayFrames(insetsController.getState());
            InsetUtil.setupSysUiInsets(context, insetsController, ((Layout)view).getInsetsFrameProviders());
        }
        view.dispatchAttachedToWindow(info, 0);
        root.mTmpFrames.displayFrame.set(wm.getCurrentWindowMetrics().getBounds());
        return renderer;
    }

    public static void dispatchOnPreDraw(View view) {
        view.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
    }

    public static void dispatchOnGlobalLayout(View view) {
        view.mAttachInfo.mTreeObserver.dispatchOnGlobalLayout();
    }

    public static void detachFromWindow(View view) {
        if (view != null) {
            View.AttachInfo attachInfo = view.mAttachInfo;
            view.dispatchDetachedFromWindow();
            if (attachInfo != null) {
                ThreadedRenderer rootRenderer;
                ViewRootImpl_Accessor.detachFromWindow(attachInfo.mViewRootImpl);
                ThreadedRenderer threadedRenderer = attachInfo.mThreadedRenderer;
                if (threadedRenderer != null) {
                    threadedRenderer.destroy();
                }
                if ((rootRenderer = attachInfo.mViewRootImpl.mAttachInfo.mThreadedRenderer) != null) {
                    rootRenderer.destroy();
                }
            }
        }
    }

    public static ViewRootImpl getRootView(View view) {
        return view.mAttachInfo != null ? view.mAttachInfo.mViewRootImpl : null;
    }
}

