/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.uwb.AngleOfArrivalMeasurement;
import android.uwb.DistanceMeasurement;
import android.uwb.UwbAddress;
import android.uwb.util.PersistableBundleUtils;
import com.android.x.uwb.com.android.uwb.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class RangingMeasurement
implements Parcelable {
    public static final int RSSI_UNKNOWN = -128;
    public static final int RSSI_MIN = -127;
    public static final int RSSI_MAX = -1;
    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
    public static final int NON_HYBRID_UWB_SESSION_ID = 0;
    private final UwbAddress mRemoteDeviceAddress;
    private final int mStatus;
    private final long mElapsedRealtimeNanos;
    private final DistanceMeasurement mDistanceMeasurement;
    private final AngleOfArrivalMeasurement mAngleOfArrivalMeasurement;
    private final AngleOfArrivalMeasurement mDestinationAngleOfArrivalMeasurement;
    private final int mLineOfSight;
    private final int mMeasurementFocus;
    private final int mRssiDbm;
    private final long mHusPrimarySessionId;
    private final PersistableBundle mRangingMeasurementMetadata;
    public static final int RANGING_STATUS_SUCCESS = 0;
    public static final int RANGING_STATUS_FAILURE_OUT_OF_RANGE = 1;
    public static final int RANGING_STATUS_FAILURE_UNKNOWN_ERROR = -1;
    public static final int LOS = 0;
    public static final int NLOS = 1;
    public static final int LOS_UNDETERMINED = 255;
    public static final int MEASUREMENT_FOCUS_NONE = 0;
    public static final int MEASUREMENT_FOCUS_RANGE = 1;
    public static final int MEASUREMENT_FOCUS_ANGLE_OF_ARRIVAL_AZIMUTH = 2;
    public static final int MEASUREMENT_FOCUS_ANGLE_OF_ARRIVAL_ELEVATION = 3;
    @NonNull
    public static final Parcelable.Creator<RangingMeasurement> CREATOR = new Parcelable.Creator<RangingMeasurement>(){

        @Override
        public RangingMeasurement createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setRemoteDeviceAddress((UwbAddress)in.readParcelable(UwbAddress.class.getClassLoader()));
            builder.setStatus(in.readInt());
            builder.setElapsedRealtimeNanos(in.readLong());
            builder.setDistanceMeasurement((DistanceMeasurement)in.readParcelable(DistanceMeasurement.class.getClassLoader()));
            builder.setAngleOfArrivalMeasurement((AngleOfArrivalMeasurement)in.readParcelable(AngleOfArrivalMeasurement.class.getClassLoader()));
            builder.setDestinationAngleOfArrivalMeasurement((AngleOfArrivalMeasurement)in.readParcelable(AngleOfArrivalMeasurement.class.getClassLoader()));
            builder.setLineOfSight(in.readInt());
            builder.setMeasurementFocus(in.readInt());
            builder.setRssiDbm(in.readInt());
            builder.setHusPrimarySessionId(in.readLong());
            PersistableBundle metadata = in.readPersistableBundle(this.getClass().getClassLoader());
            if (metadata != null) {
                builder.setRangingMeasurementMetadata(metadata);
            }
            return builder.build();
        }

        public RangingMeasurement[] newArray(int size) {
            return new RangingMeasurement[size];
        }
    };

    private RangingMeasurement(@NonNull UwbAddress remoteDeviceAddress, int status, long elapsedRealtimeNanos, @Nullable DistanceMeasurement distanceMeasurement, @Nullable AngleOfArrivalMeasurement angleOfArrivalMeasurement, @Nullable AngleOfArrivalMeasurement destinationAngleOfArrivalMeasurement, int lineOfSight, int measurementFocus, int rssiDbm, long husPrimarySessionId, PersistableBundle rangingMeasurementMetadata) {
        this.mRemoteDeviceAddress = remoteDeviceAddress;
        this.mStatus = status;
        this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
        this.mDistanceMeasurement = distanceMeasurement;
        this.mAngleOfArrivalMeasurement = angleOfArrivalMeasurement;
        this.mDestinationAngleOfArrivalMeasurement = destinationAngleOfArrivalMeasurement;
        this.mLineOfSight = lineOfSight;
        this.mMeasurementFocus = measurementFocus;
        this.mRssiDbm = rssiDbm;
        this.mHusPrimarySessionId = husPrimarySessionId;
        this.mRangingMeasurementMetadata = rangingMeasurementMetadata;
    }

    @NonNull
    public UwbAddress getRemoteDeviceAddress() {
        return this.mRemoteDeviceAddress;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    @Nullable
    public DistanceMeasurement getDistanceMeasurement() {
        return this.mDistanceMeasurement;
    }

    @Nullable
    public AngleOfArrivalMeasurement getAngleOfArrivalMeasurement() {
        return this.mAngleOfArrivalMeasurement;
    }

    @Nullable
    public AngleOfArrivalMeasurement getDestinationAngleOfArrivalMeasurement() {
        return this.mDestinationAngleOfArrivalMeasurement;
    }

    public int getLineOfSight() {
        return this.mLineOfSight;
    }

    public int getRssiDbm() {
        return this.mRssiDbm;
    }

    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
    public long getHusPrimarySessionId() {
        return this.mHusPrimarySessionId;
    }

    public int getMeasurementFocus() {
        return this.mMeasurementFocus;
    }

    @NonNull
    public PersistableBundle getRangingMeasurementMetadata() {
        return this.mRangingMeasurementMetadata;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RangingMeasurement) {
            RangingMeasurement other = (RangingMeasurement)obj;
            boolean isHusPrimarySessionIdEqual = !Flags.uwbFira3025q4() || this.mHusPrimarySessionId == other.getHusPrimarySessionId();
            return Objects.equals(this.mRemoteDeviceAddress, other.getRemoteDeviceAddress()) && this.mStatus == other.getStatus() && this.mElapsedRealtimeNanos == other.getElapsedRealtimeNanos() && Objects.equals(this.mDistanceMeasurement, other.getDistanceMeasurement()) && Objects.equals(this.mAngleOfArrivalMeasurement, other.getAngleOfArrivalMeasurement()) && Objects.equals(this.mDestinationAngleOfArrivalMeasurement, other.getDestinationAngleOfArrivalMeasurement()) && this.mLineOfSight == other.getLineOfSight() && this.mMeasurementFocus == other.getMeasurementFocus() && this.mRssiDbm == other.getRssiDbm() && isHusPrimarySessionIdEqual && PersistableBundleUtils.isEqual(this.mRangingMeasurementMetadata, other.mRangingMeasurementMetadata);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mRemoteDeviceAddress, this.mStatus, this.mElapsedRealtimeNanos, this.mDistanceMeasurement, this.mAngleOfArrivalMeasurement, this.mDestinationAngleOfArrivalMeasurement, this.mLineOfSight, this.mMeasurementFocus, this.mRssiDbm, this.mHusPrimarySessionId, PersistableBundleUtils.getHashCode(this.mRangingMeasurementMetadata));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mRemoteDeviceAddress, flags);
        dest.writeInt(this.mStatus);
        dest.writeLong(this.mElapsedRealtimeNanos);
        dest.writeParcelable(this.mDistanceMeasurement, flags);
        dest.writeParcelable(this.mAngleOfArrivalMeasurement, flags);
        dest.writeParcelable(this.mDestinationAngleOfArrivalMeasurement, flags);
        dest.writeInt(this.mLineOfSight);
        dest.writeInt(this.mMeasurementFocus);
        dest.writeInt(this.mRssiDbm);
        dest.writeLong(this.mHusPrimarySessionId);
        dest.writePersistableBundle(this.mRangingMeasurementMetadata);
    }

    public String toString() {
        return "RangingMeasurement[remote device address:" + this.mRemoteDeviceAddress + ", distance measurement: " + this.mDistanceMeasurement + ", aoa measurement: " + this.mAngleOfArrivalMeasurement + ", dest aoa measurement: " + this.mDestinationAngleOfArrivalMeasurement + ", lineOfSight: " + this.mLineOfSight + ", measurementFocus: " + this.mMeasurementFocus + ", rssiDbm: " + this.mRssiDbm + ", husPrimarySessionId: " + this.mHusPrimarySessionId + ", ranging measurement metadata: " + this.mRangingMeasurementMetadata + ", elapsed real time nanos: " + this.mElapsedRealtimeNanos + ", status: " + this.mStatus + "]";
    }

    public static class Builder {
        private UwbAddress mRemoteDeviceAddress = null;
        private int mStatus = -1;
        private long mElapsedRealtimeNanos = -1L;
        private DistanceMeasurement mDistanceMeasurement = null;
        private AngleOfArrivalMeasurement mAngleOfArrivalMeasurement = null;
        private AngleOfArrivalMeasurement mDestinationAngleOfArrivalMeasurement = null;
        private int mLineOfSight = 255;
        private int mMeasurementFocus = 0;
        private int mRssiDbm = -128;
        private long mHusPrimarySessionId = 0L;
        private PersistableBundle mRangingMeasurementMetadata = null;

        @NonNull
        public Builder setRemoteDeviceAddress(@NonNull UwbAddress remoteDeviceAddress) {
            this.mRemoteDeviceAddress = remoteDeviceAddress;
            return this;
        }

        @NonNull
        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        public Builder setElapsedRealtimeNanos(long elapsedRealtimeNanos) {
            if (elapsedRealtimeNanos < 0L) {
                throw new IllegalArgumentException("elapsedRealtimeNanos must be >= 0");
            }
            this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
            return this;
        }

        @NonNull
        public Builder setDistanceMeasurement(@NonNull DistanceMeasurement distanceMeasurement) {
            this.mDistanceMeasurement = distanceMeasurement;
            return this;
        }

        @NonNull
        public Builder setAngleOfArrivalMeasurement(@NonNull AngleOfArrivalMeasurement angleOfArrivalMeasurement) {
            this.mAngleOfArrivalMeasurement = angleOfArrivalMeasurement;
            return this;
        }

        @NonNull
        public Builder setDestinationAngleOfArrivalMeasurement(@NonNull AngleOfArrivalMeasurement angleOfArrivalMeasurement) {
            this.mDestinationAngleOfArrivalMeasurement = angleOfArrivalMeasurement;
            return this;
        }

        @NonNull
        public Builder setLineOfSight(int lineOfSight) {
            this.mLineOfSight = lineOfSight;
            return this;
        }

        @NonNull
        public Builder setMeasurementFocus(int measurementFocus) {
            this.mMeasurementFocus = measurementFocus;
            return this;
        }

        @NonNull
        public Builder setRssiDbm(int rssiDbm) {
            if (rssiDbm != -128 && (rssiDbm < -127 || rssiDbm > -1)) {
                throw new IllegalArgumentException("Invalid rssiDbm: " + rssiDbm);
            }
            this.mRssiDbm = rssiDbm;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
        public Builder setHusPrimarySessionId(long husPrimarySessionId) {
            this.mHusPrimarySessionId = husPrimarySessionId;
            return this;
        }

        @NonNull
        public Builder setRangingMeasurementMetadata(@NonNull PersistableBundle rangingMeasurementMetadata) {
            if (rangingMeasurementMetadata == null) {
                throw new IllegalStateException("Expected non-null rangingMeasurementMetadata");
            }
            this.mRangingMeasurementMetadata = rangingMeasurementMetadata;
            return this;
        }

        @NonNull
        public RangingMeasurement build() {
            if (this.mStatus != 0) {
                if (this.mDistanceMeasurement != null) {
                    throw new IllegalStateException("Distance Measurement must be null if ranging is not successful");
                }
                if (this.mAngleOfArrivalMeasurement != null) {
                    throw new IllegalStateException("Angle of Arrival must be null if ranging is not successful");
                }
            }
            if (this.mRemoteDeviceAddress == null) {
                throw new IllegalStateException("No remote device address was set");
            }
            if (this.mElapsedRealtimeNanos < 0L) {
                throw new IllegalStateException("elapsedRealtimeNanos must be >=0: " + this.mElapsedRealtimeNanos);
            }
            return new RangingMeasurement(this.mRemoteDeviceAddress, this.mStatus, this.mElapsedRealtimeNanos, this.mDistanceMeasurement, this.mAngleOfArrivalMeasurement, this.mDestinationAngleOfArrivalMeasurement, this.mLineOfSight, this.mMeasurementFocus, this.mRssiDbm, this.mHusPrimarySessionId, this.mRangingMeasurementMetadata);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasurementFocus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineOfSight {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

