/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
public class LogicalLinkConnectionParams
implements Parcelable {
    public static final int CONTROL_FIELD_MAX_LL_SDU_SIZE = 1;
    public static final int CONTROL_FIELD_MAX_LL_PDU_SIZE = 2;
    public static final int CONTROL_FIELD_TRANSMIT_WINDOW_SIZE = 4;
    public static final int CONTROL_FIELD_RECEIVE_WINDOW_SIZE = 8;
    public static final int CONTROL_FIELD_REPEAT_COUNT_MAX = 16;
    public static final int CONTROL_FIELD_LINK_TIMEOUT = 32;
    public static final int CONTROL_FIELD_PORT = 64;
    private final int mStatus;
    private final int mControlField;
    private final int mMaxLinkLayerSduSize;
    private final int mMaxLinkLayerPduSize;
    private final int mTransmitWindowSize;
    private final int mReceiveWindowSize;
    private final int mRepeatCountMax;
    private final int mLinkTimeout;
    private final int mDestinationPort;
    private final int mSourcePort;
    @NonNull
    public static final Parcelable.Creator<LogicalLinkConnectionParams> CREATOR = new Parcelable.Creator<LogicalLinkConnectionParams>(){

        @Override
        public LogicalLinkConnectionParams createFromParcel(Parcel in) {
            Builder builder = new Builder(in.readInt(), in.readInt());
            builder.setMaxLinkLayerSduSize(in.readInt());
            builder.setMaxLinkLayerPduSize(in.readInt());
            builder.setTransmitWindowSize(in.readInt());
            builder.setReceiveWindowSize(in.readInt());
            builder.setRepeatCountMax(in.readInt());
            builder.setLinkTimeout(in.readInt());
            builder.setDestinationPort(in.readInt());
            builder.setSourcePort(in.readInt());
            return builder.build();
        }

        public LogicalLinkConnectionParams[] newArray(int size) {
            return new LogicalLinkConnectionParams[size];
        }
    };

    private LogicalLinkConnectionParams(Builder builder) {
        this.mStatus = builder.mStatus;
        this.mControlField = builder.mControlField;
        this.mMaxLinkLayerSduSize = builder.mMaxLinkLayerSduSize;
        this.mMaxLinkLayerPduSize = builder.mMaxLinkLayerPduSize;
        this.mTransmitWindowSize = builder.mTransmitWindowSize;
        this.mReceiveWindowSize = builder.mReceiveWindowSize;
        this.mRepeatCountMax = builder.mRepeatCountMax;
        this.mLinkTimeout = builder.mLinkTimeout;
        this.mDestinationPort = builder.mDestinationPort;
        this.mSourcePort = builder.mSourcePort;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public boolean hasMaxLinkLayerSduSize() {
        return (this.mControlField & 1) != 0;
    }

    public int getMaxLinkLayerSduSize() {
        return this.mMaxLinkLayerSduSize;
    }

    public boolean hasMaxLinkLayerPduSize() {
        return (this.mControlField & 2) != 0;
    }

    public int getMaxLinkLayerPduSize() {
        return this.mMaxLinkLayerPduSize;
    }

    public boolean hasTransmitWindowSize() {
        return (this.mControlField & 4) != 0;
    }

    public int getTransmitWindowSize() {
        return this.mTransmitWindowSize;
    }

    public boolean hasReceiveWindowSize() {
        return (this.mControlField & 8) != 0;
    }

    public int getReceiveWindowSize() {
        return this.mReceiveWindowSize;
    }

    public boolean hasRepeatCountMax() {
        return (this.mControlField & 0x10) != 0;
    }

    public int getRepeatCountMax() {
        return this.mRepeatCountMax;
    }

    public boolean hasLinkTimeout() {
        return (this.mControlField & 0x20) != 0;
    }

    public int getLinkTimeout() {
        return this.mLinkTimeout;
    }

    public boolean hasDestinationPort() {
        return (this.mControlField & 0x40) != 0;
    }

    public int getDestinationPort() {
        return this.mDestinationPort;
    }

    public boolean hasSourcePort() {
        return (this.mControlField & 0x40) != 0;
    }

    public int getSourcePort() {
        return this.mSourcePort;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        dest.writeInt(this.mControlField);
        dest.writeInt(this.mMaxLinkLayerSduSize);
        dest.writeInt(this.mMaxLinkLayerPduSize);
        dest.writeInt(this.mTransmitWindowSize);
        dest.writeInt(this.mReceiveWindowSize);
        dest.writeInt(this.mRepeatCountMax);
        dest.writeInt(this.mLinkTimeout);
        dest.writeInt(this.mDestinationPort);
        dest.writeInt(this.mSourcePort);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogicalLinkConnectionParams)) {
            return false;
        }
        LogicalLinkConnectionParams other = (LogicalLinkConnectionParams)obj;
        return this.mStatus == other.mStatus && this.mControlField == other.mControlField && this.mMaxLinkLayerSduSize == other.mMaxLinkLayerSduSize && this.mMaxLinkLayerPduSize == other.mMaxLinkLayerPduSize && this.mTransmitWindowSize == other.mTransmitWindowSize && this.mReceiveWindowSize == other.mReceiveWindowSize && this.mRepeatCountMax == other.mRepeatCountMax && this.mLinkTimeout == other.mLinkTimeout && this.mDestinationPort == other.mDestinationPort && this.mSourcePort == other.mSourcePort;
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mControlField, this.mMaxLinkLayerSduSize, this.mMaxLinkLayerPduSize, this.mTransmitWindowSize, this.mReceiveWindowSize, this.mRepeatCountMax, this.mLinkTimeout, this.mDestinationPort, this.mSourcePort);
    }

    public String toString() {
        return "LogicalLinkConnectionParams{status=" + this.mStatus + ", controlField=" + this.mControlField + ", maxLinkLayerSduSize=" + this.mMaxLinkLayerSduSize + ", maxLinkLayerPduSize=" + this.mMaxLinkLayerPduSize + ", transmitWindowSize=" + this.mTransmitWindowSize + ", receiveWindowSize=" + this.mReceiveWindowSize + ", repeatCountMax=" + this.mRepeatCountMax + ", linkTimeout=" + this.mLinkTimeout + ", destinationPort=" + this.mDestinationPort + ", sourcePort=" + this.mSourcePort + '}';
    }

    public static class Builder {
        private final int mStatus;
        private final int mControlField;
        private int mMaxLinkLayerSduSize;
        private int mMaxLinkLayerPduSize;
        private int mTransmitWindowSize;
        private int mReceiveWindowSize;
        private int mRepeatCountMax;
        private int mLinkTimeout;
        private int mDestinationPort;
        private int mSourcePort;

        public Builder(int status, int controlField) {
            this.mStatus = status;
            this.mControlField = controlField;
        }

        @NonNull
        public Builder setMaxLinkLayerSduSize(int value) {
            this.mMaxLinkLayerSduSize = value;
            return this;
        }

        @NonNull
        public Builder setMaxLinkLayerPduSize(int value) {
            this.mMaxLinkLayerPduSize = value;
            return this;
        }

        @NonNull
        public Builder setTransmitWindowSize(int value) {
            this.mTransmitWindowSize = value;
            return this;
        }

        @NonNull
        public Builder setReceiveWindowSize(int value) {
            this.mReceiveWindowSize = value;
            return this;
        }

        @NonNull
        public Builder setRepeatCountMax(int value) {
            this.mRepeatCountMax = value;
            return this;
        }

        @NonNull
        public Builder setLinkTimeout(int value) {
            this.mLinkTimeout = value;
            return this;
        }

        @NonNull
        public Builder setDestinationPort(int value) {
            this.mDestinationPort = value;
            return this;
        }

        @NonNull
        public Builder setSourcePort(int value) {
            this.mSourcePort = value;
            return this;
        }

        @NonNull
        public LogicalLinkConnectionParams build() {
            return new LogicalLinkConnectionParams(this);
        }
    }

    public static @interface ControlField {
    }
}

