/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoStream;
import java.io.IOException;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class ProtoUtils {
    public static void toAggStatsProto(ProtoOutputStream proto, long fieldId, long min, long average, long max, int meanKb, int maxKb) {
        long aggStatsToken = proto.start(fieldId);
        proto.write(0x10300000001L, min);
        proto.write(1112396529666L, average);
        proto.write(0x10300000003L, max);
        proto.write(1120986464260L, meanKb);
        proto.write(0x10500000005L, maxKb);
        proto.end(aggStatsToken);
    }

    public static void toAggStatsProto(ProtoOutputStream proto, long fieldId, long min, long average, long max) {
        ProtoUtils.toAggStatsProto(proto, fieldId, min, average, max, 0, 0);
    }

    public static void toDuration(ProtoOutputStream proto, long fieldId, long startMs, long endMs) {
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, startMs);
        proto.write(1112396529666L, endMs);
        proto.end(token);
    }

    public static void writeBitWiseFlagsToProtoEnum(ProtoOutputStream proto, long fieldId, long flags, int[] origEnums, int[] protoEnums) {
        if (protoEnums.length != origEnums.length) {
            throw new IllegalArgumentException("The length of origEnums must match protoEnums");
        }
        int len = origEnums.length;
        for (int i = 0; i < len; ++i) {
            if (origEnums[i] == 0 && flags == 0L) {
                proto.write(fieldId, protoEnums[i]);
                return;
            }
            if ((flags & (long)origEnums[i]) == 0L) continue;
            proto.write(fieldId, protoEnums[i]);
        }
    }

    public static String currentFieldToString(ProtoInputStream proto) throws IOException {
        StringBuilder sb = new StringBuilder();
        int fieldNumber = proto.getFieldNumber();
        int wireType = proto.getWireType();
        sb.append("Offset : 0x").append(Integer.toHexString(proto.getOffset()));
        sb.append("\nField Number : 0x").append(Integer.toHexString(proto.getFieldNumber()));
        sb.append("\nWire Type : ");
        switch (wireType) {
            case 0: {
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10300000000L);
                sb.append("varint\nField Value : 0x");
                sb.append(Long.toHexString(proto.readLong(fieldConstant)));
                break;
            }
            case 1: {
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10600000000L);
                sb.append("fixed64\nField Value : 0x");
                sb.append(Long.toHexString(proto.readLong(fieldConstant)));
                break;
            }
            case 2: {
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10C00000000L);
                sb.append("length delimited\nField Bytes : ");
                sb.append(Arrays.toString(proto.readBytes(fieldConstant)));
                break;
            }
            case 3: {
                sb.append("start group");
                break;
            }
            case 4: {
                sb.append("end group");
                break;
            }
            case 5: {
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10700000000L);
                sb.append("fixed32\nField Value : 0x");
                sb.append(Integer.toHexString(proto.readInt(fieldConstant)));
                break;
            }
            default: {
                sb.append("unknown(").append(proto.getWireType()).append(")");
            }
        }
        return sb.toString();
    }
}

