/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Log;
import android.util.proto.EncodedBuffer;
import android.util.proto.ProtoParseException;
import android.util.proto.ProtoStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

@RavenwoodKeepWholeClass
public class ProtoOutputStream
extends ProtoStream {
    public static final String TAG = "ProtoOutputStream";
    private EncodedBuffer mBuffer;
    private OutputStream mStream;
    private int mDepth;
    private int mNextObjectId = -1;
    private long mExpectedObjectToken;
    private int mCopyBegin;
    private boolean mCompacted;

    public ProtoOutputStream() {
        this(0);
    }

    public ProtoOutputStream(int chunkSize) {
        this.mBuffer = new EncodedBuffer(chunkSize);
    }

    public ProtoOutputStream(@NonNull OutputStream stream) {
        this();
        this.mStream = stream;
    }

    public ProtoOutputStream(@NonNull FileDescriptor fd) {
        this(new FileOutputStream(fd));
    }

    public int getRawSize() {
        if (this.mCompacted) {
            return this.getBytes().length;
        }
        return this.mBuffer.getSize();
    }

    public void write(long fieldId, double val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 257: {
                this.writeDoubleImpl(id2, val);
                break;
            }
            case 513: 
            case 1281: {
                this.writeRepeatedDoubleImpl(id2, val);
                break;
            }
            case 258: {
                this.writeFloatImpl(id2, (float)val);
                break;
            }
            case 514: 
            case 1282: {
                this.writeRepeatedFloatImpl(id2, (float)val);
                break;
            }
            case 261: {
                this.writeInt32Impl(id2, (int)val);
                break;
            }
            case 517: 
            case 1285: {
                this.writeRepeatedInt32Impl(id2, (int)val);
                break;
            }
            case 259: {
                this.writeInt64Impl(id2, (long)val);
                break;
            }
            case 515: 
            case 1283: {
                this.writeRepeatedInt64Impl(id2, (long)val);
                break;
            }
            case 269: {
                this.writeUInt32Impl(id2, (int)val);
                break;
            }
            case 525: 
            case 1293: {
                this.writeRepeatedUInt32Impl(id2, (int)val);
                break;
            }
            case 260: {
                this.writeUInt64Impl(id2, (long)val);
                break;
            }
            case 516: 
            case 1284: {
                this.writeRepeatedUInt64Impl(id2, (long)val);
                break;
            }
            case 273: {
                this.writeSInt32Impl(id2, (int)val);
                break;
            }
            case 529: 
            case 1297: {
                this.writeRepeatedSInt32Impl(id2, (int)val);
                break;
            }
            case 274: {
                this.writeSInt64Impl(id2, (long)val);
                break;
            }
            case 530: 
            case 1298: {
                this.writeRepeatedSInt64Impl(id2, (long)val);
                break;
            }
            case 263: {
                this.writeFixed32Impl(id2, (int)val);
                break;
            }
            case 519: 
            case 1287: {
                this.writeRepeatedFixed32Impl(id2, (int)val);
                break;
            }
            case 262: {
                this.writeFixed64Impl(id2, (long)val);
                break;
            }
            case 518: 
            case 1286: {
                this.writeRepeatedFixed64Impl(id2, (long)val);
                break;
            }
            case 271: {
                this.writeSFixed32Impl(id2, (int)val);
                break;
            }
            case 527: 
            case 1295: {
                this.writeRepeatedSFixed32Impl(id2, (int)val);
                break;
            }
            case 272: {
                this.writeSFixed64Impl(id2, (long)val);
                break;
            }
            case 528: 
            case 1296: {
                this.writeRepeatedSFixed64Impl(id2, (long)val);
                break;
            }
            case 264: {
                this.writeBoolImpl(id2, val != 0.0);
                break;
            }
            case 520: 
            case 1288: {
                this.writeRepeatedBoolImpl(id2, val != 0.0);
                break;
            }
            case 270: {
                this.writeEnumImpl(id2, (int)val);
                break;
            }
            case 526: 
            case 1294: {
                this.writeRepeatedEnumImpl(id2, (int)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, double) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, float val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 257: {
                this.writeDoubleImpl(id2, val);
                break;
            }
            case 513: 
            case 1281: {
                this.writeRepeatedDoubleImpl(id2, val);
                break;
            }
            case 258: {
                this.writeFloatImpl(id2, val);
                break;
            }
            case 514: 
            case 1282: {
                this.writeRepeatedFloatImpl(id2, val);
                break;
            }
            case 261: {
                this.writeInt32Impl(id2, (int)val);
                break;
            }
            case 517: 
            case 1285: {
                this.writeRepeatedInt32Impl(id2, (int)val);
                break;
            }
            case 259: {
                this.writeInt64Impl(id2, (long)val);
                break;
            }
            case 515: 
            case 1283: {
                this.writeRepeatedInt64Impl(id2, (long)val);
                break;
            }
            case 269: {
                this.writeUInt32Impl(id2, (int)val);
                break;
            }
            case 525: 
            case 1293: {
                this.writeRepeatedUInt32Impl(id2, (int)val);
                break;
            }
            case 260: {
                this.writeUInt64Impl(id2, (long)val);
                break;
            }
            case 516: 
            case 1284: {
                this.writeRepeatedUInt64Impl(id2, (long)val);
                break;
            }
            case 273: {
                this.writeSInt32Impl(id2, (int)val);
                break;
            }
            case 529: 
            case 1297: {
                this.writeRepeatedSInt32Impl(id2, (int)val);
                break;
            }
            case 274: {
                this.writeSInt64Impl(id2, (long)val);
                break;
            }
            case 530: 
            case 1298: {
                this.writeRepeatedSInt64Impl(id2, (long)val);
                break;
            }
            case 263: {
                this.writeFixed32Impl(id2, (int)val);
                break;
            }
            case 519: 
            case 1287: {
                this.writeRepeatedFixed32Impl(id2, (int)val);
                break;
            }
            case 262: {
                this.writeFixed64Impl(id2, (long)val);
                break;
            }
            case 518: 
            case 1286: {
                this.writeRepeatedFixed64Impl(id2, (long)val);
                break;
            }
            case 271: {
                this.writeSFixed32Impl(id2, (int)val);
                break;
            }
            case 527: 
            case 1295: {
                this.writeRepeatedSFixed32Impl(id2, (int)val);
                break;
            }
            case 272: {
                this.writeSFixed64Impl(id2, (long)val);
                break;
            }
            case 528: 
            case 1296: {
                this.writeRepeatedSFixed64Impl(id2, (long)val);
                break;
            }
            case 264: {
                this.writeBoolImpl(id2, val != 0.0f);
                break;
            }
            case 520: 
            case 1288: {
                this.writeRepeatedBoolImpl(id2, val != 0.0f);
                break;
            }
            case 270: {
                this.writeEnumImpl(id2, (int)val);
                break;
            }
            case 526: 
            case 1294: {
                this.writeRepeatedEnumImpl(id2, (int)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, float) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 257: {
                this.writeDoubleImpl(id2, val);
                break;
            }
            case 513: 
            case 1281: {
                this.writeRepeatedDoubleImpl(id2, val);
                break;
            }
            case 258: {
                this.writeFloatImpl(id2, val);
                break;
            }
            case 514: 
            case 1282: {
                this.writeRepeatedFloatImpl(id2, val);
                break;
            }
            case 261: {
                this.writeInt32Impl(id2, val);
                break;
            }
            case 517: 
            case 1285: {
                this.writeRepeatedInt32Impl(id2, val);
                break;
            }
            case 259: {
                this.writeInt64Impl(id2, val);
                break;
            }
            case 515: 
            case 1283: {
                this.writeRepeatedInt64Impl(id2, val);
                break;
            }
            case 269: {
                this.writeUInt32Impl(id2, val);
                break;
            }
            case 525: 
            case 1293: {
                this.writeRepeatedUInt32Impl(id2, val);
                break;
            }
            case 260: {
                this.writeUInt64Impl(id2, val);
                break;
            }
            case 516: 
            case 1284: {
                this.writeRepeatedUInt64Impl(id2, val);
                break;
            }
            case 273: {
                this.writeSInt32Impl(id2, val);
                break;
            }
            case 529: 
            case 1297: {
                this.writeRepeatedSInt32Impl(id2, val);
                break;
            }
            case 274: {
                this.writeSInt64Impl(id2, val);
                break;
            }
            case 530: 
            case 1298: {
                this.writeRepeatedSInt64Impl(id2, val);
                break;
            }
            case 263: {
                this.writeFixed32Impl(id2, val);
                break;
            }
            case 519: 
            case 1287: {
                this.writeRepeatedFixed32Impl(id2, val);
                break;
            }
            case 262: {
                this.writeFixed64Impl(id2, val);
                break;
            }
            case 518: 
            case 1286: {
                this.writeRepeatedFixed64Impl(id2, val);
                break;
            }
            case 271: {
                this.writeSFixed32Impl(id2, val);
                break;
            }
            case 527: 
            case 1295: {
                this.writeRepeatedSFixed32Impl(id2, val);
                break;
            }
            case 272: {
                this.writeSFixed64Impl(id2, val);
                break;
            }
            case 528: 
            case 1296: {
                this.writeRepeatedSFixed64Impl(id2, val);
                break;
            }
            case 264: {
                this.writeBoolImpl(id2, val != 0);
                break;
            }
            case 520: 
            case 1288: {
                this.writeRepeatedBoolImpl(id2, val != 0);
                break;
            }
            case 270: {
                this.writeEnumImpl(id2, val);
                break;
            }
            case 526: 
            case 1294: {
                this.writeRepeatedEnumImpl(id2, val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, int) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 257: {
                this.writeDoubleImpl(id2, val);
                break;
            }
            case 513: 
            case 1281: {
                this.writeRepeatedDoubleImpl(id2, val);
                break;
            }
            case 258: {
                this.writeFloatImpl(id2, val);
                break;
            }
            case 514: 
            case 1282: {
                this.writeRepeatedFloatImpl(id2, val);
                break;
            }
            case 261: {
                this.writeInt32Impl(id2, (int)val);
                break;
            }
            case 517: 
            case 1285: {
                this.writeRepeatedInt32Impl(id2, (int)val);
                break;
            }
            case 259: {
                this.writeInt64Impl(id2, val);
                break;
            }
            case 515: 
            case 1283: {
                this.writeRepeatedInt64Impl(id2, val);
                break;
            }
            case 269: {
                this.writeUInt32Impl(id2, (int)val);
                break;
            }
            case 525: 
            case 1293: {
                this.writeRepeatedUInt32Impl(id2, (int)val);
                break;
            }
            case 260: {
                this.writeUInt64Impl(id2, val);
                break;
            }
            case 516: 
            case 1284: {
                this.writeRepeatedUInt64Impl(id2, val);
                break;
            }
            case 273: {
                this.writeSInt32Impl(id2, (int)val);
                break;
            }
            case 529: 
            case 1297: {
                this.writeRepeatedSInt32Impl(id2, (int)val);
                break;
            }
            case 274: {
                this.writeSInt64Impl(id2, val);
                break;
            }
            case 530: 
            case 1298: {
                this.writeRepeatedSInt64Impl(id2, val);
                break;
            }
            case 263: {
                this.writeFixed32Impl(id2, (int)val);
                break;
            }
            case 519: 
            case 1287: {
                this.writeRepeatedFixed32Impl(id2, (int)val);
                break;
            }
            case 262: {
                this.writeFixed64Impl(id2, val);
                break;
            }
            case 518: 
            case 1286: {
                this.writeRepeatedFixed64Impl(id2, val);
                break;
            }
            case 271: {
                this.writeSFixed32Impl(id2, (int)val);
                break;
            }
            case 527: 
            case 1295: {
                this.writeRepeatedSFixed32Impl(id2, (int)val);
                break;
            }
            case 272: {
                this.writeSFixed64Impl(id2, val);
                break;
            }
            case 528: 
            case 1296: {
                this.writeRepeatedSFixed64Impl(id2, val);
                break;
            }
            case 264: {
                this.writeBoolImpl(id2, val != 0L);
                break;
            }
            case 520: 
            case 1288: {
                this.writeRepeatedBoolImpl(id2, val != 0L);
                break;
            }
            case 270: {
                this.writeEnumImpl(id2, (int)val);
                break;
            }
            case 526: 
            case 1294: {
                this.writeRepeatedEnumImpl(id2, (int)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, long) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, boolean val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 264: {
                this.writeBoolImpl(id2, val);
                break;
            }
            case 520: 
            case 1288: {
                this.writeRepeatedBoolImpl(id2, val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, boolean) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, @Nullable String val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 265: {
                this.writeStringImpl(id2, val);
                break;
            }
            case 521: 
            case 1289: {
                this.writeRepeatedStringImpl(id2, val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, String) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public void write(long fieldId, @Nullable byte[] val) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        switch ((int)((fieldId & 0xFFF00000000L) >> 32)) {
            case 268: {
                this.writeBytesImpl(id2, val);
                break;
            }
            case 524: 
            case 1292: {
                this.writeRepeatedBytesImpl(id2, val);
                break;
            }
            case 267: {
                this.writeObjectImpl(id2, val);
                break;
            }
            case 523: 
            case 1291: {
                this.writeRepeatedObjectImpl(id2, val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to call write(long, byte[]) with " + ProtoOutputStream.getFieldIdString(fieldId));
            }
        }
    }

    public long start(long fieldId) {
        this.assertNotCompacted();
        int id2 = (int)fieldId;
        if ((fieldId & 0xFF00000000L) == 0xB00000000L) {
            long count = fieldId & 0xF0000000000L;
            if (count == 0x10000000000L) {
                return this.startObjectImpl(id2, false);
            }
            if (count == 0x20000000000L || count == 0x50000000000L) {
                return this.startObjectImpl(id2, true);
            }
        }
        throw new IllegalArgumentException("Attempt to call start(long) with " + ProtoOutputStream.getFieldIdString(fieldId));
    }

    public void end(long token) {
        this.endObjectImpl(token, ProtoOutputStream.getRepeatedFromToken(token));
    }

    @Deprecated
    public void writeDouble(long fieldId, double val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10100000000L);
        this.writeDoubleImpl(id2, val);
    }

    private void writeDoubleImpl(int id2, double val) {
        if (val != 0.0) {
            this.writeTag(id2, 1);
            this.mBuffer.writeRawFixed64(Double.doubleToLongBits(val));
        }
    }

    @Deprecated
    public void writeRepeatedDouble(long fieldId, double val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20100000000L);
        this.writeRepeatedDoubleImpl(id2, val);
    }

    private void writeRepeatedDoubleImpl(int id2, double val) {
        this.writeTag(id2, 1);
        this.mBuffer.writeRawFixed64(Double.doubleToLongBits(val));
    }

    @Deprecated
    public void writePackedDouble(long fieldId, @Nullable double[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50100000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 8);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed64(Double.doubleToLongBits(val[i]));
            }
        }
    }

    @Deprecated
    public void writeFloat(long fieldId, float val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10200000000L);
        this.writeFloatImpl(id2, val);
    }

    private void writeFloatImpl(int id2, float val) {
        if (val != 0.0f) {
            this.writeTag(id2, 5);
            this.mBuffer.writeRawFixed32(Float.floatToIntBits(val));
        }
    }

    @Deprecated
    public void writeRepeatedFloat(long fieldId, float val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20200000000L);
        this.writeRepeatedFloatImpl(id2, val);
    }

    private void writeRepeatedFloatImpl(int id2, float val) {
        this.writeTag(id2, 5);
        this.mBuffer.writeRawFixed32(Float.floatToIntBits(val));
    }

    @Deprecated
    public void writePackedFloat(long fieldId, @Nullable float[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50200000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 4);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed32(Float.floatToIntBits(val[i]));
            }
        }
    }

    private void writeUnsignedVarintFromSignedInt(int val) {
        if (val >= 0) {
            this.mBuffer.writeRawVarint32(val);
        } else {
            this.mBuffer.writeRawVarint64(val);
        }
    }

    @Deprecated
    public void writeInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10500000000L);
        this.writeInt32Impl(id2, val);
    }

    private void writeInt32Impl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 0);
            this.writeUnsignedVarintFromSignedInt(val);
        }
    }

    @Deprecated
    public void writeRepeatedInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20500000000L);
        this.writeRepeatedInt32Impl(id2, val);
    }

    private void writeRepeatedInt32Impl(int id2, int val) {
        this.writeTag(id2, 0);
        this.writeUnsignedVarintFromSignedInt(val);
    }

    @Deprecated
    public void writePackedInt32(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50500000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                int v = val[i];
                size += v >= 0 ? EncodedBuffer.getRawVarint32Size(v) : 10;
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.writeUnsignedVarintFromSignedInt(val[i]);
            }
        }
    }

    @Deprecated
    public void writeInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10300000000L);
        this.writeInt64Impl(id2, val);
    }

    private void writeInt64Impl(int id2, long val) {
        if (val != 0L) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawVarint64(val);
        }
    }

    @Deprecated
    public void writeRepeatedInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20300000000L);
        this.writeRepeatedInt64Impl(id2, val);
    }

    private void writeRepeatedInt64Impl(int id2, long val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawVarint64(val);
    }

    @Deprecated
    public void writePackedInt64(long fieldId, @Nullable long[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50300000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                size += EncodedBuffer.getRawVarint64Size(val[i]);
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.mBuffer.writeRawVarint64(val[i]);
            }
        }
    }

    @Deprecated
    public void writeUInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10D00000000L);
        this.writeUInt32Impl(id2, val);
    }

    private void writeUInt32Impl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawVarint32(val);
        }
    }

    @Deprecated
    public void writeRepeatedUInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20D00000000L);
        this.writeRepeatedUInt32Impl(id2, val);
    }

    private void writeRepeatedUInt32Impl(int id2, int val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawVarint32(val);
    }

    @Deprecated
    public void writePackedUInt32(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50D00000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                size += EncodedBuffer.getRawVarint32Size(val[i]);
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.mBuffer.writeRawVarint32(val[i]);
            }
        }
    }

    @Deprecated
    public void writeUInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10400000000L);
        this.writeUInt64Impl(id2, val);
    }

    private void writeUInt64Impl(int id2, long val) {
        if (val != 0L) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawVarint64(val);
        }
    }

    @Deprecated
    public void writeRepeatedUInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20400000000L);
        this.writeRepeatedUInt64Impl(id2, val);
    }

    private void writeRepeatedUInt64Impl(int id2, long val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawVarint64(val);
    }

    @Deprecated
    public void writePackedUInt64(long fieldId, @Nullable long[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50400000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                size += EncodedBuffer.getRawVarint64Size(val[i]);
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.mBuffer.writeRawVarint64(val[i]);
            }
        }
    }

    @Deprecated
    public void writeSInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x11100000000L);
        this.writeSInt32Impl(id2, val);
    }

    private void writeSInt32Impl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawZigZag32(val);
        }
    }

    @Deprecated
    public void writeRepeatedSInt32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x21100000000L);
        this.writeRepeatedSInt32Impl(id2, val);
    }

    private void writeRepeatedSInt32Impl(int id2, int val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawZigZag32(val);
    }

    @Deprecated
    public void writePackedSInt32(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x51100000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                size += EncodedBuffer.getRawZigZag32Size(val[i]);
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.mBuffer.writeRawZigZag32(val[i]);
            }
        }
    }

    @Deprecated
    public void writeSInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x11200000000L);
        this.writeSInt64Impl(id2, val);
    }

    private void writeSInt64Impl(int id2, long val) {
        if (val != 0L) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawZigZag64(val);
        }
    }

    @Deprecated
    public void writeRepeatedSInt64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x21200000000L);
        this.writeRepeatedSInt64Impl(id2, val);
    }

    private void writeRepeatedSInt64Impl(int id2, long val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawZigZag64(val);
    }

    @Deprecated
    public void writePackedSInt64(long fieldId, @Nullable long[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 5574867550208L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                size += EncodedBuffer.getRawZigZag64Size(val[i]);
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.mBuffer.writeRawZigZag64(val[i]);
            }
        }
    }

    @Deprecated
    public void writeFixed32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10700000000L);
        this.writeFixed32Impl(id2, val);
    }

    private void writeFixed32Impl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 5);
            this.mBuffer.writeRawFixed32(val);
        }
    }

    @Deprecated
    public void writeRepeatedFixed32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20700000000L);
        this.writeRepeatedFixed32Impl(id2, val);
    }

    private void writeRepeatedFixed32Impl(int id2, int val) {
        this.writeTag(id2, 5);
        this.mBuffer.writeRawFixed32(val);
    }

    @Deprecated
    public void writePackedFixed32(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50700000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 4);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed32(val[i]);
            }
        }
    }

    @Deprecated
    public void writeFixed64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10600000000L);
        this.writeFixed64Impl(id2, val);
    }

    private void writeFixed64Impl(int id2, long val) {
        if (val != 0L) {
            this.writeTag(id2, 1);
            this.mBuffer.writeRawFixed64(val);
        }
    }

    @Deprecated
    public void writeRepeatedFixed64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20600000000L);
        this.writeRepeatedFixed64Impl(id2, val);
    }

    private void writeRepeatedFixed64Impl(int id2, long val) {
        this.writeTag(id2, 1);
        this.mBuffer.writeRawFixed64(val);
    }

    @Deprecated
    public void writePackedFixed64(long fieldId, @Nullable long[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50600000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 8);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed64(val[i]);
            }
        }
    }

    @Deprecated
    public void writeSFixed32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10F00000000L);
        this.writeSFixed32Impl(id2, val);
    }

    private void writeSFixed32Impl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 5);
            this.mBuffer.writeRawFixed32(val);
        }
    }

    @Deprecated
    public void writeRepeatedSFixed32(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20F00000000L);
        this.writeRepeatedSFixed32Impl(id2, val);
    }

    private void writeRepeatedSFixed32Impl(int id2, int val) {
        this.writeTag(id2, 5);
        this.mBuffer.writeRawFixed32(val);
    }

    @Deprecated
    public void writePackedSFixed32(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50F00000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 4);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed32(val[i]);
            }
        }
    }

    @Deprecated
    public void writeSFixed64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x11000000000L);
        this.writeSFixed64Impl(id2, val);
    }

    private void writeSFixed64Impl(int id2, long val) {
        if (val != 0L) {
            this.writeTag(id2, 1);
            this.mBuffer.writeRawFixed64(val);
        }
    }

    @Deprecated
    public void writeRepeatedSFixed64(long fieldId, long val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x21000000000L);
        this.writeRepeatedSFixed64Impl(id2, val);
    }

    private void writeRepeatedSFixed64Impl(int id2, long val) {
        this.writeTag(id2, 1);
        this.mBuffer.writeRawFixed64(val);
    }

    @Deprecated
    public void writePackedSFixed64(long fieldId, @Nullable long[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x51000000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2 * 8);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawFixed64(val[i]);
            }
        }
    }

    @Deprecated
    public void writeBool(long fieldId, boolean val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10800000000L);
        this.writeBoolImpl(id2, val);
    }

    private void writeBoolImpl(int id2, boolean val) {
        if (val) {
            this.writeTag(id2, 0);
            this.mBuffer.writeRawByte((byte)1);
        }
    }

    @Deprecated
    public void writeRepeatedBool(long fieldId, boolean val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20800000000L);
        this.writeRepeatedBoolImpl(id2, val);
    }

    private void writeRepeatedBoolImpl(int id2, boolean val) {
        this.writeTag(id2, 0);
        this.mBuffer.writeRawByte((byte)(val ? 1 : 0));
    }

    @Deprecated
    public void writePackedBool(long fieldId, @Nullable boolean[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50800000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            this.writeKnownLengthHeader(id2, N2);
            for (int i = 0; i < N2; ++i) {
                this.mBuffer.writeRawByte((byte)(val[i] ? 1 : 0));
            }
        }
    }

    @Deprecated
    public void writeString(long fieldId, @Nullable String val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10900000000L);
        this.writeStringImpl(id2, val);
    }

    private void writeStringImpl(int id2, String val) {
        if (val != null && val.length() > 0) {
            this.writeUtf8String(id2, val);
        }
    }

    @Deprecated
    public void writeRepeatedString(long fieldId, @Nullable String val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20900000000L);
        this.writeRepeatedStringImpl(id2, val);
    }

    private void writeRepeatedStringImpl(int id2, String val) {
        if (val == null || val.length() == 0) {
            this.writeKnownLengthHeader(id2, 0);
        } else {
            this.writeUtf8String(id2, val);
        }
    }

    private void writeUtf8String(int id2, String val) {
        try {
            byte[] buf = val.getBytes("UTF-8");
            this.writeKnownLengthHeader(id2, buf.length);
            this.mBuffer.writeRawBuffer(buf);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("not possible");
        }
    }

    @Deprecated
    public void writeBytes(long fieldId, @Nullable byte[] val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10C00000000L);
        this.writeBytesImpl(id2, val);
    }

    private void writeBytesImpl(int id2, byte[] val) {
        if (val != null && val.length > 0) {
            this.writeKnownLengthHeader(id2, val.length);
            this.mBuffer.writeRawBuffer(val);
        }
    }

    @Deprecated
    public void writeRepeatedBytes(long fieldId, @Nullable byte[] val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20C00000000L);
        this.writeRepeatedBytesImpl(id2, val);
    }

    private void writeRepeatedBytesImpl(int id2, byte[] val) {
        this.writeKnownLengthHeader(id2, val == null ? 0 : val.length);
        this.mBuffer.writeRawBuffer(val);
    }

    @Deprecated
    public void writeEnum(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10E00000000L);
        this.writeEnumImpl(id2, val);
    }

    private void writeEnumImpl(int id2, int val) {
        if (val != 0) {
            this.writeTag(id2, 0);
            this.writeUnsignedVarintFromSignedInt(val);
        }
    }

    @Deprecated
    public void writeRepeatedEnum(long fieldId, int val) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20E00000000L);
        this.writeRepeatedEnumImpl(id2, val);
    }

    private void writeRepeatedEnumImpl(int id2, int val) {
        this.writeTag(id2, 0);
        this.writeUnsignedVarintFromSignedInt(val);
    }

    @Deprecated
    public void writePackedEnum(long fieldId, @Nullable int[] val) {
        int N2;
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x50E00000000L);
        int n = N2 = val != null ? val.length : 0;
        if (N2 > 0) {
            int i;
            int size = 0;
            for (i = 0; i < N2; ++i) {
                int v = val[i];
                size += v >= 0 ? EncodedBuffer.getRawVarint32Size(v) : 10;
            }
            this.writeKnownLengthHeader(id2, size);
            for (i = 0; i < N2; ++i) {
                this.writeUnsignedVarintFromSignedInt(val[i]);
            }
        }
    }

    @Deprecated
    public long startObject(long fieldId) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10B00000000L);
        return this.startObjectImpl(id2, false);
    }

    @Deprecated
    public void endObject(long token) {
        this.assertNotCompacted();
        this.endObjectImpl(token, false);
    }

    @Deprecated
    public long startRepeatedObject(long fieldId) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20B00000000L);
        return this.startObjectImpl(id2, true);
    }

    @Deprecated
    public void endRepeatedObject(long token) {
        this.assertNotCompacted();
        this.endObjectImpl(token, true);
    }

    private long startObjectImpl(int id2, boolean repeated) {
        this.writeTag(id2, 2);
        int sizePos = this.mBuffer.getWritePos();
        ++this.mDepth;
        --this.mNextObjectId;
        this.mBuffer.writeRawFixed32((int)(this.mExpectedObjectToken >> 32));
        this.mBuffer.writeRawFixed32((int)this.mExpectedObjectToken);
        long old = this.mExpectedObjectToken;
        this.mExpectedObjectToken = ProtoOutputStream.makeToken(ProtoOutputStream.getTagSize(id2), repeated, this.mDepth, this.mNextObjectId, sizePos);
        return this.mExpectedObjectToken;
    }

    private void endObjectImpl(long token, boolean repeated) {
        int depth = ProtoOutputStream.getDepthFromToken(token);
        boolean expectedRepeated = ProtoOutputStream.getRepeatedFromToken(token);
        int sizePos = ProtoOutputStream.getOffsetFromToken(token);
        int childRawSize = this.mBuffer.getWritePos() - sizePos - 8;
        if (repeated != expectedRepeated) {
            if (repeated) {
                throw new IllegalArgumentException("endRepeatedObject called where endObject should have been");
            }
            throw new IllegalArgumentException("endObject called where endRepeatedObject should have been");
        }
        if ((this.mDepth & 0x1FF) != depth || this.mExpectedObjectToken != token) {
            throw new IllegalArgumentException("Mismatched startObject/endObject calls. Current depth " + this.mDepth + " token=" + ProtoOutputStream.token2String(token) + " expectedToken=" + ProtoOutputStream.token2String(this.mExpectedObjectToken));
        }
        this.mExpectedObjectToken = (long)this.mBuffer.getRawFixed32At(sizePos) << 32 | 0xFFFFFFFFL & (long)this.mBuffer.getRawFixed32At(sizePos + 4);
        --this.mDepth;
        if (childRawSize > 0) {
            this.mBuffer.editRawFixed32(sizePos, -childRawSize);
            this.mBuffer.editRawFixed32(sizePos + 4, -1);
        } else if (repeated) {
            this.mBuffer.editRawFixed32(sizePos, 0);
            this.mBuffer.editRawFixed32(sizePos + 4, 0);
        } else {
            this.mBuffer.rewindWriteTo(sizePos - ProtoOutputStream.getTagSizeFromToken(token));
        }
    }

    @Deprecated
    public void writeObject(long fieldId, @Nullable byte[] value) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x10B00000000L);
        this.writeObjectImpl(id2, value);
    }

    void writeObjectImpl(int id2, byte[] value) {
        if (value != null && value.length != 0) {
            this.writeKnownLengthHeader(id2, value.length);
            this.mBuffer.writeRawBuffer(value);
        }
    }

    @Deprecated
    public void writeRepeatedObject(long fieldId, @Nullable byte[] value) {
        this.assertNotCompacted();
        int id2 = ProtoOutputStream.checkFieldId(fieldId, 0x20B00000000L);
        this.writeRepeatedObjectImpl(id2, value);
    }

    void writeRepeatedObjectImpl(int id2, byte[] value) {
        this.writeKnownLengthHeader(id2, value == null ? 0 : value.length);
        this.mBuffer.writeRawBuffer(value);
    }

    public static long makeFieldId(int id2, long fieldFlags) {
        return fieldFlags | (long)id2 & 0xFFFFFFFFL;
    }

    public static int checkFieldId(long fieldId, long expectedFlags) {
        long fieldCount = fieldId & 0xF0000000000L;
        long fieldType = fieldId & 0xFF00000000L;
        long expectedCount = expectedFlags & 0xF0000000000L;
        long expectedType = expectedFlags & 0xFF00000000L;
        if ((int)fieldId == 0) {
            throw new IllegalArgumentException("Invalid proto field " + (int)fieldId + " fieldId=" + Long.toHexString(fieldId));
        }
        if (fieldType != expectedType || fieldCount != expectedCount && (fieldCount != 0x50000000000L || expectedCount != 0x20000000000L)) {
            String countString = ProtoOutputStream.getFieldCountString(fieldCount);
            String typeString = ProtoOutputStream.getFieldTypeString(fieldType);
            if (typeString != null && countString != null) {
                StringBuilder sb = new StringBuilder();
                if (expectedType == 0xB00000000L) {
                    sb.append("start");
                } else {
                    sb.append("write");
                }
                sb.append(ProtoOutputStream.getFieldCountString(expectedCount));
                sb.append(ProtoOutputStream.getFieldTypeString(expectedType));
                sb.append(" called for field ");
                sb.append((int)fieldId);
                sb.append(" which should be used with ");
                if (fieldType == 0xB00000000L) {
                    sb.append("start");
                } else {
                    sb.append("write");
                }
                sb.append(countString);
                sb.append(typeString);
                if (fieldCount == 0x50000000000L) {
                    sb.append(" or writeRepeated");
                    sb.append(typeString);
                }
                sb.append('.');
                throw new IllegalArgumentException(sb.toString());
            }
            StringBuilder sb = new StringBuilder();
            if (expectedType == 0xB00000000L) {
                sb.append("start");
            } else {
                sb.append("write");
            }
            sb.append(ProtoOutputStream.getFieldCountString(expectedCount));
            sb.append(ProtoOutputStream.getFieldTypeString(expectedType));
            sb.append(" called with an invalid fieldId: 0x");
            sb.append(Long.toHexString(fieldId));
            sb.append(". The proto field ID might be ");
            sb.append((int)fieldId);
            sb.append('.');
            throw new IllegalArgumentException(sb.toString());
        }
        return (int)fieldId;
    }

    private static int getTagSize(int id2) {
        return EncodedBuffer.getRawVarint32Size(id2 << 3);
    }

    public void writeTag(int id2, int wireType) {
        this.mBuffer.writeRawVarint32(id2 << 3 | wireType);
    }

    private void writeKnownLengthHeader(int id2, int size) {
        this.writeTag(id2, 2);
        this.mBuffer.writeRawFixed32(size);
        this.mBuffer.writeRawFixed32(size);
    }

    private void assertNotCompacted() {
        if (this.mCompacted) {
            throw new IllegalArgumentException("write called after compact");
        }
    }

    @NonNull
    public byte[] getBytes() {
        this.compactIfNecessary();
        return this.mBuffer.getBytes(this.mBuffer.getReadableSize());
    }

    private void compactIfNecessary() {
        if (!this.mCompacted) {
            if (this.mDepth != 0) {
                throw new IllegalArgumentException("Trying to compact with " + this.mDepth + " missing calls to endObject");
            }
            this.mBuffer.startEditing();
            int readableSize = this.mBuffer.getReadableSize();
            this.editEncodedSize(readableSize);
            this.mBuffer.rewindRead();
            this.compactSizes(readableSize);
            if (this.mCopyBegin < readableSize) {
                this.mBuffer.writeFromThisBuffer(this.mCopyBegin, readableSize - this.mCopyBegin);
            }
            this.mBuffer.startEditing();
            this.mCompacted = true;
        }
    }

    private int editEncodedSize(int rawSize) {
        int tagPos;
        int objectStart = this.mBuffer.getReadPos();
        int objectEnd = objectStart + rawSize;
        int encodedSize = 0;
        block7: while ((tagPos = this.mBuffer.getReadPos()) < objectEnd) {
            int tag = this.readRawTag();
            encodedSize += EncodedBuffer.getRawVarint32Size(tag);
            int wireType = tag & 7;
            switch (wireType) {
                case 0: {
                    ++encodedSize;
                    while ((this.mBuffer.readRawByte() & 0x80) != 0) {
                        ++encodedSize;
                    }
                    continue block7;
                }
                case 1: {
                    encodedSize += 8;
                    this.mBuffer.skipRead(8);
                    continue block7;
                }
                case 2: {
                    int childRawSize = this.mBuffer.readRawFixed32();
                    int childEncodedSizePos = this.mBuffer.getReadPos();
                    int childEncodedSize = this.mBuffer.readRawFixed32();
                    if (childRawSize >= 0) {
                        if (childEncodedSize != childRawSize) {
                            throw new RuntimeException("Pre-computed size where the precomputed size and the raw size in the buffer don't match! childRawSize=" + childRawSize + " childEncodedSize=" + childEncodedSize + " childEncodedSizePos=" + childEncodedSizePos);
                        }
                        this.mBuffer.skipRead(childRawSize);
                    } else {
                        childEncodedSize = this.editEncodedSize(-childRawSize);
                        this.mBuffer.editRawFixed32(childEncodedSizePos, childEncodedSize);
                    }
                    encodedSize += EncodedBuffer.getRawVarint32Size(childEncodedSize) + childEncodedSize;
                    continue block7;
                }
                case 3: 
                case 4: {
                    throw new RuntimeException("groups not supported at index " + tagPos);
                }
                case 5: {
                    encodedSize += 4;
                    this.mBuffer.skipRead(4);
                    continue block7;
                }
            }
            throw new ProtoParseException("editEncodedSize Bad tag tag=0x" + Integer.toHexString(tag) + " wireType=" + wireType + " -- " + this.mBuffer.getDebugString());
        }
        return encodedSize;
    }

    private void compactSizes(int rawSize) {
        int tagPos;
        int objectStart = this.mBuffer.getReadPos();
        int objectEnd = objectStart + rawSize;
        block7: while ((tagPos = this.mBuffer.getReadPos()) < objectEnd) {
            int tag = this.readRawTag();
            int wireType = tag & 7;
            switch (wireType) {
                case 0: {
                    while ((this.mBuffer.readRawByte() & 0x80) != 0) {
                    }
                    continue block7;
                }
                case 1: {
                    this.mBuffer.skipRead(8);
                    continue block7;
                }
                case 2: {
                    this.mBuffer.writeFromThisBuffer(this.mCopyBegin, this.mBuffer.getReadPos() - this.mCopyBegin);
                    int childRawSize = this.mBuffer.readRawFixed32();
                    int childEncodedSize = this.mBuffer.readRawFixed32();
                    this.mBuffer.writeRawVarint32(childEncodedSize);
                    this.mCopyBegin = this.mBuffer.getReadPos();
                    if (childRawSize >= 0) {
                        this.mBuffer.skipRead(childEncodedSize);
                        continue block7;
                    }
                    this.compactSizes(-childRawSize);
                    continue block7;
                }
                case 3: 
                case 4: {
                    throw new RuntimeException("groups not supported at index " + tagPos);
                }
                case 5: {
                    this.mBuffer.skipRead(4);
                    continue block7;
                }
            }
            throw new ProtoParseException("compactSizes Bad tag tag=0x" + Integer.toHexString(tag) + " wireType=" + wireType + " -- " + this.mBuffer.getDebugString());
        }
    }

    public void flush() {
        if (this.mStream == null) {
            return;
        }
        if (this.mDepth != 0) {
            return;
        }
        if (this.mCompacted) {
            return;
        }
        this.compactIfNecessary();
        byte[] data = this.mBuffer.getBytes(this.mBuffer.getReadableSize());
        try {
            this.mStream.write(data);
            this.mStream.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error flushing proto to stream", ex);
        }
    }

    private int readRawTag() {
        if (this.mBuffer.getReadPos() == this.mBuffer.getReadableSize()) {
            return 0;
        }
        return (int)this.mBuffer.readRawUnsigned();
    }

    public void dump(@NonNull String tag) {
        Log.d(tag, this.mBuffer.getDebugString());
        this.mBuffer.dumpBuffers(tag);
    }
}

