/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.util.apk.DataDigester;
import android.util.apk.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;

class ByteBufferDataSource
implements DataSource {
    private final ByteBuffer mBuf;

    ByteBufferDataSource(ByteBuffer buf) {
        this.mBuf = buf.slice();
    }

    @Override
    public long size() {
        return this.mBuf.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedIntoDataDigester(DataDigester md, long offset, int size) throws IOException, DigestException {
        ByteBuffer region;
        ByteBuffer byteBuffer = this.mBuf;
        synchronized (byteBuffer) {
            this.mBuf.position(0);
            this.mBuf.limit((int)offset + size);
            this.mBuf.position((int)offset);
            region = this.mBuf.slice();
        }
        md.consume(region);
    }
}

