/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.TrustedTime;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class NtpTrustedTime
implements TrustedTime {
    private static final String URI_SCHEME_NTP = "ntp";
    @VisibleForTesting
    public static final String NTP_SETTING_SERVER_NAME_DELIMITER = "|";
    private static final String NTP_SETTING_SERVER_NAME_DELIMITER_REGEXP = "\\|";
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private final Object mRefreshLock = new Object();
    private final Object mConfigLock = new Object();
    @GuardedBy(value={"mConfigLock"})
    @Nullable
    private NtpConfig mNtpConfigForTests;
    @Nullable
    private volatile TimeResult mTimeResult;
    @Nullable
    private volatile URI mLastSuccessfulNtpServerUri;

    protected NtpTrustedTime() {
    }

    @UnsupportedAppUsage
    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            Context appContext = context.getApplicationContext();
            sSingleton = new NtpTrustedTimeImpl(appContext);
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerConfigForTests(@NonNull NtpConfig ntpConfig) {
        Object object = this.mConfigLock;
        synchronized (object) {
            this.mNtpConfigForTests = ntpConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean forceRefresh() {
        Object object = this.mRefreshLock;
        synchronized (object) {
            Network network = this.getDefaultNetwork();
            if (network == null) {
                return false;
            }
            return this.forceRefreshLocked(network);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceRefresh(@NonNull Network network) {
        Objects.requireNonNull(network);
        Object object = this.mRefreshLock;
        synchronized (object) {
            return this.forceRefreshLocked(network);
        }
    }

    @GuardedBy(value={"mRefreshLock"})
    private boolean forceRefreshLocked(@NonNull Network network) {
        Objects.requireNonNull(network);
        if (!this.isNetworkConnected(network)) {
            return false;
        }
        NtpConfig ntpConfig = this.getNtpConfig();
        if (ntpConfig == null) {
            return false;
        }
        List<URI> unorderedServerUris = ntpConfig.getServerUris();
        ArrayList<URI> orderedServerUris = new ArrayList<URI>();
        for (URI serverUri : unorderedServerUris) {
            if (((Object)serverUri).equals(this.mLastSuccessfulNtpServerUri)) {
                orderedServerUris.add(0, serverUri);
                continue;
            }
            orderedServerUris.add(serverUri);
        }
        for (URI serverUri : orderedServerUris) {
            TimeResult timeResult = this.queryNtpServer(network, serverUri, ntpConfig.getTimeout());
            if (timeResult == null) continue;
            this.mLastSuccessfulNtpServerUri = serverUri;
            this.mTimeResult = timeResult;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NtpConfig getNtpConfig() {
        Object object = this.mConfigLock;
        synchronized (object) {
            if (this.mNtpConfigForTests != null) {
                return this.mNtpConfigForTests;
            }
            return this.getNtpConfigInternal();
        }
    }

    @GuardedBy(value={"mConfigLock"})
    @VisibleForTesting
    @Nullable
    public abstract NtpConfig getNtpConfigInternal();

    @VisibleForTesting
    @Nullable
    public abstract Network getDefaultNetwork();

    @VisibleForTesting
    public abstract boolean isNetworkConnected(@NonNull Network var1);

    @VisibleForTesting
    @Nullable
    public abstract TimeResult queryNtpServer(@NonNull Network var1, @NonNull URI var2, @NonNull Duration var3);

    @Override
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasCache() {
        return this.mTimeResult != null;
    }

    @Override
    @Deprecated
    public long getCacheAge() {
        TimeResult timeResult = this.mTimeResult;
        if (timeResult != null) {
            return SystemClock.elapsedRealtime() - timeResult.getElapsedRealtimeMillis();
        }
        return Long.MAX_VALUE;
    }

    @Override
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long currentTimeMillis() {
        TimeResult timeResult = this.mTimeResult;
        if (timeResult == null) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return timeResult.currentTimeMillis();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getCachedNtpTime() {
        TimeResult timeResult = this.mTimeResult;
        return timeResult == null ? 0L : timeResult.getTimeMillis();
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getCachedNtpTimeReference() {
        TimeResult timeResult = this.mTimeResult;
        return timeResult == null ? 0L : timeResult.getElapsedRealtimeMillis();
    }

    @Nullable
    public TimeResult getCachedTimeResult() {
        return this.mTimeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachedTimeResult(TimeResult timeResult) {
        Object object = this.mRefreshLock;
        synchronized (object) {
            this.mTimeResult = timeResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedTimeResult() {
        Object object = this.mRefreshLock;
        synchronized (object) {
            this.mTimeResult = null;
        }
    }

    @NonNull
    public static URI parseNtpUriStrict(@NonNull String ntpServerUriString) throws URISyntaxException {
        URI unvalidatedUri = new URI(ntpServerUriString);
        return NtpTrustedTime.validateNtpServerUri(unvalidatedUri);
    }

    @VisibleForTesting
    @Nullable
    public static List<URI> parseNtpServerSetting(@Nullable String ntpServerSetting) {
        if (TextUtils.isEmpty(ntpServerSetting)) {
            return null;
        }
        String[] values = ntpServerSetting.split(NTP_SETTING_SERVER_NAME_DELIMITER_REGEXP);
        if (values.length == 0) {
            return null;
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String value : values) {
            if (value.startsWith("ntp:")) {
                try {
                    uris.add(NtpTrustedTime.parseNtpUriStrict(value));
                    continue;
                }
                catch (URISyntaxException e) {
                    Log.w(TAG, "Rejected NTP uri setting=" + ntpServerSetting, e);
                    return null;
                }
            }
            try {
                URI uri = new URI(URI_SCHEME_NTP, value, null, null);
                URI validatedUri = NtpTrustedTime.validateNtpServerUri(uri);
                uris.add(validatedUri);
            }
            catch (URISyntaxException e) {
                Log.w(TAG, "Rejected NTP legacy setting=" + ntpServerSetting, e);
                return null;
            }
        }
        return uris;
    }

    @NonNull
    private static URI validateNtpServerUri(@NonNull URI uri) throws URISyntaxException {
        if (!uri.isAbsolute()) {
            throw new URISyntaxException(((Object)uri).toString(), "Relative URI not supported");
        }
        if (!URI_SCHEME_NTP.equals(uri.getScheme())) {
            throw new URISyntaxException(((Object)uri).toString(), "Unrecognized scheme");
        }
        String host = uri.getHost();
        if (TextUtils.isEmpty(host)) {
            throw new URISyntaxException(((Object)uri).toString(), "Missing host");
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mConfigLock;
        synchronized (object) {
            pw.println("getNtpConfig()=" + this.getNtpConfig());
            pw.println("mNtpConfigForTests=" + this.mNtpConfigForTests);
        }
        pw.println("mLastSuccessfulNtpServerUri=" + this.mLastSuccessfulNtpServerUri);
        TimeResult timeResult = this.mTimeResult;
        pw.println("mTimeResult=" + timeResult);
        if (timeResult != null) {
            pw.println("mTimeResult.getAgeMillis()=" + Duration.ofMillis(timeResult.getAgeMillis()));
        }
    }

    private static class NtpTrustedTimeImpl
    extends NtpTrustedTime {
        @GuardedBy(value={"this"})
        private ConnectivityManager mConnectivityManager;
        @NonNull
        private final Context mContext;

        private NtpTrustedTimeImpl(@NonNull Context context) {
            this.mContext = Objects.requireNonNull(context);
        }

        @Override
        @VisibleForTesting
        @Nullable
        public NtpConfig getNtpConfigInternal() {
            List<URI> ntpServerUris;
            ContentResolver resolver = this.mContext.getContentResolver();
            Resources res = this.mContext.getResources();
            String serverGlobalSetting = Settings.Global.getString(resolver, "ntp_server");
            List<URI> settingsServerUris = NtpTrustedTimeImpl.parseNtpServerSetting(serverGlobalSetting);
            if (settingsServerUris != null) {
                ntpServerUris = settingsServerUris;
            } else {
                String[] configValues = res.getStringArray(17236135);
                try {
                    ArrayList<URI> configServerUris = new ArrayList<URI>();
                    for (String configValue : configValues) {
                        configServerUris.add(NtpTrustedTimeImpl.parseNtpUriStrict(configValue));
                    }
                    ntpServerUris = configServerUris;
                }
                catch (URISyntaxException e) {
                    ntpServerUris = null;
                }
            }
            int defaultTimeoutMillis = res.getInteger(0x10E0100);
            Duration timeout = Duration.ofMillis(Settings.Global.getInt(resolver, "ntp_timeout", defaultTimeoutMillis));
            return ntpServerUris == null ? null : new NtpConfig(ntpServerUris, timeout);
        }

        @Override
        public Network getDefaultNetwork() {
            ConnectivityManager connectivityManager = this.getConnectivityManager();
            if (connectivityManager == null) {
                return null;
            }
            return connectivityManager.getActiveNetwork();
        }

        @Override
        public boolean isNetworkConnected(@NonNull Network network) {
            ConnectivityManager connectivityManager = this.getConnectivityManager();
            if (connectivityManager == null) {
                return false;
            }
            NetworkInfo ni = connectivityManager.getNetworkInfo(network);
            return ni != null && ni.isConnected();
        }

        private synchronized ConnectivityManager getConnectivityManager() {
            if (this.mConnectivityManager == null) {
                this.mConnectivityManager = this.mContext.getSystemService(ConnectivityManager.class);
            }
            if (this.mConnectivityManager == null) {
                // empty if block
            }
            return this.mConnectivityManager;
        }

        @Override
        @Nullable
        public TimeResult queryNtpServer(@NonNull Network network, @NonNull URI ntpServerUri, @NonNull Duration timeout) {
            int timeoutMillis;
            int port;
            SntpClient client = new SntpClient();
            String serverName = ntpServerUri.getHost();
            if (client.requestTime(serverName, port = ntpServerUri.getPort() == -1 ? 123 : ntpServerUri.getPort(), timeoutMillis = NtpTrustedTimeImpl.saturatedCast(timeout.toMillis()), network)) {
                int ntpUncertaintyMillis = NtpTrustedTimeImpl.saturatedCast(client.getRoundTripTime() / 2L);
                InetSocketAddress ntpServerSocketAddress = client.getServerSocketAddress();
                return new TimeResult(client.getNtpTime(), client.getNtpTimeReference(), ntpUncertaintyMillis, ntpServerSocketAddress);
            }
            return null;
        }

        private static int saturatedCast(long longValue) {
            if (longValue > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (longValue < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)longValue;
        }
    }

    public static class NtpConfig {
        @NonNull
        private final List<URI> mServerUris;
        @NonNull
        private final Duration mTimeout;

        public NtpConfig(@NonNull List<URI> serverUris, @NonNull Duration timeout) throws IllegalArgumentException {
            Objects.requireNonNull(serverUris);
            if (serverUris.isEmpty()) {
                throw new IllegalArgumentException("Server URIs is empty");
            }
            ArrayList<URI> validatedServerUris = new ArrayList<URI>();
            for (URI serverUri : serverUris) {
                try {
                    URI validatedServerUri = NtpTrustedTime.validateNtpServerUri(Objects.requireNonNull(serverUri));
                    validatedServerUris.add(validatedServerUri);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Bad server URI", e);
                }
            }
            this.mServerUris = Collections.unmodifiableList(validatedServerUris);
            if (timeout.isNegative() || timeout.isZero()) {
                throw new IllegalArgumentException("timeout < 0");
            }
            this.mTimeout = timeout;
        }

        @NonNull
        public List<URI> getServerUris() {
            return this.mServerUris;
        }

        @NonNull
        public Duration getTimeout() {
            return this.mTimeout;
        }

        public String toString() {
            return "NtpConnectionInfo{mServerUris=" + this.mServerUris + ", mTimeout=" + this.mTimeout + '}';
        }
    }

    public static class TimeResult {
        private final long mUnixEpochTimeMillis;
        private final long mElapsedRealtimeMillis;
        private final int mUncertaintyMillis;
        @NonNull
        private final InetSocketAddress mNtpServerSocketAddress;

        public TimeResult(long unixEpochTimeMillis, long elapsedRealtimeMillis, int uncertaintyMillis, @NonNull InetSocketAddress ntpServerSocketAddress) {
            this.mUnixEpochTimeMillis = unixEpochTimeMillis;
            this.mElapsedRealtimeMillis = elapsedRealtimeMillis;
            this.mUncertaintyMillis = uncertaintyMillis;
            this.mNtpServerSocketAddress = Objects.requireNonNull(ntpServerSocketAddress);
        }

        public long getTimeMillis() {
            return this.mUnixEpochTimeMillis;
        }

        public long getElapsedRealtimeMillis() {
            return this.mElapsedRealtimeMillis;
        }

        public int getUncertaintyMillis() {
            return this.mUncertaintyMillis;
        }

        public long currentTimeMillis() {
            return this.mUnixEpochTimeMillis + this.getAgeMillis();
        }

        public long getAgeMillis() {
            return this.getAgeMillis(SystemClock.elapsedRealtime());
        }

        public long getAgeMillis(long currentElapsedRealtimeMillis) {
            return currentElapsedRealtimeMillis - this.mElapsedRealtimeMillis;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeResult)) {
                return false;
            }
            TimeResult that = (TimeResult)o;
            return this.mUnixEpochTimeMillis == that.mUnixEpochTimeMillis && this.mElapsedRealtimeMillis == that.mElapsedRealtimeMillis && this.mUncertaintyMillis == that.mUncertaintyMillis && this.mNtpServerSocketAddress.equals(that.mNtpServerSocketAddress);
        }

        public int hashCode() {
            return Objects.hash(this.mUnixEpochTimeMillis, this.mElapsedRealtimeMillis, this.mUncertaintyMillis, this.mNtpServerSocketAddress);
        }

        public String toString() {
            return "TimeResult{unixEpochTime=" + Instant.ofEpochMilli(this.mUnixEpochTimeMillis) + ", elapsedRealtime=" + Duration.ofMillis(this.mElapsedRealtimeMillis) + ", mUncertaintyMillis=" + this.mUncertaintyMillis + ", mNtpServerSocketAddress=" + this.mNtpServerSocketAddress + '}';
        }
    }
}

