/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.view.View;

@RavenwoodKeepWholeClass
public class URLSpan
extends ClickableSpan
implements ParcelableSpan {
    private final String mURL;

    public URLSpan(String url) {
        this.mURL = url;
    }

    public URLSpan(@NonNull Parcel src) {
        this.mURL = src.readString();
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 11;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mURL);
    }

    public String getURL() {
        return this.mURL;
    }

    @Override
    public void onClick(View widget) {
        Uri uri = Uri.parse(this.getURL());
        Context context = widget.getContext();
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.putExtra("com.android.browser.application_id", context.getPackageName());
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w("URLSpan", "Activity was not found for intent, " + intent.toString());
        }
    }

    @Override
    public String toString() {
        return "URLSpan{URL='" + this.getURL() + '\'' + '}';
    }
}

