/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.LeakyTypefaceStorage;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

@RavenwoodKeepWholeClass
public class TypefaceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    @Nullable
    private final String mFamily;
    @Nullable
    private final Typeface mTypeface;

    public TypefaceSpan(@Nullable String family) {
        this(family, null);
    }

    public TypefaceSpan(@NonNull Typeface typeface) {
        this(null, typeface);
    }

    public TypefaceSpan(@NonNull Parcel src) {
        this.mFamily = src.readString();
        this.mTypeface = LeakyTypefaceStorage.readTypefaceFromParcel(src);
    }

    private TypefaceSpan(@Nullable String family, @Nullable Typeface typeface) {
        this.mFamily = family;
        this.mTypeface = typeface;
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 13;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mFamily);
        LeakyTypefaceStorage.writeTypefaceToParcel(this.mTypeface, dest);
    }

    @Nullable
    public String getFamily() {
        return this.mFamily;
    }

    @Nullable
    public Typeface getTypeface() {
        return this.mTypeface;
    }

    @Override
    public void updateDrawState(@NonNull TextPaint ds) {
        this.updateTypeface(ds);
    }

    @Override
    public void updateMeasureState(@NonNull TextPaint paint) {
        this.updateTypeface(paint);
    }

    private void updateTypeface(@NonNull Paint paint) {
        if (this.mTypeface != null) {
            paint.setTypeface(this.mTypeface);
        } else if (this.mFamily != null) {
            this.applyFontFamily(paint, this.mFamily);
        }
    }

    private void applyFontFamily(@NonNull Paint paint, @NonNull String family) {
        Typeface styledTypeface;
        Typeface old = paint.getTypeface();
        int style2 = old == null ? 0 : old.getStyle();
        int fake = style2 & ~(styledTypeface = Typeface.create(family, style2)).getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(styledTypeface);
    }

    public String toString() {
        return "TypefaceSpan{family='" + this.getFamily() + '\'' + ", typeface=" + this.getTypeface() + '}';
    }
}

