/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.method.NumberKeyListener;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;

@RavenwoodKeepWholeClass
public class DateKeyListener
extends NumberKeyListener {
    private static final String SYMBOLS_TO_IGNORE = "yMLd";
    private static final String[] SKELETONS = new String[]{"yMd", "yM", "Md"};
    @Deprecated
    public static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', '-', '.'};
    private final char[] mCharacters;
    private final boolean mNeedsAdvancedInput;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static final HashMap<Locale, DateKeyListener> sInstanceCache = new HashMap();

    @Override
    public int getInputType() {
        if (this.mNeedsAdvancedInput) {
            return 1;
        }
        return 20;
    }

    @Override
    @NonNull
    protected char[] getAcceptedChars() {
        return this.mCharacters;
    }

    @Deprecated
    public DateKeyListener() {
        this(null);
    }

    public DateKeyListener(@Nullable Locale locale) {
        boolean success;
        LinkedHashSet<Character> chars = new LinkedHashSet<Character>();
        boolean bl = success = NumberKeyListener.addDigits(chars, locale) && NumberKeyListener.addFormatCharsFromSkeletons(chars, locale, SKELETONS, SYMBOLS_TO_IGNORE);
        if (success) {
            this.mCharacters = NumberKeyListener.collectionToArray(chars);
            this.mNeedsAdvancedInput = !ArrayUtils.containsAll(CHARACTERS, this.mCharacters);
        } else {
            this.mCharacters = CHARACTERS;
            this.mNeedsAdvancedInput = false;
        }
    }

    @Deprecated
    @NonNull
    public static DateKeyListener getInstance() {
        return DateKeyListener.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DateKeyListener getInstance(@Nullable Locale locale) {
        DateKeyListener instance;
        Object object = sLock;
        synchronized (object) {
            instance = sInstanceCache.get(locale);
            if (instance == null) {
                instance = new DateKeyListener(locale);
                sInstanceCache.put(locale, instance);
            }
        }
        return instance;
    }
}

