/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.Hide;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.TelephonyRegistryManager;
import android.telephony.satellite.EnableRequestAttributes;
import android.telephony.satellite.INtnSignalStrengthCallback;
import android.telephony.satellite.ISatelliteCapabilitiesCallback;
import android.telephony.satellite.ISatelliteCommunicationAccessStateCallback;
import android.telephony.satellite.ISatelliteDatagramCallback;
import android.telephony.satellite.ISatelliteDisallowedReasonsCallback;
import android.telephony.satellite.ISatelliteModemStateCallback;
import android.telephony.satellite.ISatelliteProvisionStateCallback;
import android.telephony.satellite.ISatelliteTransmissionUpdateCallback;
import android.telephony.satellite.ISelectedNbIotSatelliteSubscriptionCallback;
import android.telephony.satellite.NtnSignalStrength;
import android.telephony.satellite.NtnSignalStrengthCallback;
import android.telephony.satellite.PointingInfo;
import android.telephony.satellite.SatelliteAccessConfiguration;
import android.telephony.satellite.SatelliteCapabilities;
import android.telephony.satellite.SatelliteCapabilitiesCallback;
import android.telephony.satellite.SatelliteCommunicationAccessStateCallback;
import android.telephony.satellite.SatelliteDatagram;
import android.telephony.satellite.SatelliteDatagramCallback;
import android.telephony.satellite.SatelliteDisallowedReasonsCallback;
import android.telephony.satellite.SatelliteModemStateCallback;
import android.telephony.satellite.SatelliteProvisionStateCallback;
import android.telephony.satellite.SatelliteSessionStats;
import android.telephony.satellite.SatelliteStateChangeListener;
import android.telephony.satellite.SatelliteSubscriberInfo;
import android.telephony.satellite.SatelliteSubscriberProvisionStatus;
import android.telephony.satellite.SatelliteTransmissionUpdateCallback;
import android.telephony.satellite.SelectedNbIotSatelliteSubscriptionCallback;
import com.android.internal.telephony.IBooleanConsumer;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.IVoidConsumer;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@FlaggedApi(value="com.android.internal.telephony.flags.satellite_state_change_listener")
public class SatelliteManager {
    private static final String TAG = "SatelliteManager";
    private static final ConcurrentHashMap<SatelliteDatagramCallback, ISatelliteDatagramCallback> sSatelliteDatagramCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteProvisionStateCallback, ISatelliteProvisionStateCallback> sSatelliteProvisionStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteModemStateCallback, ISatelliteModemStateCallback> sSatelliteModemStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteTransmissionUpdateCallback, ISatelliteTransmissionUpdateCallback> sSatelliteTransmissionUpdateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<NtnSignalStrengthCallback, INtnSignalStrengthCallback> sNtnSignalStrengthCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteCapabilitiesCallback, ISatelliteCapabilitiesCallback> sSatelliteCapabilitiesCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Consumer<Boolean>, IBooleanConsumer> sSatelliteSupportedStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteCommunicationAccessStateCallback, ISatelliteCommunicationAccessStateCallback> sSatelliteCommunicationAccessStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteDisallowedReasonsCallback, ISatelliteDisallowedReasonsCallback> sSatelliteDisallowedReasonsCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SelectedNbIotSatelliteSubscriptionCallback, ISelectedNbIotSatelliteSubscriptionCallback> sSelectedNbIotSatelliteSubscriptionCallbackMap = new ConcurrentHashMap();
    private final int mSubId;
    @Nullable
    private final Context mContext;
    private TelephonyRegistryManager mTelephonyRegistryMgr;
    public static final String KEY_SATELLITE_ENABLED = "satellite_enabled";
    public static final String KEY_DEMO_MODE_ENABLED = "demo_mode_enabled";
    public static final String KEY_EMERGENCY_MODE_ENABLED = "emergency_mode_enabled";
    public static final String KEY_SATELLITE_SUPPORTED = "satellite_supported";
    public static final String KEY_SATELLITE_CAPABILITIES = "satellite_capabilities";
    public static final String KEY_SESSION_STATS = "session_stats";
    public static final String KEY_SESSION_STATS_V2 = "session_stats_v2";
    public static final String KEY_SATELLITE_PROVISIONED = "satellite_provisioned";
    public static final String KEY_SATELLITE_COMMUNICATION_ALLOWED = "satellite_communication_allowed";
    public static final String KEY_SATELLITE_NEXT_VISIBILITY = "satellite_next_visibility";
    public static final String KEY_NTN_SIGNAL_STRENGTH = "ntn_signal_strength";
    public static final String KEY_REQUEST_PROVISION_SUBSCRIBER_ID_TOKEN = "request_provision_subscriber_id";
    public static final String KEY_PROVISION_SATELLITE_TOKENS = "provision_satellite";
    public static final String KEY_DEPROVISION_SATELLITE_TOKENS = "deprovision_satellite";
    public static final String KEY_SATELLITE_ACCESS_CONFIGURATION = "satellite_access_configuration";
    public static final String KEY_SATELLITE_DISPLAY_NAME = "satellite_display_name";
    public static final String KEY_SELECTED_NB_IOT_SATELLITE_SUBSCRIPTION_ID = "selected_nb_iot_satellite_subscription_id";
    @SystemApi
    public static final int SATELLITE_RESULT_SUCCESS = 0;
    @SystemApi
    public static final int SATELLITE_RESULT_ERROR = 1;
    @SystemApi
    public static final int SATELLITE_RESULT_SERVER_ERROR = 2;
    @SystemApi
    public static final int SATELLITE_RESULT_SERVICE_ERROR = 3;
    @SystemApi
    public static final int SATELLITE_RESULT_MODEM_ERROR = 4;
    @SystemApi
    public static final int SATELLITE_RESULT_NETWORK_ERROR = 5;
    @SystemApi
    public static final int SATELLITE_RESULT_INVALID_TELEPHONY_STATE = 6;
    @SystemApi
    public static final int SATELLITE_RESULT_INVALID_MODEM_STATE = 7;
    @SystemApi
    public static final int SATELLITE_RESULT_INVALID_ARGUMENTS = 8;
    @SystemApi
    public static final int SATELLITE_RESULT_REQUEST_FAILED = 9;
    @SystemApi
    public static final int SATELLITE_RESULT_RADIO_NOT_AVAILABLE = 10;
    @SystemApi
    public static final int SATELLITE_RESULT_REQUEST_NOT_SUPPORTED = 11;
    @SystemApi
    public static final int SATELLITE_RESULT_NO_RESOURCES = 12;
    @SystemApi
    public static final int SATELLITE_RESULT_SERVICE_NOT_PROVISIONED = 13;
    @SystemApi
    public static final int SATELLITE_RESULT_SERVICE_PROVISION_IN_PROGRESS = 14;
    @SystemApi
    public static final int SATELLITE_RESULT_REQUEST_ABORTED = 15;
    @SystemApi
    public static final int SATELLITE_RESULT_ACCESS_BARRED = 16;
    @SystemApi
    public static final int SATELLITE_RESULT_NETWORK_TIMEOUT = 17;
    @SystemApi
    public static final int SATELLITE_RESULT_NOT_REACHABLE = 18;
    @SystemApi
    public static final int SATELLITE_RESULT_NOT_AUTHORIZED = 19;
    @SystemApi
    public static final int SATELLITE_RESULT_NOT_SUPPORTED = 20;
    @SystemApi
    public static final int SATELLITE_RESULT_REQUEST_IN_PROGRESS = 21;
    @SystemApi
    public static final int SATELLITE_RESULT_MODEM_BUSY = 22;
    @SystemApi
    public static final int SATELLITE_RESULT_ILLEGAL_STATE = 23;
    @SystemApi
    public static final int SATELLITE_RESULT_MODEM_TIMEOUT = 24;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_LOCATION_DISABLED = 25;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_LOCATION_NOT_AVAILABLE = 26;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_EMERGENCY_CALL_IN_PROGRESS = 27;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_DISABLE_IN_PROGRESS = 28;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_ENABLE_IN_PROGRESS = 29;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_RESULT_NO_VALID_SATELLITE_SUBSCRIPTION = 30;
    @SystemApi
    public static final int NT_RADIO_TECHNOLOGY_UNKNOWN = 0;
    @SystemApi
    public static final int NT_RADIO_TECHNOLOGY_NB_IOT_NTN = 1;
    @SystemApi
    public static final int NT_RADIO_TECHNOLOGY_NR_NTN = 2;
    @SystemApi
    public static final int NT_RADIO_TECHNOLOGY_EMTC_NTN = 3;
    @SystemApi
    public static final int NT_RADIO_TECHNOLOGY_PROPRIETARY = 4;
    @SystemApi
    public static final int DEVICE_HOLD_POSITION_UNKNOWN = 0;
    @SystemApi
    public static final int DEVICE_HOLD_POSITION_PORTRAIT = 1;
    @SystemApi
    public static final int DEVICE_HOLD_POSITION_LANDSCAPE_LEFT = 2;
    @SystemApi
    public static final int DEVICE_HOLD_POSITION_LANDSCAPE_RIGHT = 3;
    @SystemApi
    public static final int DISPLAY_MODE_UNKNOWN = 0;
    @SystemApi
    public static final int DISPLAY_MODE_FIXED = 1;
    @SystemApi
    public static final int DISPLAY_MODE_OPENED = 2;
    @SystemApi
    public static final int DISPLAY_MODE_CLOSED = 3;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public static final int SATELLITE_DATA_SUPPORT_UNKNOWN = -1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public static final int SATELLITE_DATA_SUPPORT_RESTRICTED = 0;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public static final int SATELLITE_DATA_SUPPORT_CONSTRAINED = 1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public static final int SATELLITE_DATA_SUPPORT_UNCONSTRAINED = 2;
    @SystemApi
    public static final int EMERGENCY_CALL_TO_SATELLITE_HANDOVER_TYPE_SOS = 1;
    @SystemApi
    public static final int EMERGENCY_CALL_TO_SATELLITE_HANDOVER_TYPE_T911 = 2;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final String ACTION_SATELLITE_SUBSCRIBER_ID_LIST_CHANGED = "android.telephony.satellite.action.SATELLITE_SUBSCRIBER_ID_LIST_CHANGED";
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final String ACTION_SATELLITE_START_NON_EMERGENCY_SESSION = "android.telephony.satellite.action.SATELLITE_START_NON_EMERGENCY_SESSION";
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final String PROPERTY_SATELLITE_MANUAL_CONNECT_P2P_SUPPORT = "android.telephony.satellite.PROPERTY_SATELLITE_MANUAL_CONNECT_P2P_SUPPORT";
    public static final String METADATA_SATELLITE_MANUAL_CONNECT_P2P_SUPPORT = "android.telephony.METADATA_SATELLITE_MANUAL_CONNECT_P2P_SUPPORT";
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public static final String PROPERTY_SATELLITE_DATA_OPTIMIZED = "android.telephony.PROPERTY_SATELLITE_DATA_OPTIMIZED";
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_IDLE = 0;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SENDING = 1;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SEND_SUCCESS = 2;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SEND_FAILED = 3;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVING = 4;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_SUCCESS = 5;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_NONE = 6;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_FAILED = 7;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_WAITING_TO_CONNECT = 8;
    @SystemApi
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_UNKNOWN = -1;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_IDLE = 0;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_LISTENING = 1;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_DATAGRAM_TRANSFERRING = 2;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_DATAGRAM_RETRYING = 3;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_OFF = 4;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_UNAVAILABLE = 5;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_NOT_CONNECTED = 6;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_CONNECTED = 7;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_MODEM_STATE_ENABLING_SATELLITE = 8;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_MODEM_STATE_DISABLING_SATELLITE = 9;
    @SystemApi
    public static final int SATELLITE_MODEM_STATE_UNKNOWN = -1;
    @SystemApi
    public static final int DATAGRAM_TYPE_UNKNOWN = 0;
    @SystemApi
    public static final int DATAGRAM_TYPE_SOS_MESSAGE = 1;
    @SystemApi
    public static final int DATAGRAM_TYPE_LOCATION_SHARING = 2;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int DATAGRAM_TYPE_KEEP_ALIVE = 3;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int DATAGRAM_TYPE_LAST_SOS_MESSAGE_STILL_NEED_HELP = 4;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int DATAGRAM_TYPE_LAST_SOS_MESSAGE_NO_HELP_NEEDED = 5;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int DATAGRAM_TYPE_SMS = 6;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int DATAGRAM_TYPE_CHECK_PENDING_INCOMING_SMS = 7;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public static final int SATELLITE_COMMUNICATION_RESTRICTION_REASON_USER = 0;
    @SystemApi
    public static final int SATELLITE_COMMUNICATION_RESTRICTION_REASON_GEOLOCATION = 1;
    @SystemApi
    public static final int SATELLITE_COMMUNICATION_RESTRICTION_REASON_ENTITLEMENT = 2;
    public static final int SATELLITE_DISALLOWED_REASON_NOT_SUPPORTED = 0;
    public static final int SATELLITE_DISALLOWED_REASON_NOT_PROVISIONED = 1;
    public static final int SATELLITE_DISALLOWED_REASON_NOT_IN_ALLOWED_REGION = 2;
    public static final int SATELLITE_DISALLOWED_REASON_UNSUPPORTED_DEFAULT_MSG_APP = 3;
    public static final int SATELLITE_DISALLOWED_REASON_LOCATION_DISABLED = 4;

    public SatelliteManager(@Nullable Context context) {
        this(context, Integer.MAX_VALUE);
    }

    private SatelliteManager(@Nullable Context context, int subId) {
        this.mContext = context;
        this.mSubId = subId;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_state_change_listener")
    @RequiresPermission(anyOf={"android.permission.READ_BASIC_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE", "carrier privileges"})
    public void registerStateChangeListener(@NonNull Executor executor, @NonNull SatelliteStateChangeListener listener) {
        if (this.mContext == null) {
            throw new IllegalStateException("Telephony service is null");
        }
        this.mTelephonyRegistryMgr = this.mContext.getSystemService(TelephonyRegistryManager.class);
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("Telephony registry service is null");
        }
        this.mTelephonyRegistryMgr.addSatelliteStateChangeListener(executor, listener);
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_state_change_listener")
    @RequiresPermission(anyOf={"android.permission.READ_BASIC_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE", "carrier privileges"})
    public void unregisterStateChangeListener(@NonNull SatelliteStateChangeListener listener) {
        if (this.mContext == null) {
            throw new IllegalStateException("Telephony service is null");
        }
        this.mTelephonyRegistryMgr = this.mContext.getSystemService(TelephonyRegistryManager.class);
        if (this.mTelephonyRegistryMgr == null) {
            throw new IllegalStateException("Telephony registry service is null");
        }
        this.mTelephonyRegistryMgr.removeSatelliteStateChangeListener(listener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestEnabled(@NonNull EnableRequestAttributes attributes, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(attributes);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.requestSatelliteEnabled(attributes.isEnabled(), attributes.isDemoMode(), attributes.isEmergencyMode(), errorCallback);
            } else {
                Rlog.e(TAG, "requestEnabled() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "requestEnabled() exception: ", ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsEnabled(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_ENABLED)) {
                                boolean isSatelliteEnabled = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_ENABLED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteEnabled)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_ENABLED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsSatelliteEnabled(receiver);
            } else {
                SatelliteManager.loge("requestIsEnabled() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsEnabled() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsDemoModeEnabled(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_DEMO_MODE_ENABLED)) {
                                boolean isDemoModeEnabled = resultData.getBoolean(SatelliteManager.KEY_DEMO_MODE_ENABLED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isDemoModeEnabled)));
                            } else {
                                SatelliteManager.loge("KEY_DEMO_MODE_ENABLED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsDemoModeEnabled(receiver);
            } else {
                SatelliteManager.loge("requestIsDemoModeEnabled() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsDemoModeEnabled() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsEmergencyModeEnabled(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_EMERGENCY_MODE_ENABLED)) {
                                boolean isEmergencyModeEnabled = resultData.getBoolean(SatelliteManager.KEY_EMERGENCY_MODE_ENABLED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isEmergencyModeEnabled)));
                            } else {
                                SatelliteManager.loge("KEY_EMERGENCY_MODE_ENABLED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsEmergencyModeEnabled(receiver);
            } else {
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsEmergencyModeEnabled() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    public void requestIsSupported(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_SUPPORTED)) {
                                boolean isSatelliteSupported = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_SUPPORTED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteSupported)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_SUPPORTED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsSatelliteSupported(receiver);
            } else {
                SatelliteManager.loge("requestIsSupported() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsSupported() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestCapabilities(final @NonNull Executor executor, final @NonNull OutcomeReceiver<SatelliteCapabilities, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_CAPABILITIES)) {
                                SatelliteCapabilities capabilities = resultData.getParcelable(SatelliteManager.KEY_SATELLITE_CAPABILITIES, SatelliteCapabilities.class);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(capabilities)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_CAPABILITIES does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSatelliteCapabilities(receiver);
            } else {
                SatelliteManager.loge("requestCapabilities() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestCapabilities() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void startTransmissionUpdates(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener, final @NonNull SatelliteTransmissionUpdateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                ISatelliteTransmissionUpdateCallback.Stub internalCallback = new ISatelliteTransmissionUpdateCallback.Stub(this){

                    @Override
                    public void onSatellitePositionChanged(PointingInfo pointingInfo) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatellitePositionChanged(pointingInfo)));
                    }

                    @Override
                    public void onSendDatagramStateChanged(int datagramType, int state, int sendPendingCount, int errorCode) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSendDatagramStateChanged(datagramType, state, sendPendingCount, errorCode)));
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSendDatagramStateChanged(state, sendPendingCount, errorCode)));
                    }

                    @Override
                    public void onReceiveDatagramStateChanged(int state, int receivePendingCount, int errorCode) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onReceiveDatagramStateChanged(state, receivePendingCount, errorCode)));
                    }

                    @Override
                    public void onSendDatagramRequested(int datagramType) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSendDatagramRequested(datagramType)));
                    }
                };
                sSatelliteTransmissionUpdateCallbackMap.put(callback, internalCallback);
                telephony.startSatelliteTransmissionUpdates(errorCallback, internalCallback);
            } else {
                SatelliteManager.loge("startTransmissionUpdates() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("startTransmissionUpdates() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void stopTransmissionUpdates(@NonNull SatelliteTransmissionUpdateCallback callback, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        ISatelliteTransmissionUpdateCallback internalCallback = sSatelliteTransmissionUpdateCallbackMap.remove(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                if (internalCallback != null) {
                    IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                        @Override
                        public void accept(int result) {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                        }
                    };
                    telephony.stopSatelliteTransmissionUpdates(errorCallback, internalCallback);
                } else {
                    SatelliteManager.loge("stopSatelliteTransmissionUpdates: No internal callback.");
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(8)));
                }
            } else {
                SatelliteManager.loge("stopTransmissionUpdates() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("stopTransmissionUpdates() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void provisionService(@NonNull String token, @NonNull byte[] provisionData, @Nullable CancellationSignal cancellationSignal, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        Objects.requireNonNull(provisionData);
        ICancellationSignal cancelRemote = null;
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                cancelRemote = telephony.provisionSatelliteService(token, provisionData, errorCallback);
            } else {
                SatelliteManager.loge("provisionService() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("provisionService() RemoteException=" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
        if (cancellationSignal != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void deprovisionService(@NonNull String token, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.deprovisionSatelliteService(token, errorCallback);
            } else {
                SatelliteManager.loge("deprovisionService() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("deprovisionService() RemoteException ex=" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForProvisionStateChanged(final @NonNull Executor executor, final @NonNull SatelliteProvisionStateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteProvisionStateCallback.Stub internalCallback = new ISatelliteProvisionStateCallback.Stub(this){

                    @Override
                    public void onSatelliteProvisionStateChanged(boolean provisioned) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteProvisionStateChanged(provisioned)));
                    }

                    @Override
                    @FlaggedApi(value="com.android.internal.telephony.flags.carrier_roaming_nb_iot_ntn")
                    public void onSatelliteSubscriptionProvisionStateChanged(@NonNull List<SatelliteSubscriberProvisionStatus> satelliteSubscriberProvisionStatus) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteSubscriptionProvisionStateChanged(satelliteSubscriberProvisionStatus)));
                    }
                };
                sSatelliteProvisionStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteProvisionStateChanged(internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForProvisionStateChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForProvisionStateChanged(@NonNull SatelliteProvisionStateCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteProvisionStateCallback internalCallback = sSatelliteProvisionStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSatelliteProvisionStateChanged(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForProvisionStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForProvisionStateChanged() RemoteException: " + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsProvisioned(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_PROVISIONED)) {
                                boolean isSatelliteProvisioned = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_PROVISIONED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteProvisioned)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_PROVISIONED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsSatelliteProvisioned(receiver);
            } else {
                SatelliteManager.loge("requestIsProvisioned() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsProvisioned() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForModemStateChanged(final @NonNull Executor executor, final @NonNull SatelliteModemStateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteModemStateCallback.Stub internalCallback = new ISatelliteModemStateCallback.Stub(this){

                    @Override
                    public void onSatelliteModemStateChanged(int state) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteModemStateChanged(state)));
                    }

                    @Override
                    public void onEmergencyModeChanged(boolean isEmergency) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onEmergencyModeChanged(isEmergency)));
                    }

                    @Override
                    @Hide
                    public void onRegistrationFailure(int causeCode) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onRegistrationFailure(causeCode)));
                    }

                    @Override
                    public void onTerrestrialNetworkAvailableChanged(boolean isAvailable) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onTerrestrialNetworkAvailableChanged(isAvailable)));
                    }
                };
                sSatelliteModemStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteModemStateChanged(internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForModemStateChanged() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForModemStateChanged(@NonNull SatelliteModemStateCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteModemStateCallback internalCallback = sSatelliteModemStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForModemStateChanged(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForModemStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForModemStateChanged() RemoteException:" + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForIncomingDatagram(final @NonNull Executor executor, final @NonNull SatelliteDatagramCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteDatagramCallback.Stub internalCallback = new ISatelliteDatagramCallback.Stub(this){

                    @Override
                    public void onSatelliteDatagramReceived(long datagramId, @NonNull SatelliteDatagram datagram, int pendingCount, final @NonNull IVoidConsumer internalAck) {
                        Consumer<Void> externalAck = new Consumer<Void>(){

                            @Override
                            public void accept(Void result) {
                                try {
                                    internalAck.accept();
                                }
                                catch (RemoteException e) {
                                    SatelliteManager.logd("onSatelliteDatagramReceived RemoteException: " + e);
                                }
                            }
                        };
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteDatagramReceived(datagramId, datagram, pendingCount, externalAck)));
                    }
                };
                sSatelliteDatagramCallbackMap.put(callback, internalCallback);
                return telephony.registerForIncomingDatagram(internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForIncomingDatagram() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForIncomingDatagram(@NonNull SatelliteDatagramCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteDatagramCallback internalCallback = sSatelliteDatagramCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForIncomingDatagram(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForIncomingDatagram: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForIncomingDatagram() RemoteException:" + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void pollPendingDatagrams(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.pollPendingDatagrams(internalCallback);
            } else {
                SatelliteManager.loge("pollPendingDatagrams() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("pollPendingDatagrams() RemoteException:" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void sendDatagram(int datagramType, @NonNull SatelliteDatagram datagram, boolean needFullScreenPointingUI, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(datagram);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.sendDatagram(datagramType, datagram, needFullScreenPointingUI, internalCallback);
            } else {
                SatelliteManager.loge("sendDatagram() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("sendDatagram() RemoteException:" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsCommunicationAllowedForCurrentLocation(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_COMMUNICATION_ALLOWED)) {
                                boolean isSatelliteCommunicationAllowed = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_COMMUNICATION_ALLOWED);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteCommunicationAllowed)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_COMMUNICATION_ALLOWED does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestIsCommunicationAllowedForCurrentLocation(this.mSubId, receiver);
            } else {
                SatelliteManager.loge("requestIsCommunicationAllowedForCurrentLocation() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsCommunicationAllowedForCurrentLocation() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void requestSatelliteAccessConfigurationForCurrentLocation(final @NonNull Executor executor, final @NonNull OutcomeReceiver<SatelliteAccessConfiguration, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_ACCESS_CONFIGURATION)) {
                                SatelliteAccessConfiguration satelliteAccessConfiguration = resultData.getParcelable(SatelliteManager.KEY_SATELLITE_ACCESS_CONFIGURATION, SatelliteAccessConfiguration.class);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(satelliteAccessConfiguration)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_ACCESS_CONFIGURATION does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSatelliteAccessConfigurationForCurrentLocation(receiver);
            } else {
                SatelliteManager.loge("requestSatelliteAccessConfigurationForCurrentLocation() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSatelliteAccessConfigurationForCurrentLocation() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestTimeForNextSatelliteVisibility(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Duration, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_NEXT_VISIBILITY)) {
                                int nextVisibilityDuration = resultData.getInt(SatelliteManager.KEY_SATELLITE_NEXT_VISIBILITY);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(Duration.ofSeconds(nextVisibilityDuration))));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_NEXT_VISIBILITY does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestTimeForNextSatelliteVisibility(receiver);
            } else {
                SatelliteManager.loge("requestTimeForNextSatelliteVisibility() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestTimeForNextSatelliteVisibility() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestSelectedNbIotSatelliteSubscriptionId(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Integer, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SELECTED_NB_IOT_SATELLITE_SUBSCRIPTION_ID)) {
                                int selectedSatelliteSubscriptionId = resultData.getInt(SatelliteManager.KEY_SELECTED_NB_IOT_SATELLITE_SUBSCRIPTION_ID);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(selectedSatelliteSubscriptionId)));
                            } else {
                                SatelliteManager.loge("KEY_SELECTED_NB_IOT_SATELLITE_SUBSCRIPTION_ID does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSelectedNbIotSatelliteSubscriptionId(receiver);
            } else {
                SatelliteManager.loge("requestSelectedNbIotSatelliteSubscriptionId() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSelectedNbIotSatelliteSubscriptionId() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForSelectedNbIotSatelliteSubscriptionChanged(final @NonNull Executor executor, final @NonNull SelectedNbIotSatelliteSubscriptionCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISelectedNbIotSatelliteSubscriptionCallback.Stub internalCallback = new ISelectedNbIotSatelliteSubscriptionCallback.Stub(this){

                    @Override
                    public void onSelectedNbIotSatelliteSubscriptionChanged(int selectedSubId) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSelectedNbIotSatelliteSubscriptionChanged(selectedSubId)));
                    }
                };
                sSelectedNbIotSatelliteSubscriptionCallbackMap.put(callback, internalCallback);
                return telephony.registerForSelectedNbIotSatelliteSubscriptionChanged(internalCallback);
            }
            throw new IllegalStateException("Telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSelectedNbIotSatelliteSubscriptionChanged() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
            return 9;
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForSelectedNbIotSatelliteSubscriptionChanged(@NonNull SelectedNbIotSatelliteSubscriptionCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISelectedNbIotSatelliteSubscriptionCallback internalCallback = sSelectedNbIotSatelliteSubscriptionCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSelectedNbIotSatelliteSubscriptionChanged(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForSelectedNbIotSatelliteSubscriptionChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("Telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForSelectedNbIotSatelliteSubscriptionChanged() RemoteException: " + ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void setDeviceAlignedWithSatellite(boolean isAligned) {
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.setDeviceAlignedWithSatellite(isAligned);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("setDeviceAlignedWithSatellite() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestAttachEnabledForCarrier(int subId, boolean enableSatellite, @NonNull Executor executor, @NonNull Consumer<Integer> resultListener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        if (enableSatellite) {
            this.removeAttachRestrictionForCarrier(subId, 0, executor, resultListener);
        } else {
            this.addAttachRestrictionForCarrier(subId, 0, executor, resultListener);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsAttachEnabledForCarrier(int subId, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Set<Integer> restrictionReason = this.getAttachRestrictionReasonsForCarrier(subId);
        executor.execute(() -> callback.onResult(!restrictionReason.contains(0)));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void addAttachRestrictionForCarrier(int subId, int reason, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.addAttachRestrictionForCarrier(subId, reason, errorCallback);
            } else {
                SatelliteManager.loge("addAttachRestrictionForCarrier() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("addAttachRestrictionForCarrier() RemoteException:" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void removeAttachRestrictionForCarrier(int subId, int reason, final @NonNull Executor executor, final @NonNull Consumer<Integer> resultListener) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(this){

                    @Override
                    public void accept(int result) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                    }
                };
                telephony.removeAttachRestrictionForCarrier(subId, reason, errorCallback);
            } else {
                SatelliteManager.loge("removeAttachRestrictionForCarrier() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("removeAttachRestrictionForCarrier() RemoteException:" + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(23)));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @NonNull
    public Set<Integer> getAttachRestrictionReasonsForCarrier(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                int[] receivedArray = telephony.getAttachRestrictionReasonsForCarrier(subId);
                if (receivedArray.length == 0) {
                    SatelliteManager.logd("receivedArray is empty, create empty set");
                    return new HashSet<Integer>();
                }
                return Arrays.stream(receivedArray).boxed().collect(Collectors.toSet());
            }
            throw new IllegalStateException("Telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("getAttachRestrictionReasonsForCarrier() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return new HashSet<Integer>();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @NonNull
    public int[] getSatelliteDisallowedReasons() {
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                return telephony.getSatelliteDisallowedReasons();
            }
            throw new IllegalStateException("Telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("getSatelliteDisallowedReasons() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return new int[0];
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void registerForSatelliteDisallowedReasonsChanged(final @NonNull Executor executor, final @NonNull SatelliteDisallowedReasonsCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("Telephony service is null.");
            }
            ISatelliteDisallowedReasonsCallback.Stub internalCallback = new ISatelliteDisallowedReasonsCallback.Stub(this){

                @Override
                public void onSatelliteDisallowedReasonsChanged(int[] disallowedReasons) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteDisallowedReasonsChanged(disallowedReasons)));
                }
            };
            telephony.registerForSatelliteDisallowedReasonsChanged(internalCallback);
            sSatelliteDisallowedReasonsCallbackMap.put(callback, internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSatelliteDisallowedReasonsChanged() RemoteException" + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void unregisterForSatelliteDisallowedReasonsChanged(@NonNull SatelliteDisallowedReasonsCallback callback) {
        Objects.requireNonNull(callback);
        ISatelliteDisallowedReasonsCallback internalCallback = sSatelliteDisallowedReasonsCallbackMap.remove(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                if (internalCallback == null) {
                    SatelliteManager.loge("unregisterForSatelliteDisallowedReasonsChanged: No internal callback.");
                    throw new IllegalArgumentException("callback is not valid");
                }
            } else {
                throw new IllegalStateException("Telephony service is null.");
            }
            telephony.unregisterForSatelliteDisallowedReasonsChanged(internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("unregisterForSatelliteDisallowedReasonsChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestNtnSignalStrength(final @NonNull Executor executor, final @NonNull OutcomeReceiver<NtnSignalStrength, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_NTN_SIGNAL_STRENGTH)) {
                                NtnSignalStrength ntnSignalStrength = resultData.getParcelable(SatelliteManager.KEY_NTN_SIGNAL_STRENGTH, NtnSignalStrength.class);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(ntnSignalStrength)));
                            } else {
                                SatelliteManager.loge("KEY_NTN_SIGNAL_STRENGTH does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestNtnSignalStrength(receiver);
            } else {
                SatelliteManager.loge("requestNtnSignalStrength() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestNtnSignalStrength() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void registerForNtnSignalStrengthChanged(final @NonNull Executor executor, final @NonNull NtnSignalStrengthCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("Telephony service is null.");
            }
            INtnSignalStrengthCallback.Stub internalCallback = new INtnSignalStrengthCallback.Stub(this){

                @Override
                public void onNtnSignalStrengthChanged(NtnSignalStrength ntnSignalStrength) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onNtnSignalStrengthChanged(ntnSignalStrength)));
                }
            };
            telephony.registerForNtnSignalStrengthChanged(internalCallback);
            sNtnSignalStrengthCallbackMap.put(callback, internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForNtnSignalStrengthChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForNtnSignalStrengthChanged(@NonNull NtnSignalStrengthCallback callback) {
        Objects.requireNonNull(callback);
        INtnSignalStrengthCallback internalCallback = sNtnSignalStrengthCallbackMap.remove(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                if (internalCallback == null) {
                    SatelliteManager.loge("unregisterForNtnSignalStrengthChanged: No internal callback.");
                    throw new IllegalArgumentException("callback is not valid");
                }
            } else {
                throw new IllegalStateException("Telephony service is null.");
            }
            telephony.unregisterForNtnSignalStrengthChanged(internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("unregisterForNtnSignalStrengthChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForCapabilitiesChanged(final @NonNull Executor executor, final @NonNull SatelliteCapabilitiesCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteCapabilitiesCallback.Stub internalCallback = new ISatelliteCapabilitiesCallback.Stub(this){

                    @Override
                    public void onSatelliteCapabilitiesChanged(SatelliteCapabilities capabilities) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteCapabilitiesChanged(capabilities)));
                    }
                };
                sSatelliteCapabilitiesCallbackMap.put(callback, internalCallback);
                return telephony.registerForCapabilitiesChanged(internalCallback);
            }
            throw new IllegalStateException("Telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForCapabilitiesChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForCapabilitiesChanged(@NonNull SatelliteCapabilitiesCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteCapabilitiesCallback internalCallback = sSatelliteCapabilitiesCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForCapabilitiesChanged(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForCapabilitiesChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("Telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForCapabilitiesChanged() RemoteException: " + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @NonNull
    public List<String> getSatellitePlmnsForCarrier(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                return telephony.getSatellitePlmnsForCarrier(subId);
            }
            throw new IllegalStateException("Telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("getSatellitePlmnsForCarrier() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return new ArrayList<String>();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForSupportedStateChanged(final @NonNull Executor executor, final @NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                IBooleanConsumer.Stub internalCallback = new IBooleanConsumer.Stub(this){

                    @Override
                    public void accept(boolean supported) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.accept(supported)));
                    }
                };
                sSatelliteSupportedStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteSupportedStateChanged(internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSupportedStateChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void unregisterForSupportedStateChanged(@NonNull Consumer<Boolean> callback) {
        block5: {
            Objects.requireNonNull(callback);
            IBooleanConsumer internalCallback = sSatelliteSupportedStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSatelliteSupportedStateChanged(internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForSupportedStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForSupportedStateChanged() RemoteException: " + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForCommunicationAccessStateChanged(final @NonNull Executor executor, final @NonNull SatelliteCommunicationAccessStateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteCommunicationAccessStateCallback.Stub internalCallback = new ISatelliteCommunicationAccessStateCallback.Stub(this){

                    @Override
                    public void onAccessAllowedStateChanged(boolean isAllowed) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onAccessAllowedStateChanged(isAllowed)));
                    }

                    @Override
                    public void onAccessConfigurationChanged(@Nullable SatelliteAccessConfiguration satelliteAccessConfiguration) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onAccessConfigurationChanged(satelliteAccessConfiguration)));
                    }
                };
                sSatelliteCommunicationAccessStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForCommunicationAccessStateChanged(this.mSubId, internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForCommunicationAccessStateChanged() RemoteException: " + ex);
            ex.rethrowAsRuntimeException();
            return 9;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void unregisterForCommunicationAccessStateChanged(@NonNull SatelliteCommunicationAccessStateCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteCommunicationAccessStateCallback internalCallback = sSatelliteCommunicationAccessStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForCommunicationAccessStateChanged(this.mSubId, internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForCommunicationAccessStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForCommunicationAccessStateChanged() RemoteException: " + ex);
                ex.rethrowAsRuntimeException();
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.PACKAGE_USAGE_STATS", "android.permission.MODIFY_PHONE_STATE"})
    public void requestSessionStats(final @NonNull Executor executor, final @NonNull OutcomeReceiver<SatelliteSessionStats, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SESSION_STATS)) {
                                SatelliteSessionStats stats = resultData.getParcelable(SatelliteManager.KEY_SESSION_STATS, SatelliteSessionStats.class);
                                if (resultData.containsKey(SatelliteManager.KEY_SESSION_STATS_V2)) {
                                    SatelliteSessionStats stats1 = resultData.getParcelable(SatelliteManager.KEY_SESSION_STATS_V2, SatelliteSessionStats.class);
                                    if (stats != null && stats1 != null) {
                                        stats.setSatelliteSessionStats(stats1.getSatelliteSessionStats());
                                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(stats)));
                                        return;
                                    }
                                } else {
                                    SatelliteManager.loge("KEY_SESSION_STATS_V2 does not exist.");
                                }
                            } else {
                                SatelliteManager.loge("KEY_SESSION_STATS does not exist.");
                            }
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSatelliteSessionStats(this.mSubId, receiver);
            } else {
                SatelliteManager.loge("requestSessionStats() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSessionStats() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void requestSatelliteSubscriberProvisionStatus(final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<SatelliteSubscriberProvisionStatus>, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_REQUEST_PROVISION_SUBSCRIBER_ID_TOKEN)) {
                                ArrayList<SatelliteSubscriberProvisionStatus> list = resultData.getParcelableArrayList(SatelliteManager.KEY_REQUEST_PROVISION_SUBSCRIBER_ID_TOKEN, SatelliteSubscriberProvisionStatus.class);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(list)));
                            } else {
                                SatelliteManager.loge("KEY_REQUEST_PROVISION_SUBSCRIBER_ID_TOKEN does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSatelliteSubscriberProvisionStatus(receiver);
            } else {
                SatelliteManager.loge("requestSatelliteSubscriberProvisionStatus() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSatelliteSubscriberProvisionStatus() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestSatelliteDisplayName(final @NonNull Executor executor, final @NonNull OutcomeReceiver<CharSequence, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_DISPLAY_NAME)) {
                                String satelliteDisplayName = resultData.getString(SatelliteManager.KEY_SATELLITE_DISPLAY_NAME);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(satelliteDisplayName)));
                            } else {
                                SatelliteManager.loge("KEY_SATELLITE_DISPLAY_NAME does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.requestSatelliteDisplayName(receiver);
            } else {
                SatelliteManager.loge("requestSatelliteDisplayName() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSatelliteDisplayName() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void provisionSatellite(@NonNull List<SatelliteSubscriberInfo> list, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_PROVISION_SATELLITE_TOKENS)) {
                                boolean isUpdated = resultData.getBoolean(SatelliteManager.KEY_PROVISION_SATELLITE_TOKENS);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(null)));
                            } else {
                                SatelliteManager.loge("KEY_REQUEST_PROVISION_TOKENS does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.provisionSatellite(list, receiver);
            } else {
                SatelliteManager.loge("provisionSatellite() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("provisionSatellite() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
    public void deprovisionSatellite(@NonNull List<SatelliteSubscriberInfo> list, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ResultReceiver receiver = new ResultReceiver(this, null){

                    @Override
                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        if (resultCode == 0) {
                            if (resultData.containsKey(SatelliteManager.KEY_DEPROVISION_SATELLITE_TOKENS)) {
                                boolean isUpdated = resultData.getBoolean(SatelliteManager.KEY_DEPROVISION_SATELLITE_TOKENS);
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(null)));
                            } else {
                                SatelliteManager.loge("KEY_DEPROVISION_SATELLITE_TOKENS does not exist.");
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                            }
                        } else {
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                        }
                    }
                };
                telephony.deprovisionSatellite(list, receiver);
            } else {
                SatelliteManager.loge("deprovisionSatellite() invalid telephony");
                executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
            }
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("deprovisionSatellite() RemoteException: " + ex);
            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(23))));
        }
    }

    @RequiresPermission(allOf={"android.permission.SATELLITE_COMMUNICATION", "android.permission.SEND_SMS"})
    public void setNtnSmsSupported(boolean ntnSmsSupported) {
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.setNtnSmsSupported(ntnSmsSupported);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("setNtnSmsSupported() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    @NonNull
    public List<String> getSatelliteDataOptimizedApps() {
        ArrayList<String> appsNames = new ArrayList();
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            appsNames = telephony.getSatelliteDataOptimizedApps();
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("getSatelliteDataOptimizedApps() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
        }
        return appsNames;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    @FlaggedApi(value="com.android.internal.telephony.flags.satellite_25q4_apis")
    public int getSatelliteDataSupportMode(int subId) {
        int satelliteMode = -1;
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            satelliteMode = telephony.getSatelliteDataSupportMode(subId);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("getSatelliteDataSupportMode() RemoteException:" + ex);
            ex.rethrowAsRuntimeException();
        }
        return satelliteMode;
    }

    @Nullable
    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        return binder;
    }

    private static void logd(@NonNull String log) {
        Rlog.d(TAG, log);
    }

    private static void loge(@NonNull String log) {
        Rlog.e(TAG, log);
    }

    @SystemApi
    public static class SatelliteException
    extends Exception {
        private final int mErrorCode;

        public SatelliteException(int errorCode) {
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteDisallowedReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteCommunicationRestrictionReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatagramType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteModemState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteDatagramTransferState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteDataSupportMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceHoldPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NTRadioTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteResult {
    }
}

