/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.Uri;
import android.os.RemoteException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.SipDetails;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.util.Log;
import com.android.internal.telephony.util.RemoteCallbackListExt;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ImsRegistrationImplBase {
    private static final String LOG_TAG = "ImsRegistrationImplBase";
    public static final int REGISTRATION_TECH_NONE = -1;
    public static final int REGISTRATION_TECH_LTE = 0;
    public static final int REGISTRATION_TECH_IWLAN = 1;
    public static final int REGISTRATION_TECH_CROSS_SIM = 2;
    public static final int REGISTRATION_TECH_NR = 3;
    public static final int REGISTRATION_TECH_3G = 4;
    public static final int REGISTRATION_TECH_MAX = 5;
    private static final int REGISTRATION_STATE_UNKNOWN = -1;
    public static final int REASON_UNKNOWN = 0;
    public static final int REASON_SIM_REMOVED = 1;
    public static final int REASON_SIM_REFRESH = 2;
    public static final int REASON_ALLOWED_NETWORK_TYPES_CHANGED = 3;
    public static final int REASON_NON_IMS_CAPABLE_NETWORK = 4;
    public static final int REASON_RADIO_POWER_OFF = 5;
    public static final int REASON_HANDOVER_FAILED = 6;
    public static final int REASON_VOPS_NOT_SUPPORTED = 7;
    private Executor mExecutor;
    private final IImsRegistration mBinder = new IImsRegistration.Stub(){

        @Override
        public int getRegistrationTechnology() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> ImsRegistrationImplBase.this.mRegistrationAttributes == null ? -1 : ImsRegistrationImplBase.this.mRegistrationAttributes.getRegistrationTechnology(), "getRegistrationTechnology");
        }

        @Override
        public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    ImsRegistrationImplBase.this.addRegistrationCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "addRegistrationCallback");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void addEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            this.executeMethodAsync(() -> {
                try {
                    ImsRegistrationImplBase.this.addEmergencyRegistrationCallback(c);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                }
            }, "addEmergencyRegistrationCallback");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
        }

        @Override
        public void removeEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            this.executeMethodAsync(() -> ImsRegistrationImplBase.this.removeEmergencyRegistrationCallback(c), "removeEmergencyRegistrationCallback");
        }

        @Override
        public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            this.executeMethodAsync(() -> ImsRegistrationImplBase.this.removeRegistrationCallback(c), "removeRegistrationCallback");
        }

        @Override
        public void triggerFullNetworkRegistration(int sipCode, String sipReason) {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.triggerFullNetworkRegistration(sipCode, sipReason), "triggerFullNetworkRegistration");
        }

        @Override
        public void triggerUpdateSipDelegateRegistration() {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.updateSipDelegateRegistration(), "triggerUpdateSipDelegateRegistration");
        }

        @Override
        public void triggerSipDelegateDeregistration() {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.triggerSipDelegateDeregistration(), "triggerSipDelegateDeregistration");
        }

        @Override
        public void triggerDeregistration(int reason) {
            this.executeMethodAsyncNoException(() -> ImsRegistrationImplBase.this.triggerDeregistration(reason), "triggerDeregistration");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private void executeMethodAsyncNoException(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsRegistrationImplBase.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsRegistrationImplBase.LOG_TAG, "ImsRegistrationImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
    };
    private final RemoteCallbackListExt<IImsRegistrationCallback> mCallbacks = new RemoteCallbackListExt();
    private final RemoteCallbackListExt<IImsRegistrationCallback> mEmergencyCallbacks = new RemoteCallbackListExt();
    private final Object mLock = new Object();
    private ImsRegistrationAttributes mRegistrationAttributes;
    private ImsRegistrationAttributes mEmergencyRegistrationAttributes;
    private int mRegistrationState = -1;
    private int mEmergencyRegistrationState = -1;
    private ImsReasonInfo mLastDisconnectCause = new ImsReasonInfo();
    private ImsReasonInfo mEmergencyLastDisconnectCause = new ImsReasonInfo();
    private int mLastDisconnectSuggestedAction = 0;
    private int mEmergencyLastDisconnectSuggestedAction = 0;
    private int mLastDisconnectRadioTech = -1;
    private int mEmergencyLastDisconnectRadioTech = -1;
    private Uri[] mUris = new Uri[0];
    private boolean mUrisSet = false;

    @SystemApi
    public ImsRegistrationImplBase() {
    }

    @SystemApi
    public ImsRegistrationImplBase(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    public IImsRegistration getBinder() {
        return this.mBinder;
    }

    private void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        this.mCallbacks.register(c);
        this.updateNewCallbackWithState(c, false);
    }

    private void removeRegistrationCallback(IImsRegistrationCallback c) {
        this.mCallbacks.unregister(c);
    }

    private void addEmergencyRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        this.mEmergencyCallbacks.register(c);
        this.updateNewCallbackWithState(c, true);
    }

    private void removeEmergencyRegistrationCallback(IImsRegistrationCallback c) {
        this.mEmergencyCallbacks.unregister(c);
    }

    @SystemApi
    public void updateSipDelegateRegistration() {
    }

    @SystemApi
    public void triggerSipDelegateDeregistration() {
    }

    @SystemApi
    public void triggerFullNetworkRegistration(int sipCode, @Nullable String sipReason) {
    }

    public void triggerDeregistration(int reason) {
    }

    @SystemApi
    public void onRegistered(int imsRadioTech) {
        this.onRegistered(new ImsRegistrationAttributes.Builder(imsRadioTech).build());
    }

    @SystemApi
    public void onRegistered(@NonNull ImsRegistrationAttributes attributes) {
        boolean isEmergency = this.isEmergency(attributes);
        if (isEmergency) {
            this.updateToEmergencyState(attributes, 2);
        } else {
            this.updateToState(attributes, 2);
        }
        this.broadcastToCallbacksLocked(c -> {
            try {
                c.onRegistered(attributes);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onRegistered(int, Set) - Skipping callback.");
            }
        }, isEmergency);
    }

    @SystemApi
    public void onRegistering(int imsRadioTech) {
        this.onRegistering(new ImsRegistrationAttributes.Builder(imsRadioTech).build());
    }

    @SystemApi
    public void onRegistering(@NonNull ImsRegistrationAttributes attributes) {
        boolean isEmergency = this.isEmergency(attributes);
        if (isEmergency) {
            this.updateToEmergencyState(attributes, 1);
        } else {
            this.updateToState(attributes, 1);
        }
        this.broadcastToCallbacksLocked(c -> {
            try {
                c.onRegistering(attributes);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onRegistering(int, Set) - Skipping callback.");
            }
        }, isEmergency);
    }

    @SystemApi
    public void onDeregistered(ImsReasonInfo info) {
        this.onDeregistered(info, 0, -1);
    }

    @SystemApi
    public void onDeregistered(@Nullable ImsReasonInfo info, int suggestedAction, int imsRadioTech) {
        ImsRegistrationAttributes attributes = this.mRegistrationAttributes != null ? new ImsRegistrationAttributes(imsRadioTech, this.mRegistrationAttributes.getTransportType(), this.mRegistrationAttributes.getAttributeFlags(), this.mRegistrationAttributes.getFeatureTags()) : new ImsRegistrationAttributes.Builder(imsRadioTech).build();
        this.onDeregistered(info, suggestedAction, attributes);
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public void onDeregistered(@Nullable ImsReasonInfo info, int suggestedAction, @NonNull ImsRegistrationAttributes attributes) {
        boolean isEmergency = this.isEmergency(attributes);
        int imsRadioTech = attributes.getRegistrationTechnology();
        if (isEmergency) {
            this.updateToDisconnectedEmergencyState(info, suggestedAction, imsRadioTech);
        } else {
            this.updateToDisconnectedState(info, suggestedAction, imsRadioTech);
        }
        ImsReasonInfo reasonInfo = info != null ? info : new ImsReasonInfo();
        this.broadcastToCallbacksLocked(c -> {
            try {
                c.onDeregistered(reasonInfo, suggestedAction, imsRadioTech);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onDeregistered() - Skipping callback.");
            }
        }, isEmergency);
    }

    @SystemApi
    public void onDeregistered(@Nullable ImsReasonInfo info, @NonNull SipDetails details) {
        this.onDeregistered(info, 0, -1, details);
    }

    @SystemApi
    public void onDeregistered(@Nullable ImsReasonInfo info, int suggestedAction, int imsRadioTech, @NonNull SipDetails details) {
        this.updateToDisconnectedState(info, suggestedAction, imsRadioTech);
        ImsReasonInfo reasonInfo = info != null ? info : new ImsReasonInfo();
        this.broadcastToCallbacksLocked(c -> {
            try {
                c.onDeregisteredWithDetails(reasonInfo, suggestedAction, imsRadioTech, details);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onDeregistered() - Skipping callback.");
            }
        }, false);
    }

    @SystemApi
    public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
        ImsRegistrationAttributes attributes = this.mRegistrationAttributes != null ? new ImsRegistrationAttributes(imsRadioTech, this.mRegistrationAttributes.getTransportType(), this.mRegistrationAttributes.getAttributeFlags(), this.mRegistrationAttributes.getFeatureTags()) : new ImsRegistrationAttributes.Builder(imsRadioTech).build();
        this.onTechnologyChangeFailed(info, attributes);
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.emergency_registration_state")
    public void onTechnologyChangeFailed(@Nullable ImsReasonInfo info, @NonNull ImsRegistrationAttributes attributes) {
        boolean isEmergency = this.isEmergency(attributes);
        int imsRadioTech = attributes.getRegistrationTechnology();
        ImsReasonInfo reasonInfo = info != null ? info : new ImsReasonInfo();
        this.broadcastToCallbacksLocked(c -> {
            try {
                c.onTechnologyChangeFailed(imsRadioTech, reasonInfo);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + "onTechnologyChangeFailed() - Skipping callback.");
            }
        }, isEmergency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void onSubscriberAssociatedUriChanged(Uri[] uris) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUris = ArrayUtils.cloneOrNull(uris);
            this.mUrisSet = true;
        }
        this.broadcastToCallbacksLocked(c -> this.onSubscriberAssociatedUriChanged((IImsRegistrationCallback)c, uris), false);
    }

    private boolean isEmergency(ImsRegistrationAttributes attributes) {
        if (attributes == null) {
            return false;
        }
        return (attributes.getAttributeFlags() & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastToCallbacksLocked(Consumer<IImsRegistrationCallback> c, boolean isEmergency) {
        if (isEmergency) {
            RemoteCallbackListExt<IImsRegistrationCallback> remoteCallbackListExt = this.mEmergencyCallbacks;
            synchronized (remoteCallbackListExt) {
                this.mEmergencyCallbacks.broadcastAction(c);
            }
        }
        RemoteCallbackListExt<IImsRegistrationCallback> remoteCallbackListExt = this.mCallbacks;
        synchronized (remoteCallbackListExt) {
            this.mCallbacks.broadcastAction(c);
        }
    }

    private void onSubscriberAssociatedUriChanged(IImsRegistrationCallback callback, Uri[] uris) {
        try {
            callback.onSubscriberAssociatedUriChanged(uris);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, e + "onSubscriberAssociatedUriChanged() - Skipping callback.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToState(ImsRegistrationAttributes attributes, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRegistrationAttributes = attributes;
            this.mRegistrationState = newState;
            this.mLastDisconnectCause = null;
            this.mLastDisconnectSuggestedAction = 0;
            this.mLastDisconnectRadioTech = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToEmergencyState(ImsRegistrationAttributes attributes, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEmergencyRegistrationAttributes = attributes;
            this.mEmergencyRegistrationState = newState;
            this.mEmergencyLastDisconnectCause = null;
            this.mEmergencyLastDisconnectSuggestedAction = 0;
            this.mEmergencyLastDisconnectRadioTech = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToDisconnectedState(ImsReasonInfo info, int suggestedAction, int imsRadioTech) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUrisSet = false;
            this.mUris = null;
            this.updateToState(new ImsRegistrationAttributes.Builder(-1).build(), 0);
            if (info != null) {
                this.mLastDisconnectCause = info;
                this.mLastDisconnectSuggestedAction = suggestedAction;
                this.mLastDisconnectRadioTech = imsRadioTech;
            } else {
                Log.w(LOG_TAG, "updateToDisconnectedState: no ImsReasonInfo provided.");
                this.mLastDisconnectCause = new ImsReasonInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToDisconnectedEmergencyState(ImsReasonInfo info, int suggestedAction, int imsRadioTech) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUrisSet = false;
            this.mUris = null;
            this.updateToEmergencyState(new ImsRegistrationAttributes.Builder(-1).build(), 0);
            if (info != null) {
                this.mEmergencyLastDisconnectCause = info;
                this.mEmergencyLastDisconnectSuggestedAction = suggestedAction;
                this.mEmergencyLastDisconnectRadioTech = imsRadioTech;
            } else {
                Log.w(LOG_TAG, "updateToDisconnectedState: no ImsReasonInfo provided.");
                this.mEmergencyLastDisconnectCause = new ImsReasonInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewCallbackWithState(IImsRegistrationCallback c, boolean isEmergencyCallback) throws RemoteException {
        Uri[] uris;
        boolean urisSet;
        int imsDisconnectRadioTech;
        int suggestedAction;
        ImsReasonInfo disconnectInfo;
        ImsRegistrationAttributes attributes;
        int state;
        Object object = this.mLock;
        synchronized (object) {
            state = isEmergencyCallback ? this.mEmergencyRegistrationState : this.mRegistrationState;
            attributes = isEmergencyCallback ? this.mEmergencyRegistrationAttributes : this.mRegistrationAttributes;
            disconnectInfo = isEmergencyCallback ? this.mEmergencyLastDisconnectCause : this.mLastDisconnectCause;
            suggestedAction = isEmergencyCallback ? this.mEmergencyLastDisconnectSuggestedAction : this.mLastDisconnectSuggestedAction;
            imsDisconnectRadioTech = isEmergencyCallback ? this.mEmergencyLastDisconnectRadioTech : this.mLastDisconnectRadioTech;
            urisSet = this.mUrisSet;
            uris = this.mUris;
        }
        switch (state) {
            case 0: {
                c.onDeregistered(disconnectInfo, suggestedAction, imsDisconnectRadioTech);
                break;
            }
            case 1: {
                c.onRegistering(attributes);
                break;
            }
            case 2: {
                c.onRegistered(attributes);
                break;
            }
        }
        if (urisSet) {
            this.onSubscriberAssociatedUriChanged(c, uris);
        }
    }

    public void setDefaultExecutor(@NonNull Executor executor) {
        if (this.mExecutor == null) {
            this.mExecutor = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegistrationCache() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUris = null;
            this.mUrisSet = false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsDeregistrationReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsRegistrationTech {
    }
}

