/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.telephony.ims.RcsContactPresenceTuple;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SystemApi
public class RcsContactUceCapability
implements Parcelable {
    public static final int CAPABILITY_MECHANISM_PRESENCE = 1;
    public static final int CAPABILITY_MECHANISM_OPTIONS = 2;
    public static final int SOURCE_TYPE_NETWORK = 0;
    public static final int SOURCE_TYPE_CACHED = 1;
    public static final int REQUEST_RESULT_UNKNOWN = 0;
    public static final int REQUEST_RESULT_NOT_ONLINE = 1;
    public static final int REQUEST_RESULT_NOT_FOUND = 2;
    public static final int REQUEST_RESULT_FOUND = 3;
    private final Uri mContactUri;
    private int mSourceType;
    private int mCapabilityMechanism;
    private int mRequestResult;
    private Uri mEntityUri;
    private final Set<String> mFeatureTags = new HashSet<String>();
    private final List<RcsContactPresenceTuple> mPresenceTuples = new ArrayList<RcsContactPresenceTuple>();
    @NonNull
    public static final Parcelable.Creator<RcsContactUceCapability> CREATOR = new Parcelable.Creator<RcsContactUceCapability>(){

        @Override
        public RcsContactUceCapability createFromParcel(Parcel in) {
            return new RcsContactUceCapability(in);
        }

        public RcsContactUceCapability[] newArray(int size) {
            return new RcsContactUceCapability[size];
        }
    };

    private RcsContactUceCapability(@NonNull Uri contactUri, int mechanism, int sourceType) {
        this.mContactUri = contactUri;
        this.mCapabilityMechanism = mechanism;
        this.mSourceType = sourceType;
    }

    private RcsContactUceCapability(Parcel in) {
        this.mContactUri = in.readParcelable(Uri.class.getClassLoader(), Uri.class);
        this.mCapabilityMechanism = in.readInt();
        this.mSourceType = in.readInt();
        this.mRequestResult = in.readInt();
        this.mEntityUri = in.readParcelable(Uri.class.getClassLoader(), Uri.class);
        ArrayList<String> featureTagList = new ArrayList<String>();
        in.readStringList(featureTagList);
        this.mFeatureTags.addAll(featureTagList);
        in.readParcelableList(this.mPresenceTuples, RcsContactPresenceTuple.class.getClassLoader(), RcsContactPresenceTuple.class);
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeParcelable(this.mContactUri, flags);
        out.writeInt(this.mCapabilityMechanism);
        out.writeInt(this.mSourceType);
        out.writeInt(this.mRequestResult);
        out.writeParcelable(this.mEntityUri, flags);
        out.writeStringList(new ArrayList<String>(this.mFeatureTags));
        out.writeParcelableList(this.mPresenceTuples, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCapabilityMechanism() {
        return this.mCapabilityMechanism;
    }

    @NonNull
    public Set<String> getFeatureTags() {
        if (this.mCapabilityMechanism != 2) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mFeatureTags);
    }

    @NonNull
    public List<RcsContactPresenceTuple> getCapabilityTuples() {
        if (this.mCapabilityMechanism != 1) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mPresenceTuples);
    }

    @Nullable
    public RcsContactPresenceTuple getCapabilityTuple(@NonNull String serviceId) {
        if (this.mCapabilityMechanism != 1) {
            return null;
        }
        for (RcsContactPresenceTuple tuple : this.mPresenceTuples) {
            if (tuple.getServiceId() == null || !tuple.getServiceId().equals(serviceId)) continue;
            return tuple;
        }
        return null;
    }

    public int getSourceType() {
        return this.mSourceType;
    }

    public int getRequestResult() {
        return this.mRequestResult;
    }

    @NonNull
    public Uri getContactUri() {
        return this.mContactUri;
    }

    @Nullable
    public Uri getEntityUri() {
        return this.mEntityUri;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RcsContactUceCapability");
        if (this.mCapabilityMechanism == 1) {
            builder.append("(presence) {");
        } else if (this.mCapabilityMechanism == 2) {
            builder.append("(options) {");
        } else {
            builder.append("(?) {");
        }
        if (_Original_Build.IS_ENG) {
            builder.append("uri=");
            builder.append(this.mContactUri);
        } else {
            builder.append("uri (isNull)=");
            builder.append(this.mContactUri != null ? "XXX" : "null");
        }
        builder.append(", sourceType=");
        builder.append(this.mSourceType);
        builder.append(", requestResult=");
        builder.append(this.mRequestResult);
        if (_Original_Build.IS_ENG) {
            builder.append("entity uri=");
            builder.append(this.mEntityUri != null ? this.mEntityUri : "null");
        } else {
            builder.append("entity uri (isNull)=");
            builder.append(this.mEntityUri != null ? "XXX" : "null");
        }
        if (this.mCapabilityMechanism == 1) {
            builder.append(", presenceTuples={");
            builder.append(this.mPresenceTuples);
            builder.append("}");
        } else if (this.mCapabilityMechanism == 2) {
            builder.append(", featureTags={");
            builder.append(this.mFeatureTags);
            builder.append("}");
        }
        return builder.toString();
    }

    public static class PresenceBuilder {
        private final RcsContactUceCapability mCapabilities;

        public PresenceBuilder(@NonNull Uri contact, int sourceType, int requestResult) {
            this.mCapabilities = new RcsContactUceCapability(contact, 1, sourceType);
            this.mCapabilities.mRequestResult = requestResult;
        }

        @NonNull
        public PresenceBuilder addCapabilityTuple(@NonNull RcsContactPresenceTuple tuple) {
            this.mCapabilities.mPresenceTuples.add(tuple);
            return this;
        }

        @NonNull
        public PresenceBuilder addCapabilityTuples(@NonNull List<RcsContactPresenceTuple> tuples) {
            this.mCapabilities.mPresenceTuples.addAll(tuples);
            return this;
        }

        @NonNull
        public PresenceBuilder setEntityUri(@NonNull Uri entityUri) {
            this.mCapabilities.mEntityUri = entityUri;
            return this;
        }

        @NonNull
        public RcsContactUceCapability build() {
            return this.mCapabilities;
        }
    }

    public static class OptionsBuilder {
        private final RcsContactUceCapability mCapabilities;

        public OptionsBuilder(@NonNull Uri contact) {
            this.mCapabilities = new RcsContactUceCapability(contact, 2, 0);
        }

        public OptionsBuilder(@NonNull Uri contact, int sourceType) {
            this.mCapabilities = new RcsContactUceCapability(contact, 2, sourceType);
        }

        @NonNull
        public OptionsBuilder setRequestResult(int requestResult) {
            this.mCapabilities.mRequestResult = requestResult;
            return this;
        }

        @NonNull
        public OptionsBuilder addFeatureTag(@NonNull String tag) {
            this.mCapabilities.mFeatureTags.add(tag);
            return this;
        }

        @NonNull
        public OptionsBuilder addFeatureTags(@NonNull Set<String> tags) {
            this.mCapabilities.mFeatureTags.addAll(tags);
            return this;
        }

        @NonNull
        public RcsContactUceCapability build() {
            return this.mCapabilities;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CapabilityMechanism {
    }
}

